/**
 * Classes in this package relate to modelling of financial investment
 * portfolios, and Modern Portfolio Theory.
 * <ul><li>
 * An asset is a resource with economic value, and something that can
 * be owned.
 * </li><li>
 * A portfolio is a collection of something (anything).
 * </li><li>
 * An instrument is a tool or device - an enabler.
 * </li><li>
 * Financial instruments enable financial transactions, and are defined
 * in terms of assets. A financial instrument can for instance be
 * evidence of ownership of, or a contractual right/obligation to receive
 * or deliver, an asset.
 * </li><li>
 * Financial portfolios contain financial instruments. Typically, in
 * terms of investments, it is a collection of assets with a common owner.
 * </li><li>
 * The distiction between assets, instruments and portfolios is fuzzy, and the
 * terms can often bu used interchangeably. Here the term portfolio represents
 * the collection and ownership, and the term asset represents components/contents
 * and underlying value. We try to avoid using the term instrument.
 * </li></ul>
 */
package org.ojalgo.finance.portfolio;

