package edu.udo.cs.mySVMdb;
import edu.udo.cs.mySVMdb.SVM.*;
import edu.udo.cs.mySVMdb.Container.*;
import edu.udo.cs.mySVMdb.Kernel.*;
import java.util.Date;

public class Learn
{
    /**
     * Class for learning module
     */
    public static void disclaimer(){
	System.out.println("*** mySVM/db version 0.9 ***");
	System.out.println("*** This software is free only for non-commercial use. It must not be distributed without prior permission of the author. The author is not responsible for implications from the use of this software. ****");
	System.out.println(" ");
    };


    public static void learn(String param_table)
	throws Exception
    {
	String[] args = new String[1];
	args[0] = param_table;
	learn(args);
    };


    public static void learn(String[] args)
	throws Exception
    {
	disclaimer();
	System.out.println("Starting with paramters from "+args[0]);

	JDBCDatabaseContainer the_container;
	try{
	    the_container = new OracleDatabaseContainer(args);
	}
	catch(Exception e){
	    System.out.println("Error opening "+args[0]+".");
	    throw e;
	};

	try{
	    the_container.init_for_learning();
	    // System.out.println(the_container.count_examples()+" examples read.");
	    
	    Kernel the_kernel = null;
	    String the_type = the_container.get_param("kernel:type");
	    if(the_type != null){
		the_type = the_type.toLowerCase();
	    };

	    if(the_type == null){ 
		the_kernel = new KernelDot(the_container);
	    }
	    else if(the_type.equals("dot")){
		the_kernel = new KernelDot(the_container);
	    }
	    else if(the_type.equals("radial") || the_type.equals("rbf")){
		the_kernel = new KernelRadial(the_container);
	    }
	    else{
		throw(new Exception("Unknown kernel type: "+the_type));
	    };
	    // System.out.println(the_kernel.toString()+" kernel.");
	    
	    SVM the_svm = null;
	    the_type = the_container.get_param("svm_type");
	    if(the_type == null){
		//System.out.println("Creating RSVM");
		the_svm = new SVMregression();
	    }
	    else if(the_type.equals("pattern")){
		//System.out.println("Creating PSVM");
		the_svm = new SVMpattern();
	    }
	    else{
		//System.out.println("Creating RSVM");
		the_svm = new SVMregression();
	    };
	    
	    //System.out.println("Initing SVM");
	    the_svm.init(the_kernel,the_container);
	    
	    long time_all = System.currentTimeMillis();
	    //System.out.println("Training SVM");
	    the_svm.train();
	    time_all = System.currentTimeMillis() - time_all;
	    time_all /= 1000;
	    // 	    long kernel_time = the_kernel.kernel_time / 1000;
	    // 	    long kernel_time2 = the_kernel.kernel_time2 / 1000;
	    // 	    long kernel_time3 = the_kernel.kernel_time3 / 1000;
	    // 	    long kernel_time4 = the_kernel.kernel_time4 / 1000;
	    // 	    System.out.println("Time kernel : "+kernel_time+"s");
	    // 	    System.out.println("Time kernel : "+kernel_time2+"s");
	    // 	    System.out.println("Time kernel : "+kernel_time3+"s");
	    // 	    System.out.println("Time kernel : "+kernel_time4+"s");
	    System.out.println("Time train : "+time_all+"s");

	    //	System.out.println("Closing container");
	    the_container.write_model();
	    the_container.close();
	}
	catch(Exception e){
	    the_container.close();
	    throw e;
	};

	System.out.println("Done.");
    };


    public static void main(String[] args)
	throws Exception
    {
	learn(args);
    };
};
