package edu.udo.cs.mySVMdb.Kernel;
import edu.udo.cs.mySVMdb.Container.JDBCDatabaseContainer;
import java.lang.Math;

public class KernelRadial extends Kernel
{
    /**
     * Linear Kernel
     * @author Stefan Rping
     * @version 1.0
     */
    double gamma=1;


    /**
     * Class constructor
     */
    public KernelRadial(){};



    /**
     * Output as String
     */
    public String toString(){
	return("rbf("+(-gamma)+")");
    };


    /**
     * Class constructor
     * @param examples Container for the examples.
     */
    public KernelRadial(JDBCDatabaseContainer examples)
	throws Exception
    {
	init(examples);
	gamma = -(new Double(the_examples.get_param("kernel:gamma"))).doubleValue();
	double[] Exp = the_examples.Exp;
	double[] Dev = the_examples.Dev;
	if(Exp != null){
	    select_text = "exp("+gamma+" * (";
	    select_text += "(x."+examples.x_column[0]
		+" - y."+examples.x_column[0]+")"
		+"*(x."+examples.x_column[0]
		+" - y."+examples.x_column[0]+")"
		+" / "+Dev[0]*Dev[0];
	    for(int i=1;i<(examples.x_column).length;i++){
		select_text += 
		    " + "
		    +"(x."+examples.x_column[i]
		    +" - y."+examples.x_column[i]+")"
		    +"*(x."+examples.x_column[i]
		    +" - y."+examples.x_column[i]+")"
		    +" / "+Dev[i]*Dev[i];
	    };
	    select_text += ")"; // ||.||
	    select_text += ")"; // exp()
	}
	else{
	    select_text = "exp("+gamma+" * ( x."+examples.x_column[0]
		+" * "+"y."+examples.x_column[0];
	    for(int i=1;i<(examples.x_column).length;i++){
		select_text += 
		    " + x."+examples.x_column[i]
		    +" * "+"y."+examples.x_column[i];
	    };
	    select_text += " ))";
	};
	the_examples.set_select_text(select_text);
	Kij_query = the_examples.prepareKijStatement();
	Ki_query = the_examples.prepareKiStatement();
	Kis_query = the_examples.prepareKisStatement();
    };


    /**
     * Calculates kernel value of vectors x and y
     */
    public double calculate_K(double[] x, double[] y)
    {
	double result = 0.0;
	for(int i=0;i<dim;i++){
	    result += (x[i]-y[i])*(x[i]-y[i]);
	};
	result = Math.exp(gamma*result); // gamma = -params.gamma
	return result;
    };
};
