package edu.udo.cs.mySVMdb.Kernel;
import edu.udo.cs.mySVMdb.Container.JDBCDatabaseContainer;


public class KernelDot extends Kernel
{
    /**
     * Linear Kernel
     * @author Stefan Rping
     * @version 1.0
     */


    /**
     * Class constructor
     */
    public KernelDot(){};


    /**
     * Output as String
     */
    public String toString(){
	return("linear");
    };


    /**
     * Class constructor
     * @param examples Container for the examples.
     */
    public KernelDot(JDBCDatabaseContainer examples)
	throws Exception
    {
	init(examples);
	keys = examples.keys;

	double[] Exp = the_examples.Exp;
	double[] Dev = the_examples.Dev;
	if(Exp != null){
	    select_text = "((x."+examples.x_column[0]+" - "+Exp[0]
		+") * ("+"y."+examples.x_column[0]+" - "+Exp[0]+"))/"+(Dev[0]*Dev[0]);
	    for(int i=1;i<(examples.x_column).length;i++){
		select_text += 
		    " + ((x."+examples.x_column[i]+" - "+Exp[i]
		    +") * ("+"y."+examples.x_column[i]+" - "+Exp[i]
		    +"))/"+(Dev[i]*Dev[i]);
	    };
	}
	else{
	    select_text = "x."+examples.x_column[0]
		+" * "+"y."+examples.x_column[0];
	    for(int i=1;i<(examples.x_column).length;i++){
		select_text += 
		    " + x."+examples.x_column[i]
		    +" * "+"y."+examples.x_column[i];
	    };
	};
	the_examples.set_select_text(select_text);
	Kij_query = the_examples.prepareKijStatement();
	Ki_query = the_examples.prepareKiStatement();
	Kis_query = the_examples.prepareKisStatement();
    };


    /**
     * Calculates kernel value of vectors x and y
     */
    public double calculate_K(double[] x, double[] y)
    {
	double result = 0.0;
	for(int i=0;i<dim;i++){
	    result += x[i]*y[i];
	};
	return result;
    };


};
