package edu.udo.cs.mySVMdb.Container;
import java.sql.*;
import oracle.jdbc.driver.*;
import oracle.sql.*;
import java.util.Properties;

public class OracleDatabaseContainer extends JDBCDatabaseContainer
{
    /*
     *
     *  Persistent access to databases and files
     *
     */


    /**
     * Class constructor with default parameters.
     */
    public OracleDatabaseContainer(){
    };


    /**
     * Class constructor with parameters.
     * @param params Array of parameters in the form "name:value".
     */
    public OracleDatabaseContainer(String[] params)
	throws Exception
    {
	init(params);
    };


    /**
     * Open connection
     */
    protected void open()
    	throws Exception
    {
	try{
	    DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
	    java.util.Properties info = new java.util.Properties();
 	    info.put("defaultRowPrefetch","500");
 	    info.put("defaultBatchValue","500");
	    if(null != System.getProperty("oracle.jserver.version")){
		// inside oracle db
		conn = DriverManager.getConnection("jdbc:default:connection:",info);
		//((OracleConnection)conn).setDefaultRowPrefetch(500);
		System.out.println("Internal database connection opened");
	    }
	    else{
		info.put("user",db_login);
		info.put("password",db_password);
		conn = DriverManager.getConnection(db_url,info);
		System.out.println("Connection to ("+db_url+","+db_login+") opened");
	    };
	}
	catch(SQLException e){
	    throw new Exception(e.getMessage());
	};
    };    


    /**
     * creates a temporary table with given name as prefix
     */
    protected String create_temp_table(String name, String definition)
	throws Exception
    {
	Statement stmt = conn.createStatement();
	boolean error=true;
	int suffix = 0;
	String tablename = name + "-" + suffix;
	while(error){
	    try{
		stmt.executeUpdate("create table "+tablename+" ("+definition+")");
		error = false;
	    }
	    catch(SQLException e){
		if(e.getErrorCode() == 955){
		    // table exists
		    suffix++;
		    tablename = name + "-" + suffix;
		}
		else{
		    throw e;
		};
	    };
	};
	stmt.close();
	return tablename;
    };


    public PreparedStatement prepareKiStatement(String select_text)
	throws Exception
    {
// 	OraclePreparedStatement ps = (OraclePreparedStatement)conn.prepareStatement(
// 	    "select "+select_text+" as K,"
// 	    +" y."+key_column+" as Key"
// 	    +" from "+examples_name+" x, "
// 	    +examples_name+" y"
// 	    +" where x."+key_column+" = ?");
	OraclePreparedStatement ps = (OraclePreparedStatement)conn.prepareStatement(
	   "select "+select_text+" as K,"
	   +" y."+key_column+" as Key"
	   +" from "+examples_name+" x, "
	   +examples_name+" y"
	   +" where x."+key_column+" = ?"
	   +" and y."+key_column+" in (select key from "+model_name+")");

	ps.setRowPrefetch(train_size);
	return ps;
    };
};















