package hitters.tools;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.AbstractHHH;
import hitters.multi.Element;
import hitters.multi.Exact;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

import com.google.common.collect.HashMultiset;

/**
 * @author Peter Fricke
 * 
 * resources/testcase/PATest/PA2 tmp/gt.graphml dohtFf PA 326
 *  fFdoth
 * 
 */
public class XMLPlotter {

	public static final int ABSOLUTE_FREQ   = 1;
	public static final int DISCOUNTED_FREQ = 2;
	public static final int APPROX_HITTERS  = 4;
	public static final int TRUE_HITTERS	= 8;	
	public static final int OUT_ESTIMATES	= 16;
	public static final int DUMP			= 32;
	public static final int DUMP_RED		= 64;
	public static final int DISTRIB_f	 	= 128;
	public static final int DISTRIB_F	 	= 256;

	public static final int PART_ANC	 	= 4096;
	public static final int FULL_ANC	 	= 8192;
//	public static final int CLEAN_PART_ANC	= 16384;
//	public static final int CLEAN_FULL_ANC	= 32768;

	
	public static final int SYSCALL	 		= 1;	 


	private String file;
	private HashMap<Element, Node> nodeSet = new HashMap<Element, Node>();
	private HashSet<Edge> edgeSet = new HashSet<Edge>();
	private FileWriter outData;
	private BufferedWriter out;
	HashMultiset<Element> prefixSet  = HashMultiset.create(); 
	//HashMultiset<Element> elementSet = HashMultiset.create();


	public static void main(String[] args) {

		String testcase;
		String xmlFile;
		int logLevel = 0;
		int streamType = 0;
		boolean mbug = false;
		boolean bprob = false;
		AbstractHHH hitterAlgo;
		int algoType = PART_ANC;;
		double epsilon;
		double phi;

		if( args.length > 0 ) testcase = args[0];
		else testcase = "resources/testcase/muster/mbug";

		if( args.length > 1 ) xmlFile = args[1];
		else xmlFile = "tmp/gt.graphml";			

		if( args.length > 2 ){
			char[] flags = args[2].trim().toCharArray();
			for( char c : flags ){
				switch( c ){
				case 'f': logLevel |= ABSOLUTE_FREQ; 	break;
				case 'F': logLevel |= DISCOUNTED_FREQ; 	break;
				case 'h': logLevel |= APPROX_HITTERS;	break;
				case 't': logLevel |= TRUE_HITTERS;		break;
				case 'd': logLevel |= DUMP;				break;
				case 'D': logLevel |= DUMP_RED;			break;
				case 'o': logLevel |= OUT_ESTIMATES;	break;
				case 'i': logLevel |= DISTRIB_f;		break;
				case 'I': logLevel |= DISTRIB_F;		break;
				case 'S': streamType = SYSCALL;			break;
				case 'M': mbug = true;					break;
				case 'B': bprob = true;					break;
				}
			}
		}

		if( args.length > 3 ){
			if( args[3].equals("PA") ) algoType = PART_ANC;			
			if( args[3].equals("FA") ) algoType = FULL_ANC;
		}		

		if( args.length > 4 ){
			LogService.DEBUG = Integer.parseInt(args[4]);			
		}

		byte[][] plength20 = {  };
		byte[][] plength11 = { {0,4,8,16,24,32} };
		byte[][] plength;
		if( streamType == SYSCALL ) plength = plength11;
		else plength = plength20;
		int dim = 2;
		Parameter par = new Parameter( dim - plength.length, plength );
		//par = new Parameter( 1, plength );
		par.setMBug(mbug);
		par.setMBug(bprob);		


		// Daten lesen
		MultiDatabase d = new MultiDatabase( testcase, par );
		d.openRead();
		Vector<Element> v;				
		if( streamType == SYSCALL ){
			epsilon = 0.01;
			phi = 0.02;
			v = d.readSystemCalls();
		}
		else{
			v = d.readElements();
			epsilon = d.getEpsilon();
			phi = d.getPhi();						
		}

		List<Element> elements = new ArrayList<Element>( v );
		
		// Plotter erzeugen, Items einfuegen
		XMLPlotter plotter = new XMLPlotter( xmlFile );
		plotter.addItems( elements );		
		
		// HHH-Algorithmus ausfuehren, Items dort einfuegen
		switch( algoType ){

		case FULL_ANC: 
			System.out.println( "algoType = FA" ); 
			hitterAlgo = new FullAncHHH( epsilon, par );
			break;

		case PART_ANC: 
			System.out.println( "algoType = PA" ); 
			hitterAlgo = new PartAncHHH( epsilon, par );
			break;

			
		default: throw new RuntimeException("Algorithmus angeben!"); 
		}

		Exact myExact = new Exact( par );
		for( Element e : elements ){
			hitterAlgo.insert( e.clone(), 1, true );
			myExact.insert( e.clone(), 1, true );
		}

		// Wahre f-Werte in den Graphen schreiben
		if( (logLevel & ABSOLUTE_FREQ) != 0 ) 
			plotter.addTrueAbsoluteFreq( myExact );		

		// Wahre F-Werte in den Graphen schreiben
		if( (logLevel & DISCOUNTED_FREQ) != 0 ) 
			plotter.addTrueDiscountedFreq( myExact, phi );		

		// Exakte Hitter finden, in Graphen schreiben
		if( (logLevel & TRUE_HITTERS) != 0 ) 
			plotter.addExactHHH( myExact.outputSet( phi, true ) );

		// Approx. Hitter finden, in Graphen schreiben
		if( (logLevel & APPROX_HITTERS) != 0 ) 
			plotter.addApproxHHH( hitterAlgo.outputSet( phi ) );

		// Zustand der Datenstruktur in den Graphen schreiben
		if( (logLevel & DUMP) != 0 || (logLevel & DUMP_RED) != 0 ) 
			// Wenn gewuenscht, Knoten in Datenstruktur rot faerben
			if( (logLevel & DUMP_RED) != 0 ) plotter.addDump( hitterAlgo, true );
			else plotter.addDump( hitterAlgo, false );

		// Schaetzungen fuer fmin, fmax, F schreiben
		if( (logLevel & OUT_ESTIMATES) != 0 ) 
			plotter.addEstimates( hitterAlgo, phi );

		// Versuch, Verteilung zu veranschaulichen
		if( (logLevel & DISTRIB_f) != 0 ) 
			plotter.addColoring_f( myExact );

		if( (logLevel & DISTRIB_F) != 0 ) 
			plotter.addColoring_F( myExact, phi );


		plotter.plot();
		System.out.println( "Geschrieben: " + testcase + 
				" per " + algoString(algoType) + " nach " + xmlFile );

		System.out.println( "epsilon = " + epsilon + " phi = " + phi + 
				" N = " + hitterAlgo.getN() );

		if( hitterAlgo instanceof AbstractComplexHHH) {
			System.out.println( " w = " +
					((AbstractComplexHHH)hitterAlgo).getW() );
		}	
	}


	public XMLPlotter( String file ){
		this.file = file;			
	}

	
	public void addItems( List<Element> data ){
		
		switch( data.get(0).getDim() ) {
		case 1: addItems1D( data ); break;
		case 2: addItems2D( data ); break;
		case 3: addItems3D( data ); break;
		default: throw new RuntimeException("Dim nicht impl.");
		}
		
	}
	
	
	public void addItems2D( List<Element> data ){
		Element a   = data.get(0).clone();
		Element b   = a.clone();
		Element tmp = a.clone();
		Node nd;
		int lim0, lim1;
		boolean check = true;		

		for( Element e : data ){
			a.setTo(e);				
			lim0 = a.getLevel(0);
			lim1 = a.getLevel(1);
			for( int i = 0; i <= lim0; i++ ){
				if( i > 0 ) check = a.turnIntoParent(0);
				if( check != true ) throw new RuntimeException( "Kann " +
				"nicht in Elter umwandeln" );
				b.setTo( a );
				for( int j = 0; j <= lim1; j++ ){
					if( j > 0 ) check = b.turnIntoParent(1);
					if( check != true ) throw new RuntimeException( "Kann " +
					"nicht in Elter umwandeln" );
					prefixSet.add( b.clone() );
					nd = new Node( b.toShortString() );
					nodeSet.put( b.clone(), nd );

					tmp = b.clone();
					if( tmp.turnIntoParent(0) ) 
						edgeSet.add( new Edge( b.toShortString(), tmp.toShortString() ) );
					tmp = b.clone();
					if( tmp.turnIntoParent(1) ) 
						edgeSet.add( new Edge( b.toShortString(), tmp.toShortString() ) );					
				}
			}			
		}
	}


	public void addItems3D( List<Element> data ){

		Element a   = data.get(0).clone();
		Element b   = a.clone();
		Element c   = a.clone();
		Element tmp = a.clone();
		Node nd;
		int lim0, lim1, lim2;
		boolean check = true;		

		for( Element e : data ){
			a.setTo(e);					
			lim0 = a.getLevel(0);
			lim1 = a.getLevel(1);
			lim2 = a.getLevel(2);
			for( int i = 0; i <= lim0; i++ ){
				if( i > 0 ) check = a.turnIntoParent(0);
				if( check != true ) throw new RuntimeException( "Kann " +
				"nicht in Elter umwandeln" );
				b.setTo( a );
				for( int j = 0; j <= lim1; j++ ){
					if( j > 0 ) check = b.turnIntoParent(1);
					if( check != true ) throw new RuntimeException( "Kann " +
					"nicht in Elter umwandeln" );
					c.setTo(b);
					for( int k = 0; k <= lim2; k++ ){
						if( k > 0 ) check = c.turnIntoParent(2);
						if( check != true ) throw new RuntimeException( "Kann " +
						"nicht in Elter umwandeln" );

						prefixSet.add( c.clone() );
						nd = new Node( c.toShortString() );
						nodeSet.put( c.clone(), nd );
						System.out.println( c.toShortString() );
						
						tmp = c.clone();
						if( tmp.turnIntoParent(0) ) 
							edgeSet.add( new Edge( c.toShortString(), tmp.toShortString() ) );
						tmp = c.clone();
						if( tmp.turnIntoParent(1) ) 
							edgeSet.add( new Edge( c.toShortString(), tmp.toShortString() ) );					
						tmp = c.clone();
						if( tmp.turnIntoParent(2) ) 
							edgeSet.add( new Edge( c.toShortString(), tmp.toShortString() ) );
					}
				}
			}			
		}
	}

	
	public void addItems1D( List<Element> data ){

		Element a   = data.get(0).clone();
		Element tmp = a.clone();
		Node nd;
		int lim0;
		boolean check = true;		

		for( Element e : data ){
		
			a.setTo(e);						
			prefixSet.add( a.clone() );				
			nd = new Node( a.toShortString() );
			nodeSet.put( a.clone(), nd );
		
			lim0 = a.getLevel(0);			
			for( int i = 1; i <= lim0; i++ ){						
				tmp.setTo(a);
				check = a.turnIntoParent(0);				
				if( check != true ) throw new RuntimeException( "Kann " +
				"nicht in Elter umwandeln" );
				prefixSet.add( a.clone() );				
				nd = new Node( a.toShortString() );
				nodeSet.put( a.clone(), nd );
				edgeSet.add( new Edge( tmp.toShortString(), a.toShortString() ) );
			}			
		}
	}

	
	private void addTrueAbsoluteFreq( Exact myExact ) {		
		Node nd;
		int count;	
		HashMap<Element, Integer> f = myExact.dumpf();

		if( f.size() != nodeSet.size() )
			throw new RuntimeException( "Plotter.addTrueAbsoluteFreq:" +
			" f.size() != nodeSet.size() " );

		for( Element el : nodeSet.keySet() ){
			nd = nodeSet.get( el );
			count = prefixSet.count( el );
			
			f.get(el);
			
			System.out.println( el + " " + count + "     " + f.get(el) );
			
			if( count != f.get(el) )
				throw new RuntimeException( "Plotter.addTrueAbsoluteFreq:" +
				" count != exact.getf.get(el)" );
			nd.setLabel( nd.getLabel() + "\nf* = " + count );			
		}		
	}


	private void addTrueDiscountedFreq( Exact myExact, double phi ) {		
		Node nd;
		int count;
		Integer countObj;
		HashMap<Element, Integer> F = myExact.dumpF( phi );

		for( Element el : nodeSet.keySet() ){
			nd = nodeSet.get( el );
			countObj = F.get( el );
			if( countObj == null ) count = 0;
			else count = countObj;
			nd.setLabel( nd.getLabel() + "\nF* = " + count );			
		}	
	}

	private void addColoring_f( Exact myExact ) {		
		Node nd;
		int count;		
		int green, blue;
		double rel;
		double thresh = 0.2;
		HashMap<Element, Integer> f = myExact.dumpf();

		for( Element el : nodeSet.keySet() ){

			nd    = nodeSet.get( el );
			count = f.get( el );
			rel   = count / (double)myExact.getN();

			// So sieht man mehr:
			rel = Math.sqrt( rel );

			// Zunehmende Dichte: Beginne bei FF FF FF
			// Senke zunaechst blau dann gruen bis auf FF 00 00
			if( rel > thresh ){
				blue  = 0;
				green = 255 - (int) Math.floor(( rel - thresh ) * 255/(1-thresh));
			}
			else{
				blue  = 255 - (int) Math.floor( rel * 255/thresh ); 
				green = 255;
			}				
			nd.setColor( 255, green, blue );		
		}	

	}

	private void addColoring_F( Exact myExact, double phi ) {		
		Node nd;
		int count;		
		Integer countObj;
		int green, blue;		
		double rel;
		double thresh = 0.2;
		HashMap<Element, MultiHitterInfo> hitter = myExact.outputSet(phi, true);
		HashMap<Element, Integer> F = myExact.dumpF( phi );

		for( Element el : nodeSet.keySet() ){

			nd    = nodeSet.get( el );			
			countObj = F.get( el );
			if( countObj == null ) count = 0;
			else count = countObj;
			rel   = Math.min( (count / (double)myExact.getN()) / phi, 1 );

			// So sieht man mehr:
			rel = Math.sqrt( rel );

			// Zunehmende Dichte: Beginne bei FF FF FF
			// Senke zunaechst blau dann gruen bis auf FF 00 00
			if( rel > thresh ){
				blue  = 0;
				green = 255 - (int) Math.floor(( rel - thresh ) * 255/(1-thresh));
			}
			else{
				blue  = 255 - (int) Math.floor( rel * 255/thresh ); 
				green = 255;
			}				
			nd.setColor( 255, green, blue );

			if( hitter.containsKey( el ) ) nd.setColor("blue");
		}	
	}


	public void addDump( AbstractHHH partAnc, boolean red ){

		Node nd;
		MultiStringElement msi;
		AbstractComplexHHH complex;
//		CleanComplexHHH clean;
//		
//		//Hack
//		if( partAnc instanceof CleanComplexHHH ){
//			clean = (CleanComplexHHH) partAnc;
//			for( Element el : nodeSet.keySet() ){
//				nd  = nodeSet.get( el );
//				if( red ) nd.setColor("white");
//				msi = clean.dumpElement( el ); 
//				if( msi == null ){
//					nd.setLabel( nd.getLabel() +
//							"\n( - , - , " + clean.instantiateDelta( el ) + ")" );				
//				}
//				else{
//					nd.setMargin( "5.0" );
//					if( red ) nd.setColor( "red" );
//					nd.setLabel( nd.getLabel() +
//							"\n(" + msi.g + ", " +
//							msi.m + ", " + msi.delta + ")" );
//				}
//			}
//			return;
//		}//EndHack
		
		
		
		if( ! (partAnc instanceof AbstractComplexHHH) ){
			for( Element el : nodeSet.keySet() ){
				nd  = nodeSet.get( el );
				nd.setMargin( "5.0" );
				if( red ) nd.setColor( "red" );
			}
			return;
		}
		else
			complex = (AbstractComplexHHH) partAnc;


		for( Element el : nodeSet.keySet() ){
			nd  = nodeSet.get( el );
			if( red ) nd.setColor("white");
			msi = complex.dumpElement( el ); 
			if( msi == null ){
				nd.setLabel( nd.getLabel() +
						"\n( - , - , " + complex.instantiateDelta( el ) + ")" );				
			}
			else{
				nd.setMargin( "5.0" );
				if( red ) nd.setColor( "red" );
				nd.setLabel( nd.getLabel() +
						"\n(" + msi.g + ", " +
						msi.m + ", " + msi.delta + ")" );
			}
		}					
	}


	public void addApproxHHH( HashMap<Element, MultiHitterInfo> hitter ){

		Node nd;

		for( Element el : hitter.keySet() ){
			nd = nodeSet.get( el );

			if(nd.color.equals("lightblue")) nd.setColor("green");
			else nd.setColor( "yellow" );
		}
	}


	public void addExactHHH( HashMap<Element, MultiHitterInfo> hitter ){

		Node nd;

		for( Element el : hitter.keySet() ){
			nd = nodeSet.get( el );
			nd.setShape( "ellipse" );
			if(nd.color.equals("yellow")) nd.setColor("green");
			else nd.setColor( "lightblue" );			
		}
	}



	private void addEstimates(AbstractHHH partAnc, double phi ) {
		Node nd;
		int delta, fmin, fmax, estF, estf;

		HashMap<Element, Integer> F = partAnc.dumpF( phi );
		HashMap<Element, Integer> f = partAnc.dumpf( );		

		for( Element el : nodeSet.keySet() ){
			nd = nodeSet.get( el );
			delta = partAnc.instantiateDelta( el );
			if( f.get( el) != null ) estf = f.get( el );
			else estf = 0;
			fmin  = estf - delta;
			fmax  = estf + delta;
			if( F.get( el) != null ) estF = F.get( el );
			else estF = 0;			
			nd.setLabel( nd.getLabel() + "\n(" + fmin + "; " + fmax + "; " + estF + ")" );		
		}		
	}


	public void plot() {

		String head ="<?xml version=\"1.0\" encoding=\"UTF-8\"" +
		" standalone=\"no\"?> <graphml xmlns=\"" +
		"http://graphml.graphdrawing.org/xmlns/graphml\"" +
		" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" +
		" xmlns:y=\"http://www.yworks.com/xml/graphml\"" +
		" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml" +
		" http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">" +
		"   <key for=\"node\" id=\"d0\" yfiles.type=\"nodegraphics\"/>" +
		"   <key for=\"edge\" id=\"d1\" yfiles.type=\"edgegraphics\"/>" +
		"   <key id=\"d2\" for=\"edge\" attr.name=\"weight\" attr.type=\"" +
		"double\"/> <graph edgedefault=\"directed\">\n";

		String foot ="</graph></graphml>";

		Node nd = null;

		// Datei oeffnen
		try{ 
			outData = new FileWriter(file);
			out = new BufferedWriter(outData);
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());			
		}
		catch (java.io.IOException e) { System.out.print(e.getMessage()); };


		// Datei schreiben
		try{ 
			out.write( head );

			for( Element el : nodeSet.keySet() ){
				nd = nodeSet.get( el );
				out.write( nd + System.getProperty("line.separator") );
			}					

			for( Edge myEdge : edgeSet ){
				out.write( myEdge + System.getProperty("line.separator") );
			}

			out.write( foot );
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());		    	
		}
		catch (java.io.IOException e) { };

		// Datei schliessen
		try{
			out.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: " +
					"Error: " + e.getMessage()); };	    

	}


	static private String algoString( int algoType ){
		switch( algoType ){
		case FULL_ANC: return "FULL_ANC"; 
		case PART_ANC: return "PART_ANC";  			
		default: throw new RuntimeException("Algorithmus angeben!"); 
		}
	}


	private class Node{

		String id;
		String label;
		String color     = "white";
		String colorCode; 
		String customCode;
		String shape     = "roundrectangle";
		String margin 	  = "1.0";

		public Node( String id ){
			this.id = id;
			this.label = id;  
			translateColors();
		}

		public void setColor(int red, int green, int blue) {

			color = "custom";
			customCode = "#";

			customCode += Integer.toHexString( red ).toUpperCase();
			if( red < 16 ) customCode+= "0";

			customCode += Integer.toHexString( green ).toUpperCase();
			if( green < 16 ) customCode+= "0";    		 

			customCode += Integer.toHexString( blue ).toUpperCase();
			if( blue < 16 ) customCode+= "0";    		 

			colorCode = customCode;
		}

		public void setColor( String color ){
			this.color = color;
			translateColors();
		}

		public void setShape(String shape) {
			this.shape = shape;
		}

		public void setMargin(String margin) {
			this.margin = margin;
		}

		public String getLabel(){ return label; }

		public void setLabel( String label ){ this.label = label; }

		public String toString(){
			translateColors();
			String s = "<node id=\"" + id + "\">\n" +
			"<data key=\"d0\"><y:ShapeNode><y:Geometry height=\"83.505859375\"" +
			" width=\"64.697265625\" x=\"-32.3486328125\" y=\"-41.7529296875\"/>" +
			"<y:Fill color=\"" + colorCode + "\"" +
			"  transparent=\"false\"/><y:BorderStyle type=\"line\"" +
			" width=\"" + margin + "\" color=\"#000000\" /><y:NodeLabel x=\"2\"" +
			" y=\"2\" visible=\"true\" alignment=\"center\" fontFamily=" +
			"\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" textColor=\"" +
			"#000000\" modelName=\"internal\" modelPosition=\"c\"" +
			" autoSizePolicy=\"content\">" + label + "</y:NodeLabel>" +
			"<y:Shape type=\"" + shape + "\"/></y:ShapeNode></data>\n</node>\n";
			return s;
		}

		public boolean equals( Object o ){
			if( ! (o instanceof Node) ) return false;
			Node n = (Node)o;
			return this.label.equals( n.label );
		}

		public int hashCode(){ return label.hashCode(); }

		private void translateColors() {

			if( color.equalsIgnoreCase( "lightblue" ) ) 
				colorCode = "#44CCFF";			
			if( color.equalsIgnoreCase( "blue" ) ) 
				colorCode = "#33CCCC";
			if( color.equalsIgnoreCase( "yellow" ) ) 
				colorCode = "#FFCC00";
			if( color.equalsIgnoreCase( "white" ) ) 
				colorCode = "#FFFFFF";			
			if( color.equalsIgnoreCase( "green" ) ) 
				colorCode = "#33CC33";			
			if( color.equalsIgnoreCase( "red" ) ) 
				colorCode = "#FF3333";			
			if( color.equalsIgnoreCase( "custom" ) ) 
				colorCode = customCode;
		}
	}

	private class Edge{
		String source;
		String target;

		public Edge( String source, String target ){
			this.source = source;
			this.target = target;
		}

		public String toString(){    		 
			String s = "<edge id=\"" + source + "->" + target +
			"\" source=\"" + source + "\" target=\"" + target +
			"\"><data key=\"d1\"><y:PolyLineEdge><y:LineStyle color=\"#000000\"" +
			" type=\"line\" width=\"1.0\"/><y:Arrows source=\"none\" target=\"" +
			"standard\"/></y:PolyLineEdge></data></edge>\n";             

			return s;
		}

		public boolean equals( Object o ){
			if( ! (o instanceof Edge) ) return false;
			Edge n = (Edge)o;
			return 
			( this.source.equals( n.source ) && this.target.equals( n.target ) );
		}

		public int hashCode(){ return (source + " -> " + target).hashCode(); }
	}

}
