/**
 * 
 */
package hitters.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Peter Fricke
 *
 * @version $Id$
 */
public class Spyn {


	public static void main(String[] args) throws IOException{
		
		//String pre = "/home/fricke/tmp/file";
		String infile = "J:/ExSet.txt";
		//String outfile = "/home/fricke/tmp/tst";
		String outfile = "J:/SplitSet.txt";		
		
		int nr = Integer.parseInt( args[0] );
		List<String> lines = load( infile );
		List<String> outlines = new ArrayList<String>();
		outlines.add( "id;uid;gid" );
		
		for( String s : lines ){
			String[] comps = s.split(";");
			for( int i = 0; i < nr; i++ ){
				String out = comps[0] + "-" + i + ";" + comps[0] + ";" + comps[1];
				outlines.add( out );
				System.out.println( out );
			}			
		}
		
		BufferedWriter out = null;
		try{ 

			out = new BufferedWriter( new FileWriter( outfile ) );
			for( String s : outlines ){
				out.write( s );
				out.newLine();
			}
			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		} finally { 
			if ( out != null ) try { out.close(); } catch ( IOException e ) { e.printStackTrace(); } 
		}

		
	
	}
	
	
	private static List<String> load( String file ){

		List<String> list = new ArrayList<String>();
		String line;		
				
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null ) {							
				if(  ! (line.startsWith("#") || line.startsWith("uid")) ) {
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}
		return list;
	}


}
