package hitters.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Split {


	public static void main(String[] args) throws IOException{

		int n = 10;
		int count = 0;
		String path = null;
		BufferedReader in;
		BufferedWriter[] out;
		if( args.length > 0 ) path = args[0];				
		if( args.length > 1 ) n = Integer.parseInt(args[1]);
		String line = null;
		File dir = new File(path);
		System.out.println( "n = " + n + "  Dir = " + dir );
		File[] files = dir.listFiles();

		for( File inputfile : files ){
			count = 0;
			in = new BufferedReader( new FileReader( inputfile ) );
			try{ 			
				while( (line = in.readLine()) != null ){
					if( line.length() > 0 ) count++;
				}
			}
			catch (Exception ex) { System.out.println(ex); }
			finally{ in.close(); }

			double size = count/n+1;
			System.out.println( "count = " + count );
			int c = 0;
			in = new BufferedReader( new FileReader( inputfile ) );
			out = new BufferedWriter[n];
			for( int i = 0; i < n; i++ )
				out[i] = new BufferedWriter( new FileWriter( inputfile.getAbsolutePath() + "-" + format(i) ) );
			try{ 			
				while( (line = in.readLine()) != null ){
					if( line.length() > 0 ){
						int index = (int)Math.floor( (c++) / size );
						//System.out.println( "write: " + index + " " + line + " " + out[index] + "  " + size );
						out[index].write(line);						
						if( c < count) out[index].newLine();
					}
				}
			}
			catch (Exception ex) { System.out.println(ex); }
			finally{ 
				in.close(); 
				for( int i = 0; i < n; i++ ) out[i].close();
			}			
		}
	}
	
	
	private static String format( int n ){
		DecimalFormatSymbols formatInst = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
		return new DecimalFormat("000", formatInst ).format( n );		
	}
}
