package hitters.test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import hitters.multi.DimType;
import hitters.multi.ProcTable;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.tools.LogService;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/**
 * @author Peter Fricke
 * 
 */
public class SysParserTest {

	String prefix = "resources/testcase/SysParserTest/";
	//String prefix = "J:/log/";
	
	DimType[] dims = { DimType.PATH, DimType.CALL };
	SysParameter par = new SysParameter( dims );
	
	SysParser parser = new SysParser( par );
	
	//HashMap<String, HashMap<Integer, String> > fdTables;


	// Wenn er blockt, wird er nicht fertig...
	Pattern unfinishedP = Pattern.compile("<unfinished ...>$");
	
	// ... oder irgendwann schon.
	Pattern resumedP = Pattern.compile("<...[^>]* resumed>"); 
	
	// Signal
	Pattern sigP = Pattern.compile("--- ");			
	
	// ProzessID
	Pattern pidP = Pattern.compile("^[0-9]+");

	
	@Before
	public void setUp() throws Exception {					 
	}


	@Test
	@Ignore
	public void testBigMassive() {

		String file = "raw/big";
		
		BufferedReader in;
		BufferedWriter out = null;
		SysElement el;
		String line;
		boolean problem = false;				

		//List<String> input = load( "raw/big" );

		int counter = 0;
		try{ 
			in  = new BufferedReader( new FileReader( prefix + file) );
			out = new BufferedWriter(new FileWriter("tmp/out"));

			//Massentest
			while( (line = in.readLine()) != null ){      				
				if( line.length() > 0 ){		
					//if( counter++ > 100000 ) break;
					//System.out.println( "Input = " + line );
					el = parser.createElement( line );
					if( el != null ) {
						counter++;						
						if( counter < 200000 ) 
							out.write( el + System.getProperty("line.separator") );
						//System.out.println( line );
						//System.out.println( el );
						el.hashCode();
					}
				}
			}
		}
		catch (java.io.FileNotFoundException e){ 
			problem = true;
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){
			problem = true;
			System.out.print( e.getMessage() );			
		}

		System.out.println( "counter = " + counter );
		System.out.println( "ParserCounter = " + parser.getCounter() );
		
		System.out.println( counter / (double)parser.getCounter() );

		LogService.logDBClose();
		try{
			if( out != null ) out.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}

		assertFalse( problem );
	}
		
	
	@Test
	//@Ignore
	public void testBracket() {

		
		List<String> input = load( "SP1" );
		List<String> solution = load( "SP1.res" );
		Matcher m;
		String result;
		int i = 0;
		
		for( String s : input ){

			if( s.length() == 0 ) continue;
			
			m = sigP.matcher(s);
			if( m.find() ) continue;

			m = unfinishedP.matcher(s);
			if( m.find() ) continue;

			m = resumedP.matcher(s);
			if( m.find() ) continue;

			result = parser.getPars( s ).toString();		
			//System.out.println( s + "\n->>> " + result );
			
			assertTrue( result.equals( solution.get( i++ ) ) );			
		}		
	}

	
	@Test
	//@Ignore
	public void testSplitArray() {

		List<String> input = load( "SP2" );
		List<String> solution = load( "SP2.res" );
		List<String> result;
		int i = 0;
			
		for( String s : input ){

			result = parser.splitArray( s );		
			for( String c : result ){				
				assertTrue( c.equals( solution.get( i++ ) ) );
			}
			if( result.size() > 0 ) i++;						
		}		
	}
	

	@Test
	//@Ignore
	public void testSplitSet() {

		List<String> input = load( "SP3" );
		List<String> solution = load( "SP3.res" );
		List<String> result;
		int i = 0;
			
		for( String s : input ){

			result = parser.splitSet( s );		
			for( String c : result ){				
				//System.out.println( solution.get( i ) );
				assertTrue( c.equals( solution.get( i++ ) ) );
			}
			if( result.size() > 0 ) i++;
			//System.out.println();
		}		
	}


	@Test
	//@Ignore
	public void testBatch() {		
		
		assertTrue( worksCorrectly( "getdents64" ) );
		assertTrue( worksCorrectly( "mmap2" ) );
		assertTrue( worksCorrectly( "select" ) );
		assertTrue( worksCorrectly( "munmap" ) );
		assertTrue( worksCorrectly( "_llseek" ) );
		assertTrue( worksCorrectly( "lseek" ) );
		assertTrue( worksCorrectly( "fstat64" ) );
		assertTrue( worksCorrectly( "writev" ) );
		assertTrue( worksCorrectly( "access" ) );
		assertTrue( worksCorrectly( "fcntl64" ) );
		assertTrue( worksCorrectly( "ioctl" ) );
		
		assertTrue( worksCorrectly( "mprotect" ) );
		assertTrue( worksCorrectly( "futex" ) );
		assertTrue( worksCorrectly( "poll" ) );
				
		assertTrue( worksCorrectly( "lstat64" ) );
		assertTrue( worksCorrectly( "stat64" ) );
		
		assertTrue( worksCorrectly( "recvUni" ) );
		assertTrue( worksCorrectly( "sendUni" ) );
		assertTrue( worksCorrectly( "rt_sigaction" ) );
		assertTrue( worksCorrectly( "fd/brk_clock_get_time" ) );
		assertTrue( worksCorrectly( "nanosleep" ) );
		assertTrue( worksCorrectly( "pathNullProblem" ) );
		
		
		//<unfinished..> und <...resumed>
		assertTrue( worksCorrectly( "Broken4" ) );
		
		assertTrue( worksCorrectly( "Verona" ) );
		assertTrue( worksCorrectly( "MultiProc" ) );
		
		//Seiteneffekte und Filedeskriptoren
		assertTrue( worksCorrectly( "fd/open" ) );		
		assertTrue( worksCorrectly( "fd/dup2" ) );
		assertTrue( worksCorrectly( "fd/execve" ) );
		assertTrue( worksCorrectly( "fd/clone" ) );
		assertTrue( worksCorrectly( "fd/tricky" ) );
		assertTrue( worksCorrectly( "fd/pipe" ) );
		assertTrue( worksCorrectly( "fd/socket" ) );
		assertTrue( worksCorrectly( "fd/inotify" ) );
		assertTrue( worksCorrectly( "fd/accept" ) );
		assertTrue( worksCorrectly( "fd/fork_vfork" ) );
		assertTrue( worksCorrectly( "fd/unshare" ) );
		
		
				
	}
	

	@Test
	//@Ignore
	public void testActive() {
	
		//String call = "fd/socket";
		String call = "DAseq";
		//String call = "../../data/ge4";
	
		DimType[] dims = { DimType.PATH };
		SysParameter par = new SysParameter( dims );
		System.out.println(par);
		SysParser parser = new SysParser( par );		
		
		List<String> input = load( call );		
		//List<String> solution = load( call + ".res" );
		//int i = 0;

		SysElement el;
		//String result;
		boolean problem = false;		

		for( String line : input ){			
			if( line.length() > 0 ){
				//result = solution.get(i++);
				//System.out.println( "Input = " + line );
				el = parser.createElement( line );				
				//System.out.println( el );
				//System.out.println( el.toShortString() );
				System.out.println( el );
				//System.out.println( result + "  " + i  );				
//				if( ! el.toString().equals( result.trim() ) ){
//					problem = true;
//					System.out.println( el );
//					System.out.println( result + "  " + i  );
//				}
			}
		}				
		assertFalse( problem );	
	}


	@Test
	//@Ignore
	public void testFd() {
	
		String call = "pathNullProblem";		
			
		List<String> input = load( call );		
		//List<String> solution = load( call + ".res" );
		//int i = 0;

		SysElement el;
		//String result;
		boolean problem = false;		

		for( String line : input ){			
			if( line.length() > 0 ){
				//result = solution.get(i++);
				//System.out.println( "Input = " + line );
				el = parser.createElement( line );				
				//System.out.println( el );
				//System.out.println( el.toShortString() );
				System.out.println( el );
				el.hashCode();
				//System.out.println( result + "  " + i  );				
//				if( ! el.toString().equals( result.trim() ) ){
//					problem = true;
//					System.out.println( el );
//					System.out.println( result + "  " + i  );
//				}
			}
		}				
		assertFalse( problem );	
	}

	
	
	@Test
	//@Ignore
	public void testMultiSeq() {

		String file = "DimStuff/Seq";

		DimType[] dims = { DimType.PATH, DimType.CALL, DimType.SEQUENCE };
		SysParameter par = new SysParameter( dims );

		SysParser parser = new SysParser( par );

		List<String> input = load( file );		
		List<String> solution = load( file + ".res" );
		int i = 0;

		SysElement el;
		String result;
		boolean problem = false;		

		for( String line : input ){			
			if( line.length() > 0 ){
				result = solution.get(i++);		
				el = parser.createElement( line );				
				if( ! el.toString().equals( result.trim() ) ){
					problem = true;
				}
			}
		}				
		assertFalse( problem );


		DimType[] dims2 = { DimType.CALL, DimType.SEQUENCE };
		par = new SysParameter( dims2 );

		parser = new SysParser( par );

		input = load( file );		
		solution = load( file + "2.res" );
		i = 0;

		for( String line : input ){			
			if( line.length() > 0 ){
				result = solution.get(i++);				
				el = parser.createElement( line );				
				if( ! el.toString().equals( result.trim() ) ){
					problem = true;
				}
			}
		}				
		assertFalse( problem );


		DimType[] dims3 = { DimType.PATH, DimType.SEQUENCE };
		par = new SysParameter( dims3 );

		parser = new SysParser( par );

		input = load( file );		
		solution = load( file + "3.res" );
		i = 0;

		for( String line : input ){			
			if( line.length() > 0 ){
				result = solution.get(i++);
				el = parser.createElement( line );				
				if( ! el.toString().equals( result.trim() ) ){
					problem = true;
				}
			}
		}				
		assertFalse( problem );
		
		
		DimType[] dims4 = { DimType.PATH, DimType.CALL, DimType.RETURN };
		par = new SysParameter( dims4 );

		parser = new SysParser( par );

		input = load( file );		
		solution = load( file + "4.res" );
		i = 0;

		for( String line : input ){			
			if( line.length() > 0 ){
				result = solution.get(i++);
				el = parser.createElement( line );				
				if( ! el.toString().equals( result.trim() ) ){
					problem = true;
				}
			}
		}				
		assertFalse( problem );

	}
	

	@Test
	//@Ignore
	public void testBuffer() {
		
		ProcTable pt = new ProcTable( par );
		int i = 0;
		String result;
		List<String> solution = load( "ProcTable/RoundBuffer.res" );
		
		for( int c = 0; c < 12; c++ ){
			pt.putCall( c );
			result = solution.get(i++);
		//	System.out.println( Arrays.toString(pt.getCalls()) + "  result =  " + result );
			assertTrue( result.equals( Arrays.toString(pt.getCalls()) ) );
		}
	}

	
	@Test
	//@Ignore
	public void testCleanPath() {

		String[] path  = { "\"/etc///ld.so.nohwcap\"",
				"////etc/ld.so.nohwcap",
				"/////etc//////ld.so.nohwcap",
				"/usr/lib/eclipse",
				"//usr/lib//eclipse/plugins//org.eclipse.platform_3.2.2.r322_v20070117b/////nl/de/DE/splash.bmp",
				"\"/Socket\""};
		String[] clean = { "/etc/ld.so.nohwcap",
				"/etc/ld.so.nohwcap",
				"/etc/ld.so.nohwcap",
				"/usr/lib/eclipse",
				"/usr/lib/eclipse/plugins/org.eclipse.platform_3.2.2.r322_v20070117b/nl/de/DE/splash.bmp",
				"/Socket"};		
		
		for( int i = 0; i < path.length; i++ ){
			System.out.println( parser.cleanPath(path[i]) );
			assertTrue( parser.cleanPath(path[i]).equals( clean[i] ) );			
		}
		
	}
	
	
	public static List<String> mySplitArray( String line ){

		String STRING = "\"[^\"]*\"";
			   STRING  = "\"(\\\"|[^\"])*\"";
		String STRINGTRAIL = "(" + STRING + "(\\.\\.\\.)?)";
		String SET = "\\{[^\\}\\{]*\\}";	
		String ARRAY = "\\[[^\\[\\]]*\\]";
		
		String NUMBER = "((-?0x[0-9a-f]+)|(-?[0-9]+))";
		String SYMBOL = "([A-Z_\\|]+)";
		String COM = "(/\\*[^\\*]*\\*/)";
		
		
		
		String EXT_SINGLE = "(" + STRINGTRAIL + "|" + NUMBER +
		"|" + SET + "|" + ARRAY + "|" + SYMBOL + "|" + COM + ")";
		
		Pattern extSingleP = Pattern.compile( EXT_SINGLE ); 
		
		List<String> list = new ArrayList<String>();		
		
		Matcher m = extSingleP.matcher( line.substring(1) ); 

		while( m.find() ){
			list.add( m.group() );				
		}
		return list;
	}

	
	@Test
	@Ignore
	public void testRegExp() {

		String STRING = "(\"((?<=\\\\)\"|[^\"])*\")";
		String STRINGTRAIL = "(" + STRING + "(\\.\\.\\.)?)";

		String FLAT_SET = "(\\{([^\\[\\]\\{\\}\\\"]|" + STRINGTRAIL + ")*\\})";
		String FLAT_ARRAY = "(\\[([^\\[\\]\\{\\}\\\"]|" + STRINGTRAIL + ")*\\])";

		String SET = "(\\{([^\\}\\{]|" + STRINGTRAIL + 
		"|" + FLAT_SET + "|" + FLAT_ARRAY + ")*\\})";			

		String NUMBER = "((-?0x[0-9a-f]+)|(-?[0-9]+))";
		String SYMBOL = "([A-Z_\\|]+)";		
		String CLONE_VAL = "(" + NUMBER + "|" + SYMBOL + ")"; 
		String CLONE_KEY = "(child_stack=|flags=|child_tidptr=|parent_tidptr=)";
		String CLONE_SINGLE = "(" + CLONE_KEY + CLONE_VAL + ")|" + SET;			

		Pattern cloneP = Pattern.compile( CLONE_SINGLE );

		List<String> list = load( "fd/clone2");		

		Matcher m;
		
		for( String s : list ){
			System.out.println( "s = " + s );
			m = cloneP.matcher( s ); 
			while( m.find() ){
				System.out.println(  m.group() );				
			}
		}
	}	
	
		
	private boolean worksCorrectly( String file ) {
		
		List<String> input = load( file );		
		List<String> solution = load( file + ".res" );
		int i = 0;

		SysElement el;
		String result;
		boolean problem = false;		
		//fdTables = new HashMap<String, HashMap<Integer, String> >();				
		parser = new SysParser( par );
		
		for( String line : input ){					
			if( line.length() > 0 ){
				
				el = parser.createElement( line );
				//System.out.println( line + "\n" + el );
				//Er darf Zeilen ueberspringen, z.B. wenn SIGs auftreten
				if( el != null ){					
					result = solution.get(i++);
					if( ! el.toString().equals( result.trim() ) ) problem = true;
				}
			}
		}
		if( i < solution.size() )  problem = true;
		return (! problem );
	}

	
	private List<String> load( String file ){

		List<String> list = new ArrayList<String>();
		String line;
		file = prefix + file;
		int counter = 0;
		
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null && ( counter++ < 100000 )) {							
				if(  ! line.startsWith("#") ) {
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		return list;
	}

}
