package hitters.test;

import hitters.multi.Element;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.StreamReader;

import java.util.Date;
import java.util.HashMap;
import com.google.common.collect.HashMultiset;

/**
 * @author Peter Fricke
 * 
 */
public class StreamReaderUser {

	public static void main(String[] args) {

		final int PART_ANC = 4096;
		final int FULL_ANC = 8192;

		int count = 0;
		int remaining;
		int readCount = 0;
		int algoType = 0;
		double phi = 0.02;
		int delay = 0;

		AbstractComplexHHH hitterAlgo;
		HashMultiset<Element> hashContainer = HashMultiset.create();
		//Vector<Element> vectorContainer = new Vector<Element>();
		//Collection<Element> container = hashContainer;
		//byte[][] plength = {};
		byte[][] plength = { {0,4,8,16,24,32} };
		Parameter par = new Parameter( 2 - plength.length, plength );			

		if( args.length < 3 ) System.out.println( "Anzahl," +
		" Buffersize, Epsilon, AlgoType, Delay  angeben!" );

		long 	lines  = Long.parseLong(   args[0] );
		int buffersize = Integer.parseInt( args[1] );
		double epsilon = Double.parseDouble( args[2] );
		if( args[3].equals("FA") ) algoType = FULL_ANC;
		if( args[3].equals("PA") ) algoType = PART_ANC;
		if( algoType == 0 ) throw new RuntimeException("Algorithmus angeben!");

		// Teste vollen Pipe-Buffer (64k) durch Verzoegern
		if( args.length > 4 ) delay = Integer.parseInt( args[4] );

		System.out.println( "Lines = " + lines + ", buffersize = " +
				buffersize + ", epsilon = " + epsilon + " delay = " + delay );

		switch( algoType ){

		case FULL_ANC: 
			System.out.println( "algoType = FA" ); 
			hitterAlgo = new FullAncHHH( epsilon, par );
			break;

		case PART_ANC: 
			System.out.println( "algoType = PA" ); 
			hitterAlgo = new PartAncHHH( epsilon, par );
			break;

		default: throw new RuntimeException("Algorithmus angeben!"); 
		}


		//AbstractComplexHHH fastPA = new PartAncHHH( epsilon, par );





		StreamReader reader   = new StreamReader( par );		

		System.out.println( "Start: " + new Date() );

		while( count < lines ){

			if( delay > 0 ){
				try { Thread.sleep(delay);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				}	
			}
			remaining = Math.min( buffersize, (int)lines - count );			
			readCount += reader.readLoop( hashContainer, remaining );
			//System.out.println("waitcount= " + waitCount );			
			count += hashContainer.size();			
			for( Element e : hashContainer.elementSet() ){
				//System.out.println(e + " = " + hashContainer.count(e) + " " + count);
				hitterAlgo.insert( e, hashContainer.count(e), true );
			}
		}

		reader.close();		
		System.out.println( "Stop: " + new Date() );
		System.out.println("readcount= " + readCount );
		System.out.println(" N = " + hitterAlgo.getN() );
		HashMap<Element, MultiHitterInfo> res;		
		res = hitterAlgo.outputSet( phi );		
		System.out.println( " Ergebnis fr epsilon = " + epsilon + ", phi = " + phi + ": " );		
		for( Element h : res.keySet() ){		
			System.out.println( h + " " + res.get(h) );			
		}
	}
}
