/**
 * 
 */
package hitters.test;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.AbstractHHH;
import hitters.multi.AlgoType;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.Exact;
import hitters.multi.FullAncHHH;
import hitters.multi.HitterComparator;
import hitters.multi.HitterPolice;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.OLD_AbstractComplexHHH;
import hitters.multi.OLD_FullAncHHH;
import hitters.multi.OLD_PartAncHHH;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.StreamReader;
import hitters.tools.LogService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

import com.google.common.collect.HashMultiset;

/**
 * @author Peter Fricke
 * 
 */
public class ProductionIPGenerator {

	static String DELIMITER = "\n\n************************************\n\n";

	/////////////////////////////////////////////////////////////////
	// 
	// 					Anwendungsarten ( modes )
	//
	/////////////////////////////////////////////////////////////////

	// Erzeuge mehrere Testfaelle und pruefe auf Korrektheit
	static final int MULTIPLE 		= 1; 

	// Pruefe auf Korrektheit anhand eines bestehenden Testfalls
	static final int OLD 			= 2; 

	// Pruefe anhand mehrerer bestehender Testfaelle
	static final int BATCHOLD		= 3; 

	// Erzeuge Testfaelle, vergleiche Ergebnisse versch. Implementierungsvarianten
	static final int MULTICOMPARE	= 4; 

	// Lese von Stdin, zum Lesen der gepipe-ten geloggten SystemCalls
	static final int STREAM			= 5; 

	// Erzeuge Testfaelle, vergleiche Ergebnisse fuer Epsilon = 0 mit Exact
	static final int EXACT			= 6; 

	// Erzeuge Testfaelle, vergleiche Ergebnisse fuer Epsilon != 0 anhand
	// Precision, Recall, Jaccard, Dice mit Exact
	static final int QUALITY		= 7; 

	// Erzeuge Testfaelle, vergleiche Ergebnisse versch. Implementierungsvarianten
	static final int MULTICOMPARE_2	= 8; 

	// Messe Aenderung der Abstandsmasse bei kleiner Aenderung des Stroms
	static final int EVALUATION	= 9; 
	
	// Vergleiche Ergebnisse der getesteten Version mit der neuen, 
	// entschlackten Version
	static final int FORKCHECK	= 10; 

	//Laufzeiten messen
	//static final int SPEED	= 11; 

	
	
	/////////////////////////////////////////////////////////////////
	// 
	// 					Verteilungen/Groessen ( distr )
	//
	/////////////////////////////////////////////////////////////////

	static final int TINY   = 1;  // Winzige Testfaelle, klein genug fuer Handberechnung
	static final int UNIBIG = 2;
	static final int MEDIUM = 3;
	static final int SKEWED = 16; // Gross und schief
	static final int EPSI_0 = 32; // Epsilon = 0 fuer mode = EXACT 


	/////////////////////////////////////////////////////////////////
	// 
	// 					Algorithmen ( algo )
	//
	/////////////////////////////////////////////////////////////////



	static int mode;//  = MULTIPLE;//MULTICOMPARE;
	static int distr;// = MEDIUM;						
	static AlgoType algo;
	static String file;	

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		//byte[][] plength = { {0,4,8,16,24,32}, {0,4,8,16,24,32} };
		//byte[][] plength = { {0,16,32}, {0,32} };
		//byte[][] plength = { {0,16,32}, {0,16,32} };
		//byte[][] plength = { {0,32} };
		//byte[][] plength = { {0,8,16,24,28,32} };
		byte[][] plength = { };
		Parameter par = new Parameter( 2 - plength.length, plength );				

		// Schreibe berechnete Loesung in Testdatei
		boolean writeSolution = true;			

		// Vergleiche gefundene Loesung mit Loesung in Testdatei
		boolean compareToFileSolution = false;	

		double phi, epsilon;
		int numberOfTestcases, offset = 0;
		boolean bug = false;

		System.out.println( "Start: " + new Date() );

		if( args.length < 2 ){
			throw new RuntimeException( "Dateinamen fr " +
					"Testcase(s) und Zahl der Flle und " +
			"Offset in Kommandozeile angeben!");

		}
		else{
			file = args[0].trim();
			numberOfTestcases = Integer.parseInt( args[1].trim() );
			if( args.length > 2 ) offset = Integer.parseInt( args[2].trim() );
			if( args.length > 3 ) LogService.DEBUG = Integer.parseInt(args[3].trim());
			else LogService.DEBUG = LogService.SILENT;

			if( args.length > 4 ){
				char[] flags = args[4].toCharArray();
				for( char c : flags ){
					switch( c ){				
					case 'M': par.setMBug(true);	break;
					case 'B': par.setBProb(true);	break;
					case 'F': algo = AlgoType.FULL_ANC;	break;
					case 'P': algo = AlgoType.PART_ANC;	break;
					case 'm': mode = MULTIPLE;		break;
					case 'o': mode = OLD;			break;
					case 'b': mode = BATCHOLD;		break;
					case 'c': mode = MULTICOMPARE;	break;
					case '2': mode = MULTICOMPARE_2;break;
					case 's': mode = STREAM;		break;
					case 'e': mode = EXACT;			break;
					case 'q': mode = QUALITY;		break;
					case 'v': mode = EVALUATION;	break;
					case 'f': mode = FORKCHECK;		break;
					case 't': distr = TINY;			break;
					case 'd': distr = MEDIUM;		break;
					case 'u': distr = UNIBIG;		break;
					case 'w': distr = SKEWED;		break;
					}
				}
			}
		}

		if( mode == EXACT ) distr = EPSI_0;

		if( mode == 0 || distr == 0 || algo == null )
			throw new RuntimeException( "Parameter angeben!" );		


		switch( mode ){

		//////////////////////////////////////////////////////////////////
		// 
		//  Erzeugen von Testfllen und Test
		//
		//////////////////////////////////////////////////////////////////
		case MULTIPLE:			

			writeSolution = false;
			compareToFileSolution = false;

			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );

			for( long seed = offset; seed <= offset - 1 + numberOfTestcases; seed++ ){				

				writeTestcase( par, seed, distr, writeSolution );
				phi = readPhi( par );
				epsilon = readEpsilon( par );
				if( test( file, par, phi, epsilon, compareToFileSolution ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed + DELIMITER );
				}

				//if( (seed+1) % 1000 == 0 ) 
				System.out.println( "Fortschritt: " + 
						seed + " phi " + phi + " epsilon " + epsilon );
			}

			System.out.println( "Habe fertig: (" + par.getDimS() + ", " + 
					par.getDimI() + ") " + numberOfTestcases + " mit Offset " +
					offset + " berechnet." );

			System.out.println( "Bugs: " + bug );
			break;

			//////////////////////////////////////////////////////////////
			// 
			//  Test bestehender Dateien
			//
			//////////////////////////////////////////////////////////////
		case OLD:

			System.out.println( "mode = old: Lese Datei " + file );

			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );			

			if( test( file, par, readPhi( par ), readEpsilon( par ),
					compareToFileSolution ) == false ){

				bug = true;
				System.out.println( " BUG " + DELIMITER);
			}
			System.out.println( "Bugs: " + bug );
			System.out.println( " done" );
			break;

			//////////////////////////////////////////////////////////////
			// 
			//  Test anhand mehrerer bestehender Dateien
			//
			//////////////////////////////////////////////////////////////
		case BATCHOLD: 
			throw new RuntimeException( "BATCHOLD not impl");
			//break;

			//////////////////////////////////////////////////////////////
			// 
			//  Erzeugen von Testfllen und Test, 
			//  vergleiche Ergebnisse versch. Implementierungsvarianten
			//
			//////////////////////////////////////////////////////////////
		case MULTICOMPARE:

			byte[][] pl1 = { };
			byte[][] pl2 = { {0,32} };			
			byte[][] pl3 = { {0,16,32}, {0,32} };
			//byte[][] plength = { {0,8,16,24,28,32} };
			//byte[][] plength = { };
			//byte[][] plength = { {0,4,8,16,24,28,32}, {0,4,8,16,24,28,32} };

			Parameter par1 = new Parameter( 2 - pl1.length, pl1 );
			Parameter par2 = new Parameter( 2 - pl2.length, pl2 );
			Parameter par3 = new Parameter( 2 - pl3.length, pl3 );

			writeSolution = true;
			compareToFileSolution = true;

			printSetup( par1, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						
			printSetup( par2, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						
			printSetup( par3, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						

			for( long seed = offset; seed <= offset - 1 + numberOfTestcases; seed++ ){

				// Testcase mit Parametersatz 1 schreiben, spaeter die Loesungen 
				// anderer Varianten mit der dabei in die Datei geschriebenen Loesung 
				// vergleichen.
				writeTestcase( par1, seed, distr, writeSolution );				
				phi = readPhi( par1 );
				epsilon = readEpsilon( par1 );

				// Loesung des ersten Parametersatzes auf Korrektheit testen
				if( test( file, par1, phi, epsilon, false ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed +
							" mit par 1 " + DELIMITER );
				}								
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );

				// Loesung des zweiten Parametersatzes auf Korr. testen und 
				// mit Loesung des ersten Parametersatzes vergleichen
				if( test( file, par2, phi, epsilon, true ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed + " mit par 2" +
							", evtl. im Vgl. mit par1 " + DELIMITER );
				}				
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );		

				// Loesung des dritten Parametersatzes auf Korr. testen und 
				// mit Loesung des ersten Parametersatzes vergleichen
				if( test( file, par3, phi, epsilon, true ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed + " mit par 3, evtl. " +
							"im Vgl. mit par1 " + DELIMITER );
				}
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );

				//	if( (seed+1) % 100 == 0 ) 
				System.out.println( "Fortschritt: " + seed + " phi " +
						phi + " epsilon " + epsilon );
			}

			System.out.println( "Habe fertig: (" + par1.getDimS() + ", " + 
					par1.getDimI() + ") " + numberOfTestcases + " mit Offset " +
					offset + " berechnet.\n" + par2 + par3 );

			System.out.println( "Bugs: " + bug );

			break;

			//////////////////////////////////////////////////////////////
			// 
			//  Erzeugen von Testfllen und Test, 
			//  vergleiche Ergebnisse des exakten Algo mit approx. 
			//  und epsilon = 0.
			//
			//////////////////////////////////////////////////////////////
		case EXACT:

			byte[][] pl = { };

			Parameter parEps0 = new Parameter( 2 - pl.length, pl );

			printSetup( parEps0, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						

			for( long seed = offset; seed <= offset - 1 + numberOfTestcases; seed++ ){

				// Testcase schreiben, spaeter die Loesungen 
				// des exakten Algos mit der dabei in die Datei geschriebenen Loesung 
				// vergleichen.
				System.out.println( "Start appr  " + new Date() );
				writeTestcase( parEps0, seed, EPSI_0, true );		
				System.out.println( "Stop appr  " + new Date() );

				phi = readPhi( parEps0 );
				epsilon = readEpsilon( parEps0 );
				if( epsilon > 1E-9 ) throw new RuntimeException("Epsilon ist groesser 0");				

				// Loesung auf Korrektheit testen
				if( test( file, parEps0, phi, epsilon, false ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed +
							" mit Approx. " + DELIMITER );
				}				
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );

				// Mit Loesung des exakten Algos vergleichen.
				System.out.println( "Start ex  " + new Date() );
				if( compareToExact( file, parEps0, phi ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed +
							" im Vgl. mit Exact " + DELIMITER );
				}				
				System.out.println( "Stop ex  " + new Date() );				

				//	if( (seed+1) % 100 == 0 ) 
				System.out.println( "Fortschritt: " + seed + " phi " +
						phi + " epsilon " + epsilon );
			}

			System.out.println( "Habe fertig: " + numberOfTestcases + " Testcase " +
					" mit Offset " + offset + " berechnet und mit Exact vergl." );

			System.out.println( "Bugs: " + bug );

			break;


			//////////////////////////////////////////////////////////////
			// 
			// Erzeuge Testfaelle, vergleiche Ergebnisse fuer 
			// Epsilon != 0 anhand Precision, Recall, Jaccard, Dice 
			// und OMG mit Exact
			//
			//////////////////////////////////////////////////////////////
		case QUALITY:

			Exact myExact;
			AbstractComplexHHH hitterAlgo;
			HashMap<Element, MultiHitterInfo> exact;
			HashMap<Element, MultiHitterInfo> approx;
			double precision, recall, jaccard, dice, omg;

			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						


			for( long seed = offset; seed <= offset - 1 + numberOfTestcases; seed++ ){

				// Testcase schreiben, spaeter die Loesungen 
				// des exakten Algos darauf mit verschiedenen approx.
				// Loesungen vergleichen und Qualitaetsmasse berechnen.
				writeTestcase( par, seed, distr, false );		

				myExact = fillExact( file, par );

				for( double myEps = 0.005; myEps < 0.05; myEps += 0.005 ){

					hitterAlgo = fillApprox( file, par, myEps );

					for( double myPhi = 2 * myEps; myPhi < 0.1; myPhi += 0.01 ){

						//System.out.println( "vor exact " + new Date() );
						exact  = myExact.outputSet( myPhi );
						//System.out.println( "nach exact " + new Date() );
						approx = hitterAlgo.outputSet( myPhi );
						//System.out.println( "nach approx " + new Date() );
						precision = Evaluation.precision( 
								approx.keySet(), exact.keySet() );

						recall = Evaluation.recall( 
								approx.keySet(), exact.keySet() );

						jaccard = Evaluation.jaccard( 
								approx.keySet(), exact.keySet() );

						dice = Evaluation.dice( 
								approx.keySet(), exact.keySet() );
						
						// Nur begrenzt sinnvoll, siehe Kommentare
						omg = Evaluation.ogmGanesan( 
								approx.keySet(), exact.keySet() );
						
//						System.out.println( myEps + "\t" + myPhi + "\t" + 
//								exact.size() + "\t" + approx.size() + "\t" +
//								precision + "\t" + recall + "\t" + jaccard +
//								"\t" + dice + "\t" + omg );
						System.out.println( Evaluation.compactAll(
								approx.keySet(), exact.keySet()) );
					}
					System.out.println();
				}
			}
			break;


			//////////////////////////////////////////////////////////////
			// 
			//   Stream
			//  
			//
			//////////////////////////////////////////////////////////////
		case STREAM:

			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );			

			phi = 0.01;
			epsilon = 0.001;

			System.out.println( "Arbeite mit phi = " + phi + 
					", epsilon = " + epsilon );

			if( streamTest( file, par, phi, epsilon ) == false ){
				bug = true;
				System.out.println( " BUG " + DELIMITER );
			}

			System.out.println( "Habe fertig: (" + par.getDimS() + ", " + 
					par.getDimI() + ")  mit Offset " +
					offset + " berechnet." );

			System.out.println( "Bugs: " + bug );

			break;
		
			
			
			//////////////////////////////////////////////////////////////
			// 
			//  Erzeugen von Testfllen und Test, 
			//  vergleiche Ergebnisse versch. Implementierungsvarianten
			//
			//////////////////////////////////////////////////////////////
		case MULTICOMPARE_2:
			
			writeSolution = true;
			compareToFileSolution = true;

			// Erst unoptimiert und sicher:
			par.setOptimizeOutput(false);
			
			
			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						

			for( long seed = offset; seed <= offset - 1 + numberOfTestcases; seed++ ){

				// Testcase schreiben, spaeter die Loesungen 
				// anderer Varianten mit der dabei in die Datei geschriebenen Loesung 
				// vergleichen.
				writeTestcase( par, seed, distr, writeSolution );				
				phi = readPhi( par );
				epsilon = readEpsilon( par );				
				
				// Loesung auf Korrektheit testen
				if( test( file, par, phi, epsilon, false ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed + DELIMITER );
				}								
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );				
				
				// Optimiert auf demselben Problem sollte selbe Loesung ergeben
				par.setOptimizeOutput(true);
				
				// Loesung auf Korr. testen und 
				// mit Loesung des ersten Laufs vergleichen
				if( test( file, par, phi, epsilon, true ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed + DELIMITER );
				}				
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );		
								
				if( (seed+1) % 100 == 0 ) 
					System.out.println( "Fortschritt: " + seed + " phi " +
							phi + " epsilon " + epsilon );
			}

			System.out.println( "Habe fertig: (" + par.getDimS() + ", " + 
					par.getDimI() + ") " + numberOfTestcases + " mit Offset " +
					offset + " berechnet.\n" );

			System.out.println( "Bugs: " + bug );

			break;

			//////////////////////////////////////////////////////////////
			// 
			//  Messe Aenderung der Abstandsmasse bei kleiner Aenderung
			//  des Stroms.
			//
			//////////////////////////////////////////////////////////////
		case EVALUATION:			

			writeSolution = false;
			compareToFileSolution = false;

			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );

			writeTestcase( par, offset, distr, writeSolution );
			phi = readPhi( par );
			epsilon = readEpsilon( par );
			evaluationStability( file, par, phi, epsilon, offset );				

			break;


			//////////////////////////////////////////////////////////////
			// 
			// Vergleiche Ergebnisse der getesteten Version mit der neuen, 
			// entschlackten Version.
			//
			//////////////////////////////////////////////////////////////
		case FORKCHECK:			

			byte[][] myPlength = { };
			par = new Parameter( 2 - myPlength.length, myPlength );				
			//byte[][] plength = { {0,8,16,24,28,32} };
			//byte[][] plength = { };
			//byte[][] plength = { {0,4,8,16,24,28,32}, {0,4,8,16,24,28,32} };

			writeSolution = true;
			compareToFileSolution = true;

			printSetup( par, numberOfTestcases, offset, 
					writeSolution, compareToFileSolution );						

			for( long seed = offset; seed <= offset - 1 + numberOfTestcases; seed++ ){

				// Testcase schreiben, spaeter die Loesungen 
				// anderer Varianten mit der dabei in die Datei geschriebenen Loesung 
				// vergleichen.
				writeTestcase( par, seed, distr, writeSolution, AlgoType.OLD_PART_ANC );				
				phi = readPhi( par );
				epsilon = readEpsilon( par );

				//						System.out.println("Geschrieben");
				//						try{
				//							Thread.sleep( 60000 );
				//						}catch( Exception e ){}
				//						System.out.println("Weiter");
				//						
				// Loesung der ersten Implementierung auf Korrektheit testen
				if( test( file, par, phi, epsilon, false, AlgoType.OLD_PART_ANC ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed +
							", erste Impl rechnet falsch." + DELIMITER );
				}								
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );

				// Loesung der zweiten Implementierung auf Korr. testen und 
				// mit Loesung der ersten Implementierung vergleichen
				if( test( file, par, phi, epsilon, true, AlgoType.PART_ANC ) == false ){
					bug = true;
					System.out.println( " BUG BEI : " + seed + " zweite Impl. falsch, oder " +
							"erste hat falsches Ergebnis in Datei geschr." + DELIMITER );
				}				
				if( LogService.shouldLog(LogService.COMPARE) ) 
					LogService.log( LogService.COMPARE, DELIMITER );		

				//	if( (seed+1) % 100 == 0 ) 
				System.out.println( "Fortschritt: " + seed + " phi " +
						phi + " epsilon " + epsilon );
			}

			System.out.println( "Habe fertig: (" + par.getDimS() + ", " + 
					par.getDimI() + ") " + numberOfTestcases + " mit Offset " +
					offset + " berechnet.\n" );

			System.out.println( "Bugs: " + bug );

			break;

		}

		LogService.logDBClose();
		System.out.println( "Stop: " + new Date() );
	}


	public static void writeTestcase( Parameter par, long seed,
			int distrib, boolean writeSolution ){
	
		writeTestcase( par, seed, distrib, writeSolution, algo );		
	}
	
	
	public static void writeTestcase( Parameter par, long seed,
			int distrib, boolean writeSolution, AlgoType algo ){

		Random gen        = new Random( seed );	
		MultiDatabase d   = new MultiDatabase( file, par );
		List<Element> res = new LinkedList<Element>();
		String[] s        = new String[par.getDim()];
		String[] sStr     = new String[par.getDimS()];
		String[] iStr     = new String[par.getDimI()];	
		String[][] hit = null;		
		//AbstractComplexHHH hitterAlgo;
		//AbstractHHH hitterAlgo;
		List<Map.Entry<Element, MultiStringElement>> dump = null;
		HashMap<Element, MultiHitterInfo> partAncHitters  = null;
		double epsilon = 0;
		double phi = 0;		
		int N = 0;			
		int rep = -1;

		for( int i=0; i< 10; i++) gen.nextDouble(); //Einschwing

		switch( distrib ){

		case TINY:

			//			phi = 0.3;			
			//			N = 10;
			//			epsilon = 0.2;

			phi = gen.nextDouble() * 0.35;			
			N = 15 + (int)seed/10000;
			epsilon = gen.nextDouble() * phi;
			hit = getTinyHitters();						
			break;

		case MEDIUM:
			phi = gen.nextDouble() * 0.3;			
			N = 10000 + (int)seed/100;
			epsilon = gen.nextDouble() * phi;			
			hit = getMediumHitters();			
			break;

		case UNIBIG:			
			phi = gen.nextDouble() * 0.05 + 0.005;
			if( gen.nextInt(10) > 7 ) phi *= 4;
			epsilon = gen.nextDouble() * phi; 	//eps <= phi
			N = 100000;
			if( gen.nextInt(10) > 8 ) N = N * 10;
			hit = getHitters();						
			break;			

		case SKEWED:			
			phi = gen.nextDouble() * 0.05 + 0.005;
			if( gen.nextInt(10) > 7 ) phi *= 4;
			epsilon = gen.nextDouble() * phi; 	//eps <= phi		
			N = 10000;
			hit = getHitters();						
			break;		

		case EPSI_0:			
			phi = gen.nextDouble() * 0.05 + 0.005;
			if( gen.nextInt(10) > 7 ) phi *= 4;
			epsilon = 0;		
			N = 10000;
			hit = getHitters();						
			break;
		}


		//System.out.println( phi + ", " + epsilon + ", " + N);		

		int min = (int)Math.ceil( phi * N );


		for( int i = 0; i < hit.length; i++ ){
			for( int k = 0; k < min; k++ ){
				s = new String[par.getDim()];

				s[0] = hit[i][0];
				s[1] = hit[i][1];				

				switch( distrib ){				
				case TINY:
					s = randomTinyCompletion( s, gen );
					break;					
				case MEDIUM:
					s = randomMediumCompletion( s, gen );
					break;					
				case UNIBIG:	// Wie Skewed		
				case EPSI_0:	
				case SKEWED:
					s = randomCompletion( s, gen );	
					break;									
				}							

				if( LogService.shouldLog(LogService.NORMAL) )
					LogService.log( LogService.NORMAL, s[0] + ", " +s[1]);

				// Interne Darstellung als int und String muss mglich sein
				sStr = new String[par.getDimS()];
				iStr = new String[par.getDimI()];
				for( int p = 0; p < par.getDimS(); p++ ) sStr[p] = s[p];
				for( int q = 0; q < par.getDimI(); q++ ) iStr[q] = s[q + par.getDimS()];

				res.add( Element.createElement( sStr, iStr, par ) ); 				
			}
		}

		int counter = res.size();

		while( counter < N ){		
			s = new String[par.getDim()];
			s[0] = "";
			s[1] = "";

			switch( distrib ){				
			case TINY:
				s = randomTinyCompletion( s, gen );
				break;					
			case MEDIUM:
				s = randomMediumCompletion( s, gen );
				break;					
			case UNIBIG: 	// Wie Skewed
			case EPSI_0:	
			case SKEWED:
				s = randomCompletion( s, gen );	
				break;									
			}

			if( distrib == SKEWED ) rep = gen.nextInt(20);
			else rep = 6;

			for( int i = 0; i < rep; i++ ){ //Selbes Element mehrfach einfgen
				if( counter < N ){
					sStr = new String[par.getDimS()];
					iStr = new String[par.getDimI()];
					for( int p = 0; p < par.getDimS(); p++ ) sStr[p] = s[p];
					for( int q = 0; q < par.getDimI(); q++ ) iStr[q] = s[q + par.getDimS()];
					res.add( Element.createElement( sStr, iStr, par ) ); 				
					counter++;
				}
			}
		}		

		Collections.shuffle( res, gen ); // gen fr Reproduzierbarkeit

		// Schreibe Zustand der Datenstruktur vor der Ausgabe und
		// die ausgegebenen Hitter. So lassen sich verschiedene Implementierungen,
		// optimierte Varianten usw. leichter vergleichen und obskure Bugs
		// leichter isolieren.
		if( writeSolution ){

			AbstractHHH hitterAlgo;
			
			switch( algo ){
			case FULL_ANC: hitterAlgo = new FullAncHHH( epsilon, par ); break;
			case PART_ANC: hitterAlgo = new PartAncHHH( epsilon, par ); break;
			case OLD_FULL_ANC: hitterAlgo = new OLD_FullAncHHH( epsilon, par ); break;
			case OLD_PART_ANC: hitterAlgo = new OLD_PartAncHHH( epsilon, par ); break;
			
			default: throw new RuntimeException("Kein Algorithmus gewaehlt");
			}

			for( Element element : res ){				
				hitterAlgo.insert( element.clone(), 1, true );			
			}

			if( algo == AlgoType.PART_ANC || algo == AlgoType.FULL_ANC ){
				dump = ( (AbstractComplexHHH) hitterAlgo).dumpTrie();
			}
			else{				
				dump = ( (OLD_AbstractComplexHHH) hitterAlgo).dumpTrie();
			}
			partAncHitters = hitterAlgo.outputSet(phi);
		}

		d.openWrite();
		d.println( "# Synthetische Daten, erzeugt: " + new Date() );
		d.println( "#");
		d.println( "#? Geschrieben von ProductionIP-Generator (Generic) mit seed " + seed);
		d.println( "#");
		d.println( "# Parameter: \n" + par );
		d.println( "# Tatschliche Dimensionen fr String und Int:");
		d.println( "#$ " + par.getDimS() + " | " + par.getDimI() );
		d.println( "#");		
		d.println( "# N, phi, Epsilon" );
		d.println( "#% " + N + " | " + phi + " | " + epsilon );
		d.println( "#");
		d.println( "#");
		for( int i = 0; i < hit.length; i++ ){
			d.println( "#@ " + hit[i][0] + " | " + hit[i][1] + " | " + min);
		}
		d.println( "#\n#\n#");

		if( writeSolution ){

			d.println( "# Algo: " + algo );
			d.println( "# Epsilon: " + epsilon );
			d.println( "# Phi: " + phi );
			d.println( "# Ausgegebene HHH: Praefix, fmin, fmax, F");
			for( Map.Entry<Element, MultiHitterInfo> hitter : partAncHitters.entrySet() ){
				d.println( "#= " + hitter.getKey().get(0) + 
						" | " + hitter.getKey().get(1) +
						" | " + hitter.getValue().fmin +
						" | " + hitter.getValue().fmax +
						" | " + hitter.getValue().F );
			}
			d.println( "#\n#\n#");

			d.println( "# Datenstruktur nach Einfgen aller Items: Praefix, g, m, delta");
			for( Map.Entry<Element, MultiStringElement> node : dump ){
				d.println( "#* " + node.getKey().get(0) + 
						" | " + node.getKey().get(1) +						
						" | " + node.getValue().g +
						" | " + node.getValue().m +
						" | " + node.getValue().delta );
			}

			d.println( "#\n#\n#");			
		}

		for( Element a : res ){
			d.println( a.get(0) + " | " + a.get(1) );
		}				
		d.closeWrite();
	}


	private static String[] randomTinyCompletion(String[] s, Random gen) {

		for( int j = s[0].length()/2; j < 2; j++ ) 
			s[0] = s[0] + "/" + (gen.nextInt(2)+1);

		for( int j = s[1].length()/2; j < 1; j++ ) 
			s[1] = s[1] + "/" + (gen.nextInt(2)+1);

		return s;
	}


	private static String[] randomMediumCompletion(String[] s, Random gen) {

		for( int j = s[0].length()/2; j < 2; j++ ) 
			s[0] = s[0] + "/" + (gen.nextInt(4)+1);

		for( int j = s[1].length()/2; j < 2; j++ ) 
			s[1] = s[1] + "/" + (gen.nextInt(4)+1);

		return s;
	}


	private static String[] randomCompletion(String[] s, Random gen) {

		for( int j = s[0].length()/2; j < 5; j++ )
			s[0] = s[0] + "/" + (gen.nextInt(4)+1);

		for( int j = s[1].length()/2; j < 5; j++ )
			s[1] = s[1] + "/" + (gen.nextInt(4)+1);

		return s;
	}


	private static String[][] getTinyHitters() {
		String[][] hit = { {"/1",""}, {"/2",""} };
		return hit;
	}

	private static String[][] getMediumHitters() {
		String[][] hit = { {"/1",""}, {"/2",""} };
		return hit;
	}


	private static String[][] getHitters() {
		String[][] hit = { {"/1",""}, {"","/2"}, 
				{"/1","/3"}, {"/2","/4"} };
		return hit;
	}


	public static boolean test( String file, Parameter par,
			double phi, double epsilon, boolean compareToFileSolution ) {				
	
		return test( file, par, phi, epsilon,
				compareToFileSolution, algo);				

	}
	

	public static boolean test( String file, Parameter par, double phi, 
			double epsilon, boolean compareToFileSolution, AlgoType algo ) {				

		boolean erg;

		if( algo == AlgoType.PART_ANC || algo == AlgoType.FULL_ANC){			
			AbstractComplexHHH hitter = fillApprox(file, par, epsilon, algo);			
			erg = HitterPolice.check( file, hitter, par, phi, false);
			if( compareToFileSolution )
				erg = erg && HitterPolice.compareToSolution( file,
						hitter, par, phi, false );	
		}
		else{
			OLD_AbstractComplexHHH oldHitter = fillOld(file, par, epsilon, algo);			
			erg = HitterPolice.check( file, oldHitter, par, phi, false);
			if( compareToFileSolution )
				throw new RuntimeException("Nicht impl.: " +
				"Test fuer OLD_ ohne compareToFileSolution starten.");	
		}
		return erg;	
	}


	// Vergleich der von einem approx. Algorithmus mit Epsilon = 0
	// in eine Datei geschriebenen Loesung mit der Loesung des
	// exakten Algorithmus.
	public static boolean compareToExact( String file, 
			Parameter par, double phi ) {				

		HashMap<Element, MultiHitterInfo> exactHitters;
		HashMap<Element, MultiHitterInfo> solutionHitters; 
		ArrayList<Map.Entry<Element, MultiHitterInfo>> exHitterList;
		ArrayList<Map.Entry<Element, MultiHitterInfo>> solHitterList;
		HitterComparator hitterComparator = new HitterComparator();

		MultiDatabase d = new MultiDatabase( file, par );
		d.openRead();
		solutionHitters = d.readSolution();
		double filePhi = d.getPhi();
		double fileEpsilon = d.getEpsilon();		
		d.closeRead();	

		if( Math.abs( phi - filePhi ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Phi-Werte in" +
					" Datei und Methodenaufruf: " + phi + ", " + filePhi );

		if( Math.abs( fileEpsilon ) > 1E-10 ) 
			throw new RuntimeException( "Epsilon > 0");

		// Hittermengen sortieren
		exactHitters = calcExact( file, par, phi );// myExact.outputSet( phi );				

		exHitterList = 
			new ArrayList<Map.Entry<Element, MultiHitterInfo>>(exactHitters.entrySet());

		solHitterList = 
			new ArrayList<Map.Entry<Element, MultiHitterInfo>>(solutionHitters.entrySet());

		Collections.sort( exHitterList, hitterComparator );		
		Collections.sort( solHitterList, hitterComparator );	

		return solutionHitters.equals( exactHitters );
	}


	// Vergleiche die Abstandsmasse von Originalstrom und
	// leicht vernderten Varianten. Interessant fuer Beurteilung
	// der Stabilitt der Abstandsmasse.
	public static void evaluationStability( String file, Parameter par,
			double phi, double epsilon, long seed ) {				

		Random gen = new Random( seed );
		AbstractComplexHHH fastPA = fillApprox(file, par, epsilon);			
		AbstractComplexHHH noisePA;					
		HashSet<Element> original = new HashSet<Element>();
		HashSet<Element> noise = new HashSet<Element>();
		Set<Element> tmp;		
		
		tmp = fastPA.outputSet(phi).keySet();		
		for( Element el : tmp ) original.add(el);		
		
		MultiDatabase d = new MultiDatabase( file, par );
		d.openRead();
		Vector<Element> data = d.readElements();	
		d.closeRead();	

		for( int round = 0; round < 30; round++ ){
			switch( algo ){
			case FULL_ANC: noisePA = new FullAncHHH( epsilon, par ); break;
			case PART_ANC: noisePA = new PartAncHHH( epsilon, par ); break;
			default: throw new RuntimeException("Kein Algorithmus gewaehlt");
			}			
			
			//Manipuliere Strom
			int man = gen.nextInt( 400 );
			for( int k = 0; k < man; k++ )
				data.remove( gen.nextInt( data.size() ) );
			
			for( Element element : data )			
				noisePA.insert( element, 1, true );			

			tmp = noisePA.outputSet(phi).keySet();		
			for( Element el : tmp ) noise.add(el);		

			System.out.println( Evaluation.compactHierarch(original, noise) );

		}

	}


	// Gibt ein Objekt vom Typ Exact zurueck,
	// das den in der Datei enthaltenen
	// Strom aggregiert hat und nun fuer beliebige phi die passenden
	// exakten HHH ausgeben kann.
	public static Exact fillExact( String file, Parameter par ) {				

		Exact myExact = new Exact( par );					

		MultiDatabase d = new MultiDatabase( file, par );
		d.openRead();
		Vector<Element> data = d.readElements();		
		d.closeRead();

		for( Element element : data )			
			myExact.insert( element, 1, true );			

		return myExact;
	}


	// Berechnet fuer das Problem in der Datei file die exakten HHH
	// mit dem exakten Algorithmus fuer das uebergebene phi.
	public static HashMap<Element, MultiHitterInfo> calcExact( String file, 
			Parameter par, double phi ) {				

		Exact myExact = fillExact( file, par );			
		return myExact.outputSet( phi );
	}


	public static AbstractComplexHHH fillApprox( String file, 
			Parameter par, double epsilon ) {
		return fillApprox( file, par, epsilon, algo );
	}
	
	// Gibt ein Objekt vom Typ AbstractComplexHHH zurueck,
	// das mit dem uebergebenen epsilon den in der Datei enthaltenen
	// Strom aggregiert hat und nun fuer beliebige phi die passenden
	// approximativen HHH ausgeben kann.
	public static AbstractComplexHHH fillApprox( String file, 
			Parameter par, double epsilon, AlgoType algo ) {				

		AbstractComplexHHH fastPA;					

		MultiDatabase d = new MultiDatabase( file, par );
		d.openRead();
		Vector<Element> data = d.readElements();	
		d.closeRead();	

		switch( algo ){
		case FULL_ANC: fastPA = new FullAncHHH( epsilon, par ); break;
		case PART_ANC: fastPA = new PartAncHHH( epsilon, par ); break;
		default: throw new RuntimeException("Kein Algorithmus gewaehlt");
		}			

		for( Element element : data )			
			fastPA.insert( element, 1, true );			

		return fastPA;
	}

	
	public static OLD_AbstractComplexHHH fillOld( String file, 
			Parameter par, double epsilon, AlgoType algo ) {				

		OLD_AbstractComplexHHH hitterAlgo;					

		MultiDatabase d = new MultiDatabase( file, par );
		d.openRead();
		Vector<Element> data = d.readElements();	
		d.closeRead();	

		switch( algo ){
		case OLD_FULL_ANC: hitterAlgo = new OLD_FullAncHHH( epsilon, par ); break;
		case OLD_PART_ANC: hitterAlgo = new OLD_PartAncHHH( epsilon, par ); break;
		default: throw new RuntimeException("Kein Algorithmus gewaehlt");
		}			

		for( Element element : data )			
			hitterAlgo.insert( element, 1, true );			

		return hitterAlgo;
	}



	// Berechnet fuer das Problem in der Datei file die approx. HHH
	// mit dem Algorithmus algo fuer das uebergebene phi und epsilon.
	public static HashMap<Element, MultiHitterInfo> calcApprox( String file, 
			Parameter par, double phi, double epsilon ) {				

		AbstractComplexHHH fastPA = fillApprox( file, par, epsilon );
		return fastPA.outputSet( phi );
	}


	// Wenn der Stream in einer Datei liegt, kann getestet werden,
	// ob Verarbeiten und Permutieren Fehler verursachen.
	public static boolean streamTest( String file, Parameter par,
			double phi, double epsilon ) {				

		int buffersize = 100;
		int count = 0;
		int remaining;

		MultiDatabase d = new MultiDatabase( file, par );
		d.openRead();
		Vector<Element> data = d.readElements();	
		d.closeRead();	
		long lines  = data.size(); 

		AbstractComplexHHH fastPA;					
		HashMultiset<Element> container = HashMultiset.create();						
		StreamReader reader = new StreamReader( par );
		//reader.open();

		switch( algo ){
		case FULL_ANC: fastPA = new FullAncHHH( epsilon, par ); break;
		case PART_ANC: fastPA = new PartAncHHH( epsilon, par ); break;
		default: throw new RuntimeException("Kein Algorithmus gewaehlt");
		}	

		if( LogService.shouldLog(LogService.NORMAL) ) 
			LogService.log( LogService.NORMAL, "Start: " + new Date() );		

		while( count < lines ){
			remaining = Math.min( buffersize, (int)lines - count );
			reader.readLoop( container, remaining );					
			count += container.size();
			for( Element e : container.elementSet() ){
				fastPA.insert( e, container.count(e), true );
			}
		}		
		reader.close();		
		System.out.println( "Stop: " + new Date() );		

		if( LogService.shouldLog(LogService.NORMAL) ){
			LogService.log( LogService.NORMAL, "Stop: " + new Date() );
			LogService.log( LogService.NORMAL, "tupel: = " + 
					fastPA.getTupelCount() + "  " + new Date() +
					"reach= " + fastPA.reach + "  unreach " +
					fastPA.unreach + "Stop Insert" );			
		}

		boolean erg =  HitterPolice.check( file, fastPA, par, phi, false);				

		return erg;	
	}


	static double readPhi( Parameter par ){ 
		MultiDatabase d = new MultiDatabase( file, par );
		double phi = d.getPhi();		
		return phi;
	}

	static double readEpsilon( Parameter par ){ 
		MultiDatabase d = new MultiDatabase( file, par );
		double epsilon = d.getEpsilon();		
		return epsilon;
	}


	private static void printSetup( Parameter par, int numberOfTestcases,
			int offset, boolean writeSolution, boolean compareToFileSolution ){

		System.out.println( "\nAlgo = " + algo +
				"\nBenutze Datei " + file + 
				" NumberOfTestcases: " + numberOfTestcases + 
				" mit Offset " + offset + "\nParameter:\n" + 
				par + "\nmode=" + modeString(mode) +
				"\ndistr=" + distrString(distr) +
				"\nWriteSolution=" + writeSolution +
				"\nCompareToFileSolution=" + compareToFileSolution + "\n" );		

		if( par.mBug() == true ) 
			System.out.println( "\n\n ************* MBUG ist " +
			"eingeschaltet! *****************\n\n");

		if( par.bProb() == true ) 
			System.out.println( "\n\n ************* BPROB ist " +
			"eingeschaltet! *****************\n\n");
	}


	private static String modeString( int mode ){
		String s = "";	
		switch( mode ){
		case MULTIPLE: 		s = "MULTIPLE";			break;
		case OLD: 			s = "OLD";				break;
		case BATCHOLD:		s = "BATCHOLD";			break;
		case MULTICOMPARE: 	s = "MULTICOMPARE";		break;
		case MULTICOMPARE_2:s = "MULTICOMPARE_2";	break;
		case STREAM: 		s = "STREAM";			break;
		case EXACT: 		s = "EXACT";			break;
		case QUALITY: 		s = "QUALITY";			break;
		case EVALUATION:	s = "EVALUATION";		break;		
		case FORKCHECK:		s = "FORKCHECK";		break;
		}
		return s;
	}

	private static String distrString( int distr ){
		String s = "";	
		switch( distr ){
		case TINY: 	 s = "TINY";	break;
		case UNIBIG: s = "UNIBIG";	break;
		case MEDIUM: s = "MEDIUM";	break;			
		case SKEWED: s = "SKEWED";	break;
		case EPSI_0: s = "EPSI_0";	break;
		}
		return s;
	}

//	private static String algoString( int algo ){		
//		switch( algo ){
//		case FULL_ANC: return "FULL_ANC";
//		case PART_ANC: return "PART_ANC";			
//		}
//		return "UNKNOWN_ALGO";
//	}
}
