package hitters.test;

import static org.junit.Assert.*;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.PartAncHHH;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.tools.LogService;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.junit.Before;
import org.junit.Test;

public class MultiDatabaseTest {

	String prefix = "resources/testcase/MultiDatabase/";
	
	
	@Before
	public void setUp() throws Exception {
	}

	
	@Test
	public void testReadSystemCalls() {

		// Verwendete Dimensionen
		DimType[] dims = { DimType.PATH, DimType.RETURN, DimType.CALL };
		// Verwendete Hierarchietiefen
		int[] caps = { 1, 2, 2 };	
		SysParameter par = new SysParameter( dims, caps );						
						
		MultiDatabase d = new MultiDatabase( prefix + "cut", par );
		d.openRead();
		Vector<Element> elems = d.readSystemCalls();
		
		List<String> solution = load( "cut.res" );
		int i = 0;
		
		for( Element e : elems ){
			System.out.println( e );
			System.out.println( solution.get(i) + "\n" );
			assertTrue( e.toString().trim().equals( solution.get(i++).trim() ) );
		}
		System.out.println("\n\n\n");

		DimType[] dims2 = { DimType.CALL, DimType.PATH };
		int[] caps2 = { 5, 8 };	
		par = new SysParameter( dims2, caps2 );		

		d = new MultiDatabase( prefix + "cut", par );
		d.openRead();
		elems = d.readSystemCalls();
		
		solution = load( "cut2.res" );
		i = 0;
		
		for( Element e : elems ){			
			System.out.println( e );
			System.out.println( solution.get(i) + "\n" );
			assertTrue( e.toString().equals( solution.get(i++) ) );
		}
		System.out.println("\n\n\n");

		DimType[] dims3 = { DimType.CALL, DimType.PATH };
		int[] caps3 = { 4, 3 };	
		par = new SysParameter( dims3, caps3 );		

		d = new MultiDatabase( prefix + "cut", par );
		d.openRead();
		elems = d.readSystemCalls();
		
		solution = load( "cut3.res" );
		i = 0;
		
		for( Element e : elems ){			
			System.out.println( e );
			System.out.println( solution.get(i) + "\n" );
			assertTrue( e.toString().equals( solution.get(i++) ) );
		}

	}


	@Test
	public void testGenEquals() {

		DimType[] dims = { DimType.PATH, DimType.RETURN, DimType.CALL };
		int[] caps = { 5, 2, 2 };	
		SysParameter par = new SysParameter( dims, caps );						
						
		MultiDatabase d = new MultiDatabase( prefix + "eq", par );
		d.openRead();
		Vector<Element> elems = d.readSystemCalls();
		
		assertTrue( elems.elementAt(0).equals(elems.elementAt(1)) );
		assertFalse( elems.elementAt(2).equals(elems.elementAt(1)) );
		assertFalse( elems.elementAt(2).equals(elems.elementAt(0)) );		
		assertFalse( elems.elementAt(2).equals(elems.elementAt(3)) );
		assertFalse( elems.elementAt(3).equals(elems.elementAt(4)) );
		assertTrue( elems.elementAt(4).equals(elems.elementAt(5)) );
		assertFalse( elems.elementAt(3).equals(elems.elementAt(6)) );
		
		Element el2 = elems.elementAt(2).clone(); 
		int dim = par.retDim();
		elems.elementAt(2).turnIntoParent(dim);
		elems.elementAt(1).turnIntoParent(dim);
		assertTrue( elems.elementAt(2).equals(elems.elementAt(1)) );
		
		//23
		elems.set( 2, el2.clone() );
		int[] label = { 5, 1, 0 };
		elems.elementAt(2).generalizeTo(label);
		elems.elementAt(3).generalizeTo(label);
		assertTrue( elems.elementAt(2).equals(elems.elementAt(3)) );
				
		int[] label2 = { 5, 1, 0 };
		elems.elementAt(3).generalizeTo(label2);
		elems.elementAt(6).generalizeTo(label2);
		assertFalse( elems.elementAt(3).equals(elems.elementAt(6)) );
		
		int[] label3 = { 2, 1, 0 };
		elems.elementAt(3).generalizeTo(label3);
		elems.elementAt(6).generalizeTo(label3);
		assertTrue( elems.elementAt(3).equals(elems.elementAt(6)) );
		
	}
			
	
	@Test
	public void testReadWriteHitters1() {

		SysParameter par;
		DimType[] dims = { DimType.SEQUENCE, DimType.CALL };
		par = new SysParameter( dims );
		AlgoType algo = AlgoType.PART_ANC;
		System.out.println( par.toFullString() );		

		double epsilon = 0.001;
		double phi = 0.01;
		int n = 10;
		String[] files = { "ff1", "ff6", "gy1", "gy6", "rb1",
				"rb6", "ge1", "ge2", "tp1", "tp6" };

		AbstractComplexHHH hitterAlgo;		 

		List< HashMap<Element, MultiHitterInfo> > res = 
			new ArrayList< HashMap<Element, MultiHitterInfo> >();
		Set<Element> l1; 
		
		for( int i = 0; i < n; i++ ){		
			hitterAlgo = fillApprox( "resources/data/" + files[i], par, epsilon, algo);
			res.add( hitterAlgo.outputSet(phi));
			System.out.println( res.get(i).size() );
			MultiDatabase.saveHHH( res.get(i).keySet(), "tmp/tst.0000" +
					i, files[i], par, epsilon, phi, algo);
		}
		
		for( int i = 0; i < n; i++ ){
			l1 = MultiDatabase.readHHH( "tmp/tst.0000" + i );
			System.out.println( Evaluation.bgm2( l1, res.get(i).keySet() ) );
			assertTrue( Math.abs(Evaluation.bgm2( l1, res.get(i).keySet() ) - 1.0) < 1E-9 );
			assertTrue( l1.equals( res.get(i).keySet() ) );
		}
	}	

	
	@Test
	public void testReadWriteHitters2() {

		SysParameter par;
		DimType[] dims = { DimType.PATH, DimType.RETURN };
		par = new SysParameter( dims );
		AlgoType algo = AlgoType.PART_ANC;
		System.out.println( par.toFullString() );		
	
		double epsilon = 0.001;
		double phi = 0.01;
		int n = 3;
		String[] files = { "ff1", "gy6", "rb1" };

		AbstractComplexHHH hitterAlgo;		 

		List< HashMap<Element, MultiHitterInfo> > res = 
			new ArrayList< HashMap<Element, MultiHitterInfo> >();
		Set<Element> l1; 
		
		for( int i = 0; i < n; i++ ){		
			hitterAlgo = fillApprox( "resources/data/" + files[i], par, epsilon, algo);
			res.add( hitterAlgo.outputSet(phi));
			System.out.println( res.get(i).size() );
			MultiDatabase.saveHHH( res.get(i).keySet(), "tmp/tst2.0000" +
					i, files[i], par, epsilon, phi, algo);
		}
		
		for( int i = 0; i < n; i++ ){
			l1 = MultiDatabase.readHHH( "tmp/tst2.0000" + i );
//			System.out.println( "Original: \n\n" + res.get(i).keySet());
//			System.out.println( "Faelschung: \n\n" + l1);
			System.out.println( Evaluation.bgm2( l1, res.get(i).keySet() ) );
			assertTrue( Math.abs(Evaluation.bgm2( l1, res.get(i).keySet() ) - 1.0) < 1E-9 );
			assertTrue( l1.equals( res.get(i).keySet() ) );
		}
	}	

	
	@Test
	public void testReadWriteHitters3() {

		SysParameter par;
		DimType[] dims = { DimType.PATH, DimType.SEQUENCE };
		par = new SysParameter( dims );
		AlgoType algo = AlgoType.PART_ANC;
		System.out.println( par.toFullString() );		
		HashSet<String> callSubset = new HashSet<String>();
		callSubset.add("writev");
		par.setUsedCalls( callSubset );	
		
		double epsilon = 0.001;
		double phi = 0.01;
		int n = 3;
		String[] files = { "ff1", "gy6", "rb1" };

		AbstractComplexHHH hitterAlgo;		 

		List< HashMap<Element, MultiHitterInfo> > res = 
			new ArrayList< HashMap<Element, MultiHitterInfo> >();
		Set<Element> l1; 
		
		for( int i = 0; i < n; i++ ){		
			hitterAlgo = fillApprox( "resources/data/" + files[i], par, epsilon, algo);
			res.add( hitterAlgo.outputSet(phi));
			System.out.println( res.get(i).size() );
			MultiDatabase.saveHHH( res.get(i).keySet(), "tmp/tst2.0000" +
					i, files[i], par, epsilon, phi, algo);
		}
		
		for( int i = 0; i < n; i++ ){
			l1 = MultiDatabase.readHHH( "tmp/tst2.0000" + i );
//			System.out.println( "Original: \n\n" + res.get(i).keySet());
//			System.out.println( "Faelschung: \n\n" + l1);
			System.out.println( Evaluation.bgm2( l1, res.get(i).keySet() ) );
			assertTrue( Math.abs(Evaluation.bgm2( l1, res.get(i).keySet() ) - 1.0) < 1E-9 );
			assertTrue( l1.equals( res.get(i).keySet() ) );
		}
	}	

	
	@Test
	public void testReadWriteHitters4() {

		SysParameter par;
		DimType[] dims = { DimType.PATH, DimType.SEQUENCE };
		par = new SysParameter( dims );
		AlgoType algo = AlgoType.PART_ANC;
		System.out.println( par.toFullString() );
		
		double epsilon = 0.001;
		double phi = 0.01;
		int n = 3;
		String[] files = { "xt9-025", "gy6-000", "rb1-002" };

		AbstractComplexHHH hitterAlgo;		 

		List< HashMap<Element, MultiHitterInfo> > res = 
			new ArrayList< HashMap<Element, MultiHitterInfo> >();
		Set<Element> l1; 
		
		for( int i = 0; i < n; i++ ){		
			hitterAlgo = fillApprox( "/home/fricke/log30/" + files[i], par, epsilon, algo);
			res.add( hitterAlgo.outputSet(phi));
			System.out.println( res.get(i).size() );
			MultiDatabase.saveHHH( res.get(i).keySet(), "tmp/tst2.0000" +
					i, files[i], par, epsilon, phi, algo);
		}
		
		for( int i = 0; i < n; i++ ){
			l1 = MultiDatabase.readHHH( "tmp/tst2.0000" + i );
			System.out.println( "Original: \n\n" + res.get(i).keySet());
			System.out.println( "Faelschung: \n\n" + l1);
			System.out.println( Evaluation.bgm2( l1, res.get(i).keySet() ) );
			assertTrue( Math.abs(Evaluation.bgm2( l1, res.get(i).keySet() ) - 1.0) < 1E-9 );
			assertTrue( l1.equals( res.get(i).keySet() ) );
		}
	}	
	

	private List<String> load( String file ){

		List<String> list = new ArrayList<String>();
		String line;
		file = prefix + file;
		int counter = 0;
		
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null && ( counter++ < 500000 )) {							
				if(  ! line.startsWith("#") ) {
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}
		
		return list;
	}

	

	// Gibt ein Objekt vom Typ AbstractComplexHHH zurueck,
	// das mit dem uebergebenen epsilon den in der Datei enthaltenen
	// Strom aggregiert hat und nun fuer beliebige phi die passenden
	// approximativen HHH ausgeben kann.
	private static AbstractComplexHHH fillApprox( String file, 
			SysParameter par, double epsilon, AlgoType algo ) {				

		AbstractComplexHHH fastPA;					
		BufferedReader in = null;
		SysElement el;
		String line;
		int counter = 0;		

		//HashSet<String> callSubset = new HashSet<String>(); 
		//par.setUsedCalls( callSubset );
		SysParser parser = new SysParser( par );		

		switch( algo ){
		case FULL_ANC: fastPA = new FullAncHHH( epsilon, par ); break;
		case PART_ANC: fastPA = new PartAncHHH( epsilon, par ); break;
		default: throw new RuntimeException("Kein Algorithmus gewaehlt");
		}			

		try{ 
			in  = new BufferedReader( new FileReader( file) );			

			while( (line = in.readLine()) != null ){      				
				if( line.length() > 0 ){			
					el = parser.createElement( line );
					if( el != null ) {		
						fastPA.insert( el, 1 );
						counter++;
					}
				}
			}

		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){			
			System.out.print( e.getMessage() );			
		}

		System.out.println( "counter = " + counter );
		System.out.println( "ParserCounter = " + parser.getCounter() );
		System.out.println( counter / (double)parser.getCounter() );

		LogService.logDBClose();
		try{
			in.close();			
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}
		
		return fastPA;
	}

}
