/**
 * 
 */
package hitters.test;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import hitters.multi.Element;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * @author Peter Fricke
 * 
 */
public class ElementTest {

	Element[] aUnsort = new Element[9];
	Element[] aSorted = new Element[9];
	AbstractComplexHHH pa;
	Parameter par;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {

		byte[][] plength = { {0,8,16,24,32}, {0,8,16,24,32} };		
		par = new Parameter( 2 - plength.length, plength );				
		pa = new PartAncHHH( 0, par );

		String[] st = { "/1/3/4/1", "/1/3/5/3", "/1/3/4/1", "/1/5/2/1",
				"/1/5/9/1", "/1/3/4/1", "/1/5/9/1", "/1/3/4/1",
				"/1/5/9/1", "/1/5/9/6", "/2/4/4/7", "/2/5/1/9", 
				"/3/5/2/7", "/3/5/2/8", "/3/5/2/9", "/3/5/6/1", 
				"/3/5/7/8",	"/1/3/4/1" };

		String[] md; 
		String[] eInt;

		int off = 6;

		for( int i = 0; i < aUnsort.length; i++ ){			
			eInt = new String[2];
			eInt[0] = st[(2*i+off)%18];
			eInt[1] = st[(2*i+off+1)%18];			
			md = new String[0];
			aUnsort[i] = Element.createElement(md , eInt, par);
		}

		for( int i = 0; i < aSorted.length; i++ ){			
			eInt = new String[2];
			eInt[0] = st[(2*i)];
			eInt[1] = st[(2*i+1)];			
			md = new String[0];
			aSorted[i] = Element.createElement(md , eInt, par);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}


	@Test( expected = NumberFormatException.class )
	public final void testBitfield1() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/256", "/102/110/101/104"};
		Element a = Element.createElement(md , s1, par);
		a.setTo(a);
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield2() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/122", "/102/257/101/104"};
		Element a = Element.createElement(md , s1, par);
		a.setTo(a);
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield3() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/256", "/102/110/101/104"};
		String[] s2 = {"/127/112/111/109", "/102/110/101"};
		Element a = Element.createElement(md , s2, par);
		a.setTo( null, s1 );
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield4() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/122", "/102/257/101/104"};
		String[] s2 = {"/127/112/111/109", "/102/110/101"};
		Element a = Element.createElement(md , s2, par);
		a.setTo( null, s1 );
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield5() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/0/122", "/102/257/101/104"};
		Element a = Element.createElement(md , s1, par); 			
		a.setTo(a);
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield6() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/122", "/102/257/101/0"};
		Element a = Element.createElement(md , s1, par);
		a.setTo(a);
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield7() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/-7/111/122", "/102/257/101/104"};
		Element a = Element.createElement(md , s1, par);
		a.setTo(a);
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield8() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/122", "/102/257/-1/104"};
		Element a = Element.createElement(md , s1, par);
		a.setTo(a);
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield9() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/122", "/102/257/0/104"};
		String[] s2 = {"/127/112/111/109", "/102/110/101"};
		Element a = Element.createElement(md , s2, par);
		a.setTo( null, s1 );
	}

	@Test( expected = NumberFormatException.class )
	public final void testBitfield10() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] md = new String[0];
		String[] s1 = {"/127/112/111/0", "/102/257/10/104"};
		String[] s2 = {"/127/112/111/109", "/102/110/101"};
		Element a = Element.createElement(md , s2, par);
		a.setTo( null, s1 );		
	}


	@Test	 
	public final void testBitfieldLarge() {  // Test, ob Werte ihren Bitbereich bersteigen testen 

		String[] s1 = {"/127/112/111/109", "/102/110/101/104"};
		String[] s2 = {"/127/112/111/109", "/102/110/101"};
		String[] s3 = {"/128/112/111/154", "/102/110/101/104"};
		String[] s4 = {"/128/112/111/154", "/102/110/101"};
		String[] md;

		md = new String[0];
		Element a = Element.createElement(md , s1, par);

		md = new String[0];
		Element b = Element.createElement(md , s2, par);
		a.setTo(b);

		md = new String[0];
		a = Element.createElement(md , s3, par);

		md = new String[0];
		a = Element.createElement(md , s4, par);

		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );

		a.setTo( null, s1 );
		a.setTo( null, s2 );
		a.setTo( null, s3 );
		a.setTo( null, s4 );

	}


	@Test
	//@Ignore
	public final void testSetTo() {  //Set, GeneralizeTo, isGeneralizationOf

		String[] s1 = {"/9/9/9/9", "/3/4/5/6"};
		String[] s2 = {"/1/3/4/1", "/1/3/5/3"};
		String[] s3 = {"/1", "/1/3/5"};
		String[] s4 = {"*", "*"};
		String[] s5 = {"*", "/3/4"};
		String[] s6 = {"/9/9/9", "*"};
		String[] s11 = {"/9", "/3/4/5"};
		String[] s12 = {"/1/3/4/1", "/1/3/5"};
		String[] s13 = {"/127/112/111/109", "/102/110/101/104"};
		String[] s14 = {"/127/112/111/109", "/102/110/101"};
		String[] s15 = {"/128/112/111/154", "/102/110/101/104"};
		String[] s16 = {"/128/112/111/154", "/102/110/101"};

		int[] label = {1,3};
		int[] label2 = {0,0};	
		int[] label5 = {0,2};
		int[] label6 = {3,0};
		int[] label7 = {3,5};

		Element clone = aSorted[0].clone();

		String[] sLeer = new String[0];
		aSorted[0].setTo( sLeer, s1 );			
		assertFalse( aSorted[0].equals( clone ) );
		assertTrue( aSorted[0].equals( aSorted[0] ) );
		Element a = clone.clone(), b;
		a.setTo(aSorted[0]);
		assertTrue( aSorted[0].equals( a ) );
		clone.setTo(a);
		assertTrue( aSorted[0].equals( clone ) );
		clone.setTo( sLeer, s2 );
		assertTrue( aSorted[0].equals( a ) );
		assertFalse( aSorted[0].compareTo( clone ) == 0 );
		assertTrue( aSorted[0].compareTo( a ) == 0 );
		assertFalse( aSorted[0].hashCode() == clone.hashCode() );
		assertTrue( aSorted[0].hashCode() == a.hashCode() );

		aSorted[0].setTo( sLeer, s2 );
		assertTrue( aSorted[0].equals( clone ) );
		assertTrue( aSorted[0].compareTo( clone ) == 0 );
		assertTrue( aSorted[0].hashCode() == clone.hashCode() );

		a = clone.clone();
		b = clone.clone();				
		assertTrue( a.hasParent( 0 ) );
		assertTrue( a.hasParent( 1 ) );
		assertTrue( a.turnIntoParent( 0 ) );
		assertTrue( b.turnIntoParent( 1 ) );				
		assertFalse( a.equals(clone) );
		assertFalse( a.hashCode() == clone.hashCode() );
		assertFalse( b.hashCode() == clone.hashCode() );
		assertTrue( a.isGenOf(clone) );
		assertTrue( b.isGenOf(clone) );
		assertFalse( clone.isGenOf(a) );
		assertFalse( clone.isGenOf(b) );
		assertFalse( b.isGenOf(a) );		

		a.setTo( sLeer, s1 );
		b.setTo(a);
		assertTrue( a.equals(b) );
		a.turnIntoParent(1);
		assertFalse( a.equals(b) );	

		a.setTo( sLeer, s2 );
		assertTrue( a.hashCode() == clone.hashCode() );
		assertTrue( a.equals(clone) );
		assertTrue( a.generalizeTo( label ) );
		b.setTo( sLeer, s3 );
		assertTrue( a.hashCode() == b.hashCode() );
		assertTrue( a.equals(b) );
		assertFalse( a.generalizeTo( label6 ) );

		a.setTo( sLeer, s2 );
		assertTrue( a.generalizeTo( label2 ) );
		b.setTo( sLeer, s4 );
		assertTrue( a.hashCode() == b.hashCode() );
		assertTrue( a.equals(b) );
		assertFalse( a.generalizeTo( label ) );

		a.setTo( sLeer, s1 );
		b.setTo( sLeer, s5 );
		assertFalse( a.equals(b) );
		assertTrue( a.generalizeTo( label5 ) );
		assertTrue( a.equals(b) );		
		assertFalse( a.generalizeTo( label ) );

		a.setTo( sLeer, s1 );
		b.setTo( sLeer, s6 );
		assertFalse( a.equals(b) );
		assertTrue( a.generalizeTo( label6 ) );
		assertTrue( a.equals(b) );		
		assertFalse( a.generalizeTo( label ) );

		a.setTo( sLeer, s1 );
		b.setTo( sLeer, s11 );		
		assertFalse( a.generalizeTo( label7 ) );
		assertFalse( a.equals(b) );		
		assertTrue( a.generalizeTo( label ) );
		assertTrue( a.equals(b) );		
		a.setTo( null, s2 );
		b.setTo( null, s2 );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );		
		assertTrue( a.hasParent(1) );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );
		assertTrue( a.equals( b ) );		
		assertTrue( a.turnIntoParent(1) );		
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );

		assertFalse( a.equals( b ) );
		b.setTo( null, s12 );
		assertTrue( a.equals( b ) );

		String[] md = new String[0];
		a = Element.createElement(md , s2, par);						
		b = a.clone();
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );

		assertTrue( a.turnIntoParent(0) );	
		assertTrue( a.turnIntoParent(0) );			

		assertTrue( a.getLevel( 0 ) == 2 );
		assertTrue( a.getLevel( 1 ) == 4 );

		int cont = 0;
		while( a.hasParent(1) ){
			cont++;
			assertTrue( a.turnIntoParent(1) );
			assertTrue( a.getLevel( 0 ) == 2 );
			assertTrue( a.getLevel( 1 ) == 4-cont );			
		}
		assertTrue( b.getLevel( 0 ) == 4 );
		assertTrue( b.getLevel( 1 ) == 4 );

		md = new String[0];
		a = Element.createElement(md , s13, par);
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );
		md = new String[0];
		a = Element.createElement(md , s14, par);
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );
		md = new String[0];
		a = Element.createElement(md , s15, par);
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );
		md = new String[0];
		a = Element.createElement(md , s16, par);
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );
	}

	@Test
	//@Ignore
	public final void testSetToGlbOf() {

		byte[][] plength = { {0,4,8,12,16,20,24,28,32}, {0,4,8,12,16,20,24,28,32} };		
		par = new Parameter( 2 - plength.length, plength );				
		pa = new PartAncHHH( 0, par );

		String[][] s  = { {"/1/3/4/9", "/1/3/5/3/7/8/9/6"}, {"/1/3/4/1", "/1/3/5/3"},
				{"/1", "/1/3/5/3/7/8"},	{"*", "*"},	{"*", "/1/3"},
				{"/1/3/4/9/6", "*"}, {"/1/3/4/9/6", "/1/3/5/3/7/8"},
				{"/1/3/4/9","/1/3/5/3/7/8"}, {"/1/3/4/9/6","/1/3/5/3/7/8/9/6"},
				{"/4","/1"}, {"/5","/2"} };
		Element[] a = new Element[s.length];
		// {i,j,k} bedeutet glb von i und j ist k
		int[][] exp     = { {0,1,-1},{0,2,0},{7,0,0},{7,2,7},{0,3,0},{0,4,0},{0,5,8},
				{0,6,8},{0,7,0},{1,7,-1},{1,3,1},{1,4,1},{1,5,-1},{5,6,6},{2,3,2},
				{9,10,-1} };

		Element glb = new Element(par);
		Element expected = new Element(par);
		String[] sEmpty = new String[0];
		boolean possible;

		for( int i = 0; i < s.length; i++ ){
			sEmpty = new String[0];			
			a[i] = Element.createElement( sEmpty, s[i], par);			
		}
		for( int i = 0; i < exp.length; i++ ){						
			possible = glb.setToGlbOf( a[ exp[i][0] ], a[ exp[i][1] ] );
			if( exp[i][2] >= 0 ){
				expected.setTo( a[ exp[i][2] ] );
				assertTrue( glb.equals( expected ) );
				assertTrue( possible );
			}
			else{
				assertFalse( ( a[ exp[i][0] ] ).equals( a[ exp[i][1] ] ) );
				assertFalse( possible );
			}
		}		

	}


	@Test
	//@Ignore
	public final void testLca(){

		byte[][] plength = { {0,4,8,12,16,20,24,28,32}, {0,4,8,12,16,20,24,28,32} };		
		byte[][] plengthString = {  };
		byte[][] plengthMix = { {0,4,8,12,16,20,24,28,32} };
		par = new Parameter( 2 - plength.length, plength );									
		Parameter parString = new Parameter( 2, plengthString );						
		Parameter parMix = new Parameter( 1, plengthMix );

		String[][] s  = { {"/1/3/4/9", "/1/3/5/3/7/8/9/6"}, 
				{"/1/3/4/1", "/1/3/5/3"},	//1
				{"/1/3/4", "/1/3/5/3"},	 	//2
				{"/1", "/1/3/5/3/4/8"},		//3
				{"/1", "/1/3/5/3"}, 		//4
				{"*", "*"},					//5
				{"*", "/1/3"},				//6
				{"/1/3/4/9/6", "*"},		//7
				{"/1/3/4", "*"},			//8
				{"*", "/1"},				//9
				{"/4","/1"},				//10
				{"/5","/2"},				//11
				{"/1", "*"}  };				//12


		Element[] a = new Element[s.length];
		Element[] b = new Element[s.length];
		Element[] c = new Element[s.length];

		//{i,j,k} bedeutet lca von i und j ist k
		int[][] exp = { {0,1,2},{0,3,4},{1,5,5},{3,5,5},{2,6,6},{4,6,6},
				{1,7,8},{3,7,12},{10,1,9},{10,0,9},
				{3,11,5},{1,11,5},{7,11,5},{10,11,5} };

		Element lca;
		String[] tmp1 = new String[1];
		String[] tmp2 = new String[1];

		// Einmal fr ints, einmal fr String, einmal Mixed
		for( int i = 0; i < s.length; i++ ){
			tmp1 = new String[1];
			tmp2 = new String[1];
			tmp1[0] = s[i][0];
			tmp2[0] = s[i][1];
			a[i] = Element.createElement( null, s[i], par);			
			b[i] = Element.createElement( s[i], null, parString);
			c[i] = Element.createElement( tmp1, tmp2, parMix);
		}

		for( int i = 0; i < exp.length; i++ ){	
			lca = a[exp[i][0]].getLca( a[exp[i][1]] );													

			//			System.out.println( i + "\na= " + a[exp[i][0]].toShortString() +
			//					"\nb= " + a[exp[i][1]].toShortString() +
			//					"\nc= " + a[exp[i][2]].toShortString() + 
			//					"\nlca= " + lca.toShortString() );

			assertTrue( lca.equals( a[exp[i][2]] ) );						
			lca = a[exp[i][1]].getLca( a[exp[i][0]] );						
			assertTrue( lca.equals( a[exp[i][2]] ) );
		}		

		for( int i = 0; i < exp.length; i++ ){	
			lca = b[exp[i][0]].getLca( b[exp[i][1]] );													

			//			System.out.println( i + "\na= " + b[exp[i][0]].toShortString() +
			//					"\nb= " + b[exp[i][1]].toShortString() +
			//					"\nc= " + b[exp[i][2]].toShortString() + 
			//					"\nlca= " + lca.toShortString() );

			assertTrue( lca.equals( b[exp[i][2]] ) );						
			lca = b[exp[i][1]].getLca( b[exp[i][0]] );						
			assertTrue( lca.equals( b[exp[i][2]] ) );
		}		


		for( int i = 0; i < exp.length; i++ ){	
			lca = c[exp[i][0]].getLca( c[exp[i][1]] );													

			//			System.out.println( i + "\na= " + c[exp[i][0]] +
			//					"\nb= " + c[exp[i][1]] +
			//					"\nc= " + c[exp[i][2]] + 
			//					"\nlca= " + lca );

			assertTrue( lca.equals( c[exp[i][2]] ) );						
			lca = c[exp[i][1]].getLca( c[exp[i][0]] );						
			assertTrue( lca.equals( c[exp[i][2]] ) );
		}		
	}



	@Test
	public final void testHashCode() {

		byte[][] plength = { };		
		par = new Parameter( 2 - plength.length, plength );				
		pa = new PartAncHHH( 0, par );		

		String[] e1 = {"/a/b/c/d", "/1/2/3/4"};
		String[] e2 = {"/a/b/c", "/1/2"};
		String[] e3 = {"/a/b/c/d", "/1/2/3/4"};
		String[] e4 = {"*", "*"};
		String[] n1 = {};
		String[] n2 = {};
		String[] n3 = {};
		String[] n4 = {};

		Element m1 = Element.createElement( e1, n1, par);
		Element m2 = Element.createElement( e2, n2, par);
		Element m3 = Element.createElement( e3, n3, par);
		Element m4 = Element.createElement( e4, n4, par);

		String s1 = e1[0] + e1[1];
		String s2 = e2[0] + e2[1];
		String s3 = e3[0] + e3[1];
		String s4 = e4[0] + e4[1];

		assertTrue( s1.hashCode() == m1.hashCode() );
		assertTrue( s2.hashCode() == m2.hashCode() );
		assertTrue( s3.hashCode() == m3.hashCode() );
		assertTrue( s4.hashCode() == m4.hashCode() );
		assertFalse( s3.hashCode() == m2.hashCode() );
		assertFalse( s4.hashCode() == m2.hashCode() );
		assertTrue( m1.hashCode() == m3.hashCode() );
		assertFalse( m4.hashCode() == m2.hashCode() );
		assertFalse( m3.hashCode() == m2.hashCode() );
	}


	@Test
	//@Ignore
	public final void testEqualsObject() {
		List<Element> lUnsort = Arrays.asList( aUnsort );						
		Collections.sort( lUnsort ); // Verschiede inhaltlich gleiche Objekte auf Gleichheit testen		
		lUnsort.toArray( aUnsort );

		for( int i = 0; i < aSorted.length; i++ ){
			for( int j = 0; j < aSorted.length; j++ ){
				if( (i==j) | ( (i==2) & (j==3) ) | ( (i==3) & (j==2) ) ){
					assertTrue( aSorted[i].equals( aSorted[j]) );
					assertTrue( aUnsort[i].equals( aUnsort[j]) );
					assertTrue( aSorted[i].equals( aUnsort[j]) );
					assertTrue( aUnsort[i].equals( aSorted[j]) );
				}else{
					assertFalse( aSorted[i].equals( aSorted[j]) );
					assertFalse( aUnsort[i].equals( aUnsort[j]) );
					assertFalse( aSorted[i].equals( aUnsort[j]) );
					assertFalse( aUnsort[i].equals( aSorted[j]) );
				}
			}
		}		
	}


	@Test
	//@Ignore
	public final void testCompareTo() {
		assertTrue( aSorted[0].compareTo( aSorted[1]) < 0 );
		assertTrue( aSorted[1].compareTo( aSorted[0]) > 0 );
		assertTrue( aSorted[2].compareTo( aSorted[2]) == 0 );
		assertTrue( aSorted[2].compareTo( aSorted[3]) == 0 );
		assertTrue( aSorted[3].compareTo( aSorted[2]) == 0 );
		assertTrue( aSorted[5].compareTo( aSorted[8]) < 0 );
		assertTrue( aSorted[8].compareTo( aSorted[5]) > 0 );
		assertTrue( aSorted[4].compareTo( aSorted[7]) < 0 );
		assertTrue( aSorted[7].compareTo( aSorted[4]) > 0 );		

		List<Element> lUnsort = Arrays.asList( aUnsort );
		List<Element> lSorted = Arrays.asList( aSorted );			
		assertFalse( lUnsort.equals( lSorted ) );
		Collections.sort( lUnsort );
		assertTrue( lUnsort.equals( lSorted ) );
		Collections.shuffle( lUnsort );
		Collections.sort( lUnsort );
		assertTrue( lUnsort.equals( lSorted ) );		
	}


	@Test( expected = NullPointerException.class )
	//@Ignore
	public final void testNull() {
		for( int i = 0; i < aSorted.length; i++ ){
			assertFalse( aSorted[i].equals( null ) );
		}	
		aSorted[4].compareTo(null);//NullPointerException	
	}


	@Test
	//@Ignore
	public final void testTurnIntoParent() {

		byte[][] plength = { {0,6,12,18,24,32}, {0,6,12,18,24,32} };		
		par = new Parameter( 2 - plength.length, plength );				
		pa = new PartAncHHH( 0, par );		

		String[] emptyStr = {};
		String[][] s = { {"/1/3/4/1", "/1/3/5/3"}, {"/1/3/4/1/6", "/1/3"}, {"/1", "*"},
				{"*", "/1/3/5/3"},{"/1", "/1/3/5/3"},{"*", "*"},};
		String[][] p0 = { {"/1/3/4", "/1/3/5/3"}, {"/1/3/4/1", "/1/3"}, {"*", "*"},
				{"*", "/1/3/5/3"},{"*", "/1/3/5/3"},{"*", "*"},};
		String[][] p1 = { {"/1/3/4/1", "/1/3/5"}, {"/1/3/4/1/6", "/1"}, {"/1", "*"},
				{"*", "/1/3/5"},{"/1", "/1/3/5"},{"*", "*"},};

		boolean[][] hasPar = { {true,true},{true,true},{true,false},
				{ false,true},{true,true},{false,false} };

		Element a, b;		

		for( int j = 0; j < 2; j++ ){
			for( int i = 0; i < s.length; i++){
				aUnsort[i] = Element.createElement( emptyStr.clone(), s[i], par);
				a = Element.createElement( emptyStr.clone(), s[i], par);
				Element parent0 = Element.createElement( emptyStr.clone(), p0[i], par);
				Element parent1 = Element.createElement( emptyStr.clone(), p1[i], par);
				b = aUnsort[i].clone();
				assertTrue( aUnsort[i].turnIntoParent( j ) == hasPar[i][j] );
				if( j == 0 ) assertTrue( aUnsort[i].equals( parent0 ) );
				else assertTrue( aUnsort[i].equals( parent1 ) );
				assertTrue( a.equals(b) );
				assertTrue( b.equals(a) );
				assertTrue( b.equals( aUnsort[i] ) != hasPar[i][j] );				
			}
		}		
	}


	@Test
	//@Ignore
	public final void testGetLevel() {

		byte[][] plength = { {0,6,12,18,24,32}, {0,6,12,18,24,32} };		
		par = new Parameter( 2 - plength.length, plength );		
		pa = new PartAncHHH( 0, par );		

		String[] emptyStr = {};
		String[][] s = { {"/1/3/4/1", "/1/3/5/3"}, {"/1/3/4/1/6", "/1/3"}, {"/1", "*"},
				{"*", "/1/3/5/3"},{"/1", "/1/3/5/3"},{"*", "*"},};
		int[][]     expLevel = { {4,4},{5,2},{1,0},{0,4},{1,4},{0,0} };
		int[] 	    expL     = { 8,7,1,4,5,0 };		
		boolean[][] hasPar   = { {true,true},{true,true},{true,false},
				{ false,true},{true,true},{false,false} };

		for( int i = 0; i < s.length; i++){
			aUnsort[i] = Element.createElement( emptyStr.clone(), s[i], par);
			assertTrue( aUnsort[i].getL() == expL[i] );
			for( int j = 0; j < 2; j++ ){
				assertTrue( aUnsort[i].getLevel( j )  == expLevel[i][j] );
				assertTrue( aUnsort[i].hasParent( j ) == hasPar[i][j] );
			}
		}

		Element a = new Element( par );
		assertTrue( a.getL() == 0 );		
		for( int j = 0; j < 2; j++ ){
			assertTrue( a.getLevel(j) == 0 );
			//assertTrue( a.hasParent( j ) == false ); Erwnschte NullpointerException
		}
	}




	@Test	
	public final void testHack() {  //Set, GeneralizeTo, isGeneralizationOf

		byte[][] plength = { {0,8,16,24,32} };
		par = new Parameter( 2 - plength.length, plength );		
		pa = new PartAncHHH( 0, par );						

		String[] st = { "/1/3/4/1", "/1/3/5/3", "/1/3/4/1", "/1/5/2/1",
				"/1/5/9/1", "/1/3/4/1", "/1/5/9/1", "/1/3/4/1",
				"/1/5/9/1", "/1/5/9/6", "/2/4/4/7", "/2/5/1/9", 
				"/3/5/2/7", "/3/5/2/8", "/3/5/2/9", "/3/5/6/1", 
				"/3/5/7/8",	"/1/3/4/1" };

		String[] mda, mdb; 

		int off = 6;

		for( int i = 0; i < aUnsort.length; i++ ){			
			mda = new String[1];
			mdb = new String[1];
			mda[0] = st[(2*i+off)%18];
			mdb[0] = st[(2*i+off+1)%18];			
			aUnsort[i] = Element.createElement( mda, mdb, par );
			mda = new String[1];
			mdb = new String[1];
		}

		for( int i = 0; i < aSorted.length; i++ ){			
			mda = new String[1];
			mdb = new String[1];
			mda[0] = st[(2*i)];
			mdb[0] = st[(2*i+1)];					
			aSorted[i] = Element.createElement( mda, mdb, par );
			mda = new String[1];
			mdb = new String[1];	
		}

		String[] s1 = {"/9/9/9/9", "/3/4/5/6"};
		String[] s2 = {"/1/3/4/1", "/1/3/5/3"};
		String[] s3 = {"/1", "/1/3/5"};
		String[] s4 = {"*", "*"};
		String[] s5 = {"*", "/3/4"};
		String[] s6 = {"/9/9/9", "*"};
		String[] s11 = {"/9", "/3/4/5"};
		String[] s12 = {"/1/3/4/1", "/1/3/5"};
		String[] s13 = {"/127/112/111/109", "/102/110/101/104"};
		String[] s14 = {"/127/112/111/109", "/102/110/101"};
		String[] s15 = {"/128/112/111/154", "/102/110/101/104"};
		String[] s16 = {"/128/112/111/154", "/102/110/101"};

		int[] label = {1,3};
		int[] label2 = {0,0};	
		int[] label5 = {0,2};
		int[] label6 = {3,0};
		int[] label7 = {3,5};

		//int[] aInt = Element.stringToInt( s1[0], s1[1] );
		//String[] sLeer = new String[0];
		//		aSorted[0].setToHack( s1, null );		
		//		assertFalse( aSorted[0].equals( clone ) );
		//		assertTrue( aSorted[0].equals( aSorted[0] ) );
		//		Element a = clone.clone(), b;
		//		a.setTo(aSorted[0]);
		//		assertTrue( aSorted[0].equals( a ) );
		//		clone.setTo(a);
		//		assertTrue( aSorted[0].equals( clone ) );
		//		clone.setToHack( s2, null );
		//		assertTrue( aSorted[0].equals( a ) );
		//		assertFalse( aSorted[0].compareTo( clone ) == 0 );
		//		assertTrue( aSorted[0].compareTo( a ) == 0 );
		//		assertFalse( aSorted[0].hashCode() == clone.hashCode() );
		//		assertTrue( aSorted[0].hashCode() == a.hashCode() );
		//		
		//		aSorted[0].setToHack( s2, null );
		//		assertTrue( aSorted[0].equals( clone ) );
		//		assertTrue( aSorted[0].compareTo( clone ) == 0 );
		//		assertTrue( aSorted[0].hashCode() == clone.hashCode() );
		//		
		Element clone = aSorted[0].clone();
		Element a = clone.clone();
		Element b = clone.clone();				
		assertTrue( a.hashCode() == clone.hashCode() );
		assertTrue( a.hasParent( 0 ) );
		assertTrue( a.hasParent( 1 ) );
		assertTrue( a.turnIntoParent( 0 ) );
		assertTrue( b.hashCode() == clone.hashCode() );
		assertTrue( b.turnIntoParent( 1 ) );				
		assertFalse( a.equals(clone) );
		assertFalse( a.hashCode() == clone.hashCode() );
		assertFalse( b.hashCode() == clone.hashCode() );
		assertTrue( a.isGenOf(clone) );
		assertTrue( b.isGenOf(clone) );
		assertFalse( clone.isGenOf(a) );
		assertFalse( clone.isGenOf(b) );
		assertFalse( b.isGenOf(a) );

		mda = new String[1];
		mdb = new String[1];
		mda[0] = s1[0];
		mdb[0] = s1[1];

		a = Element.createElement(mda, mdb, par);
		b.setTo(a);
		assertTrue( a.equals(b) );
		a.turnIntoParent(1);
		assertFalse( a.equals(b) );

		mda = new String[1];
		mdb = new String[1];		
		mda[0] = s2[0];
		mdb[0] = s2[1];            
		a = Element.createElement(mda, mdb, par);
		a = makeMixed( s2, par);

		assertTrue( a.hashCode() == clone.hashCode() );
		assertTrue( a.equals(clone) );
		assertTrue( a.generalizeTo( label ) );

		mda = new String[1];
		mdb = new String[1];		
		mda[0] = s3[0];
		mdb[0] = s3[1];            
		b = Element.createElement(mda, mdb, par);				
		assertTrue( a.hashCode() == b.hashCode() );
		assertTrue( a.equals(b) );
		assertFalse( a.generalizeTo( label6 ) );

		a = makeMixed( s2, par );
		assertTrue( a.generalizeTo( label2 ) );
		b = makeMixed( s4, par );
		assertTrue( a.hashCode() == b.hashCode() );
		assertTrue( a.equals(b) );
		assertFalse( a.generalizeTo( label ) );

		a = makeMixed( s1, par );
		b = makeMixed( s5, par );
		assertFalse( a.equals(b) );
		assertTrue( a.generalizeTo( label5 ) );
		assertTrue( a.equals(b) );		
		assertFalse( a.generalizeTo( label ) );

		a = makeMixed( s1, par );
		b = makeMixed( s6, par );
		assertFalse( a.equals(b) );
		assertTrue( a.generalizeTo( label6 ) );
		assertTrue( a.equals(b) );		
		assertFalse( a.generalizeTo( label ) );

		a = makeMixed( s1, par );
		b = makeMixed( s11, par );		
		assertFalse( a.generalizeTo( label7 ) );
		assertFalse( a.equals(b) );		
		assertTrue( a.generalizeTo( label ) );
		assertTrue( a.equals(b) );		
		a = makeMixed( s2, par );
		b = makeMixed( s2, par );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );		
		assertTrue( a.hasParent(1) );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );
		assertTrue( a.equals( b ) );		
		assertTrue( a.turnIntoParent(1) );		
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );

		assertFalse( a.equals( b ) );
		b = makeMixed( s12, par );
		assertTrue( a.equals( b ) );

		a = makeMixed( s2, par );
		b = a.clone();
		//System.out.println( "a=" + a);
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );

		assertTrue( a.turnIntoParent(0) );
		//System.out.println( "parent 0 =" + a);	
		assertTrue( a.turnIntoParent(0) );
		//System.out.println( "parent 0 =" + a);	

		assertTrue( a.getLevel( 0 ) == 2 );
		assertTrue( a.getLevel( 1 ) == 4 );

		int cont = 0;
		while( a.hasParent(1) ){
			cont++;
			assertTrue( a.turnIntoParent(1) );
			//System.out.println( "parent 1 =" + a);
			assertTrue( a.getLevel( 0 ) == 2 );
			assertTrue( a.getLevel( 1 ) == 4-cont );			
		}
		assertTrue( b.getLevel( 0 ) == 4 );
		assertTrue( b.getLevel( 1 ) == 4 );

		a = makeMixed( s13, par );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );
		a = makeMixed( s14, par );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );
		a = makeMixed( s15, par );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 4 );
		a = makeMixed( s16, par );
		assertTrue( a.getLevel( 0 ) == 4 );
		assertTrue( a.getLevel( 1 ) == 3 );
	}


	private Element makeMixed(String[] s, Parameter par) {
		String[] mda = new String[1];
		String[] mdb = new String[1];		
		mda[0] = s[0];
		mdb[0] = s[1];            
		return Element.createElement(mda, mdb, par);		
	}

}
