/**
 * 
 */
package hitters.test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.SysParameter;
import hitters.tools.Utils;
import hitters.tools.XMLPlotter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.junit.Test;

/**
 * @author Peter Fricke
 * 
 */
public class ComplexHHHTest {

	static final int PART_ANC	 	= 4096;
	static final int FULL_ANC	 	= 8192;

	//Pfad zu Testfaellen
	String dir = "resources/testcase/";

	MultiDatabase d;
	AbstractComplexHHH hitterAlgo;
	
	byte[][] plength = {  };
	//byte[][] plength = { {0,4,8,12,16,20,24,28,32}, {0,4,8,12,16,20,24,28,32} };
	Parameter myParams = new Parameter( 2 - plength.length, plength );

	double phi;

	//Fr Darstellung der Elemente als int Buchstaben in Ziffern umgewandelt a->1 b->2 usw.
	String[][] k = { {"*","*"}, {"/2","*"}, {"*","/1"}, {"*","/2"}, {"/1","*"}, {"*","/3"},
			{"/2","/1"}, {"/2","/2"}, {"/1","/1"}, {"/1","/2"}, {"/1","/3"} };

	// Sortieren von Testfllen erleichtert die Vergleiche von Soll und Ist
	Comparator<int[]> defaultComparator = new Comparator<int[]>(){ 
		public int compare( int[] a, int[] b  ){ 
			int erg = k[a[0]][0].compareTo(k[b[0]][0]);
			if( erg != 0 ) return erg;
			else return k[a[0]][1].compareTo(k[b[0]][1]);
		}
	};

	Comparator< Map.Entry<Element, MultiStringElement> > entryComparator
	= new Comparator< Map.Entry<Element, MultiStringElement> >(){
		public int compare( Map.Entry<Element, MultiStringElement> a, Map.Entry<Element, MultiStringElement> b ){
			return a.getKey().compareTo( b.getKey() );
		}
	};


	@Test	
	//@Ignore
	public void testEmpty() {		
		String res = "{( * (s) | * (s) )= ( fmin = 0, fmax = 0, F = 0 ) }";
		hitterAlgo = new PartAncHHH( 0, myParams );
		assertTrue( hitterAlgo.outputSet( 0.3 ).toString().equals( res ) );
		assertTrue( hitterAlgo.outputSet( 1.0 ).toString().equals( res ) );
		assertTrue( hitterAlgo.outputSet( 0.0 ).toString().equals( res ) );

		hitterAlgo = new FullAncHHH( 0, myParams );
		assertTrue( hitterAlgo.outputSet( 0.3 ).toString().equals( res ) );
		assertTrue( hitterAlgo.outputSet( 1.0 ).toString().equals( res ) );
		assertTrue( hitterAlgo.outputSet( 0.0 ).toString().equals( res ) );

	}
	
	@Test
	//@Ignore
	public void testWTF(){
		//Verschiedene Prozesse!
		double epsilon = 0.007;
		double phi = 3 * epsilon;
		DimType[] dims = { DimType.SEQUENCE };
		SysParameter par = new SysParameter( dims );
		HashSet<String> calls = new HashSet<String>();
		//calls.add("clock_gettime");
		calls.add("brk");
		par.setUsedCalls(calls);
		hitterAlgo = new FullAncHHH( epsilon, par );
		d = new MultiDatabase( "D:/ws/HHH/resources/data/ge4", par );
		d = new MultiDatabase( "D:/ws/HHH/resources/data/ff1", par );

		d.openRead(); 
		Vector<Element> data = d.readSystemCalls();

		for( Element e : data ) hitterAlgo.insert(e, 1, true);
		
		HashMap<Element, MultiHitterInfo> res = hitterAlgo.outputSet(phi);	
		List<String> list = new ArrayList<String>();
		
		for( Element e : res.keySet() ){
			list.add( e.toShortString() + " " + 
					res.get( e ).toShortString() );
		}								
		Collections.sort( list );

		for( int i = 0; i < list.size(); i++ ){
			System.out.println( list.get(i) );			
		}

	}

	
	@Test	
	//@Ignore
	public void testInsert() {		

		d = new MultiDatabase( dir + "PATest/PA6", myParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		hitterAlgo = new PartAncHHH( 0, myParams );

		for( Element e : data ) hitterAlgo.insert(e, 1, true);

		assertTrue( hitterAlgo.getN() == 15 );
		assertTrue( hitterAlgo.getTupelCount() == 7 );
		assertTrue( hitterAlgo.getMaxTupelCount() == 7 );

		for( Element e : data ) hitterAlgo.insert(e.clone(), 9, true);

		assertTrue( hitterAlgo.getN() == 150 );
		assertTrue( hitterAlgo.getTupelCount() == 7 );
		assertTrue( hitterAlgo.getMaxTupelCount() == 7 );

		hitterAlgo = new FullAncHHH( 0, myParams );

		for( Element e : data ) hitterAlgo.insert(e, 1, true);

		assertTrue( hitterAlgo.getN() == 15 );

		for( Element e : data ) hitterAlgo.insert(e.clone(), 9, true);

		assertTrue( hitterAlgo.getN() == 150 );
	}


	
	/////////////////////////////////////////////////////////////////////////
	//
	// Das hier ist die wesentliche Testmethode anhand von Testfllen,
	// die in Dateien liegen und von Hand berechnet wurden. Nicht nur die 
	// Ausgabe, sondern auch der jeweilige Zustand der Datenstruktur 
	// ist geprueft.
	//
	// Die passenden Bilder liegen ebenfalls dabei. 
	// 
	// Weiter unten kommen zwar noch weitere Tests, aber die sind alt 
	// und umstaendlich. Ich lasse sie trotzdem mal drin, kann 
	// ja nicht schaden.
	//
	/////////////////////////////////////////////////////////////////////////
	@Test
	//@Ignore
	public void testOutputSetBatch() {

		HashMap<Element, MultiHitterInfo> res;
		List<Map.Entry<Element, MultiStringElement>> dump;
		String file = "PATest/PA";

		for( int i = 1; i < 8; i++ ){
			this.load( file + i, PART_ANC );			
			res = hitterAlgo.outputSet( phi, false );
			this.validateHitter( res, file, i);
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i );
			this.load( file + i, PART_ANC );
			res = hitterAlgo.outputSet( phi, true );
			this.validateHitter( res, file, i);
			// Nochmal, moeglichen Fehler ausloesen
			res = hitterAlgo.outputSet( phi, true );			
			this.validateHitter( res, file, i);
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i);
		}

		file = "FATest/FA";

		for( int i = 2; i < 9; i++ ){
			this.load( file + i, FULL_ANC );			
			res = hitterAlgo.outputSet( phi, false );
			this.validateHitter( res, file, i );
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i );
			this.load( file + i, FULL_ANC );
			res = hitterAlgo.outputSet( phi, true );
			this.validateHitter( res, file, i );
			res = hitterAlgo.outputSet( phi, true );			
			this.validateHitter( res, file, i );
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i );
		}
	}

	
	@Test
	//@Ignore
	public void testPar(){
		Parameter p = new Parameter(1);
		assertTrue( p.getH() == 13 );
		DimType[] dims = { DimType.CALL, DimType.SEQUENCE };
		p = new SysParameter( dims );
		assertTrue( p.getH() == 35 );
	}
	
	@Test
	//@Ignore
	public void testBits(){
//		Parameter p = new Parameter(1);
//		assertTrue( p.getH() == 13 );
		DimType[] dims = { DimType.SEQUENCE, DimType.SEQUENCE };
		Parameter p = new SysParameter( dims );
		AbstractComplexHHH hitter = new PartAncHHH( 0.1, p);
		hitter.getEpsilon();
		
	}

	@Test
	//@Ignore
	public void testCalcLabels(){
		Parameter p = new Parameter(1);
		AbstractComplexHHH hitter = new PartAncHHH( 0.1, p);
		List<int[]> labels = hitter.calcLabels(3);
		int[] a = {3};
		List<int[]> res = new ArrayList<int[]>();
		res.add(a);
		assertTrue( arrayListEquals(labels, res ) );

		res.clear();
		p = new Parameter(2);
		hitter = new PartAncHHH( 0.1, p);
		labels = hitter.calcLabels(3);
		int[][] b = { {0,3}, {1,2}, {2,1}, {3,0} };
		for( int i = 0; i < b.length; i++ ) res.add(b[i]);
		assertTrue( arrayListEquals(labels, res ) );
		
		res.clear();
		p = new Parameter(3);
		hitter = new PartAncHHH( 0.1, p);
		labels = hitter.calcLabels(2);
		int[][] c = { {0,0,2}, {0,1,1}, {0,2,0}, {1,0,1}, {1,1,0}, {2,0,0} };
		for( int i = 0; i < c.length; i++ ) res.add(c[i]);
		assertTrue( arrayListEquals(labels, res ) );
		System.out.println( labels.size() );
	}

	
	@Test
	//@Ignore
	public void test1D(){

		HashMap<Element, MultiHitterInfo> res;
		List<Map.Entry<Element, MultiStringElement>> dump;
		Parameter p = new Parameter(1);
		String file = "PATest/1D/PA1D";

		for( int i = 1; i < 4; i++ ){
			this.load( file + i, PART_ANC, p );			
			res = hitterAlgo.outputSet( phi, false );			
			this.validateHitter( res, file, i);
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i );
			this.load( file + i, PART_ANC, p );
			res = hitterAlgo.outputSet( phi, true );
			this.validateHitter( res, file, i);
			// Nochmal, moeglichen Fehler ausloesen
			res = hitterAlgo.outputSet( phi, true );			
			this.validateHitter( res, file, i);
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i);
		}
		
//		int i = 3;
//		
//		this.load( file + i, PART_ANC, p );			
//		res = hitterAlgo.outputSet( phi, false );			
//		dump = hitterAlgo.dumpTrie();
//		
//		for( Map.Entry<Element, MultiStringElement> me : dump ){
//			System.out.println( me.getKey().toShortString() + " " + me.getValue().toShortString() );
//		}
//		
//		System.out.println();
//				
//		for( Element e : res.keySet() )
//			System.out.println( e.toShortString() + " " + res.get(e).toShortString() );
	}


	@Test
	//@Ignore
	public void testPlotter(){
		Parameter p = new Parameter(3);
		String[] eStr = {"/a/b", "/1/2", "/3/4"};
		Element e = Element.createElement(eStr, p);
		List<Element> list = new ArrayList<Element>();
		list.add(e);
		XMLPlotter pl = new XMLPlotter( "tmp/gt.graphml" );
		pl.addItems3D( list );
		pl.plot();
	}
	
	@Test
	//@Ignore
	public void test3D(){

		HashMap<Element, MultiHitterInfo> res;
		List<Map.Entry<Element, MultiStringElement>> dump;
		Parameter p = new Parameter(3);
		String file = "PATest/3D/PA3D";

		for( int i = 1; i < 3; i++ ){
			this.load( file + i, PART_ANC, p );			
			res = hitterAlgo.outputSet( phi, false );			
			this.validateHitter( res, file, i);
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i );
			this.load( file + i, PART_ANC, p );
			res = hitterAlgo.outputSet( phi, true );
			this.validateHitter( res, file, i);
			// Nochmal, moeglichen Fehler ausloesen
			res = hitterAlgo.outputSet( phi, true );			
			this.validateHitter( res, file, i);
			dump = hitterAlgo.dumpTrie();
			this.validateDump( dump, file, i);
		}
		
		int i = 2;
		
		this.load( file + i, PART_ANC, p );			
		res = hitterAlgo.outputSet( phi, false );			
		dump = hitterAlgo.dumpTrie();
		
		for( Map.Entry<Element, MultiStringElement> me : dump ){
			System.out.println( me.getKey().toShortString() + " " + me.getValue().toShortString() );
		}
		
		System.out.println();
				
		for( Element e : res.keySet() )
			System.out.println( e.toShortString() + " " + res.get(e).toShortString() );
	}
	
	@Test	
	//@Ignore
	public final void testAncestorInsert() {

		/////////// Teste, ob die Berechnung der m-Werte beim Insert funktioniert //////////////////////////
		// bcurrent - 1 wre immer korrekt, die engeren m-Werte ber das Minimum der
		// Vorfahren sind komplizierter, aber besser.
		// Siehe Bild Insert auf Fragebogen.
		String[][] t = { {"/1/2/3/4/5", "*"}, {"/1/2/3/4", "*"}, {"/1/2/3", "*"},
				{"/1/2", "*"}, {"/1", "*"}, {"*", "*"}, {"/1/2/3/4/5", "/1"}, 
				{"/1/2/3", "/1"}, {"/1/2", "/1"}, {"/1", "/1"}, {"*", "/1"},
				{"/1/2/3/4", "/1/2"}, {"*", "/1/2"},
				{"/1/2/3/4", "/1/2/3"}, {"/1/2", "/1/2/3"}, {"/1", "/1/2/3"},
				{"*", "/1/2/3/4"}, {"/1/2/3/4/5", "/1/2/3/4"} };

		int[][] d0 = { {4,1,1}, {4,1,1}, {4,1,1}, {4,1,1}, {4,1,1}, {4,1,1}, 
				{6,3,4}, {6,3,4}, {6,3,4}, {6,3,4}, {4,1,1},
				{6,3,4}, {6,3,4}, {6,3,4}, {6,3,4}, {6,3,4}, {6,3,4}, {0,0,0} };				

		MultiStringElement m;
		Element a;				 

		hitterAlgo = new PartAncHHH( 0.1, myParams ); // w = 10				
		hitterAlgo.setN( 170 );


		for( int i = 0; i < 18; i++ ){
			a = Element.createElement( t[i], null, myParams );
			m = new MultiStringElement( d0[i][0], d0[i][1], d0[i][2]);
			if( d0[i][0] != 0 ) hitterAlgo.setTest( a, m );
		}
		a = Element.createElement( t[17], null, myParams );
		assertTrue( 3 == hitterAlgo.instantiateDelta( a ) );
		hitterAlgo.insertWithoutCompress(a, 1, true);
		m = hitterAlgo.dumpElement( a );
		assertTrue( m.delta == 3);

		int x = 2;							 

		for( int k = 7; k < 17; k++ ){
			if( k > 7 ) d0[k-1][1] = 3;
			d0[k][1] = x;
			hitterAlgo = new PartAncHHH( 0.1, myParams ); // w = 10				
			hitterAlgo.setN( 170 );

			for( int i = 0; i < 18; i++ ){
				a = Element.createElement( t[i], null, myParams );
				m = new MultiStringElement( d0[i][0], d0[i][1], d0[i][2]);
				if( d0[i][0] != 0 ) hitterAlgo.setTest( a, m );
			}
			a = Element.createElement( t[17], null, myParams );
			if( k != 10 ) assertTrue( x == hitterAlgo.instantiateDelta( a ) );
			hitterAlgo.insertWithoutCompress( a, 1, true);
			m = hitterAlgo.dumpElement( a );
			if( k != 10 ) assertTrue( m.delta == x);
			else assertTrue( m.delta == 3);
		}
	}



	
	@Test
	//@Ignore
	public final void testInsertNoCompress() {

		/////////// Teste insert() ohne compress() //////////////////////////
		// ins[i] = { x, y }: Fge als i-ten Schritt y mal k[x] ein.
		int[][] ins = { {6,1}, {7,1}, {8,1}, {7,9}, {9,4}, {6,5}, {7,2}, {10,1}, {9,8} };		
		// exp[i] = {a, b, c}: k[a] wurde b mal eingefgt und hat delta c.
		int[][] exp = { {8,1,0}, {9,12,1}, {10,1,2}, {6,6,0}, {7,12,0} }; 

		compareInsert( ins, exp, 0.1, false, null );

		String[][] str = { {"*","*"}, {"*","/1"}, {"/1","*"}, {"*","/2"}, {"/2","*"}, {"*","/3"} };				
		int[][] ins1 = { {0,4}, {4,5}, {1,3}, {2,9}, {3,4}, {5,5} };		 
		int[][] exp1 = { {0,4,0}, {4,5,0}, {1,3,0}, {2,9,0}, {3,4,0}, {5,5,0} }; 
		compareInsert( ins1, exp1, 0.1, false, str );
	}
	

	private void compareInsert( int[][] insr, int[][] expc, 
			double eps, boolean compress, final String[][] s ){
		compareInsert( insr, expc, eps, compress, s, plength);
	}


	private void compareInsert( int[][] insr, int[][] expc, double eps, 
			boolean compress, final String[][] s, byte[][] myPlength ){		

		int counter = 0, offset = 0;
		if( compress ) offset = 1;							

		hitterAlgo = new PartAncHHH( 0.1, myParams ); //  w = 1 / eps
		MultiStringElement m;				
		Element a;

		Comparator<int[]> arrayComparator;
		String[][] str; 
		if( s == null ){
			str = k;// Globaler default
			arrayComparator = defaultComparator;
		}
		else{
			str = s;
			arrayComparator = new Comparator<int[]>(){ 
				public int compare( int[] a, int[] b  ){ 
					int erg = s[a[0]][0].compareTo(s[b[0]][0]);
					if( erg != 0 ) return erg;
					else return s[a[0]][1].compareTo(s[b[0]][1]);
				}
			};
		}

		Arrays.sort( expc , arrayComparator );

		for( int i = 0; i < insr.length; i++ ){
			counter += insr[i][1];
			a = Element.createElement( str[ insr[i][0] ], null, myParams ); 					
			if( compress ) hitterAlgo.insert( a, insr[i][1], true );
			else hitterAlgo.insertWithoutCompress( a, insr[i][1], true );			
		}


		List<Map.Entry< Element, MultiStringElement> > trie = hitterAlgo.dumpTrie();		
		Collections.sort( trie, entryComparator );		
		assertTrue( trie.size() == expc.length );

		for( int i = 0; i < expc.length; i++ ){
			//HHHMulti.log(i+" ");
			a = trie.get( i ).getKey();
			m = trie.get( i ).getValue();		
			assertTrue( a.equals( 
					Element.createElement( str[expc[i][0]], null, myParams ) ) );

			assertTrue( m.g == expc[i][1] );					
			assertTrue( m.m == expc[i][2] );
			assertTrue( m.delta == expc[i][2+offset] );
		}		

		assertTrue( hitterAlgo.getN() == counter );
	}


	@Test
	//@Ignore
	public final void testCompress() {
		////////////////////////////////////////////////////////////////////////////////////
		// Kleiner Testcase: Setze einfache Datenstruktur auf, komprimiere, vergleiche Ist-Soll.
		// w = 10, bcurrent = 3 
		// Korrekte Anpassung der Eltern-m-Werte bei Kinderlschung wird abgedeckt.

		// Datei Testcase C1.jpg
		//
		String[][] str = { {"*","*"}, {"*","/1"}, {"/1","*"}, {"*","/2"}, {"/2","*"}, {"*","/3"},
				{"/1","/1"}, {"/2","/1"}, {"/1","/2"}, {"/1","/3"}, {"/2","/2"}, {"/2","/3"} };		
		// i-ter Eintrag ist {a,b,c}: Setze g-Wert fr k[i] auf a, m auf b, delta auf c
		int[][] d0 = { {5,1,1}, {2,2,2}, {0,0,0}, {1,2,2}, {3,4,3},	{5,5,5},
				{1,3,3}, {2,2,2}, {0,0,0}, {1,0,0}, {3,0,0}, {1,3,3} };
		// exp1[i] = {a, b, c, d}: k[a] wurde b mal eingefgt und hat m = c und delta = d.
		int[][] expc = { {1,2,2,2}, {3,4,3,2}, {4,6,4,3}, {5,6,5,5}, {6,1,3,3},
				{7,2,2,2}, {11,1,3,3} }; 		

		compareCompress( d0, expc, .1, 22, str );

	}

	/*
	 * Ist-Soll-Abgleich.
	 */
	private void compareCompress( int[][] data, int[][] expc, double eps, int N, final String[][] s ){

		Comparator<int[]> arrayComparator;
		String[][] str; 
		if( s == null ){
			str = k;// Globaler default
			arrayComparator = defaultComparator;
		}
		else{
			str = s;
			arrayComparator = new Comparator<int[]>(){ 
				public int compare( int[] a, int[] b  ){ 
					int erg = s[a[0]][0].compareTo(s[b[0]][0]);
					if( erg != 0 ) return erg;
					else return s[a[0]][1].compareTo(s[b[0]][1]);
				}
			};
		}

		Arrays.sort( expc , arrayComparator );

		hitterAlgo = new PartAncHHH( 0.1, myParams ); 
		MultiStringElement m;		
		Element a;

		for( int i = 0; i < data.length; i++ ){
			a = Element.createElement( str[i], null, myParams );
			m = new MultiStringElement( data[i][0], data[i][1], data[i][2]);
			if( data[i][0] != 0 ) hitterAlgo.setTest( a, m );
		}
		hitterAlgo.setN( N );

		hitterAlgo.compress();

		List<Map.Entry< Element, MultiStringElement> > trie = hitterAlgo.dumpTrie();		
		Collections.sort( trie, entryComparator );		
		assertTrue( trie.size() == expc.length );

		for( int i = 0; i < expc.length; i++ ){
			a = trie.get( i ).getKey();
			m = trie.get( i ).getValue();		
			assertTrue( a.equals(
					Element.createElement( str[expc[i][0]], null, myParams ) ) );

			assertTrue( m.g == expc[i][1] );					
			assertTrue( m.m == expc[i][2] );
			assertTrue( m.delta == expc[i][3] );
		}		
	}


	@Test
	//@Ignore
	public final void testOutputSet() {

		//////////////////////////////////////////////////////////////////////////////////////
		// Teste den Fall, dass die glb nicht in der Datenstruktur vorhanden sind:
		// Fr phi * N = 4 sind u.a. (*,1) und (a,*) HHH, ihr glb (a,1) ist nicht in der Datenstruktur
		//
		// Datei Testcase A1.jpg
		//
		String[][] t = { {"*","*"}, {"/2","*"}, {"*","/1"}, {"*","/2"}, {"/1","*"}, {"*","/3"},
				{"/2","/1"}, {"/2","/2"}, {"/1","/1"}, {"/1","/2"}, {"/1","/3"}, {"/3","/1"}, {"/3","*"} };
		// i-ter Eintrag ist {a,b,c}: Setze g-Wert fr k[i] auf a, m auf b, delta auf c
		int[][] d0 = { {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},	{0,0,0},
				{3,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {3,0,0}, {1,0,0}, {0,0,0} };
		// expc[i] = {a, b, c, d}: t[a] hat fmin = b, fmax = c, F = d
		int[][] expc  = { {2,4,4,4}, {4,4,4,4} };

		compareOutput( d0, expc, 0, 8, 0.5, t );


		//////////////////////////////////////////////////////////////////////////////////////
		// Getestet wird die Ausgabe bei durch d definiertem Zustand der Datenstruktur,
		// N = 40, phi * N = 7, 
		// bcurrent ist durchgngig 1, also m = 0, so dass online erzeugten 
		// Knoten delta = 0 haben und den Test nicht verkomplizieren.
		//
		// Siehe Testcase A4.jpg
		//
		// i-ter Eintrag ist {a,b,c}: Setze g-Wert fr k[i] auf a, m auf b, delta auf c 
		int[][] d = { {9,0,6}, {6,0,1}, {1,0,1}, {4,0,7}, {3,0,3}, {5,0,0},
				{5,0,1}, {1,0,7}, {4,0,3}, {1,0,1}, {1,0,0} };
		// ex[i] = {a, b, c, d}: t[a] hat fmin = b, fmax = c, F = d
		int[][] ex = { {0, 34, 46, 38}, {2,9,11,9}, {3,-1,13,12} ,
				{4,6,12,8} , {8,1,7,4}, {1,11,13,18}, {7,-6,8,1} };

		compareOutput( d, ex, 0, 40, 7.0/40.0, null );


		//////////////////////////////////////////////////////////////////////////////////////
		// Getestet wird die Ausgabe bei durch d definiertem Zustand der Datenstruktur,
		// N = 49, phi * N = 7, bcurrent = 1.
		//
		// Siehe Testcase A5.jpg
		//

		// i-ter Eintrag ist {a,b,c}: Setze g-Wert fr k[i] auf a, m auf b, delta auf c
		int[][] d2 = { {6,0,99}, {4,0,6}, {3,0,2}, {4,0,1}, {6,0,1}, {5,0,2},
				{5,0,1}, {6,0,2}, {1,0,7}, {4,0,0}, {5,0,1} };
		// ex2[i] = {a, b, c, d}: t[a] hat fmin = b, fmax = c, F = d
		int[][] ex2 = { {0, -50, 148, 29}, {1,9,21,11}, {2,7,11,15} ,
				{3,13,15,10}, {4,15,17,22}, {5,8,12,10}, {7,4,8,6}, {8,-6,8,1} };

		compareOutput( d2, ex2, 0, 49, 1.0/7.0, null );


		//////////////////////////////////////////////////////////////////////////////////////
		// Getestet wird die Ausgabe bei durch d definiertem Zustand der Datenstruktur,
		// N = 36, phi * N = 4, bcurrent = 1.
		//
		// Siehe Testcase A3.jpg
		//

		// i-ter Eintrag ist {a,b,c}: Setze g-Wert fr k[i] auf a, m auf b, delta auf c
		int[][] d3 = { {6,0,1}, {3,0,1}, {2,0,0}, {3,0,2}, {3,0,3}, {2,0,1},
				{4,0,1}, {3,0,2}, {3,0,1}, {4,0,0}, {3,0,0} };
		// ex3[i] = {a, b, c, d}: t[a] hat fmin = b, fmax = c, F = d
		int[][] ex3 = { {0, 35, 37, 17}, {1,9,11,6}, {2,9,9,4}, {3,8,12,5}, 
				{4,10,16,7}, {5,4,6,5}, {6,3,5,4}, {7,1,5,3}, {8,2,4,3}, {9,4,4,4} };

		compareOutput( d3, ex3, 0, 36, 1.0/9.0, null );


		//////////////////////////////////////////////////////////////////////////////////////
		//
		// Nochmal Testcase A3.jpg mit /2/3 = 1,0,1, um glb-Effekt fr Nichthitter zu prfen
		//

		String[][] t4 = { {"*","*"}, {"/2","*"}, {"*","/1"}, {"*","/2"}, {"/1","*"}, {"*","/3"},
				{"/2","/1"}, {"/2","/2"}, {"/1","/1"}, {"/1","/2"}, {"/1","/3"}, {"/2","/3"} };

		// i-ter Eintrag ist {a,b,c}: Setze g-Wert fr k[i] auf a, m auf b, delta auf c
		int[][] d4 = { {6,0,1}, {3,0,1}, {2,0,0}, {3,0,2}, {3,0,3}, {2,0,1},
				{4,0,1}, {3,0,2}, {3,0,1}, {4,0,0}, {3,0,0}, {1,0,1} };
		// ex4[i] = {a, b, c, d}: t[a] hat fmin = b, fmax = c, F = d
		int[][] ex4 = { {0, 36, 38, 18}, {1,10,12,7}, {2,9,9,4}, {3,8,12,5}, 
				{4,10,16,7}, {5,5,7,6}, {6,3,5,4}, {7,1,5,3}, {8,2,4,3}, {9,4,4,4} };

		compareOutput( d4, ex4, 0, 36, 1.0/9.0, t4 );

	}


	public void compareOutput( int[][] d, int[][] exp, double eps, 
			int N, double phi, final String[][] s ){

		Comparator<int[]> arrayComparator;
		String[][] str; 
		if( s == null ){
			str = k;// Globaler default
			arrayComparator = defaultComparator;
		}
		else{
			str = s;
			arrayComparator = new Comparator<int[]>(){ 
				public int compare( int[] a, int[] b  ){ 
					int erg = s[a[0]][0].compareTo(s[b[0]][0]);
					if( erg != 0 ) return erg;
					else return s[a[0]][1].compareTo(s[b[0]][1]);
				}
			};
		}

		Arrays.sort( exp , arrayComparator );

		hitterAlgo = new PartAncHHH( 0.1, myParams );		 
		MultiStringElement m;
		MultiHitterInfo    h;
		Element 	   a;

		for( int i = 0; i < d.length; i++ ){
			a = Element.createElement( str[i], null, myParams );								
			m = new MultiStringElement( d[i][0], d[i][1], d[i][2]);
			if( d[i][0] != 0 ) hitterAlgo.setTest( a, m );
		}

		hitterAlgo.setN( N );

		HashMap<Element, MultiHitterInfo> res = hitterAlgo.outputSet( phi );		

		ArrayList<Element> ls = new ArrayList<Element>(res.keySet());		
		Collections.sort( ls );		
		assertTrue( ls.size() == exp.length );

		for( int i = 0; i < ls.size(); i++ ){			

			a = ls.get( i );
			h = res.get( a );			
			assertTrue( a.equals( 
					Element.createElement( str[exp[i][0]], null, myParams ) ) );

			assertTrue( h.fmin == exp[i][1] );
			assertTrue( h.fmax == exp[i][2] );
			assertTrue( h.F    == exp[i][3] );		
		}		
	}


	@Test	
	public final void testExp() {		
		assertTrue( Utils.exp( 2, 3) == 8 );
		assertTrue( Utils.exp( 2, 5) == 32 );
		assertFalse( Utils.exp( 2, 2) == 8 );
		assertTrue( Utils.exp( 1, 3) == 1 );
		assertTrue( Utils.exp( 0, 3) == 0 );
		assertTrue( Utils.exp( 2, 0) == 1 );
		assertTrue( Utils.exp( 0, 0) == 1 );		
	}


	private void load( String testcase, int algo, Parameter theParams ){

		d = new MultiDatabase( dir + testcase, theParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		phi = d.getPhi();

		switch( algo ){

		case FULL_ANC: hitterAlgo = new FullAncHHH( d.getEpsilon(), theParams );
		break;

		case PART_ANC: hitterAlgo = new PartAncHHH( d.getEpsilon(), theParams );
		break;

		default: throw new RuntimeException("Algorithmus angeben!"); 
		}

		for( Element e : data ) hitterAlgo.insert(e, 1, true);		
	}

	
	private void load( String testcase, int algo ){
		load( testcase, algo, myParams );
	}



	private void validateHitter( HashMap<Element, MultiHitterInfo> res,
			String testcase, int nr ){

		String s = null;
		String message, pre;

		List<String> list = new ArrayList<String>();

		testcase += nr;

		for( Element e : res.keySet() ){
			list.add( e.toShortString() + " " + 
					res.get( e ).toShortString() );
		}								
		Collections.sort( list );

		List<String> solution = this.loadSolution( dir + testcase + ".res");		

		assertTrue("Problem: Testcase " + nr + " Hitter Groessen unterschiedl.",
				list.size() == solution.size() );	

		for( int i = 0; i < list.size(); i++ ){
			s = list.get(i);
			pre = "Problem: Hitter Testcase " + nr + " Zeile " + i + ": ";
			message = pre + " Berechnet: " + list.get(i);
			message += "\nGelesen: " + solution.get(i);
			assertTrue( message, s.trim().equals( solution.get(i).trim() ) );
		}

	}


	private void validateDump( 
			List<Map.Entry<Element, MultiStringElement>> dump,			
			String testcase, int nr ){

		String s = null;
		String message, pre;

		List<String> list = new ArrayList<String>();

		testcase += nr;

		for( Map.Entry<Element, MultiStringElement> entry : dump ){
			list.add( entry.getKey().toShortString() + " " + 
					entry.getValue().toShortString() );
		}								
		Collections.sort( list );

		List<String> solution = this.loadSolution( dir + testcase + ".data");		

		assertTrue("Problem: Testcase " + nr + " Dump Groessen unterschiedl.",
				list.size() == solution.size() );	

		for( int i = 0; i < list.size(); i++ ){
			s = list.get(i);
			pre = "Problem: Dump Testcase " + nr + " Zeile " + i + ": ";
			message = pre + " Berechnet: " + list.get(i);
			message += "\nGelesen: " + solution.get(i);
			assertTrue( message, s.trim().equals( solution.get(i).trim() ) );
		}

	}


	private List<String> loadSolution( String file ){

		List<String> list = new ArrayList<String>();
		String line;

		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {				
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		Collections.sort( list );		

		return list;
	}

	
	private boolean arrayListEquals( List<int[]> a, List<int[]> b ) {
		
		boolean equal = true;
		int[] aArr, bArr;
		
		if( a.size() != b.size() ) return false; 
		for( int j = 0; j < a.size(); j++ ){
			aArr = a.get(j);
			bArr = b.get(j);
			for( int i = 0; i < aArr.length; i++ )
				if( aArr[i] != bArr[i] ) equal = false;
		}
		return equal;
	}
}
