package hitters.multi;

import hitters.tools.Utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Peter Fricke
 *
 * Es gibt eine hierarchische Darstellung der Calls, bei der auf
 * jeder Hierarchieebene geschaut wird, wievieltes Kind der Call ist.
 * Diese Zahlen werden durch Shiften in ein int gestopft und bei Bedarf
 * wieder herausgefummelt. Sinn der �bung ist die Darstellung eines Calls
 * und seiner Parameter innerhalb der Hierarchie der Calls.
 * 
 * Daneben gibt es eine flache Darstellung der Calls als kleine Zahl.
 * Diese ist f�r die Sequenzinformationen erforderlich. F�r
 * die Sequenzen werden die letzten n Calls betrachtet, um Informationen
 * �ber den Kontext eines Calls zu erhalten. Auch diese Information ist
 * hierarchisch: Sequenzen der L�nge k-1 sind Pr�fixe von Sequenzen der
 * L�nge k. Um auch diese (zeitliche) Hierarchie in ein Int stopfen zu k�nnen,
 * m�ssen die einzelnen Komponenten der Pr�fixe kleiner als ein int sein,
 * also ist die oben genannte bei der hierarchischen Darstellung der Calls verwendete Zahl
 * nicht verwendbar. F�r die flache Darstellung verwende ich daher die 
 * fortlaufende Nummer des Calls (Position in der Taxonomiedatei).  
 * Um Verwechselungen zu vermeiden, benutze ich jeweils den Zusatz "Flat". 
 * 
 * 
 */
public class Taxonomy{

	private static final int maxWidth = 40;		

	// Zugriff auf Codes ueber die vollen Strings
	private HashMap<String, String> map = new HashMap<String, String>();
	
	// Zugriff auf Codes ueber die Namen der calls
	private HashMap<String, String> callMap = new HashMap<String, String>();
	
	// Zugriff auf flache Nummer der Calls ueber die Namen der calls
	private HashMap<String, Integer> call2flat = new HashMap<String, Integer>();

	// Zugriff auf die Namen der calls ueber flache Nummer der Calls
	private HashMap<Integer, String> flat2call = new HashMap<Integer, String>();

	
	private TaxNode root = new TaxNode("*");
	private int size = 0;


	public static void main(String[] args) {

		String label;
		int[] code = new int[SysParser.MAXDEPTH];
		Taxonomy tax = null; 
		try{
			tax  = new Taxonomy("Taxonomy3");
		}catch(Exception e) {};
		
		System.out.println( "Code = " + tax.getCode( "/FILESYS/open" ) );
		System.out.println( "Map = " + tax.map );
		System.exit(0);
		
		for( int i = 0; i < 4; i++ )
			for( int j = 0; j < maxWidth; j++ )
				for( int k = 0; k < maxWidth; k++ )
					for( int l = 0; l < maxWidth; l++ ){
						code[1] = i;
						code[2] = j;
						code[3] = k;						
						code[4] = l;
						if( (label = tax.getPathlabel( code )) != null ) {
							System.out.print( "\n" + label + " -> "); 
							for(int m=1; m< 5; m++)
								System.out.print(" /" + code[m]);
						}
					}
	}


	public Taxonomy( String file ) throws java.io.FileNotFoundException{

		// Locate file
		Reader reader = null;		
		InputStream str = null;
		String[] places = Utils.resourceLocationsJar();
		for( String place : places ){
			str = Taxonomy.class.getResourceAsStream( place + file );
			if( str != null ){
				reader = new InputStreamReader( str );
				break;
			}
		}
		
		if( str == null ){
			URL url = Taxonomy.class.getClassLoader().getResource(".");			
			String p = url.getPath();
			String[] otherPlaces = Utils.resourceLocationsFiles();			
			for( String place : otherPlaces ){
				try{ 
					reader = new FileReader( p + place + file );
				}catch(Exception e){ }//System.out.println(e); }			
				if( reader != null ){				
					break;
				}
			}		
		}
		
		String[] components = new String[SysParser.MAXDEPTH];
		String line, codeString, label, name;
		Pattern callnameP = Pattern.compile( "/[a-z_][^/$]+" );
		Pattern groupAndCallP = Pattern.compile( "/[A-Z_][^/$]+/[a-z_][^/$]+" );
		Matcher m;
		int[] code = new int[SysParser.MAXDEPTH];
		int level = 0, flatCounter = 0;

		deleteSuffix( code, components, level );

		try {
			BufferedReader in = new BufferedReader( reader );
			while( (line = in.readLine()) != null) {				
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					
					// Auf Ebene der Calls mitzaehlen und 
					// flache Nummern speichern
					if( getLevel(line) == 2 ){
						flatCounter++;
						flat2call.put( flatCounter, line.substring(1).trim() );
						call2flat.put( line.substring(1).trim(), flatCounter );
					}
						
					if( getLevel( line ) <= level ){
						add( code, components );
						level = getLevel( line );
						deleteSuffix( code, components, level );
						components[level] = getComponent( line );
						code[level]++;												
					}
					else{
						level++;
						components[level] = getComponent( line );
						code[level]++;
					}
				}				
			}			
			// Letzte Zeile nicht vergessen
			if( level > 0 )	add( code, components );
			in.close();

		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		// Map liefert zu einem Call den passenden Code (erste zwei Stufen)
		for( int i = 0; i < 10; i++ ){
			for( int j = 0; j < maxWidth; j++ ){
				
						code[1] = i;
						code[2] = j;
						if( (label = getPathlabel( code )) != null ) {
							codeString = "/" + code[1] + "/" + code[2];
							//System.out.println( codeString + "  --- >>> " + label );
							//map.put(label, codeString);	
							m = groupAndCallP.matcher( label );
							if( m.find() ){ 
								name = m.group();								
								map.put( name, codeString );							
							}
							
							
							//Zugriff auch ueber den reinen Callnamen
							m = callnameP.matcher( label );
							if( m.find(1) ){ 
								name = m.group();								
								callMap.put( name.substring(1), codeString );							
							}
							
						}
					}
		}		
	}

	
	public Set<String> getAllCalls(){ return callMap.keySet(); }
	
	
	public String getCode( String call ) { return map.get( call ); }

	
	public String code4Call( String call ){				
		return callMap.get(call);
	}
	
	
	public void add( int[] call, String[] components ) {
		trav( call, components );
		size++;				
	}


	public String getPathlabel( int[] call ) {
		return trav( call, null );
	}

	
	public String getPathlabel( String s ) {
		
		//Split -> Erste Komponente leer.
		String[] parts = s.split("/");
		int len = parts.length;
		int[] ints = new int[len];
		
		for( int i = 0; i < len; i++ ){
			if( parts[i].equals("") ) ints[i] = 0;
			else ints[i] = Integer.parseInt(parts[i]);
		}

		return getPathlabel( ints );
	}
	
	
	public String flat2call( int flat ){ 
		
		String s = flat2call.get( flat );
		//if( s == null ) s = "-1";
		return s;
		
	}
	
	
	public int call2flat( String call ){ 
		int i;
		Integer integer = call2flat.get( call );
		if( integer == null ) i = -1;
		else i = integer;
		return i;
	}

	
	// Durchlaufe Taxonomie, erzeuge Knoten gdw. components != null
	private String trav( int[] call, String[] components ) {

		if( call == null ) throw new NullPointerException();

		if( components != null && components[1] == "" ) 
			throw new RuntimeException( "Taxonomie: Versuch * einzufuegen");

		if( call[1] == 0 ){
			for( int i = 1; i < call.length; i++ ){
				if( call[i] != 0 ) return null;
			}
			return "*";
		}

		TaxNode node = root;
		String pathlabel = "";
		int index;

		for( int i = 1; i < call.length; i++ ){

			index = call[i];

			if( index < 0 || index >= maxWidth ) {
				throw new RuntimeException( "Taxonomie: " +
						"Zu viele Kinder erwartet. index=" + index +
						"maxWidth= " + maxWidth );
			}
			if( index == 0 ){
				for( int j = i; j < call.length; j++ ){
					if( call[j] != 0 ) return null;
				}
				break;
			}

			if( node.children[index] == null ) {
				if( components != null ) {
					node.children[index] = new TaxNode( components[ i ] );
				}
				// Fuer Hash und andere nicht explizit in der Taxonomie
				// aufgefuehrte Werte
				else{ 
					for( int k = i; k < call.length; k++ ){
						if( call[ k ] != 0 ) 
							pathlabel = pathlabel + "/" + call[ k ];
					}
					return pathlabel;
				}
			}			
			node = node.children[index];
			pathlabel = pathlabel + "/" + node.label;
		}

		return pathlabel;
	}

	
	// Durchlaufe Taxonomie finde Code fuer gegebenes Pathlabel.
	// Noetig zum Laden von HHH aus Datei.
	public int[] pathlabel2code( String pathlabel ) {		

		String[] comps = pathlabel.split("/");
		int[] call = new int[ comps.length ];
		TaxNode node = root;		

		for( int i = 1; i < call.length; i++ ){
			
			for( int j = 1; j < node.children.length; j++ ){		
				if( node.children[ j ] == null ) break;
				if( comps[i].trim().equals( node.children[ j ].label ) )
					call[i] = j;
			}
			
			if( call[i] < 1 ){
				call[i] = Integer.parseInt( comps[i]);
			}

				//				throw new RuntimeException("Taxonomie pathlabel2code: " +
				//				"Auf Ebene " + i + " keinen Code geunden: " + pathlabel );

			node = node.children[ call[i] ];			
		}

		return call;
	}



	public int size(){
		return this.size;
	}


	private void deleteSuffix( int[] code, String[] components, int level ){
		for( int i = level+1; i < SysParser.MAXDEPTH; i++ ){
			code[i] = 0;
			components[i] = "";
		}
	}

	private String getComponent( String line ){
		int pos = line.lastIndexOf("-");
		return line.substring( pos + 1 ).trim();		
	}

	private int getLevel( String line ){
		int pos = line.lastIndexOf("-");
		for( int i = 0; i < pos; i++ ){
			if( line.charAt(i) != '-' )
				throw new RuntimeException(" Minuszeichen" +
						" fehlen: getLevel:"+ line);
		}		
		return pos + 2;
	}


	private class TaxNode {
		//TODO: Kinder als Liste
		public TaxNode[] children = new TaxNode[maxWidth];
		public String label;
		public TaxNode( String label ){ this.label = label; }
		public String toString(){ return label; }
	}

}