package hitters.multi;

import hitters.tools.LogService;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;

/**
 * @author Peter Fricke
 * 
 */
public class StreamReader {

	//Automatisches Identifizieren des Stromtyps
	private static final int SYSCALL = 1;
	private static final int SIMPLE  = 2;
	private static final int UNKNOWN = -1;

	private final int dimS;
	private final int dimI;
	private final int dim;
	private int streamType = UNKNOWN;

	private BufferedReader in;	
	private Parameter myParams; 

	SysParameter sysPar = null;	
	SysParser parser = null;

	
	private String[] clean;
	private String str = null;

	public StreamReader( Parameter myParams ){		

		if( LogService.shouldLog( LogService.NORMAL ) ) 
			LogService.log(LogService.NORMAL,  "MultiDataBase:" +
					" dimI lt. Par " + myParams.getDimI() +
					" dimS lt Par " + myParams.getDimS() );		

		boolean problem = false;
		this.myParams = myParams;
		dimS = myParams.getDimS();
		dimI = myParams.getDimI();							
		dim  = dimI + dimS;
		clean = new String[ dim ];
		in = new BufferedReader(new InputStreamReader(System.in));

		// StreamType bestimmen (werden SystemCalls gelesen?)
		while (streamType == UNKNOWN) {				
			try{
				str = in.readLine();				
				streamType = getStreamType( str );
				System.out.println("streamtype " + printType(streamType) );
				if( str == null ) Thread.sleep(500);
			}catch (IOException e){ 
				System.out.print(e.getMessage());
			}
			catch (InterruptedException e){ 
				System.out.print(e.getMessage());
			}			
		}

		// Pruefe, ob StreamType zu Parametern passt
		if( streamType == SYSCALL && (dimI != 1 || dimS != 1) ) problem = true;
		if( streamType == SIMPLE && (dimI != 0 ) ) problem = true;
		if( problem )
			throw new RuntimeException("Stromtyp passt nicht zu Parametern:\n" +
					" StreamType == " + printType(streamType) + "\n" + myParams );
		
		
		if( streamType == SYSCALL ){
		
			if( ! (myParams instanceof SysParameter) )
				throw new RuntimeException( "System Calls lesen nur" +
				" mit Parameterobjekt vom Typ SysParameter." );

			sysPar = (SysParameter) myParams;

			parser = new SysParser( sysPar );
			
		}
	}


	public void close(){
		try{
			in.close();
		}catch (IOException e){ 
			System.out.print(e.getMessage());
		}
	}


	public int readLoop( Collection<Element> container, long lines ){

		int readcount=0;	
		int counter = 0;
		String str  = "";
		Element elem = null;
		container.clear();

		while (str != null) {				
			try{
				readcount++;
				str = in.readLine();
				if( streamType == UNKNOWN ){
					streamType = getStreamType( str );
					System.out.println("streamtype " + printType(streamType) );
				}

				switch( streamType ){
				case SIMPLE:  elem = readStreamElement( str ); break;
				case SYSCALL: elem = readSysElement(	str ); break;
				// Typ konnte noch nicht identifiziert werden, tue nichts
				case UNKNOWN: 
				}

				if( elem != null ){
					container.add( elem );					
					if( ++counter >= lines ) {
						return readcount;
					}
				}	

			}catch (IOException e){ 
				System.out.print(e.getMessage());
			}
		}

		return readcount;
	}



	public Element readStreamElement( String line ){ 

		String[] item;						
		String[] eStr;		
		String[] eInt;				
		Element e = null;

		if( line != null && line.length() > 0 && line.startsWith("/") ){      

			item = line.split( "[|]" );
			if( dim != item.length  ) 
				throw new RuntimeException( "Verschiedene Dim." +
						" in Parametern und Strom: Item.length=" + 
						item.length + ", lt Par: " + dim ); 

			for( int i = 0; i < item.length; i++ ) 
				clean[i] = item[i].trim();
			eStr = new String[ dimS ];  
			eInt = new String[ dimI ];

			for( int i = 0; i < dimS; i++ ) eStr[i] = clean[i];
			for( int i = 0; i < dimI; i++ ) eInt[i] = clean[ i + dimS ]; 

			e = Element.createElement( eStr, eInt, myParams );
			//System.out.println("Stream : ELEMENT " + e );

		}

		return e;
	}



	public Element readSysElement( String line ){ 


		SysElement e = null;    	    

		if( line != null && line.length() > 0 ){
			
			e = null;
			e = parser.createElement( line );

//			
//			if( line.startsWith("open(") )  
//				e = parser.createSystemCallElement( line, fdTables, myParams );
//			if( line.startsWith("close(") ) 
//				e = SysParser.createSystemCallElement( line, fdTables, myParams );
//			if( line.startsWith("read(") )  
//				e = SysParser.createSystemCallElement( line, fdTables, myParams );
//			if( line.startsWith("write(") ) 
//				e = SysParser.createSystemCallElement( line, fdTables, myParams );
//			if( line.startsWith("gettimeofday(") ) 
//				e = SysParser.createSystemCallElement( line, fdTables, myParams );

			//System.out.println( "StreamReader gelesen : System Call " + e + " aus " + line);
			//if( e != null ) System.out.println( "StreamReader gelesen : System Call " + e);
		}
		return e;
	}

	// Automatisches Bestimmen der Art des Stroms:
	// SystemCalls, einfach (Zahlen oder Pfade), unbekannt
	private int getStreamType( String s ){
		if( s == null || s.trim().equals("") ) return UNKNOWN;
		if( s.startsWith("#") ) return SIMPLE;
		if( s.startsWith("/") ) return SIMPLE;
		if( s.startsWith("|") ) return SIMPLE;
		if( s.startsWith("*") ) return SIMPLE;
		if( s.contains("=") ) 	return SYSCALL;
		return UNKNOWN;
	}

	private String printType( int streamType ){
		String s;
		switch( streamType ){
		case SYSCALL: s = "SYSCALL"; break;
		case SIMPLE:  s = "SIMPLE";  break;
		case UNKNOWN: s = "UNKNOWN"; break;
		default: s = "Undefined";
		}
		return s;
	}
}
