package hitters.multi;

/**
 * @author Peter Fricke
 * 
 */
public class Parameter {
	
	int L = 0;
	
	// Dimensionen, die intern als String dargestellt werden
	int dimS;		

	// Dimensionen, die intern als int dargestellt werden
	int dimI;		
	
	// Bei der internen Darstellung einer Dimension
	// als int werden jeder Hierarchieebenen Bits zugeteilt. 
	// plength gibt diese Bitintervalle an.
	// { {0,3,7,15,23,32} } bedeutet: Eine Dimension
	// wird als int dargestellt, die oberste Ebene erhaelt drei Bit,
	// die naechste vier, die naechsten beiden acht
	// und die letzte neun Bit.
	byte[][] plength;     
	
	// Default: Verwende intern nur Strings, keine ints
	static final byte[][] deflt = { };
	
	// Bitmaske zum Extrahieren der Bits der einzelnen
	// Hierarchieebenen.
	int[][]  mask;      
	
	final int stringCap = 12;
	int seqLength = 5;
	
	private boolean mBug  =  false; // Bug im Pseudocode, siehe Kommentare instantiateDelta
	private boolean bProb =  false; // Bug im Paper S. 29, korrekt im Pseudocode
	private boolean optimizeOutput = false;
//	private Taxonomy taxonomy;
//	private Weights myWeights; 

	String cr = com.rapidminer.tools.Tools.getLineSeparator();
	

	public Parameter(){} 
	
	/**
	 * Erzeugt ein Parameterobjekt. Die Anzahl der Dimensionen
	 * wird auf dimS festgelegt. Die einzelnen Variablen werden
	 * intern als String dargestellt. 
	 * 
	 * @param dimS Anzahl der Dimensionen.
	 */
	public Parameter( int dimS ) {		
		this( dimS, deflt );					
	}
	
	/**
	 * Erzeugt ein Parameterobjekt. 
	 * 
	 * <code>DimS</code> gibt an, wie viele Variablen intern als String dargestellt
	 * werden sollen.
	 * <p>
	 * <code>byte[][] plength</code> legt fr die Variablen, die intern als int
	 * dargestellt werden sollen, die Bits je Hierarchieebene fest.
	 * <p>
	 * Beispiel:<p> 
	 * <code>byte[][] plength = { {0,8,16,24,32} {0,16,32} };</code><p>
	 * legt fest, dass zwei Dimensionen intern als int gespeichert werden, 
	 * die erste dieser Dimensionen mit 8 Bit je Hierarchieebene, 
	 * die zweite mit 16.
	 * <p>
	 * Wer den Code nicht kennt, sollte als interne Darstellung Strings whlen,
	 * dazu gibt es einen Konstruktor mit nur einem Parameter.
	 * 
	 * @param dimS Anzahl der Dimensionen.
	 * @param plength Die Bits je Hierarchieebene fr die interne 
	 * Darstellung als int.
	 */
	public Parameter( int dimS, byte[][] plength ) {	
		this.dimS = dimS;
		this.dimI = plength.length;				
		this.mask = new int[dimI][]; 
		this.plength = new byte[dimI][];

		for( int d = 0; d < dimI; d++ ){			
			mask[d] = new int[ plength[d].length ];
			this.plength[d] = plength[d].clone();
			for( int i = 1; i < mask[d].length; i++ ){ 
				mask[d][i] = 0xFFFFFFFF << ( 32 - plength[d][i] );
				/* log( "Maske in dim " + d + " , i= "1 + i + " : "  );
				System.out.println( " 24 " + ((mask[d][i] & 0xff000000) >>> 24) );
				System.out.println( " 16 " + ((mask[d][i] & 0x00ff0000) >>> 16) );
				System.out.println( "  8 " + ((mask[d][i] & 0x0000ff00) >>>  8) );
				System.out.println( "  0 " + ((mask[d][i] & 0x000000ff)       ) ); */
			}	
		}
				
	}


	/**
	 * @return Anzahl der Dimensionen, die intern als String dargestellt werden.
	 */
	public int getDimS() {
		return dimS;
	}
	

	/**
	 * @return Anzahl der Dimensionen, die intern als int dargestellt werden.
	 */
	public int getDimI() {
		return dimI;
	}


	/**
	 * @return Gesamtanzahl der Dimensionen.
	 */
	public int getDim() {
		return dimI + dimS;
	}

	
	/**
	 * @param dim Dimensionsnummer
	 * @return Hierarchietiefe in Dimension <code>dim</code>
	 */
	public int gethi( int dim ){
		if( dim < dimS ) return stringCap;
		else return plength[dim - dimS].length -1;
	}

	
	/**
	 * Berechnet den Wert <code>L</code>, analog zum Paper ist die
	 * Anzahl der Ebenen im Verband <code>L + 1</code>.
	 * @return <code>L</code>
	 */
	public int getL(){
		if( L == 0 ){			
			for( int i = 0; i < getDim(); i++) L += gethi( i ); 			
		}
		return L;
	}

	
	/**
	 * Nur bei Verwendung der internen Darstellung als int. 
	 *
	 * @param dim Dimensionsnummer
	 * @param index Position im Array plength
	 * @return plength[dim][index];
	 */
	public int getPlength( int dim, int index ) {
		return plength[dim][index];
	}

	
	/**
	 * Nur bei Verwendung der internen Darstellung als int.<p> 
	 * Gibt die Anzahl der Bits an, die in Dimension <code>dim</code>
	 * zur Darstellung der <code>index</code>-ten Hierarchieebene
	 * verwendet werden.
	 *
	 * @param dim Dimensionsnummer
	 * @param index Hierarchieebene
	 * @return Anzahl der verwendeten Bits 
	 */
	public int getWidth( int dim, int index ) {
		return plength[dim][index] - plength[dim][index-1]; 		
	}	
	

	
	public int getMask( int dim, int index ) {
		return mask[dim][index];
	}

	
	public int getMaskLength( int dim ) {
		return mask[dim].length;
	}

	public void setMask(int[][] mask) {
		this.mask = mask;
	}

	public int getStringCap() {
		return stringCap;
	}


	/**
	 * Gibt an, ob der Fehler im Pseudocode in Zeile 14 der Compressmethode 
	 * eingeschaltet ist.
	 * Es wird dann so gerechnet, wie es im Pseudocode steht und gelegentlich
	 * entstehen Fehler. An Testfall resources/testcase/PATest/PA1 lt sich
	 * der Fehler durch Ein- und Ausschalten des Bugs nachvollziehen.

	 * @return <code>true</code>, wenn der Fehler eingeschaltet ist.
	 */
	public boolean mBug() {
		return mBug;
	}


	public boolean bProb() {
		return bProb;
	}

	
	/**
	 * Schaltet den Fehler im Pseudocode in Zeile 14 der Compressmethode ein.
	 * Es wird dann so gerechnet, wie es im Pseudocode steht und gelegentlich
	 * entstehen Fehler. An Testfall resources/testcase/PATest/PA1 lt sich
	 * der Fehler durch Ein- und Ausschalten des Bugs nachvollziehen.
	 * Noch besser geht es ber den XMLPlotter: Kommandozeilenoption 
	 * <code>M</code> schaltet den Bug ein, ohne <code>M</code> 
	 * wird korrekt gerechnet. 
	 * 
	 * Default ist <code>false</code>.
	 * @param mBug Schaltet den Fehler ein, falls <code>true</code>.
	 */
	public void setMBug(boolean mBug) {
		this.mBug = mBug;
	}

	
	public void setBProb(boolean bProb) {
		this.bProb = bProb;
	}

	
	public void setOptimizeOutput(boolean optimizeOutput) {
		this.optimizeOutput = optimizeOutput;
	}


	public boolean optimizeOutput() {
		return optimizeOutput;
	}

	public String toString(){
		String s = "#" + cr + "# Dim = " + (dimI + dimS) + 
		", DimS = " + dimS + ", DimI = " + dimI +
		cr + "# mBug = " + mBug + " bProb = " + bProb + 
		cr + "# OptimizeHp = " + optimizeOutput + cr + "#";
		//		for( int i = 0; i < getDim(); i++){
		//			s = s + " dim " + i + ": Hierarchietiefe " + gethi( i ) + cr + "#"; 			
		//		}		
		return s;
	}

	
	/**
	 * Gives a String representation of the most important parameters,
	 * omits the details. To be used in RapidMiner.
	 * 
	 * @return a String representation of the most important parameters
	 */
	public String toNiceString(){
		String s = cr + "Number of Dimensions: " + (dimI + dimS);
		return s;
	}
	
	
	/**
	 * Berechnet die Gre H des Verbandes.
	 * @return H Gre des Verbandes.
	 */
	public int getH() {
		
		int bigH = 1;
		for( int d = 0; d < getDim(); d++ ){
			bigH *= ( gethi( d ) + 1 );
		}
		return bigH;
	}

	
	
}
