/**
 * 
 */
package hitters.multi;

/**
 * @author Peter Fricke
 * 
 *  Nutzlast eines Eintrags in der HashMap der gefundenen HHHitter.
 * 
 * 	Gespeichert werden die HHH per HashMap, Schlssel ist das 
 * 	multidimensionale Prfix (Element), ber das auch die
 * 	Navigation stattfindet, Wert ist das MultiHitterInfo.
 *
 */
public class MultiHitterInfo implements Comparable<MultiHitterInfo>{	

	public int fmin, fmax, F;

	public MultiHitterInfo( int fmin, int fmax ){
		this( fmin, fmax, 0 );
	}


	public MultiHitterInfo( int fmin, int fmax, int F ){		
		this.fmin = fmin;
		this.fmax = fmax;		
		this.F = F;
	}


	public String toString(){		
		String s = " ( fmin = " + fmin + ", fmax = " + fmax + ", F = " + F + " ) ";
		return s;// + System.getProperty( "line.separator" );
	}

	public String toShortString(){		
		String s = "(" + fmin + ", " + fmax + ", " + F + ")";
		return s;
	}


	public boolean equals( Object o){
		if( ! (o instanceof MultiHitterInfo) ) return false;
		MultiHitterInfo m = (MultiHitterInfo) o;
		return( m.fmin == fmin && m.fmax == fmax && m.F == F );
	}

	public int compareTo(MultiHitterInfo value) {
		int erg = fmin - value.fmin;
		if( erg != 0 ) return erg; else erg = fmax - value.fmax;
		if( erg != 0 ) return erg; else erg = F    - value.F;
		return erg;
	}

}
