/**
 * 
 */
package hitters.multi;

import hitters.tools.LogService;

import java.io.*;
import java.util.*;


/**
 * @author Peter Fricke
 * 
 */
public class MultiDatabase {

	final int HITTER = 1;
	final int NODES  = 2;
	private String filename;
	private FileWriter outData;
	private BufferedWriter out;
	private FileReader inData;
	private BufferedReader in;
	private int N = -1;
	private double phi     = -1;
	private double epsilon = -1;
	private Parameter myParams; 

	public MultiDatabase( String filename, Parameter myParams ){

		if( LogService.shouldLog( LogService.NORMAL ) ) 
			LogService.log(LogService.NORMAL,  "MultiDataBase:" +
					" dimI lt. Par " + myParams.getDimI() +
					" dimS lt Par " + myParams.getDimS() );

		this.filename  = filename;
		this.myParams  = myParams;	
	}


	public Vector<TestCaseInfo> readTestCaseInfo(){		

		int dim = -1;
		int dimS = -1, dimI = -1; 
		int number; 
		String line;
		String[] item;		
		String[] clean;		
		String[] eStr;		
		String[] eInt;		

		Element e;
		Vector<TestCaseInfo> data = new Vector<TestCaseInfo>();

		try{ 			
			while( (line = in.readLine()) != null ){
				if( line.length() > 0 ){		
					if( line.startsWith("#$") ){

						line = line.substring( 2 );
						dimS = Integer.parseInt( line.split("[|]")[0].trim());
						dimI = Integer.parseInt( line.split("[|]")[1].trim());						

						if( dimS != myParams.getDimS() || dimI != myParams.getDimI() ){

							if( LogService.shouldLog( LogService.NORMAL ) )
								LogService.log( LogService.NORMAL, 
										"Dimensionen in Datei entsprechen" +
								" nicht Dimensionen im Parameterobjekt.");

							dimS = myParams.getDimS();
							dimI = myParams.getDimI();							
						}

						dim = dimI + dimS;
					}
					if( line.startsWith("#@") ){						

						if( dim < 1 ) throw new RuntimeException(" Dimensionen" +
						" nicht in Testdatei angegeben oder null.");

						line = line.substring( 2 );						
						item = line.split( "[|]" );

						if( dim != item.length - 1 ) 
							throw new RuntimeException( "Verschiedene Dim." +
							" beim Lesen der Daten." ); 

						clean = new String[ item.length - 1 ];

						for( int i = 0; i < item.length - 1; i++ ) 
							clean[i] = item[i].trim();

						number = Integer.parseInt( item[ item.length - 1].trim() );

						eStr = new String[ dimS ];  
						eInt = new String[ dimI ];

						for( int i = 0; i < dimS; i++ ) eStr[i] = clean[i];
						for( int i = 0; i < dimI; i++ ){
							eInt[i] = clean[ i + dimS ]; 
						}
						e = Element.createElement( eStr, eInt, myParams );
						data.add( new TestCaseInfo( e, number ) );
					}
				}
			}	    
		}		
		catch (java.io.IOException ex) { System.out.println(ex); };	   

		return data;
	}


	public Vector<Element> readElements(){ 

		int dim = -1;
		int dimS = -1, dimI = -1;  
		String line;
		String[] item;		
		String[] clean;		
		String[] eStr;		
		String[] eInt;				
		Element e;
		Vector<Element> data = new Vector<Element>();    	    

		try{ 
			while( (line = in.readLine()) != null ){      
				if( line.length() > 0 ){		
					if( line.startsWith("#$") ){

						line = line.substring( 2 );
						dimS = Integer.parseInt( line.split("[|]")[0].trim());
						dimI = Integer.parseInt( line.split("[|]")[1].trim());						

						if( dimS != myParams.getDimS() || dimI != myParams.getDimI() ){

							if( LogService.shouldLog( LogService.NORMAL ) )
								LogService.log( LogService.NORMAL, 
										"Dimensionen in Datei entsprechen " +
								"nicht Dimensionen im Parameterobjekt.");

							dimS = myParams.getDimS();
							dimI = myParams.getDimI();							
						}

						dim = dimI + dimS;
					}
					if( line.startsWith("/") ){						

						if( dim < 1 ) throw new RuntimeException( "Dimensionen " +
						"nicht in Datei angegeben oder null.");

						item = line.split( "[|]" );
						if( dim != item.length  ) 
							throw new RuntimeException( "Verschiedene Dim." +
							" beim Lesen der Daten." ); 

						clean = new String[ item.length ];
						for( int i = 0; i < item.length; i++ ) clean[i] = item[i].trim();
						eStr = new String[ dimS ];  
						eInt = new String[ dimI ];

						for( int i = 0; i < dimS; i++ ) eStr[i] = clean[i];
						for( int i = 0; i < dimI; i++ ) eInt[i] = clean[ i + dimS ]; 

						e = Element.createElement( eStr, eInt, myParams );
						data.add( e.clone() );
					}
				}
			}
		}		
		catch (java.io.IOException ex) {};	   

		return data;
	}
	

	public Vector<Element> readSystemCalls(){ 

		String line;
		SysElement e = null;
		Vector<Element> data = new Vector<Element>();
		
		if( ! (myParams instanceof SysParameter) )
			throw new RuntimeException( "System Calls lesen nur" +
					" mit Parameterobjekt vom Typ SysParameter." );
		
		SysParameter sysPar = (SysParameter) myParams;
		
		SysParser parser = new SysParser( sysPar );
		
		try{ 
			while( (line = in.readLine()) != null ){      
				if( line.length() > 0 ){		
	
					if( LogService.shouldLog( LogService.NORMAL ) ) 
						LogService.log(LogService.NORMAL, "DATABASE" +
								" lese : System Call " + line ); 

					e = null;
					e = parser.createElement( line );

					if( e != null ){
						
						if( sysPar.capDepth() ){
							
							e.capHierarchy( sysPar.getCap() );
							
						}
						
						data.add( e );
					}
				}
			}
		}		
		catch (java.io.IOException ex) {};	   

		return data;
	}
	
	
	public boolean openRead(){
		boolean success = true;
		try{ 
			inData = new FileReader(filename);
			in = new BufferedReader(inData);		
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());
			success = false;
		}	    	    
		return success;
	}


	public void closeRead(){	    
		try{
			in.close();
			inData.close();
		}
		catch (java.io.IOException e) {  };	    
	}


	public boolean openWrite(){
		boolean success = true;
		try{ 
			outData = new FileWriter(filename);
			out = new BufferedWriter(outData);
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());
			success = false;
		}
		catch (java.io.IOException e) { success = false; };

		return success;
	}


	public void closeWrite(){	    
		try{
			out.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		};	    
	}


	public void println(String s) {
		try{ 
			out.write( s + System.getProperty("line.separator") );
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());		    	
		}
		catch (java.io.IOException e) { };
	}


	public void reset() {
		closeRead();
		openRead();		
	}


	public double getPhi() {
		if( in != null) reset();
		else openRead();
		if( phi < 0 ) readSolution();
		if( phi < -1E-10 ) throw new RuntimeException("Kann phi nicht lesen");
		closeRead();
		return phi;
	}


	public double getEpsilon() {
		if( in != null) reset();
		else openRead();
		if( epsilon < 0 ) readSolution();

		if( epsilon < -1E-10 ) 
			throw new RuntimeException("Kann epsilon nicht lesen");

		closeRead();
		return epsilon;
	}


	public int getSize() {
		if( in != null ) reset();
		else openRead();
		if( N < 0 ) readSolution();
		if( N < 0 ) throw new RuntimeException("Kann N nicht lesen");
		closeRead();
		return N;
	}


	public HashMap<Element, MultiStringElement> readNodes() {
		HashMap<Element, MultiStringElement> map;
		map = (HashMap<Element, MultiStringElement>) genericReadSolution( NODES );
		return map;
	}


	public HashMap<Element, MultiHitterInfo> readSolution() {
		HashMap<Element, MultiHitterInfo> map;
		map = (HashMap<Element, MultiHitterInfo>) genericReadSolution( HITTER );
		return map;
	}

	
	public static void saveHHH( Set<Element> res, String saveFile, String original,  
			Parameter par, double epsilon, double phi, AlgoType algo ) {
		
		saveHHH( res, saveFile, original, 
				(SysParameter)par, epsilon, phi, algo );
	}
	
	
	public static void saveHHH( Set<Element> res, String saveFile, String original,  
			SysParameter par, double epsilon, double phi, AlgoType algo ) {				

		BufferedWriter out = null;
		saveFile += ".hhh";		
		String cr = System.getProperty("line.sparator");
		cr = com.rapidminer.tools.Tools.getLineSeparator();
		
		try{ 
			out = new BufferedWriter( new FileWriter( saveFile ) );
			
//			out.write( "#" );
//			out.write( cr + "# Date = " + new Date() );
//			out.write( cr + "# Input file = " + original );
//			out.write( cr + "# Dateiname = " + saveFile );
//			out.write( cr + "# Epsilon = " + epsilon );
//			out.write( cr + "# Phi = " + phi );
//			out.write( cr + "# Algo = " + algo );
//			out.write( cr + "" + par.toFullString() );
			out.write( par.dimString() + cr );
//			out.write( cr + cr + cr );
						
			for( Element el : res )
				out.write( el.toShortString() + cr );					
				
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){			
			System.out.print( e.getMessage() );			
		}			
		
		try{		
			out.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}						
	}

	
	public static Set<Element> readHHH( String file ) {				

		Set<Element> res = new HashSet<Element>(); 
							
		BufferedReader in = null;		
		DimType[] dims;
		SysParameter par = null;
		SysParser parser = null;
		SysElement el;
		String line;
		String[] comps;				
		
		try{ 
			in  = new BufferedReader( new FileReader( file + ".hhh" ) );		

			while( (line = in.readLine()) != null && par == null ){      				
				if( line.length() > 0 && line.startsWith( "# Dimensionen = [" ) ){			

					comps = line.split( "\\[|\\]" );
					comps = comps[1].split(",");
					dims = new DimType[comps.length];

					for( int i = 0; i < comps.length; i++ ){
						if( comps[i].trim().equals("PATH") ) dims[i] = DimType.PATH;
						if( comps[i].trim().equals("CALL") ) dims[i] = DimType.CALL;
						if( comps[i].trim().equals("SEQUENCE") ) dims[i] = DimType.SEQUENCE;
						if( comps[i].trim().equals("RETURN") ) dims[i] = DimType.RETURN;						
					}

					par = new SysParameter( dims );
					parser = new SysParser( par );										
				}
			}

			while( (line = in.readLine()) != null ){      					
				if( line.length() > 0 && ( ! line.startsWith("#") ) ){			
					
					el = parser.parseLine( line );					
					
					if( el == null ) {						
						throw new RuntimeException( "readHHH: Can't  " +
								"parse line: " + line );
					}
					else{
						res.add( el );
					}
				}
			}
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){			
			System.out.print( e.getMessage() );			
		}

		try{
			in.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}
				
		return res;
	}


	public static Set<Element> readSpincHHH( String file ) {				

		Set<Element> res = new HashSet<Element>(); 
							
		BufferedReader in = null;		
		DimType[] dims;
		SysParameter par = null;		
		Element el;
		String line, fl;
		String[] comps;
		
		
		try{ 
			in  = new BufferedReader( new FileReader( file + ".hhh" ) );		

			while( (line = in.readLine()) != null && par == null ){      				
				if( line.length() > 0 && line.startsWith( "# Dimensionen = [" ) ){			

					comps = line.split( "\\[|\\]" );
					comps = comps[1].split(",");
					dims = new DimType[comps.length];

					for( int i = 0; i < comps.length; i++ ){
						if( comps[i].trim().equals("PATH") ) dims[i] = DimType.PATH;
						if( comps[i].trim().equals("CALL") ) dims[i] = DimType.CALL;
						if( comps[i].trim().equals("SEQUENCE") ) dims[i] = DimType.SEQUENCE;
						if( comps[i].trim().equals("RETURN") ) dims[i] = DimType.RETURN;						
					}
					
					if( dims.length > 1 && dims[0] != DimType.PATH )
						throw new RuntimeException( "Use PATH only for Spincyk-logs.");

					par = new SysParameter( dims );												
				}
			}

			while( (line = in.readLine()) != null ){      					
				if( line.length() > 0 && ( ! line.startsWith("#") ) ){			
					
					fl = line.trim();
					if( fl.equals("") ) throw new RuntimeException( "readHHH: Can't  " +
							"parse line: " + line );
					if( fl.length() > 1 ) fl = "/" + fl;					
					el = Element.createElement( new String[]{ fl }, par );					
					
					if( el == null ) {						
						throw new RuntimeException( "readHHH: Can't  " +
								"parse line: " + line );
					}
					else{
						res.add( el );
					}
				}
			}
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){			
			System.out.print( e.getMessage() );			
		}

		try{
			in.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}
				
		return res;
	}


	private HashMap genericReadSolution( int type ) {

		HashMap solution = null;
		String marker    = null;

		switch( type ){

		case HITTER:
			marker = "#=";
			solution = new HashMap<Element, MultiHitterInfo>();
			break;

		case NODES:
			marker = "#*";
			solution = new HashMap<Element, MultiStringElement>();
			break;

		}

		int dim = -1;
		int dimS = -1, dimI = -1; 
		String line;
		String[] item;		
		String[] clean;		
		String[] eStr;		
		String[] eInt;		

		Element e;
		int i1, i2, i3;

		try{ 			
			while( (line = in.readLine()) != null ){
				if( line.length() > 0 ){	
					if( line.startsWith("#$") ){

						line = line.substring( 2 );
						dimS = Integer.parseInt( line.split("[|]")[0].trim());
						dimI = Integer.parseInt( line.split("[|]")[1].trim());						

						if( dimS != myParams.getDimS() || dimI != myParams.getDimI() ){
							if( LogService.shouldLog( LogService.NORMAL ) ) 
								LogService.log( LogService.NORMAL, 
										"Dimensionen in Datei entsprechen " +
								"nicht Dimensionen im Parameterobjekt.");

							dimS = myParams.getDimS();
							dimI = myParams.getDimI();							
						}
						dim = dimI + dimS;
					}
					if( line.startsWith("#%") ){

						line 	= line.substring( 2 );
						N 		= Integer.parseInt( line.split("[|]")[0].trim());
						phi 	= Double.parseDouble( line.split("[|]")[1].trim());						
						epsilon = Double.parseDouble( line.split("[|]")[2].trim());
					}
					if( line.startsWith( marker ) ){						

						if( dim < 1 ) throw new RuntimeException("Dimensionen " +
						"nicht in Musterl�sung angegeben oder null.");
						if( phi < -1E10 ) throw new RuntimeException("Phi nicht " +
						"in Musterl�sung angegeben.");
						if( epsilon < -1E10 ) throw new RuntimeException(" Epsilon " +
						"nicht in Musterl�sung angegeben.");

						line = line.substring( 2 );						
						item = line.split( "[|]" );

						if( dim != item.length - 3 ) 
							throw new RuntimeException( "Verschiedene Dim. beim Lesen der Daten." );

						clean = new String[ item.length - 3 ];

						for( int i = 0; i < item.length - 3; i++ ) clean[i] = item[i].trim();
						i1 = Integer.parseInt( item[ item.length - 3 ].trim() );
						i2 = Integer.parseInt( item[ item.length - 2 ].trim() );
						i3 = Integer.parseInt( item[ item.length - 1 ].trim() );

						eStr = new String[ dimS ];  
						eInt = new String[ dimI ];

						for( int i = 0; i < dimS; i++ ) eStr[i] = clean[i];
						for( int i = 0; i < dimI; i++ ){
							eInt[i] = clean[ i + dimS ]; 
						}
						e = Element.createElement( eStr, eInt, myParams );					

						switch( type ){

						case HITTER:							
							solution.put( e, new MultiHitterInfo( i1, i2, i3 ) );
							break;

						case NODES:
							solution.put( e, new MultiStringElement( i1, i2, i3 ) );
							break;

						}						
					}
				}
			}	    
		}		
		catch (java.io.IOException ex) { System.out.println(ex); };	   

		return solution;
	}

}
