/**
 * 
 */
package hitters.multi;

import hitters.tools.LogService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.Map.Entry;


import com.google.common.collect.HashMultiset;

/**
 * @author Peter Fricke
 *	
 *	Testflle von Hand zu entwerfen ist nicht ausreichend,
 *  weil manche Probleme erst bei sehr groen Testfllen
 *  auftreten, darum zustzlich zu der begrenzten Zahl 
 *  von Hand erzeugter Testflle die Mglichkeit, 
 *  synthetische Daten zum Testen zu verwenden und
 *  die Ergebnisse automatisch auf Fehler zu pruefen.
 *  
 *  Natrlich nur zur Ergnzung, denn der Test ist nicht symmetrisch: 
 *  Wenn er keinen Fehler findet, kann trotzdem einer da sein.
 *  
 *  Wenn der Algorithmus auf den synthetischen Daten 
 *  arbeitet, lt sich prfen, ob in den berechneten Ergebnissen
 *  a) 	alle wahren Hufigkeiten zwischen fmin und fmax liegen,
 *  b) 	der Abstand zwischen fmin und fmax zulssig ist,
 *  c)	die einseitige Fehlerschranke fr F eingehalten wird (Ueberpruefung
 *  	anhand der tatschlichen, bekannten Hufigkeiten),
 *  d)  bei einer Uberpruefung der berechneten Hitter mit einer 
 *  	Methode hnlich der Output-Methode Inkonsistenzen auftreten.
 *
 *  
 *  
 *  Zusaetzlich kann die Datenstruktur und die Loesung mit einer
 *  in der Datei gespeicherteten Datenstruktur und Loesung verglichen 
 *  werden, sinnvoll fuer das Vergleichen mehrerer 
 *  Implementierungsvarianten auf demselben Problem.
 * 
 */
public class HitterPolice {

	static Comparator<Map.Entry<Element, MultiStringElement>> nodeComparator =
		new NodeComparator();

	static Comparator<Map.Entry<Element, MultiHitterInfo>> hitterComparator =
		new HitterComparator();


	// Datenstruktur vor Ausgabe mit Datenstruktur laut Datei vergleichen,
	// berechnete HHH mit HHH laut Datei vergleichen.
	public static boolean compareToSolution( String testCase, AbstractComplexHHH partAnc, 
			Parameter myParams, double phiUsed, boolean sysCall ){

		MultiDatabase d = new MultiDatabase( testCase, myParams );

		double phi;
		double epsilon; 			
		double epsUsed = partAnc.getEpsilon();		
		HashMap<Element, MultiHitterInfo> solutionHitters;		
		HashMap<Element, MultiStringElement> nodes;

		if( sysCall ){
			throw new RuntimeException( "compareToSolution fuer " +
			"SysCalls nicht impl." );
		}else{
			d.openRead();
			solutionHitters = d.readSolution();
			phi     		= d.getPhi();
			epsilon 		= d.getEpsilon();
			d.reset();
			nodes			= d.readNodes();
			d.closeRead();
		}

		if( phi < epsilon + 1E-10 ) throw new RuntimeException(
				" Phi < Epsilon, keine gute Idee: phi= " + phi + " eps= " + epsilon );

		if( Math.abs( phi - phiUsed ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Phi-Werte in" +
					" Datei und Methodenaufruf: " + phi + ", " + phiUsed );

		if( Math.abs( epsilon - epsUsed ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Epsilon-Werte" +
			" in Datei und partAnc");

		// Hittermengen sortieren
		HashMap<Element, MultiHitterInfo> partAncHitters = partAnc.outputSet( phi );				
		ArrayList<Map.Entry<Element, MultiHitterInfo>> paHitterList = 
			new ArrayList<Map.Entry<Element, MultiHitterInfo>>(partAncHitters.entrySet());
		ArrayList<Map.Entry<Element, MultiHitterInfo>> solHitterList = 
			new ArrayList<Map.Entry<Element, MultiHitterInfo>>(solutionHitters.entrySet());
		Collections.sort( paHitterList, hitterComparator );		
		Collections.sort( solHitterList, hitterComparator );	

		// Knoten der Datenstruktur sortieren		
		List<Map.Entry<Element, MultiStringElement>> paNodes = partAnc.dumpTrie();
		ArrayList<Map.Entry<Element, MultiStringElement>> fileNodes = 
			new ArrayList<Map.Entry<Element, MultiStringElement>>(nodes.entrySet());		
		Collections.sort( paNodes, nodeComparator );		
		Collections.sort( fileNodes, nodeComparator );	

		if( LogService.shouldLog( LogService.COMPARE ) ){


			LogService.log( LogService.COMPARE, "\nDatenstruktur berechnet: " );				

			for( Entry<Element, MultiStringElement> entr : paNodes )	 
				LogService.log( LogService.COMPARE, entr );					

			LogService.log( LogService.COMPARE, "\nApproximative Hitter: ");

			for( Entry<Element, MultiHitterInfo> entr : paHitterList )
				LogService.log( LogService.COMPARE, entr );					

			LogService.log(LogService.COMPARE,  
					"Approximative Hitter: Anzahl= " + partAncHitters.size() );
			LogService.log(LogService.COMPARE, 
			" \n ************************************** \n " );
			LogService.log( LogService.COMPARE, 
			"\nDatenstruktur gelesen: " );				

			for( Entry<Element, MultiStringElement> entr : fileNodes )
				LogService.log( LogService.COMPARE, entr );					

			LogService.log( LogService.COMPARE, "\nSolutionHitters: " );
			for( Entry<Element, MultiHitterInfo> entr : solHitterList )
				LogService.log( LogService.COMPARE, entr );					

			LogService.log(LogService.COMPARE,  
					"solutionHitters: Anzahl= " + solutionHitters.size() );		
			LogService.log(LogService.COMPARE, 
					"Loesungen gleich: " + solutionHitters.equals( partAncHitters ) );
			LogService.log(LogService.COMPARE, 
			"Datenstrukturen gleich: " );
			LogService.log(LogService.COMPARE, 
					fileNodes.containsAll( paNodes ) && paNodes.containsAll( fileNodes ) );
		}

		boolean datenGleich = 
			fileNodes.containsAll( paNodes ) && paNodes.containsAll( fileNodes );
		if( ! datenGleich ) 
			if( LogService.shouldLog( LogService.COMPARE ) ) 
				LogService.log(LogService.COMPARE, " Berechnete Datenstruktur"+
				" entspricht nicht der Datenstruktur laut Datei.");

		boolean hitterGleich = solutionHitters.equals( partAncHitters );
		if( ! hitterGleich ) 
			if( LogService.shouldLog( LogService.COMPARE ) ) 
				LogService.log(LogService.COMPARE, " Berechnete HHH"+
				" entsprechen nicht den HHH laut Datei.");

		return (datenGleich && hitterGleich);
	}



	// Auf Inkonsistenzen, Definition und Verletzung der 
	// Fehlerschranken pruefen
	public static boolean check( String testCase, AbstractComplexHHH partAnc, 
			Parameter myParams, double phiUsed, boolean sysCall ){

		boolean correct = true;
		MultiDatabase d = new MultiDatabase( testCase, myParams );

		int trueCount   = 0;		

		Vector<Element> data;		
		int N;		
		double phi;
		double epsilon; 			
		double epsUsed = partAnc.getEpsilon();		

		if( sysCall ){
			d.openRead();
			data    = d.readSystemCalls();
			N       = data.size();
			phi     = phiUsed;
			epsilon = epsUsed;
		}else{
			d.openRead();
			data    = d.readElements();
			d.reset();
			N       = d.getSize();
			phi     = d.getPhi();
			epsilon = d.getEpsilon();
		}

		if( N != data.size() ) throw new RuntimeException( "Falscher" +
				" N-Wert in Datei: " + N + ". Tats.: " + data.size() );

		if( phi < epsilon + 1E-10 ) throw new RuntimeException(
				" Phi < Epsilon, keine gute Idee: phi= " + phi + " eps= " + epsilon );

		if( Math.abs( phi - phiUsed ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Phi-Werte in" +
					" Datei und Methodenaufruf: " + phi + ", " + phiUsed );

		if( Math.abs( epsilon - epsUsed ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Epsilon-Werte" +
			" in Datei und partAnc");

		if( LogService.shouldLog( LogService.NORMAL ) ) 
			LogService.log( LogService.NORMAL, "Trie: " + partAnc.dumpTrie() );


		// Wahre Hufigkeiten zhlen
		HashMultiset<Element> prefixSet  = HashMultiset.create(); 
		HashMultiset<Element> elementSet = HashMultiset.create();
		Element a = new Element( myParams );
		Element b = new Element( myParams );
		int lim0, lim1;

		// Alle Generalisierungen ebenfalls zhlen
		for( Element e : data ){
			a.setTo(e);				
			elementSet.add( a.clone() );
			lim0 = a.getLevel(0);
			lim1 = a.getLevel(1);
			for( int i = 0; i <= lim0; i++ ){
				if( i > 0 ) a.turnIntoParent(0);			
				b.setTo( a );
				for( int j = 0; j <= lim1; j++ ){
					if( j > 0 ) b.turnIntoParent(1);					
					prefixSet.add( b.clone() );					
				}
			}			
		}


		HashMap<Element, MultiHitterInfo> partAncHitters;
		HashMap<Element, Integer> F;
		HashMap<Element, Integer> estF = partAnc.dumpF( phi );		
		double marg;			
		MultiHitterInfo mhi;					
		Element p;
		boolean block;

		int limit = 1;
		double phiNow;
		for( int round = 0; round < limit; round++ ){

			phiNow = epsilon + ( round + 1 + limit ) * (phi - epsilon) / ( 2 * limit );		
			partAncHitters = partAnc.outputSet( phiNow );
			marg = partAnc.getEpsilon() * partAnc.getN();					

			if( LogService.shouldLog( LogService.OUTPUTHHH ) ) 
				LogService.log( LogService.OUTPUTHHH, "Approximative Hitter: ");
			for( Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet() ){
				if( LogService.shouldLog( LogService.OUTPUTHHH ) ) 
					LogService.log( LogService.OUTPUTHHH, entr );					
			}
			if( LogService.shouldLog( LogService.OUTPUTHHH ) ) 
				LogService.log( LogService.OUTPUTHHH, "phiNow= " + phiNow +
						" Approximative Hitter: Anzahl= " +
						partAncHitters.size() );


			////////////////////////////////////

			// Fall a + b)		
			for( Element elem : partAncHitters.keySet() ){
				trueCount = prefixSet.count( elem );
				mhi = partAncHitters.get( elem );
				if( trueCount < mhi.fmin ){
					correct = false;			// Fall a)

					System.out.println( "Zu gro: Element: " + elem + " hat" +
							" TrueCount " + trueCount + " aber fmin=" + 
							mhi.fmin + " und fmax =" + mhi.fmax );
				}
				if( trueCount > mhi.fmax ){
					correct = false;			// Fall a)
					System.out.println( "Zu klein: Element: " + elem + " hat" +
							" TrueCount " + trueCount + " aber fmin=" +
							mhi.fmin + " und fmax =" + mhi.fmax );
				}
				if( mhi.fmax - mhi.fmin > 2 * marg ){
					correct = false;			// Fall b)
					System.out.println( "Spanne: Element: " + elem + " hat" +
							" 2 * marg " + (2 * marg) + " aber fmin=" +
							mhi.fmin + " und fmax =" + mhi.fmax );				
				}

				// F > fmax ist kein Bug, sondern Ergebnis der fehlenden Schranken
				// fr den Fehler von F. Die Schtzung der diskontierten
				// Haeufigkeiten kann sehr schlecht werden, im Extremfall
				// kann sie die fehlerbeschraenkte Schtzung der absoluten 
				// Haeufigkeiten uebersteigen.
				// Hershberger et al. (2005) zeigen, dass jeder Algorithmus, der
				// Fehlerschranken fuer die diskontierten Haeufigkeiten angeben soll,
				// omega( 1 / phi ^ (dim+1) ) Platz benoetigt.
				//
				// Siehe Ffmax.pdf fuer ein Beispiel.
				//
				//				if( mhi.fmax < mhi.F ){				
				//					System.out.println( "fmax < F: Element: " + elem + " hat" +
				//							" fmax " + mhi.fmax + " aber F=" +
				//							mhi.F );				
				//				}
				//				int delta = (mhi.fmax - mhi.fmin) / 2;
				//				if( ( mhi.fmax < mhi.F + delta ) && ( mhi.fmax < ( phiNow * N ) ) ){
				//					correct = false;// Damit ich benachrichtigt werde
				//					System.out.println( "Interessant: fmax < F: Element: " + elem + 
				//							" delta= " + delta + " fmin und  phiNow * N = " + ( phiNow * N ) + 
				//							" fmin " + mhi.fmin + " fmax " + mhi.fmax + " sowie F=" +	mhi.F );				
				//				}

			}

			if( LogService.shouldLog( LogService.NORMAL ) ) 
				LogService.log( LogService.NORMAL, "Nach ab) - " +
						"alles korrekt: " + correct );


			///////////////////////////////////////

			// Fall c) und d)

			F = new HashMap<Element, Integer>();
			int[] label = new int[ myParams.getDim() ];
			if( myParams.getDim() != 2 ) throw new RuntimeException("Hitterpolice:" +
			" Dimension muss 2 sein.");
			int estFint;

			p = new Element( myParams );				

			for( Element e : elementSet.elementSet() ) F.put( e, 0 );

			//Fr alle Ebenen
			for( int l = myParams.getL(); l >= 0; l-- ){

				//Fr alle Label aus level(l)
				lloop: for( int i = 0; i <= l; i++ ){ //Zweidim Fall, TODO: Flexibilisieren
					label[0] = i;
					label[1] = l-i;
					if( label[0] > myParams.gethi(0) ||	label[1] > myParams.gethi(1) )
						continue lloop;

					if( LogService.shouldLog( LogService.POLICE ) ) 
						LogService.log(LogService.POLICE, " ***Police Label: " +
								"["+label[0]+","+label[1]+"] ***");

					//Fr alle e, HIER nur aus der untersten Ebene!								
					for( Element e : elementSet.elementSet() ){
						if( LogService.shouldLog( LogService.POLICE ) ) 
							LogService.log(LogService.POLICE,  "Berabeite nun " + e);						
						p.setTo( e );						

						// Wenn generalisierbar, tu es
						if( p.generalizeTo( label ) == true ){ 
							block = false;
							 // HIER fr die zu prfenden HHH
							for( Element h : partAncHitters.keySet() ){   

								// Bedingungen fuer Block
								if( h.getL() > l &&				 //Redundant
										h.isGenOf( e ) &&
										p.isGenOf(h) )//Abdeck-Def-Prob Cormode04 
									block = true;

								if( h.equals( p ) ) block = true;
							}
							if( ! block ){						
								if( ! F.containsKey( p ) ) 
									F.put( p.clone(), elementSet.count(e) ); 
								else 
									F.put( p.clone() , F.get( p ) + elementSet.count(e) );			
								if( LogService.shouldLog( LogService.POLICE ) ) 
									LogService.log( LogService.POLICE, "Police: " +
											"Addiere " + elementSet.count(e) + " zu F " +
											"fr p="+ p + " wegen " + e );					
							}
						}						
					}		
				}

			if( LogService.shouldLog( LogService.POLICE ) ) 
				LogService.log( LogService.POLICE, "\nEbene beendet: " + l);			

			for( Element e : F.keySet() ){							
				if( e.getL() == l ){ 

					if( F.get( e ) >= phiNow * N ){
						correct = false;
						MultiHitterInfo h = 
							new MultiHitterInfo( prefixSet.count(e), 
									prefixSet.count(e), F.get(e) );																		
						System.out.println("htte ausgegeben werden mssen: " + e + 
								" mit h=" + h  + 
								" wegen phiNow * N =" + (phiNow * N) + " F="+F.get( e ) );						 
					}
					else{
						if( estF.get(e) == null ) estFint = 0;
						else estFint = estF.get(e); 
						if( F.get( e ) > estFint + partAnc.instantiateDelta(e) ){
							correct = false;
							System.out.println("N=" + N + " Schaetzung F zu niedrig");
							MultiHitterInfo h = 
								new MultiHitterInfo( prefixSet.count(e), 
										prefixSet.count(e), F.get(e) );																		
							System.out.println("zu niedrig: " + e + "  " + h +
									" mit delta=" + partAnc.instantiateDelta(e) + 
									" gesch F= " + estF.get( e ) );

						}

					}
				}
			}
			}
			if( LogService.shouldLog( LogService.POLICE ) ) 
				LogService.log( LogService.POLICE, "Nach e)  " +
						"correct = " + correct );

			if( ! correct ) {
				System.out.println("\n\ngefunden Approximative Hitter: ");

				for( Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet() ){
					System.out.println(" gefunden " +entr );					
				}
				System.out.println("gefunden phiNow= " + phiNow + 
						" Approximative Hitter: Anzahl= " +
						partAncHitters.size() );
			}

		}

		return correct;		
	}

	
	
	
	//Hack zum besseren Vergleichen der neuen, sauberen Implementierung
	//mit der alten getesteten. Unterscheidet sich von der anderen clean Methode
	//nur im Typ der Hitteralgos.
	//
	// KANN GELSCHT WERDEN, SOBALD INTEGRATION DES NEUEN ALGOS FERTIG
	//
	// Fuers Testen vorerst behalten, obwohl Integration erfolgt.
	//
	public static boolean check( String testCase, OLD_AbstractComplexHHH partAnc, 
			Parameter myParams, double phiUsed, boolean sysCall ){

		boolean correct = true;
		MultiDatabase d = new MultiDatabase( testCase, myParams );

		int trueCount   = 0;		

		Vector<Element> data;		
		int N;		
		double phi;
		double epsilon; 			
		double epsUsed = partAnc.getEpsilon();		

		if( sysCall ){
			d.openRead();
			data    = d.readSystemCalls();
			N       = data.size();
			phi     = phiUsed;
			epsilon = epsUsed;
		}else{
			d.openRead();
			data    = d.readElements();
			d.reset();
			N       = d.getSize();
			phi     = d.getPhi();
			epsilon = d.getEpsilon();
		}

		if( N != data.size() ) throw new RuntimeException( "Falscher" +
				" N-Wert in Datei: " + N + ". Tats.: " + data.size() );

		if( phi < epsilon + 1E-10 ) throw new RuntimeException(
				" Phi < Epsilon, keine gute Idee: phi= " + phi + " eps= " + epsilon );

		if( Math.abs( phi - phiUsed ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Phi-Werte in" +
					" Datei und Methodenaufruf: " + phi + ", " + phiUsed );

		if( Math.abs( epsilon - epsUsed ) > 1E-10 ) 
			throw new RuntimeException( "Verschiedene Epsilon-Werte" +
			" in Datei und partAnc");

		if( LogService.shouldLog( LogService.NORMAL ) ) 
			LogService.log( LogService.NORMAL, "Trie: " + partAnc.dumpTrie() );


		// Wahre Hufigkeiten zhlen
		HashMultiset<Element> prefixSet  = HashMultiset.create(); 
		HashMultiset<Element> elementSet = HashMultiset.create();
		Element a = new Element( myParams );
		Element b = new Element( myParams );
		int lim0, lim1;

		// Alle Generalisierungen ebenfalls zhlen
		for( Element e : data ){
			a.setTo(e);				
			elementSet.add( a.clone() );
			lim0 = a.getLevel(0);
			lim1 = a.getLevel(1);
			for( int i = 0; i <= lim0; i++ ){
				if( i > 0 ) a.turnIntoParent(0);			
				b.setTo( a );
				for( int j = 0; j <= lim1; j++ ){
					if( j > 0 ) b.turnIntoParent(1);					
					prefixSet.add( b.clone() );					
				}
			}			
		}


		HashMap<Element, MultiHitterInfo> partAncHitters;
		HashMap<Element, Integer> F;
		HashMap<Element, Integer> estF = partAnc.dumpF( phi );		
		double marg;			
		MultiHitterInfo mhi;					
		Element p;
		boolean block;

		int limit = 1;
		double phiNow;
		for( int round = 0; round < limit; round++ ){

			phiNow = epsilon + ( round + 1 + limit ) * (phi - epsilon) / ( 2 * limit );		
			partAncHitters = partAnc.outputSet( phiNow );
			marg = partAnc.getEpsilon() * partAnc.getN();					

			if( LogService.shouldLog( LogService.OUTPUTHHH ) ) 
				LogService.log( LogService.OUTPUTHHH, "Approximative Hitter: ");
			for( Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet() ){
				if( LogService.shouldLog( LogService.OUTPUTHHH ) ) 
					LogService.log( LogService.OUTPUTHHH, entr );					
			}
			if( LogService.shouldLog( LogService.OUTPUTHHH ) ) 
				LogService.log( LogService.OUTPUTHHH, "phiNow= " + phiNow +
						" Approximative Hitter: Anzahl= " +
						partAncHitters.size() );


			////////////////////////////////////

			// Fall a + b)		
			for( Element elem : partAncHitters.keySet() ){
				trueCount = prefixSet.count( elem );
				mhi = partAncHitters.get( elem );
				if( trueCount < mhi.fmin ){
					correct = false;			// Fall a)

					System.out.println( "Zu gro: Element: " + elem + " hat" +
							" TrueCount " + trueCount + " aber fmin=" + 
							mhi.fmin + " und fmax =" + mhi.fmax );
				}
				if( trueCount > mhi.fmax ){
					correct = false;			// Fall a)
					System.out.println( "Zu klein: Element: " + elem + " hat" +
							" TrueCount " + trueCount + " aber fmin=" +
							mhi.fmin + " und fmax =" + mhi.fmax );
				}
				if( mhi.fmax - mhi.fmin > 2 * marg ){
					correct = false;			// Fall b)
					System.out.println( "Spanne: Element: " + elem + " hat" +
							" 2 * marg " + (2 * marg) + " aber fmin=" +
							mhi.fmin + " und fmax =" + mhi.fmax );				
				}

				// F > fmax ist kein Bug, sondern Ergebnis der fehlenden Schranken
				// fr den Fehler von F. Die Schtzung der diskontierten
				// Haeufigkeiten kann sehr schlecht werden, im Extremfall
				// kann sie die fehlerbeschraenkte Schtzung der absoluten 
				// Haeufigkeiten uebersteigen.
				// Hershberger et al. (2005) zeigen, dass jeder Algorithmus, der
				// Fehlerschranken fuer die diskontierten Haeufigkeiten angeben soll,
				// omega( 1 / phi ^ (dim+1) ) Platz benoetigt.
				//
				// Siehe Ffmax.pdf fuer ein Beispiel.
				//
				//				if( mhi.fmax < mhi.F ){				
				//					System.out.println( "fmax < F: Element: " + elem + " hat" +
				//							" fmax " + mhi.fmax + " aber F=" +
				//							mhi.F );				
				//				}
				//				int delta = (mhi.fmax - mhi.fmin) / 2;
				//				if( ( mhi.fmax < mhi.F + delta ) && ( mhi.fmax < ( phiNow * N ) ) ){
				//					correct = false;// Damit ich benachrichtigt werde
				//					System.out.println( "Interessant: fmax < F: Element: " + elem + 
				//							" delta= " + delta + " fmin und  phiNow * N = " + ( phiNow * N ) + 
				//							" fmin " + mhi.fmin + " fmax " + mhi.fmax + " sowie F=" +	mhi.F );				
				//				}

			}

			if( LogService.shouldLog( LogService.NORMAL ) ) 
				LogService.log( LogService.NORMAL, "Nach ab) - " +
						"alles korrekt: " + correct );


			///////////////////////////////////////

			// Fall c) und d)

			F = new HashMap<Element, Integer>();
			int[] label = new int[ myParams.getDim() ];
			if( myParams.getDim() != 2 ) throw new RuntimeException("Hitterpolice:" +
			" Dimension muss 2 sein.");
			int estFint;

			p = new Element( myParams );				

			for( Element e : elementSet.elementSet() ) F.put( e, 0 );

			//Fr alle Ebenen
			for( int l = myParams.getL(); l >= 0; l-- ){

				//Fr alle Label aus level(l)
				lloop: for( int i = 0; i <= l; i++ ){ //Zweidim Fall, TODO: Flexibilisieren
					label[0] = i;
					label[1] = l-i;
					if( label[0] > myParams.gethi(0) ||	label[1] > myParams.gethi(1) )
						continue lloop;

					if( LogService.shouldLog( LogService.POLICE ) ) 
						LogService.log(LogService.POLICE, " ***Police Label: " +
								"["+label[0]+","+label[1]+"] ***");

					//Fr alle e, HIER nur aus der untersten Ebene!								
					for( Element e : elementSet.elementSet() ){
						if( LogService.shouldLog( LogService.POLICE ) ) 
							LogService.log(LogService.POLICE,  "Berabeite nun " + e);						
						p.setTo( e );						

						// Wenn generalisierbar, tu es
						if( p.generalizeTo( label ) == true ){ 
							block = false;
							 // HIER fr die zu prfenden HHH
							for( Element h : partAncHitters.keySet() ){   

								// Bedingungen fuer Block
								if( h.getL() > l &&				 //Redundant
										h.isGenOf( e ) &&
										p.isGenOf(h) )//Abdeck-Def-Prob Cormode04 
									block = true;

								if( h.equals( p ) ) block = true;
							}
							if( ! block ){						
								if( ! F.containsKey( p ) ) 
									F.put( p.clone(), elementSet.count(e) ); 
								else 
									F.put( p.clone() , F.get( p ) + elementSet.count(e) );			
								if( LogService.shouldLog( LogService.POLICE ) ) 
									LogService.log( LogService.POLICE, "Police: " +
											"Addiere " + elementSet.count(e) + " zu F " +
											"fr p="+ p + " wegen " + e );					
							}
						}						
					}		
				}

			if( LogService.shouldLog( LogService.POLICE ) ) 
				LogService.log( LogService.POLICE, "\nEbene beendet: " + l);			

			for( Element e : F.keySet() ){							
				if( e.getL() == l ){ 

					if( F.get( e ) >= phiNow * N ){
						correct = false;
						MultiHitterInfo h = 
							new MultiHitterInfo( prefixSet.count(e), 
									prefixSet.count(e), F.get(e) );																		
						System.out.println("htte ausgegeben werden mssen: " + e + 
								" mit h=" + h  + 
								" wegen phiNow * N =" + (phiNow * N) + " F="+F.get( e ) );						 
					}
					else{
						if( estF.get(e) == null ) estFint = 0;
						else estFint = estF.get(e); 
						if( F.get( e ) > estFint + partAnc.instantiateDelta(e) ){
							correct = false;
							System.out.println("N=" + N + " Schaetzung F zu niedrig");
							MultiHitterInfo h = 
								new MultiHitterInfo( prefixSet.count(e), 
										prefixSet.count(e), F.get(e) );																		
							System.out.println("zu niedrig: " + e + "  " + h +
									" mit delta=" + partAnc.instantiateDelta(e) + 
									" gesch F= " + estF.get( e ) );

						}

					}
				}
			}
			}
			if( LogService.shouldLog( LogService.POLICE ) ) 
				LogService.log( LogService.POLICE, "Nach e)  " +
						"correct = " + correct );

			if( ! correct ) {
				System.out.println("\n\ngefunden Approximative Hitter: ");

				for( Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet() ){
					System.out.println(" gefunden " +entr );					
				}
				System.out.println("gefunden phiNow= " + phiNow + 
						" Approximative Hitter: Anzahl= " +
						partAncHitters.size() );
			}

		}

		return correct;		
	}

}
