/**
 * @author Peter Fricke
 */
package hitters.multi;

import hitters.tools.LogService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author Peter Fricke
 *
 */
public abstract class AbstractHHH{

	Parameter par;
	int N          = 0;
	int tupelCount = 0;
	int maxTupel   = 0;	


	public AbstractHHH( Parameter myParams ){

		this.par = myParams;

//		if( myParams.getDim() != 2 ) throw new RuntimeException("Nur 2" +
//		" dim durchgngig implementiert.");

		if( LogService.shouldLog( LogService.NORMAL ) ) 
			LogService.log( LogService.NORMAL, 
					"AbstractHHH: DimI = " + myParams.getDimI() +
					" Dims = " + myParams.getDimS() + 
					" Dim = " + myParams.getDim() + 
					" und myParams.getL() +1 " +  
					(myParams.getL() +1) );		
	}


	// Berechnet die Menge der undominierten HHH unterhalb eines Labels.
	// Erlaubt schnelleren Output durch Reduzieren der
	// Menge der HHH, die fuer das Diskontieren berhaupt 
	// geprft werden mssen.
	Set<Element> trimHitters( 
			Set<Element> fullHitters, int[] label ){
		
		boolean blocked = false;
		HashSet<Element> temp =	new HashSet<Element>();
		HashSet<Element> trim =	new HashSet<Element>();
		
		// Nur Nachfahren von Elementen des Labels
		for( Element h : fullHitters ){
			if( h.isBelowLabel( label ) ) temp.add(h);
		}
		
		// Nur undominierte HHH
		for( Element h : temp ){
			blocked = false;
			for( Element other : temp ){
				if( other.isGenOf(h) == true && other.equals(h) == false )
					blocked = true;
			}
			if( ! blocked ) trim.add(h);
		}
		
		return trim;
	}

	
	public List<int[]> calcLabels( int level ){
		
		int dim = par.getDim();
		int[] label = new int[dim];
		List<int[]> list = new ArrayList<int[]>();		
		
		switch( dim ){

		case 1:
			label = new int[dim];
			label[0] = level;		
			list.add( label );
			break;
		case 2:
			int imin2 = Math.max(0, level - par.gethi(1));
			for( int i = imin2; i <= Math.min(par.gethi(0), level); i++){
				label = new int[dim];
				label[0] = i;
				label[1] = level - label[0];
				list.add( label );
			}
				break;
		case 3:
			int imin3 = Math.max(0, level - par.gethi(1) - par.gethi(2));										
			for( int i = imin3; i <= Math.min(par.gethi(0), level); i++){
				int iminj3 = Math.max(0, level - i - par.gethi(2));
				for( int j = iminj3; j <= Math.min(par.gethi(1), level - i); j++){
					label = new int[dim];
					label[0] = i;
					label[1] = j;
					label[2] = level - i - j;
					list.add( label );
				}
			}
			break;

		case 4:
			int imini = Math.max(0, level - par.gethi(1) - par.gethi(2) - par.gethi(3));						
			for( int i = imini; i <= Math.min(par.gethi(0), level); i++){
				int iminj = Math.max(0, level - i - par.gethi(2) - par.gethi(3) );
				for( int j = iminj; j <= Math.min(par.gethi(1), level - i); j++){
					int imink = Math.max(0, level - i - j - par.gethi(3) );
					for( int k = imink; k <= Math.min(par.gethi(2), level - i - j); k++){
						label = new int[dim];
						label[0] = i;
						label[1] = j;
						label[2] = k;
						label[3] = level - i - j - k;
						list.add( label );
					}
				}
			}
			break;
		
		default: throw new RuntimeException( "Dimension nicht implementiert." );
		}
		
		return list;
	}


	public void insert(Element e, int count){
		insert( e, count, true );
	}
	
	public abstract void insert(Element e, int count, boolean increase);

	public abstract HashMap<Element, MultiHitterInfo> outputSet(double phi);	

	// Zum Loggen der absoluten und diskontierten Haeufigkeiten
	public abstract HashMap<Element, MultiHitterInfo> outputSet(double phi, boolean log);

	public abstract HashMap<Element, Integer> dumpf();

	public abstract HashMap<Element, Integer> dumpF(double phi);

	public abstract int instantiateDelta(Element e);

	public int getN() { return N; }

	public int getTupelCount() { return tupelCount; }

	public int getMaxTupelCount() { return Math.max( maxTupel, tupelCount ); }

	public Parameter getParameter() { return par; }

}
