package com.rapidminer.operator.preprocessing.hhhitter;

import hitters.multi.DimType;
import hitters.multi.SysParameter;
import hitters.tools.Utils;

import java.util.HashSet;
import java.util.List;

import com.google.common.collect.HashMultiset;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueString;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;

/**
 * 
 * This operator calculates the histogram of system calls for each Example in
 * the given ExampleSet and returns an ExampleSet containing these histograms.
 * 
 * @author Peter Fricke 
 * @version $Id$
 *  
 */
public class HistoExtraction extends Operator {
	
	String callString = "";
	
	/** Creates a new HistoExtraction operator. */
	public HistoExtraction(OperatorDescription description) {
		super(description);

		addValue( new ValueString("UsedCalls", "The systemcalls that are used, all other calls are ignored."){
			public String getStringValue(){
				return callString;
			}
		});
		
	}


	public IOObject[] apply() throws OperatorException {
				
		LogService logService = LogService.getGlobal();
		logService.setVerbosityLevel( LogService.STATUS );		
		logService.log( "Start apply   ", LogService.STATUS );		
		
		ExampleSet exampleSet = getInput( ExampleSet.class );
		ExampleSet clone = (ExampleSet) exampleSet.clone();
		clone.recalculateAllAttributeStatistics();
		
		ParameterWrapper pw = new ParameterWrapper();		
		DimType[] dims = { DimType.PATH };
		pw.par = new SysParameter( dims );		
		
		HashSet<String> calls = new HashSet<String>(); 				
		
		for( Attribute attr : clone.getAttributes() ){
			calls.add(attr.getName());
		}
		
		callString = makeString( calls );
		
		logService.log( "" + calls, LogService.STATUS );
		pw.par.setUsedCalls(calls);
		
		HashMultiset<String> globalSet = HashMultiset.create();
		
		for (Example example : clone) {
		
			checkForStop();
			HashMultiset<String> set = calcHisto( example, pw );	
			globalSet.addAll( set );
			
			double count = 0.0;
			double d;

			//Sum counts or the selected attributes only
			for( Attribute a : example.getAttributes() ){
				count += set.count( a.getName() );
			}
			
			System.out.println( "count = " + count );
			
			for( Attribute a : example.getAttributes() ){
				
				d = set.count( a.getName() );
				//System.out.println( a.getName() + " " + d + " " + (d/count) );			
				example.setValue(a, d / count );
			}			
		}

		double count = 0.0;
		double d;
		Example example = clone.getExample(0);
		for( Attribute a : example.getAttributes() ){		
			d = globalSet.count( a.getName() );
			System.out.println( a.getName() + ";" + d + ";" + (d/count) );						
		}		
		
		return new IOObject[] { clone };
	}


	public Class<?>[] getInputClasses() {
		return new Class[] { ExampleSet.class };
	}

	
	public Class<?>[] getOutputClasses() {
		return new Class[] { ExampleSet.class };
	}
	

	/** Counts the system calls for each logfile in the given Example.
	 */
	public HashMultiset<String> calcHisto( Example example, ParameterWrapper pw ) throws OperatorException{
				
		HashMultiset<String> set = null;
		LogService logService = LogService.getGlobal();
		Attribute idAttribute = example.getAttributes().getSpecial(Attributes.ID_NAME);		
		String id = example.getValueAsString(idAttribute, 3, false);							
				
		logService.log( "Extracting Histo for " + id + "...", LogService.STATUS );
		set = Utils.getHist( id );
		logService.log( "...done." );

		return set;
	}

	
	private String makeString( HashSet<String> calls ){
		String s = "";
		for( String c : calls ) s += ", " + c;
		return s.substring(2);		
	}
	
	
	/** Returns a list with all parameter types of this model. */
	public List<ParameterType> getParameterTypes() {
		
		List<ParameterType> types = super.getParameterTypes();
		return types;
	}
			
}
