/**
 * @author Peter Fricke 
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import hitters.multi.Element;

import java.util.Set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeight;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.example.table.struct.Structures;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

/**
 * @author Peter Fricke 
 *
 */
public abstract class HierarchicalSimilarity extends SimilarityMeasure {

	
	private static final long serialVersionUID = -9162977561294965657L;
	ObjectAttribute<?> hitterAttribute;
	AttributeWeight weight;
	int index = -1;
	
	/* (non-Javadoc)
	 * @see com.rapidminer.tools.math.similarity.DistanceMeasure#calculateDistance(double[], double[])
	 */
	@Override
	public double calculateDistance(double[] value1, double[] value2) {
		//System.out.println( "calculateDistance: value1.length " + value1.length );
		return 1 - calculateSimilarity( value1, value2 );
	}

	/* (non-Javadoc)
	 * @see com.rapidminer.tools.math.similarity.DistanceMeasure#calculateSimilarity(double[], double[])
	 */
	@SuppressWarnings("unchecked")
	@Override
	public double calculateSimilarity(double[] value1, double[] value2) {

//		System.out.println( "calculateSimilarity: " + Arrays.toString(value1) + "   " + Arrays.toString(value2) );
		//System.out.println( "calculateSimilarity: " + value1.length );
		if( hitterAttribute == null ) 
			throw new RuntimeException("No hitterAttribute was stored during init");

		Set<Element> hhh1, hhh2;
		int index1 = new Double( value1[index] ).intValue();
		int index2 = new Double( value2[index] ).intValue();
		hhh1 = (Set<Element>) hitterAttribute.getMapping().mapObjectIndex( index1 );
		hhh2 = (Set<Element>) hitterAttribute.getMapping().mapObjectIndex( index2 );
		
		if( hhh1.size() == 0 || hhh2.size() == 0 ) return 0;
		//System.out.println( calculateSimilarity( hhh1, hhh2 ) );
		return calculateSimilarity( hhh1, hhh2 );
	}

	
	/* (non-Javadoc)
	 * @see com.rapidminer.tools.math.similarity.DistanceMeasure#init(com.rapidminer.example.ExampleSet)
	 */
	@Override
	public void init(ExampleSet exampleSet) throws OperatorException {
		
		int i = 0;
		Attributes attributes = exampleSet.getAttributes();
		//System.out.println( attributes.size() );
		for( Attribute a : attributes ){			
			if( a.getName().equals(Structures.ID_ATTRIBUTE) ){
				
//				System.out.println( "Insinde " + this.getClass().getName() );
//				System.out.println( " ------------------------------------------------------- ");
//				System.out.println( "Name ObjectAttribute = " + ObjectAttribute.class.getName() );
//				System.out.println( "Package ObjectAttribute = " + ObjectAttribute.class.getPackage() );
//				System.out.println( "Class Loader ObjectAttribute = " + ObjectAttribute.class.getClassLoader() );
//				System.out.println( "Type Parammeters ObjectAttribute = " + Arrays.toString(ObjectAttribute.class.getTypeParameters()) );
//				System.out.println( "GetResource ObjectAttribute = " + ObjectAttribute.class.getResource("ObjectAttribute.class") );
//				System.out.println( " ------------------------------------------------------- ");
//				System.out.println( "Name Class of Object = " + a.getClass().getName() );
//				System.out.println( "Package Class of Object = " + a.getClass().getPackage() );
//				System.out.println( "Class Loader Class of Object = " + a.getClass().getClassLoader() );
//				System.out.println( "Type Parammeters Class of Object = " + Arrays.toString(a.getClass().getTypeParameters()) );
//				System.out.println( "GetResource Class of Object = " + a.getClass().getResource("ObjectAttribute.class") );
//				System.out.println( " ------------------------------------------------------- ");
//				System.out.println( "Name AttributeWeight = " + AttributeWeight.class.getName() );
//				System.out.println( "Package AttributeWeight = " + AttributeWeight.class.getPackage() );
//				System.out.println( "Class Loader AttributeWeight = " + AttributeWeight.class.getClassLoader() );
//				System.out.println( "Type Parammeters AttributeWeight = " + Arrays.toString(AttributeWeight.class.getTypeParameters()) );
//				System.out.println( "GetResource AttributeWeight = " + AttributeWeight.class.getResource("AttributeWeight.class") );
//				
				
				hitterAttribute = (ObjectAttribute<?>)a;
				index = i;
			}
			i++;
		}
		if( hitterAttribute == null ){
			throw new UserError(null, 128, "ID (containing the Hierarchical " +
					"Heavy Hitters). The distance measure you have chosen is " +
					"not applicable for other datasets");		
		}
	}

	
	/**
	 * Calculates the hierarchy-aware similarity of the given sets of HHH.
	 * 
	 * @param hhh1
	 * @param hhh2
	 * @return similarity of the given sets of HHH.
	 */
	protected abstract double calculateSimilarity(Set<Element> hhh1, Set<Element> hhh2);

}
