package com.rapidminer.operator.preprocessing.hhhitter;

import hitters.multi.Element;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.Annotations;
//import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOConsumeOperator;


/**
 * This class is used for storing a list of sets of Hierarchical Heavy Hitters. 
 * The HHH themselves are prefixes, so we have a list of sets of prefixes.
 * 
 * It also stores the parameters used to create these sets of Hierarchical Heavy 
 * Hitters. You should not compare sets of HHH that were created with different 
 * sets of parameters. 
 * 
 */
public class HHHSets extends AbstractIOObject {

	
	private static final long serialVersionUID = -7560033990739364403L;

	ArrayList<Set<Element>> hitters = new ArrayList<Set<Element>>();
	ParameterWrapper pw;
	
	IOConsumeOperator X;
	/**
	 * Creates an empty instance of HHHSets, but sets the parameters 
	 * used to create the HHH that will be stored in this object.
	 * 
	 * @param pw Parameters used to create the HHH that 
	 * will be stored in this object.
	 */
	public HHHSets( ParameterWrapper pw ){
		this.pw = pw;
	}
	
	
	/**
	 * Creates an instance of HHHSets, adds some sets of HHH
	 * and sets the parameters used to create these HHH.
	 * 
	 * @param pw Parameters used to create the HHH that 
	 * will be stored in this object.
	 * @param hitters Some sets of HHH.
	 */	
	public HHHSets( ParameterWrapper pw, ArrayList<Set<Element>> hitters ){
		this( pw );
		this.hitters = hitters;		
	}
	
	
	/**
	 * Adds a single set of HHH. 
	 * 
	 * @param set The single set of HHH to be added.
	 */
	public void add( Set<Element> set ){
		hitters.add( set );
	}

	
	/**
	 * Returns the list of of sets of HHH stored in this object.
	 * 
	 * @return The list of of sets of HHH stored in this object. 
	 */
	public List<Set<Element>> getAllHitters(){
		return hitters;
	}
	
	
	/**
	 * Returns the Parameters used to create the HHH that 
	 * are stored in this object.
	 * 
	 * @return The Parameters used to create the HHH that 
	 * are stored in this object.
	 */
	public ParameterWrapper getParameters(){
		return pw;
	}


	@Override
	public Annotations getAnnotations() {
		// TODO Auto-generated method stub
		return null;
	}

/*
	@Override
	public Annotations getAnnotations() {
		// TODO Auto-generated method stub
		return null;
	}
	*/
}
