package com.rapidminer.operator.preprocessing.hhhitter;

import hitters.multi.Element;

import java.util.List;
import java.util.Set;

import com.rapidminer.operator.ResultObjectAdapter;


/**
 * This class is used for storing a list of sets of Hierarchical Heavy Hitters. 
 * The HHH themselves are prefixes, so we have a list of sets of prefixes.
 * 
 * It also stores the parameters used to create these sets of Hierarchical Heavy 
 * Hitters. You should not compare sets of HHH that were created with different 
 * sets of parameters. 
 * 
 */
public class HHHResult extends ResultObjectAdapter {

	
	private static final long serialVersionUID = -7560033990739364403L;

	List<Set<Element>> hitters;// = new ArrayList<Set<Element>>();
	List<String> names;// = new ArrayList<String>();
	ParameterWrapper pw;
	

//	/**
//	 * Creates an empty instance of HHHSets, but sets the parameters 
//	 * used to create the HHH that will be stored in this object.
//	 * 
//	 * @param pw Parameters used to create the HHH that 
//	 * will be stored in this object.
//	 */
//	public HHHResult( ParameterWrapper pw ){
//		this.pw = pw;
//	}
	
	
	/**
	 * Creates an instance of HHHSets, adds some sets of HHH
	 * and sets the parameters used to create these HHH.
	 * 
	 * @param pw Parameters used to create the HHH that 
	 * will be stored in this object.
	 * @param hitters Some sets of HHH.
	 */	
	public HHHResult( ParameterWrapper pw, List<Set<Element>> hitters, List<String> names ){
		this.pw = pw;
		this.hitters = hitters;		
		this.names = names;
	}
	
	
	/**
	 * Adds a single set of HHH. 
	 * 
	 * @param set The single set of HHH to be added.
	 */
//	public void add( Set<Element> set ){
//		hitters.add( set );
//	}

	
	/**
	 * Returns the list of sets of HHH stored in this object.
	 * 
	 * @return The list of sets of HHH stored in this object. 
	 */
	public List<Set<Element>> getAllHitters(){
		return hitters;
	}
	
	
	/**
	 * Returns the names of the sets of HHH stored in this object.
	 * A name of a set of HHH could be something like the name of the
	 * logFile from which it was created or a label.
	 * 
	 * @return The list of the names of the sets of HHH stored in this object. 
	 */
	public List<String> getNames(){
		return names;
	}
	
	
	/**
	 * Returns the Parameters used to create the HHH that 
	 * are stored in this object.
	 * 
	 * @return The Parameters used to create the HHH that 
	 * are stored in this object.
	 */
	public ParameterWrapper getParameters(){
		return pw;
	}
	
	
	public String getExtension() {
		return "h3";
	}

	public String getFileDescription() {
		return "Heavy Hitters";
	}

	
}
