package com.rapidminer.operator.preprocessing.hhhitter;

import hitters.multi.Element;

import java.util.Iterator;
import java.util.Set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Ontology_struct;
import com.rapidminer.tools.RandomGenerator;

/**
 * 
 * Debug operator. 
 * 
 * @author Peter Fricke
 *
 */
public class HHHConsumer extends Operator {
	

	/** Creates a new HHHExtraction operator. */
	public HHHConsumer(OperatorDescription description) {
		super(description);
	}


	public IOObject[] apply() throws OperatorException {
				
		LogService logService = LogService.getGlobal();
		logService.setVerbosityLevel( LogService.STATUS );		
		logService.log( "Start apply   ", LogService.STATUS );
		
		ExampleSet exampleSet = getInput(ExampleSet.class);
		
		
		RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
		
//		int[] rs;
//		for( int i = 0; i < 10; i++ ){
//			rs= Val.getRandomSubset( i, random );
//			System.out.println( " i= " + i + Arrays.toString( rs ) );
//		}
//		System.exit(0);
	    
//		Attribute label = exampleSet.getAttributes().getLabel();
//		SplittedExampleSet s = SplittedExampleSet.splitByAttribute(exampleSet, label);
//		System.out.println( "Sub= " + s.getNumberOfSubsets() );
//		System.out.println( "SIZE= " + s.size() );
//		s.selectSingleSubset(3);
//		System.out.println( "SIZE= " + s.size() );
//		System.out.println( s );
//		System.exit(0);		
		
		if( ! Tools.containsValueType(exampleSet, Ontology.OBJECT) ){			
			throw new UserError(this, 128, "OBJECT");
		}
		
		SimpleAttributes attributes = new SimpleAttributes();
		Iterator<AttributeRole> roleIterator = exampleSet.getAttributes().allAttributeRoles();
		while (roleIterator.hasNext()) {
			AttributeRole role = roleIterator.next();
			if (role.isSpecial()) {
				attributes.add(role);
			}
		}
	
		logService.log( "SPEC " + attributes, LogService.STATUS );
		
		
//		Attribute structID = exampleSet.getAttributes().get(
//				Structures.ID_ATTRIBUTE);
//		if (structID == null) {
//			LogService.getGlobal().log("Creating structID attribute...",
//					LogService.NOTE);
//			structID = AttributeObjectFactory.createAttribute(
//					Structures.ID_ATTRIBUTE, Ontology_struct.OBJECT);
//			exampleSet.getExampleTable().addAttribute(structID);
//			exampleSet.getAttributes().addRegular(structID);
//		}

		Attribute object = null;
		Attributes as = exampleSet.getAttributes();
		Iterator<Attribute> iter = as.iterator();
		while(iter.hasNext()){
			Attribute temp = iter.next();
			if(temp.getValueType()==Ontology_struct.OBJECT){
				object = temp;
				break;
			}
		}

		Set<Element> hhh;
		
		for (Example example : exampleSet) {
			checkForStop();
			
//			double val = ((ObjectAttribute<?>)structID).getMapping().mapString( hhh );
//			example.setValue(structID, val);

			if(object!=null){
				int index = new Double(example.getValue(object)).intValue();
				hhh = (Set<Element>)((ObjectAttribute)object).getMapping().mapObjectIndex(index);
				for( Element e : hhh ){
					logService.log( "HHH= " + e, LogService.STATUS );					
				}
			}
			logService.log( "------------------------------ " , LogService.STATUS );
		}
		
		return new IOObject[] { exampleSet };	
	}

	
	public Class<?>[] getInputClasses() {
		return new Class[] { ExampleSet.class };
	}

	
	public Class<?>[] getOutputClasses() {
		return new Class[] { ExampleSet.class };
	}
}