/**
 * @author Peter Fricke 
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeight;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

public class ClassLoaderBugSimilarity extends SimilarityMeasure {
	
	ObjectAttribute<?> myAttribute;
	AttributeWeight weight;
	int index = -1;

	@Override
	public double calculateDistance(double[] value1, double[] value2) {
		return 1 - calculateSimilarity( value1, value2 );
	}

	@Override
	public double calculateSimilarity(double[] value1, double[] value2) {
		return 1.0;
	}

	@Override
	public void init(ExampleSet exampleSet) throws OperatorException {
		
		Attributes attributes = exampleSet.getAttributes();
		for( Attribute a : attributes ){			
			if( a.getName().equals( "structID" ) ){
				
				System.out.println( "Insinde " + this.getClass().getName() );
				System.out.println( " ------------------------------------------------------- ");
				System.out.println( "Name ObjectAttribute = " + ObjectAttribute.class.getName() );
				System.out.println( "Package ObjectAttribute = " + ObjectAttribute.class.getPackage() );
				System.out.println( "Class Loader ObjectAttribute = " + ObjectAttribute.class.getClassLoader() );				
				System.out.println( "GetResource ObjectAttribute = " + ObjectAttribute.class.getResource("ObjectAttribute.class") );
				System.out.println( " ------------------------------------------------------- ");
				System.out.println( "Name Class of Object = " + a.getClass().getName() );
				System.out.println( "Package Class of Object = " + a.getClass().getPackage() );
				System.out.println( "Class Loader Class of Object = " + a.getClass().getClassLoader() );				
				System.out.println( "GetResource Class of Object = " + a.getClass().getResource( a.getClass().getSimpleName() + ".class" ) );
				System.out.println( " ------------------------------------------------------- ");
				System.out.println( "Name AttributeWeight = " + AttributeWeight.class.getName() );
				System.out.println( "Package AttributeWeight = " + AttributeWeight.class.getPackage() );
				System.out.println( "Class Loader AttributeWeight = " + AttributeWeight.class.getClassLoader() );
				System.out.println( "GetResource AttributeWeight = " + AttributeWeight.class.getResource("AttributeWeight.class") );
				
				myAttribute = (ObjectAttribute<?>)a;
			}			
		}		
	}

}
