package com.rapidminer.example.table.struct;

import java.util.Collection;

import com.rapidminer.example.Example;
import com.rapidminer.operator.IOObject;

/**
 * <p>
 * This interface defines an arbitrary set of structures which can be forwarded between
 * RapidMiner operators. It serves as a container of structures which are created once and
 * stored in memory or can be created on the fly, e.g. using a simple parser.
 * </p>
 * @author Christian Bockermann &lt;chris@jwall.org&gt;
 *
 */
public interface Structures<T>
    extends IOObject
{
    /* The name of the regular attribute which associates examples with structures */
    public final static String ID_ATTRIBUTE = "structID";

    /**
     * In the simplest case a <code>Structures</code> object is simply an array of previously
     * created trees, graphs or other structures, which can efficiently be accessed by their
     * index. Using nominal ID attributes or nominal mapping allows to retrieve the structure
     * for an example using the appropriate index. 
     * 
     * @param index The index of the structure which shall be retrieved.
     * @return The structure or <code>null</code> if no such structure exists.
     */
    public T getStructure( int index );
    
    
    /**
     * Return the structure for a given example. Usually this is basically a look up in an
     * array of previously created structures. This may also create the structure for the
     * given example on-the-fly. 
     * 
     * @param example The example which is the source of the structure.
     * @return The structure (e.g. tree, graph) for the given example.
     */
    public T getStructureFor( Example example );
    
    
    /**
     * Returns the number of structures which are contained within this IOObject. It is
     * determined by the number of unique mapping IDs, i.e. two &quot;equal&quot; examples
     * may share the same structure.
     * 
     * @return The number of structures.
     */
    public int size();
    
    
    
    public Collection<Integer> getIdentifiers();
}