package com.rapidminer.example.table.struct.tree;


/**
 * 
 * This interface encapsulates a generic parser. A parser will simply start
 * processing a string and return a parse tree by means of a tree node, i.e.
 * the root node of that parse tree.
 * 
 * @author Christian Bockermann &lt;chris@jwall.org&gt;
 *
 */
public interface Parser<E extends KTreeNode> {
	
	/**
	 * This method will parse the string according to the grammar inherent to
	 * the parser implementation and return the root node of the resulting parse
	 * tree.
	 * 
	 * @param str The string to be parsed.
	 * @return The root node of the parse tree.
	 * @throws ParseException In case parsing failed, e.g. due to syntactical errors.
	 */
	public E parse( String str ) throws ParseException;
}