package com.rapidminer.example.table.struct.tree;

import java.util.ArrayList;


/**
 * <p>
 * Extracted interface from the Tree class. This class represents a tree node for a tree-kernel.
 * (This is what the <i>K</i> is for in the name.)
 * </p>
 * 
 * @author Christian Bockermann lt;&chris@jwall.org&gt;
 *
 */
public interface KTreeNode{


	public abstract String getLabel();

	public abstract void setLabel(String label);

	/**
	 * @return Return this node's parent or <code>null</code>, if this node IS the parent.
	 */
	public abstract KTreeNode getParent();

	public void setParent( KTreeNode node );
	
	
	/**
	 * @return The depth of nodes below this one, longest path to a leaf (a leaf has depthBelow == 0)
	 */
	public abstract int getDepthBelow();

	
	/**
	 * @return the depth of the current node, seen from root (root has depth == 0)
	 */
	public abstract int getDepth();


	/**
	 * TODO: It might make sense to generalize this to some arbitrary ordered collection?
	 * @return
	 */
	public abstract ArrayList<KTreeNode> children();

	/**
	 * Returns the i'th child of this instance.
	 * 
	 * @param i The index of the child to be returned.
	 * @return
	 */
	public abstract KTreeNode getChild(int i);

	
	/**
	 * Adds a new child to this node.
	 * 
	 * @param child The child to be added.
	 */
	public abstract void addChild( KTreeNode child );

	
	/**
	 * @return Whether this is a leaf node or not, i.e. <code>numChildren() == 0</code>.
	 */
	public abstract boolean isLeaf();


	public abstract Double getKernelValue();

	public abstract void setKernelValue(Double kernelValue);

	public abstract String toString2();
	
	public abstract String printTree();
}