/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.Helpers;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalCollection<E>
extends AbstractCollection<E> {
    private final E[] contents;
    private final Class<? super E> type;
    private final boolean allowNulls;

    public static <E> MinimalCollection<E> of(E ... contents) {
        return new MinimalCollection<Object>(Object.class, true, contents);
    }

    public static <E> MinimalCollection<E> ofClassAndContents(Class<? super E> type, E ... contents) {
        return new MinimalCollection<E>(type, true, contents);
    }

    MinimalCollection(Class<? super E> type, boolean allowNulls, E ... contents) {
        this.contents = (Object[])contents.clone();
        this.type = type;
        this.allowNulls = allowNulls;
        if (!allowNulls) {
            for (E element : contents) {
                Helpers.checkNotNull(element);
            }
        }
    }

    @Override
    public int size() {
        return this.contents.length;
    }

    @Override
    public boolean contains(Object object) {
        if (!this.allowNulls) {
            Helpers.checkNotNull(object);
        }
        this.type.cast(object);
        return Arrays.asList(this.contents).contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!this.allowNulls) {
            for (Object object : collection) {
                Helpers.checkNotNull(object);
            }
        }
        return super.containsAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.contents).iterator();
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.contents.clone();
    }

    @Override
    public boolean addAll(Collection<? extends E> elementsToAdd) {
        throw MinimalCollection.up();
    }

    @Override
    public boolean removeAll(Collection<?> elementsToRemove) {
        throw MinimalCollection.up();
    }

    @Override
    public boolean retainAll(Collection<?> elementsToRetain) {
        throw MinimalCollection.up();
    }

    @Override
    public void clear() {
        throw MinimalCollection.up();
    }

    private static UnsupportedOperationException up() {
        throw new UnsupportedOperationException();
    }
}

