/*
 * Decompiled with CFR 0.152.
 */
package hitters.tools;

import com.google.common.collect.HashMultiset;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.AbstractHHH;
import hitters.multi.Element;
import hitters.multi.Exact;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.tools.LogService;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class XMLPlotter {
    public static final int ABSOLUTE_FREQ = 1;
    public static final int DISCOUNTED_FREQ = 2;
    public static final int APPROX_HITTERS = 4;
    public static final int TRUE_HITTERS = 8;
    public static final int OUT_ESTIMATES = 16;
    public static final int DUMP = 32;
    public static final int DUMP_RED = 64;
    public static final int DISTRIB_f = 128;
    public static final int DISTRIB_F = 256;
    public static final int PART_ANC = 4096;
    public static final int FULL_ANC = 8192;
    public static final int SYSCALL = 1;
    private String file;
    private HashMap<Element, Node> nodeSet = new HashMap();
    private HashSet<Edge> edgeSet = new HashSet();
    private FileWriter outData;
    private BufferedWriter out;
    HashMultiset<Element> prefixSet = HashMultiset.create();

    public static void main(String[] args) {
        AbstractComplexHHH hitterAlgo;
        Vector<Element> v;
        double phi;
        double epsilon;
        int logLevel = 0;
        boolean streamType = false;
        boolean mbug = false;
        boolean bprob = false;
        int algoType = 4096;
        String testcase = args.length > 0 ? args[0] : "resources/testcase/muster/mbug";
        String xmlFile = args.length > 1 ? args[1] : "tmp/gt.graphml";
        if (args.length > 2) {
            char[] flags;
            block18: for (char c : flags = args[2].trim().toCharArray()) {
                switch (c) {
                    case 'f': {
                        logLevel |= 1;
                        continue block18;
                    }
                    case 'F': {
                        logLevel |= 2;
                        continue block18;
                    }
                    case 'h': {
                        logLevel |= 4;
                        continue block18;
                    }
                    case 't': {
                        logLevel |= 8;
                        continue block18;
                    }
                    case 'd': {
                        logLevel |= 0x20;
                        continue block18;
                    }
                    case 'D': {
                        logLevel |= 0x40;
                        continue block18;
                    }
                    case 'o': {
                        logLevel |= 0x10;
                        continue block18;
                    }
                    case 'i': {
                        logLevel |= 0x80;
                        continue block18;
                    }
                    case 'I': {
                        logLevel |= 0x100;
                        continue block18;
                    }
                    case 'S': {
                        streamType = true;
                        continue block18;
                    }
                    case 'M': {
                        mbug = true;
                        continue block18;
                    }
                    case 'B': {
                        bprob = true;
                    }
                }
            }
        }
        if (args.length > 3) {
            if (args[3].equals("PA")) {
                algoType = 4096;
            }
            if (args[3].equals("FA")) {
                algoType = 8192;
            }
        }
        if (args.length > 4) {
            LogService.DEBUG = Integer.parseInt(args[4]);
        }
        byte[][] plength20 = new byte[][]{};
        byte[][] plength11 = new byte[][]{{0, 4, 8, 16, 24, 32}};
        byte[][] plength = streamType ? plength11 : plength20;
        int dim = 2;
        Parameter par = new Parameter(dim - plength.length, plength);
        par.setMBug(mbug);
        par.setMBug(bprob);
        MultiDatabase d = new MultiDatabase(testcase, par);
        d.openRead();
        if (streamType) {
            epsilon = 0.01;
            phi = 0.02;
            v = d.readSystemCalls();
        } else {
            v = d.readElements();
            epsilon = d.getEpsilon();
            phi = d.getPhi();
        }
        ArrayList<Element> elements = new ArrayList<Element>(v);
        XMLPlotter plotter = new XMLPlotter(xmlFile);
        plotter.addItems(elements);
        switch (algoType) {
            case 8192: {
                System.out.println("algoType = FA");
                hitterAlgo = new FullAncHHH(epsilon, par);
                break;
            }
            case 4096: {
                System.out.println("algoType = PA");
                hitterAlgo = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Algorithmus angeben!");
            }
        }
        Exact myExact = new Exact(par);
        for (Element e : elements) {
            ((AbstractHHH)hitterAlgo).insert(e.clone(), 1, true);
            myExact.insert(e.clone(), 1, true);
        }
        if ((logLevel & 1) != 0) {
            plotter.addTrueAbsoluteFreq(myExact);
        }
        if ((logLevel & 2) != 0) {
            plotter.addTrueDiscountedFreq(myExact, phi);
        }
        if ((logLevel & 8) != 0) {
            plotter.addExactHHH(myExact.outputSet(phi, true));
        }
        if ((logLevel & 4) != 0) {
            plotter.addApproxHHH(((AbstractHHH)hitterAlgo).outputSet(phi));
        }
        if ((logLevel & 0x20) != 0 || (logLevel & 0x40) != 0) {
            if ((logLevel & 0x40) != 0) {
                plotter.addDump(hitterAlgo, true);
            } else {
                plotter.addDump(hitterAlgo, false);
            }
        }
        if ((logLevel & 0x10) != 0) {
            plotter.addEstimates(hitterAlgo, phi);
        }
        if ((logLevel & 0x80) != 0) {
            plotter.addColoring_f(myExact);
        }
        if ((logLevel & 0x100) != 0) {
            plotter.addColoring_F(myExact, phi);
        }
        plotter.plot();
        System.out.println("Geschrieben: " + testcase + " per " + XMLPlotter.algoString(algoType) + " nach " + xmlFile);
        System.out.println("epsilon = " + epsilon + " phi = " + phi + " N = " + hitterAlgo.getN());
        if (hitterAlgo instanceof AbstractComplexHHH) {
            System.out.println(" w = " + hitterAlgo.getW());
        }
    }

    public XMLPlotter(String file) {
        this.file = file;
    }

    public void addItems(List<Element> data) {
        switch (data.get(0).getDim()) {
            case 1: {
                this.addItems1D(data);
                break;
            }
            case 2: {
                this.addItems2D(data);
                break;
            }
            case 3: {
                this.addItems3D(data);
                break;
            }
            default: {
                throw new RuntimeException("Dim nicht impl.");
            }
        }
    }

    public void addItems2D(List<Element> data) {
        Element a = data.get(0).clone();
        Element b = a.clone();
        Element tmp = a.clone();
        boolean check = true;
        for (Element e : data) {
            a.setTo(e);
            int lim0 = a.getLevel(0);
            int lim1 = a.getLevel(1);
            for (int i = 0; i <= lim0; ++i) {
                if (i > 0) {
                    check = a.turnIntoParent(0);
                }
                if (!check) {
                    throw new RuntimeException("Kann nicht in Elter umwandeln");
                }
                b.setTo(a);
                for (int j = 0; j <= lim1; ++j) {
                    if (j > 0) {
                        check = b.turnIntoParent(1);
                    }
                    if (!check) {
                        throw new RuntimeException("Kann nicht in Elter umwandeln");
                    }
                    this.prefixSet.add((Object)b.clone());
                    Node nd = new Node(b.toShortString());
                    this.nodeSet.put(b.clone(), nd);
                    tmp = b.clone();
                    if (tmp.turnIntoParent(0)) {
                        this.edgeSet.add(new Edge(b.toShortString(), tmp.toShortString()));
                    }
                    if (!(tmp = b.clone()).turnIntoParent(1)) continue;
                    this.edgeSet.add(new Edge(b.toShortString(), tmp.toShortString()));
                }
            }
        }
    }

    public void addItems3D(List<Element> data) {
        Element a = data.get(0).clone();
        Element b = a.clone();
        Element c = a.clone();
        Element tmp = a.clone();
        boolean check = true;
        for (Element e : data) {
            a.setTo(e);
            int lim0 = a.getLevel(0);
            int lim1 = a.getLevel(1);
            int lim2 = a.getLevel(2);
            for (int i = 0; i <= lim0; ++i) {
                if (i > 0) {
                    check = a.turnIntoParent(0);
                }
                if (!check) {
                    throw new RuntimeException("Kann nicht in Elter umwandeln");
                }
                b.setTo(a);
                for (int j = 0; j <= lim1; ++j) {
                    if (j > 0) {
                        check = b.turnIntoParent(1);
                    }
                    if (!check) {
                        throw new RuntimeException("Kann nicht in Elter umwandeln");
                    }
                    c.setTo(b);
                    for (int k = 0; k <= lim2; ++k) {
                        if (k > 0) {
                            check = c.turnIntoParent(2);
                        }
                        if (!check) {
                            throw new RuntimeException("Kann nicht in Elter umwandeln");
                        }
                        this.prefixSet.add((Object)c.clone());
                        Node nd = new Node(c.toShortString());
                        this.nodeSet.put(c.clone(), nd);
                        System.out.println(c.toShortString());
                        tmp = c.clone();
                        if (tmp.turnIntoParent(0)) {
                            this.edgeSet.add(new Edge(c.toShortString(), tmp.toShortString()));
                        }
                        if ((tmp = c.clone()).turnIntoParent(1)) {
                            this.edgeSet.add(new Edge(c.toShortString(), tmp.toShortString()));
                        }
                        if (!(tmp = c.clone()).turnIntoParent(2)) continue;
                        this.edgeSet.add(new Edge(c.toShortString(), tmp.toShortString()));
                    }
                }
            }
        }
    }

    public void addItems1D(List<Element> data) {
        Element a = data.get(0).clone();
        Element tmp = a.clone();
        boolean check = true;
        for (Element e : data) {
            a.setTo(e);
            this.prefixSet.add((Object)a.clone());
            Node nd = new Node(a.toShortString());
            this.nodeSet.put(a.clone(), nd);
            int lim0 = a.getLevel(0);
            for (int i = 1; i <= lim0; ++i) {
                tmp.setTo(a);
                check = a.turnIntoParent(0);
                if (!check) {
                    throw new RuntimeException("Kann nicht in Elter umwandeln");
                }
                this.prefixSet.add((Object)a.clone());
                nd = new Node(a.toShortString());
                this.nodeSet.put(a.clone(), nd);
                this.edgeSet.add(new Edge(tmp.toShortString(), a.toShortString()));
            }
        }
    }

    private void addTrueAbsoluteFreq(Exact myExact) {
        HashMap<Element, Integer> f = myExact.dumpf();
        if (f.size() != this.nodeSet.size()) {
            throw new RuntimeException("Plotter.addTrueAbsoluteFreq: f.size() != nodeSet.size() ");
        }
        for (Element el : this.nodeSet.keySet()) {
            Node nd = this.nodeSet.get(el);
            int count = this.prefixSet.count(el);
            f.get(el);
            System.out.println(el + " " + count + "     " + f.get(el));
            if (count != f.get(el)) {
                throw new RuntimeException("Plotter.addTrueAbsoluteFreq: count != exact.getf.get(el)");
            }
            nd.setLabel(nd.getLabel() + "\nf* = " + count);
        }
    }

    private void addTrueDiscountedFreq(Exact myExact, double phi) {
        HashMap<Element, Integer> F = myExact.dumpF(phi);
        for (Element el : this.nodeSet.keySet()) {
            Node nd = this.nodeSet.get(el);
            Integer countObj = F.get(el);
            int count = countObj == null ? 0 : countObj;
            nd.setLabel(nd.getLabel() + "\nF* = " + count);
        }
    }

    private void addColoring_f(Exact myExact) {
        double thresh = 0.2;
        HashMap<Element, Integer> f = myExact.dumpf();
        for (Element el : this.nodeSet.keySet()) {
            int green;
            int blue;
            Node nd = this.nodeSet.get(el);
            int count = f.get(el);
            double rel = (double)count / (double)myExact.getN();
            if ((rel = Math.sqrt(rel)) > thresh) {
                blue = 0;
                green = 255 - (int)Math.floor((rel - thresh) * 255.0 / (1.0 - thresh));
            } else {
                blue = 255 - (int)Math.floor(rel * 255.0 / thresh);
                green = 255;
            }
            nd.setColor(255, green, blue);
        }
    }

    private void addColoring_F(Exact myExact, double phi) {
        double thresh = 0.2;
        HashMap<Element, MultiHitterInfo> hitter = myExact.outputSet(phi, true);
        HashMap<Element, Integer> F = myExact.dumpF(phi);
        for (Element el : this.nodeSet.keySet()) {
            int green;
            int blue;
            Node nd = this.nodeSet.get(el);
            Integer countObj = F.get(el);
            int count = countObj == null ? 0 : countObj;
            double rel = Math.min((double)count / (double)myExact.getN() / phi, 1.0);
            if ((rel = Math.sqrt(rel)) > thresh) {
                blue = 0;
                green = 255 - (int)Math.floor((rel - thresh) * 255.0 / (1.0 - thresh));
            } else {
                blue = 255 - (int)Math.floor(rel * 255.0 / thresh);
                green = 255;
            }
            nd.setColor(255, green, blue);
            if (!hitter.containsKey(el)) continue;
            nd.setColor("blue");
        }
    }

    public void addDump(AbstractHHH partAnc, boolean red) {
        if (!(partAnc instanceof AbstractComplexHHH)) {
            for (Element el : this.nodeSet.keySet()) {
                Node nd = this.nodeSet.get(el);
                nd.setMargin("5.0");
                if (!red) continue;
                nd.setColor("red");
            }
            return;
        }
        AbstractComplexHHH complex = (AbstractComplexHHH)partAnc;
        for (Element el : this.nodeSet.keySet()) {
            MultiStringElement msi;
            Node nd = this.nodeSet.get(el);
            if (red) {
                nd.setColor("white");
            }
            if ((msi = complex.dumpElement(el)) == null) {
                nd.setLabel(nd.getLabel() + "\n( - , - , " + complex.instantiateDelta(el) + ")");
                continue;
            }
            nd.setMargin("5.0");
            if (red) {
                nd.setColor("red");
            }
            nd.setLabel(nd.getLabel() + "\n(" + msi.g + ", " + msi.m + ", " + msi.delta + ")");
        }
    }

    public void addApproxHHH(HashMap<Element, MultiHitterInfo> hitter) {
        for (Element el : hitter.keySet()) {
            Node nd = this.nodeSet.get(el);
            if (nd.color.equals("lightblue")) {
                nd.setColor("green");
                continue;
            }
            nd.setColor("yellow");
        }
    }

    public void addExactHHH(HashMap<Element, MultiHitterInfo> hitter) {
        for (Element el : hitter.keySet()) {
            Node nd = this.nodeSet.get(el);
            nd.setShape("ellipse");
            if (nd.color.equals("yellow")) {
                nd.setColor("green");
                continue;
            }
            nd.setColor("lightblue");
        }
    }

    private void addEstimates(AbstractHHH partAnc, double phi) {
        HashMap<Element, Integer> F = partAnc.dumpF(phi);
        HashMap<Element, Integer> f = partAnc.dumpf();
        for (Element el : this.nodeSet.keySet()) {
            Node nd = this.nodeSet.get(el);
            int delta = partAnc.instantiateDelta(el);
            int estf = f.get(el) != null ? f.get(el) : 0;
            int fmin = estf - delta;
            int fmax = estf + delta;
            int estF = F.get(el) != null ? F.get(el) : 0;
            nd.setLabel(nd.getLabel() + "\n(" + fmin + "; " + fmax + "; " + estF + ")");
        }
    }

    public void plot() {
        String head = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> <graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">   <key for=\"node\" id=\"d0\" yfiles.type=\"nodegraphics\"/>   <key for=\"edge\" id=\"d1\" yfiles.type=\"edgegraphics\"/>   <key id=\"d2\" for=\"edge\" attr.name=\"weight\" attr.type=\"double\"/> <graph edgedefault=\"directed\">\n";
        String foot = "</graph></graphml>";
        Node nd = null;
        try {
            this.outData = new FileWriter(this.file);
            this.out = new BufferedWriter(this.outData);
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            this.out.write(head);
            for (Element el : this.nodeSet.keySet()) {
                nd = this.nodeSet.get(el);
                this.out.write(nd + System.getProperty("line.separator"));
            }
            for (Edge myEdge : this.edgeSet) {
                this.out.write(myEdge + System.getProperty("line.separator"));
            }
            this.out.write(foot);
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
    }

    private static String algoString(int algoType) {
        switch (algoType) {
            case 8192: {
                return "FULL_ANC";
            }
            case 4096: {
                return "PART_ANC";
            }
        }
        throw new RuntimeException("Algorithmus angeben!");
    }

    private class Edge {
        String source;
        String target;

        public Edge(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String toString() {
            String s = "<edge id=\"" + this.source + "->" + this.target + "\" source=\"" + this.source + "\" target=\"" + this.target + "\"><data key=\"d1\"><y:PolyLineEdge><y:LineStyle color=\"#000000\"" + " type=\"line\" width=\"1.0\"/><y:Arrows source=\"none\" target=\"" + "standard\"/></y:PolyLineEdge></data></edge>\n";
            return s;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge n = (Edge)o;
            return this.source.equals(n.source) && this.target.equals(n.target);
        }

        public int hashCode() {
            return (this.source + " -> " + this.target).hashCode();
        }
    }

    private class Node {
        String id;
        String label;
        String color = "white";
        String colorCode;
        String customCode;
        String shape = "roundrectangle";
        String margin = "1.0";

        public Node(String id) {
            this.id = id;
            this.label = id;
            this.translateColors();
        }

        public void setColor(int red, int green, int blue) {
            this.color = "custom";
            this.customCode = "#";
            this.customCode = this.customCode + Integer.toHexString(red).toUpperCase();
            if (red < 16) {
                this.customCode = this.customCode + "0";
            }
            this.customCode = this.customCode + Integer.toHexString(green).toUpperCase();
            if (green < 16) {
                this.customCode = this.customCode + "0";
            }
            this.customCode = this.customCode + Integer.toHexString(blue).toUpperCase();
            if (blue < 16) {
                this.customCode = this.customCode + "0";
            }
            this.colorCode = this.customCode;
        }

        public void setColor(String color) {
            this.color = color;
            this.translateColors();
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public void setMargin(String margin) {
            this.margin = margin;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String toString() {
            this.translateColors();
            String s = "<node id=\"" + this.id + "\">\n" + "<data key=\"d0\"><y:ShapeNode><y:Geometry height=\"83.505859375\"" + " width=\"64.697265625\" x=\"-32.3486328125\" y=\"-41.7529296875\"/>" + "<y:Fill color=\"" + this.colorCode + "\"" + "  transparent=\"false\"/><y:BorderStyle type=\"line\"" + " width=\"" + this.margin + "\" color=\"#000000\" /><y:NodeLabel x=\"2\"" + " y=\"2\" visible=\"true\" alignment=\"center\" fontFamily=" + "\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" textColor=\"" + "#000000\" modelName=\"internal\" modelPosition=\"c\"" + " autoSizePolicy=\"content\">" + this.label + "</y:NodeLabel>" + "<y:Shape type=\"" + this.shape + "\"/></y:ShapeNode></data>\n</node>\n";
            return s;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            Node n = (Node)o;
            return this.label.equals(n.label);
        }

        public int hashCode() {
            return this.label.hashCode();
        }

        private void translateColors() {
            if (this.color.equalsIgnoreCase("lightblue")) {
                this.colorCode = "#44CCFF";
            }
            if (this.color.equalsIgnoreCase("blue")) {
                this.colorCode = "#33CCCC";
            }
            if (this.color.equalsIgnoreCase("yellow")) {
                this.colorCode = "#FFCC00";
            }
            if (this.color.equalsIgnoreCase("white")) {
                this.colorCode = "#FFFFFF";
            }
            if (this.color.equalsIgnoreCase("green")) {
                this.colorCode = "#33CC33";
            }
            if (this.color.equalsIgnoreCase("red")) {
                this.colorCode = "#FF3333";
            }
            if (this.color.equalsIgnoreCase("custom")) {
                this.colorCode = this.customCode;
            }
        }
    }
}

