/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import com.google.common.collect.HashMultiset;
import com.rapidminer.operator.UserError;
import hitters.tools.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testCreateCallCode() throws UserError {
        HashSet<String> calls = new HashSet<String>();
        String input = "_llseek;accept;accept4;access;brk;clock_gettime";
        String output = "1;3;7;15;31;63;191";
        String[] some = input.split(";");
        String[] result = output.split(";");
        int i = 0;
        for (String single : some) {
            calls.add(single);
            Assert.assertTrue(Utils.createCallCode(calls).equals(result[i++]));
        }
        calls.add("close");
        Assert.assertTrue(Utils.createCallCode(calls).equals(result[i++]));
    }

    @Test
    public void testCreateCallCode2() throws UserError {
        HashSet<String> calls = new HashSet<String>();
        String fixedCalls = "_llseek;accept;accept4;access;brk;clock_gettime;clone;close;dup;dup2;dup3;execve;fcntl;fcntl64;fork;fstat;fstat64;futex;getdents;getdents64;gettimeofday;inotify_init;inotify_init1;ioctl;lseek;lstat;lstat64;mmap2;mprotect;munmap;nanosleep;open;pipe;pipe2;poll;read;readlink;recv;recvmsg;rt_sigaction;select;send;sendfile;sendmsg;sendto;socket;stat;stat64;time;uname;unshare;vfork;write;writev";
        String[] fixed = fixedCalls.split(";");
        List<String> list = Arrays.asList(fixed);
        int i = 0;
        for (String single : list) {
            calls.add(single);
            Assert.assertTrue(Utils.createCallCode(calls).equals(Long.toString(Utils.exp(2, i + 1) - 1L)));
            ++i;
        }
    }

    @Test(expected=UserError.class)
    public void testCreateCallCodeFail() throws UserError {
        HashSet<String> calls = new HashSet<String>();
        String input = "_llseek;accept;accept4;access;brk;clock_gettime";
        String output = "1;3;7;15;31;63;191";
        String[] some = input.split(";");
        String[] result = output.split(";");
        int i = 0;
        for (String single : some) {
            calls.add(single);
            Assert.assertTrue(Utils.createCallCode(calls).equals(result[i++]));
        }
        calls.add("close");
        Assert.assertTrue(Utils.createCallCode(calls).equals(result[i++]));
        calls.add("neeeeneeeee");
        Utils.createCallCode(calls);
    }

    @Test
    public void testFormat() throws UserError {
        System.out.println(Utils.format(8.444444444444445));
        System.out.println(Utils.format(9.0));
        System.out.println(Utils.format(10.255));
    }

    @Test
    public void testGetHist() {
        String f = "resources/testcase/histTest/histTest";
        HashMultiset<String> set = Utils.getHist(f);
        System.out.println("DONE " + set);
    }

    @Test
    public void testGetGlobalHist() {
        String f = "/home/fricke/log30/";
        String saveFile = "/home/fricke/weights";
        HashMultiset<String> set = Utils.getGlobalHist(f);
        System.out.println("DONE " + set);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(saveFile));
            for (String call : set.elementSet()) {
                out.write(call + "\t" + set.count(call));
                out.newLine();
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            out.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
    }

    @Test
    public void testCleanPath() {
        String path = "/;/etc/abc/../x;/var/../etc/;///etc///x///;//etc/x/y//z//..//..//x/;./../include;../../extra";
        for (String s : path.split(";")) {
            System.out.println(s + " :  " + Utils.cleanPath(s));
        }
        String p2 = "/usr/lib/gcc/i486-linux-gnu/4.3.2/../../../../lib/libc.so";
        System.out.println(p2 + " :  " + Utils.cleanPath(p2));
        path = ".;./x/;.././x/y;../../x/y;/fs/students/steink00/.macromedia/Flash_Player/";
        for (String s : path.split(";")) {
            System.out.println(s + " :  " + Utils.cleanPath(s));
        }
    }

    @Test
    public void testSp2() {
        String path = ".;./x/;.././x/y;../../x/y;/fs/students/steink00/.macromedia/Flash_Player/";
        for (String s : path.split(";")) {
            System.out.println(s + " :  " + Utils.cleanPath2(s));
        }
    }

    @Test
    public void testSp() {
        ArrayList<String> list = new ArrayList<String>();
        String file = "J:/uid.hhh";
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String s : list) {
            s = "/" + s.split(" ")[2];
            System.out.println(s + " :  " + Utils.cleanPath(s));
        }
    }
}

