/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import com.google.common.collect.HashMultiset;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.AbstractHHH;
import hitters.multi.AlgoType;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.Exact;
import hitters.multi.FullAncHHH;
import hitters.multi.HitterComparator;
import hitters.multi.HitterPolice;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.OLD_AbstractComplexHHH;
import hitters.multi.OLD_FullAncHHH;
import hitters.multi.OLD_PartAncHHH;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.StreamReader;
import hitters.tools.LogService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class ProductionIPGenerator {
    static String DELIMITER = "\n\n************************************\n\n";
    static final int MULTIPLE = 1;
    static final int OLD = 2;
    static final int BATCHOLD = 3;
    static final int MULTICOMPARE = 4;
    static final int STREAM = 5;
    static final int EXACT = 6;
    static final int QUALITY = 7;
    static final int MULTICOMPARE_2 = 8;
    static final int EVALUATION = 9;
    static final int FORKCHECK = 10;
    static final int TINY = 1;
    static final int UNIBIG = 2;
    static final int MEDIUM = 3;
    static final int SKEWED = 16;
    static final int EPSI_0 = 32;
    static int mode;
    static int distr;
    static AlgoType algo;
    static String file;

    public static void main(String[] args) {
        byte[][] plength = new byte[][]{};
        Parameter par = new Parameter(2 - plength.length, plength);
        boolean writeSolution = true;
        boolean compareToFileSolution = false;
        int offset = 0;
        boolean bug = false;
        System.out.println("Start: " + new Date());
        if (args.length < 2) {
            throw new RuntimeException("Dateinamen f\u00fcr Testcase(s) und Zahl der F\u00e4lle und Offset in Kommandozeile angeben!");
        }
        file = args[0].trim();
        int numberOfTestcases = Integer.parseInt(args[1].trim());
        if (args.length > 2) {
            offset = Integer.parseInt(args[2].trim());
        }
        LogService.DEBUG = args.length > 3 ? Integer.parseInt(args[3].trim()) : 0;
        if (args.length > 4) {
            char[] flags;
            block32: for (char c : flags = args[4].toCharArray()) {
                switch (c) {
                    case 'M': {
                        par.setMBug(true);
                        continue block32;
                    }
                    case 'B': {
                        par.setBProb(true);
                        continue block32;
                    }
                    case 'F': {
                        algo = AlgoType.FULL_ANC;
                        continue block32;
                    }
                    case 'P': {
                        algo = AlgoType.PART_ANC;
                        continue block32;
                    }
                    case 'm': {
                        mode = 1;
                        continue block32;
                    }
                    case 'o': {
                        mode = 2;
                        continue block32;
                    }
                    case 'b': {
                        mode = 3;
                        continue block32;
                    }
                    case 'c': {
                        mode = 4;
                        continue block32;
                    }
                    case '2': {
                        mode = 8;
                        continue block32;
                    }
                    case 's': {
                        mode = 5;
                        continue block32;
                    }
                    case 'e': {
                        mode = 6;
                        continue block32;
                    }
                    case 'q': {
                        mode = 7;
                        continue block32;
                    }
                    case 'v': {
                        mode = 9;
                        continue block32;
                    }
                    case 'f': {
                        mode = 10;
                        continue block32;
                    }
                    case 't': {
                        distr = 1;
                        continue block32;
                    }
                    case 'd': {
                        distr = 3;
                        continue block32;
                    }
                    case 'u': {
                        distr = 2;
                        continue block32;
                    }
                    case 'w': {
                        distr = 16;
                    }
                }
            }
        }
        if (mode == 6) {
            distr = 32;
        }
        if (mode == 0 || distr == 0 || algo == null) {
            throw new RuntimeException("Parameter angeben!");
        }
        switch (mode) {
            case 1: {
                writeSolution = false;
                compareToFileSolution = false;
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                for (long seed = (long)offset; seed <= (long)(offset - 1 + numberOfTestcases); ++seed) {
                    ProductionIPGenerator.writeTestcase(par, seed, distr, writeSolution);
                    double phi = ProductionIPGenerator.readPhi(par);
                    double epsilon = ProductionIPGenerator.readEpsilon(par);
                    if (!ProductionIPGenerator.test(file, par, phi, epsilon, compareToFileSolution)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + DELIMITER);
                    }
                    System.out.println("Fortschritt: " + seed + " phi " + phi + " epsilon " + epsilon);
                }
                System.out.println("Habe fertig: (" + par.getDimS() + ", " + par.getDimI() + ") " + numberOfTestcases + " mit Offset " + offset + " berechnet.");
                System.out.println("Bugs: " + bug);
                break;
            }
            case 2: {
                System.out.println("mode = old: Lese Datei " + file);
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                if (!ProductionIPGenerator.test(file, par, ProductionIPGenerator.readPhi(par), ProductionIPGenerator.readEpsilon(par), compareToFileSolution)) {
                    bug = true;
                    System.out.println(" BUG " + DELIMITER);
                }
                System.out.println("Bugs: " + bug);
                System.out.println(" done");
                break;
            }
            case 3: {
                throw new RuntimeException("BATCHOLD not impl");
            }
            case 4: {
                byte[][] pl1 = new byte[][]{};
                byte[][] pl2 = new byte[][]{{0, 32}};
                byte[][] pl3 = new byte[][]{{0, 16, 32}, {0, 32}};
                Parameter par1 = new Parameter(2 - pl1.length, pl1);
                Parameter par2 = new Parameter(2 - pl2.length, pl2);
                Parameter par3 = new Parameter(2 - pl3.length, pl3);
                writeSolution = true;
                compareToFileSolution = true;
                ProductionIPGenerator.printSetup(par1, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                ProductionIPGenerator.printSetup(par2, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                ProductionIPGenerator.printSetup(par3, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                for (long seed = (long)offset; seed <= (long)(offset - 1 + numberOfTestcases); ++seed) {
                    ProductionIPGenerator.writeTestcase(par1, seed, distr, writeSolution);
                    double phi = ProductionIPGenerator.readPhi(par1);
                    double epsilon = ProductionIPGenerator.readEpsilon(par1);
                    if (!ProductionIPGenerator.test(file, par1, phi, epsilon, false)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + " mit par 1 " + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    if (!ProductionIPGenerator.test(file, par2, phi, epsilon, true)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + " mit par 2" + ", evtl. im Vgl. mit par1 " + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    if (!ProductionIPGenerator.test(file, par3, phi, epsilon, true)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + " mit par 3, evtl. " + "im Vgl. mit par1 " + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    System.out.println("Fortschritt: " + seed + " phi " + phi + " epsilon " + epsilon);
                }
                System.out.println("Habe fertig: (" + par1.getDimS() + ", " + par1.getDimI() + ") " + numberOfTestcases + " mit Offset " + offset + " berechnet.\n" + par2 + par3);
                System.out.println("Bugs: " + bug);
                break;
            }
            case 6: {
                byte[][] pl = new byte[][]{};
                Parameter parEps0 = new Parameter(2 - pl.length, pl);
                ProductionIPGenerator.printSetup(parEps0, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                for (long seed = (long)offset; seed <= (long)(offset - 1 + numberOfTestcases); ++seed) {
                    System.out.println("Start appr  " + new Date());
                    ProductionIPGenerator.writeTestcase(parEps0, seed, 32, true);
                    System.out.println("Stop appr  " + new Date());
                    double phi = ProductionIPGenerator.readPhi(parEps0);
                    double epsilon = ProductionIPGenerator.readEpsilon(parEps0);
                    if (epsilon > 1.0E-9) {
                        throw new RuntimeException("Epsilon ist groesser 0");
                    }
                    if (!ProductionIPGenerator.test(file, parEps0, phi, epsilon, false)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + " mit Approx. " + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    System.out.println("Start ex  " + new Date());
                    if (!ProductionIPGenerator.compareToExact(file, parEps0, phi)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + " im Vgl. mit Exact " + DELIMITER);
                    }
                    System.out.println("Stop ex  " + new Date());
                    System.out.println("Fortschritt: " + seed + " phi " + phi + " epsilon " + epsilon);
                }
                System.out.println("Habe fertig: " + numberOfTestcases + " Testcase " + " mit Offset " + offset + " berechnet und mit Exact vergl.");
                System.out.println("Bugs: " + bug);
                break;
            }
            case 7: {
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                for (long seed = (long)offset; seed <= (long)(offset - 1 + numberOfTestcases); ++seed) {
                    ProductionIPGenerator.writeTestcase(par, seed, distr, false);
                    Exact myExact = ProductionIPGenerator.fillExact(file, par);
                    for (double myEps = 0.005; myEps < 0.05; myEps += 0.005) {
                        AbstractComplexHHH hitterAlgo = ProductionIPGenerator.fillApprox(file, par, myEps);
                        for (double myPhi = 2.0 * myEps; myPhi < 0.1; myPhi += 0.01) {
                            HashMap<Element, MultiHitterInfo> exact = myExact.outputSet(myPhi);
                            HashMap<Element, MultiHitterInfo> approx = hitterAlgo.outputSet(myPhi);
                            double precision = Evaluation.precision(approx.keySet(), exact.keySet());
                            double recall = Evaluation.recall(approx.keySet(), exact.keySet());
                            double jaccard = Evaluation.jaccard(approx.keySet(), exact.keySet());
                            double dice = Evaluation.dice(approx.keySet(), exact.keySet());
                            double omg = Evaluation.ogmGanesan(approx.keySet(), exact.keySet());
                            System.out.println(Evaluation.compactAll(approx.keySet(), exact.keySet()));
                        }
                        System.out.println();
                    }
                }
                break;
            }
            case 5: {
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                double phi = 0.01;
                double epsilon = 0.001;
                System.out.println("Arbeite mit phi = " + phi + ", epsilon = " + epsilon);
                if (!ProductionIPGenerator.streamTest(file, par, phi, epsilon)) {
                    bug = true;
                    System.out.println(" BUG " + DELIMITER);
                }
                System.out.println("Habe fertig: (" + par.getDimS() + ", " + par.getDimI() + ")  mit Offset " + offset + " berechnet.");
                System.out.println("Bugs: " + bug);
                break;
            }
            case 8: {
                writeSolution = true;
                compareToFileSolution = true;
                par.setOptimizeOutput(false);
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                for (long seed = (long)offset; seed <= (long)(offset - 1 + numberOfTestcases); ++seed) {
                    ProductionIPGenerator.writeTestcase(par, seed, distr, writeSolution);
                    double phi = ProductionIPGenerator.readPhi(par);
                    double epsilon = ProductionIPGenerator.readEpsilon(par);
                    if (!ProductionIPGenerator.test(file, par, phi, epsilon, false)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    par.setOptimizeOutput(true);
                    if (!ProductionIPGenerator.test(file, par, phi, epsilon, true)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    if ((seed + 1L) % 100L != 0L) continue;
                    System.out.println("Fortschritt: " + seed + " phi " + phi + " epsilon " + epsilon);
                }
                System.out.println("Habe fertig: (" + par.getDimS() + ", " + par.getDimI() + ") " + numberOfTestcases + " mit Offset " + offset + " berechnet.\n");
                System.out.println("Bugs: " + bug);
                break;
            }
            case 9: {
                writeSolution = false;
                compareToFileSolution = false;
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                ProductionIPGenerator.writeTestcase(par, offset, distr, writeSolution);
                double phi = ProductionIPGenerator.readPhi(par);
                double epsilon = ProductionIPGenerator.readEpsilon(par);
                ProductionIPGenerator.evaluationStability(file, par, phi, epsilon, offset);
                break;
            }
            case 10: {
                byte[][] myPlength = new byte[][]{};
                par = new Parameter(2 - myPlength.length, myPlength);
                writeSolution = true;
                compareToFileSolution = true;
                ProductionIPGenerator.printSetup(par, numberOfTestcases, offset, writeSolution, compareToFileSolution);
                for (long seed = (long)offset; seed <= (long)(offset - 1 + numberOfTestcases); ++seed) {
                    ProductionIPGenerator.writeTestcase(par, seed, distr, writeSolution, AlgoType.OLD_PART_ANC);
                    double phi = ProductionIPGenerator.readPhi(par);
                    double epsilon = ProductionIPGenerator.readEpsilon(par);
                    if (!ProductionIPGenerator.test(file, par, phi, epsilon, false, AlgoType.OLD_PART_ANC)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + ", erste Impl rechnet falsch." + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    if (!ProductionIPGenerator.test(file, par, phi, epsilon, true, AlgoType.PART_ANC)) {
                        bug = true;
                        System.out.println(" BUG BEI : " + seed + " zweite Impl. falsch, oder " + "erste hat falsches Ergebnis in Datei geschr." + DELIMITER);
                    }
                    if (LogService.shouldLog(128)) {
                        LogService.log(128, DELIMITER);
                    }
                    System.out.println("Fortschritt: " + seed + " phi " + phi + " epsilon " + epsilon);
                }
                System.out.println("Habe fertig: (" + par.getDimS() + ", " + par.getDimI() + ") " + numberOfTestcases + " mit Offset " + offset + " berechnet.\n");
                System.out.println("Bugs: " + bug);
            }
        }
        LogService.logDBClose();
        System.out.println("Stop: " + new Date());
    }

    public static void writeTestcase(Parameter par, long seed, int distrib, boolean writeSolution) {
        ProductionIPGenerator.writeTestcase(par, seed, distrib, writeSolution, algo);
    }

    public static void writeTestcase(Parameter par, long seed, int distrib, boolean writeSolution, AlgoType algo) {
        Random gen = new Random(seed);
        MultiDatabase d = new MultiDatabase(file, par);
        LinkedList<Element> res = new LinkedList<Element>();
        String[] s = new String[par.getDim()];
        String[] sStr = new String[par.getDimS()];
        String[] iStr = new String[par.getDimI()];
        String[][] hit = null;
        List<Map.Entry<Element, MultiStringElement>> dump = null;
        HashMap<Element, MultiHitterInfo> partAncHitters = null;
        double epsilon = 0.0;
        double phi = 0.0;
        int N = 0;
        int rep = -1;
        for (int i = 0; i < 10; ++i) {
            gen.nextDouble();
        }
        switch (distrib) {
            case 1: {
                phi = gen.nextDouble() * 0.35;
                N = 15 + (int)seed / 10000;
                epsilon = gen.nextDouble() * phi;
                hit = ProductionIPGenerator.getTinyHitters();
                break;
            }
            case 3: {
                phi = gen.nextDouble() * 0.3;
                N = 10000 + (int)seed / 100;
                epsilon = gen.nextDouble() * phi;
                hit = ProductionIPGenerator.getMediumHitters();
                break;
            }
            case 2: {
                phi = gen.nextDouble() * 0.05 + 0.005;
                if (gen.nextInt(10) > 7) {
                    phi *= 4.0;
                }
                epsilon = gen.nextDouble() * phi;
                N = 100000;
                if (gen.nextInt(10) > 8) {
                    N *= 10;
                }
                hit = ProductionIPGenerator.getHitters();
                break;
            }
            case 16: {
                phi = gen.nextDouble() * 0.05 + 0.005;
                if (gen.nextInt(10) > 7) {
                    phi *= 4.0;
                }
                epsilon = gen.nextDouble() * phi;
                N = 10000;
                hit = ProductionIPGenerator.getHitters();
                break;
            }
            case 32: {
                phi = gen.nextDouble() * 0.05 + 0.005;
                if (gen.nextInt(10) > 7) {
                    phi *= 4.0;
                }
                epsilon = 0.0;
                N = 10000;
                hit = ProductionIPGenerator.getHitters();
            }
        }
        int min = (int)Math.ceil(phi * (double)N);
        for (int i = 0; i < hit.length; ++i) {
            for (int k = 0; k < min; ++k) {
                int n;
                s = new String[par.getDim()];
                s[0] = hit[i][0];
                s[1] = hit[i][1];
                switch (distrib) {
                    case 1: {
                        s = ProductionIPGenerator.randomTinyCompletion(s, gen);
                        break;
                    }
                    case 3: {
                        s = ProductionIPGenerator.randomMediumCompletion(s, gen);
                        break;
                    }
                    case 2: 
                    case 16: 
                    case 32: {
                        s = ProductionIPGenerator.randomCompletion(s, gen);
                    }
                }
                if (LogService.shouldLog(1)) {
                    LogService.log(1, s[0] + ", " + s[1]);
                }
                sStr = new String[par.getDimS()];
                iStr = new String[par.getDimI()];
                for (n = 0; n < par.getDimS(); ++n) {
                    sStr[n] = s[n];
                }
                for (n = 0; n < par.getDimI(); ++n) {
                    iStr[n] = s[n + par.getDimS()];
                }
                res.add(Element.createElement(sStr, iStr, par));
            }
        }
        int counter = res.size();
        while (counter < N) {
            s = new String[par.getDim()];
            s[0] = "";
            s[1] = "";
            switch (distrib) {
                case 1: {
                    s = ProductionIPGenerator.randomTinyCompletion(s, gen);
                    break;
                }
                case 3: {
                    s = ProductionIPGenerator.randomMediumCompletion(s, gen);
                    break;
                }
                case 2: 
                case 16: 
                case 32: {
                    s = ProductionIPGenerator.randomCompletion(s, gen);
                }
            }
            rep = distrib == 16 ? gen.nextInt(20) : 6;
            for (int i = 0; i < rep; ++i) {
                int n;
                if (counter >= N) continue;
                sStr = new String[par.getDimS()];
                iStr = new String[par.getDimI()];
                for (n = 0; n < par.getDimS(); ++n) {
                    sStr[n] = s[n];
                }
                for (n = 0; n < par.getDimI(); ++n) {
                    iStr[n] = s[n + par.getDimS()];
                }
                res.add(Element.createElement(sStr, iStr, par));
                ++counter;
            }
        }
        Collections.shuffle(res, gen);
        if (writeSolution) {
            AbstractHHH hitterAlgo;
            switch (algo) {
                case FULL_ANC: {
                    hitterAlgo = new FullAncHHH(epsilon, par);
                    break;
                }
                case PART_ANC: {
                    hitterAlgo = new PartAncHHH(epsilon, par);
                    break;
                }
                case OLD_FULL_ANC: {
                    hitterAlgo = new OLD_FullAncHHH(epsilon, par);
                    break;
                }
                case OLD_PART_ANC: {
                    hitterAlgo = new OLD_PartAncHHH(epsilon, par);
                    break;
                }
                default: {
                    throw new RuntimeException("Kein Algorithmus gewaehlt");
                }
            }
            for (Element element : res) {
                hitterAlgo.insert(element.clone(), 1, true);
            }
            dump = algo == AlgoType.PART_ANC || algo == AlgoType.FULL_ANC ? ((AbstractComplexHHH)hitterAlgo).dumpTrie() : ((OLD_AbstractComplexHHH)hitterAlgo).dumpTrie();
            partAncHitters = hitterAlgo.outputSet(phi);
        }
        d.openWrite();
        d.println("# Synthetische Daten, erzeugt: " + new Date());
        d.println("#");
        d.println("#? Geschrieben von ProductionIP-Generator (Generic) mit seed " + seed);
        d.println("#");
        d.println("# Parameter: \n" + par);
        d.println("# Tats\u00e4chliche Dimensionen f\u00fcr String und Int:");
        d.println("#$ " + par.getDimS() + " | " + par.getDimI());
        d.println("#");
        d.println("# N, phi, Epsilon");
        d.println("#% " + N + " | " + phi + " | " + epsilon);
        d.println("#");
        d.println("#");
        for (int i = 0; i < hit.length; ++i) {
            d.println("#@ " + hit[i][0] + " | " + hit[i][1] + " | " + min);
        }
        d.println("#\n#\n#");
        if (writeSolution) {
            d.println("# Algo: " + (Object)((Object)algo));
            d.println("# Epsilon: " + epsilon);
            d.println("# Phi: " + phi);
            d.println("# Ausgegebene HHH: Praefix, fmin, fmax, F");
            for (Map.Entry<Element, MultiHitterInfo> entry : partAncHitters.entrySet()) {
                d.println("#= " + entry.getKey().get(0) + " | " + entry.getKey().get(1) + " | " + entry.getValue().fmin + " | " + entry.getValue().fmax + " | " + entry.getValue().F);
            }
            d.println("#\n#\n#");
            d.println("# Datenstruktur nach Einf\u00fcgen aller Items: Praefix, g, m, delta");
            for (Map.Entry<Element, Comparable<MultiHitterInfo>> entry : dump) {
                d.println("#* " + entry.getKey().get(0) + " | " + entry.getKey().get(1) + " | " + ((MultiStringElement)entry.getValue()).g + " | " + ((MultiStringElement)entry.getValue()).m + " | " + ((MultiStringElement)entry.getValue()).delta);
            }
            d.println("#\n#\n#");
        }
        for (Element element : res) {
            d.println(element.get(0) + " | " + element.get(1));
        }
        d.closeWrite();
    }

    private static String[] randomTinyCompletion(String[] s, Random gen) {
        int j;
        for (j = s[0].length() / 2; j < 2; ++j) {
            s[0] = s[0] + "/" + (gen.nextInt(2) + 1);
        }
        for (j = s[1].length() / 2; j < 1; ++j) {
            s[1] = s[1] + "/" + (gen.nextInt(2) + 1);
        }
        return s;
    }

    private static String[] randomMediumCompletion(String[] s, Random gen) {
        int j;
        for (j = s[0].length() / 2; j < 2; ++j) {
            s[0] = s[0] + "/" + (gen.nextInt(4) + 1);
        }
        for (j = s[1].length() / 2; j < 2; ++j) {
            s[1] = s[1] + "/" + (gen.nextInt(4) + 1);
        }
        return s;
    }

    private static String[] randomCompletion(String[] s, Random gen) {
        int j;
        for (j = s[0].length() / 2; j < 5; ++j) {
            s[0] = s[0] + "/" + (gen.nextInt(4) + 1);
        }
        for (j = s[1].length() / 2; j < 5; ++j) {
            s[1] = s[1] + "/" + (gen.nextInt(4) + 1);
        }
        return s;
    }

    private static String[][] getTinyHitters() {
        String[][] hit = new String[][]{{"/1", ""}, {"/2", ""}};
        return hit;
    }

    private static String[][] getMediumHitters() {
        String[][] hit = new String[][]{{"/1", ""}, {"/2", ""}};
        return hit;
    }

    private static String[][] getHitters() {
        String[][] hit = new String[][]{{"/1", ""}, {"", "/2"}, {"/1", "/3"}, {"/2", "/4"}};
        return hit;
    }

    public static boolean test(String file, Parameter par, double phi, double epsilon, boolean compareToFileSolution) {
        return ProductionIPGenerator.test(file, par, phi, epsilon, compareToFileSolution, algo);
    }

    public static boolean test(String file, Parameter par, double phi, double epsilon, boolean compareToFileSolution, AlgoType algo) {
        boolean erg;
        if (algo == AlgoType.PART_ANC || algo == AlgoType.FULL_ANC) {
            AbstractComplexHHH hitter = ProductionIPGenerator.fillApprox(file, par, epsilon, algo);
            erg = HitterPolice.check(file, hitter, par, phi, false);
            if (compareToFileSolution) {
                erg = erg && HitterPolice.compareToSolution(file, hitter, par, phi, false);
            }
        } else {
            OLD_AbstractComplexHHH oldHitter = ProductionIPGenerator.fillOld(file, par, epsilon, algo);
            erg = HitterPolice.check(file, oldHitter, par, phi, false);
            if (compareToFileSolution) {
                throw new RuntimeException("Nicht impl.: Test fuer OLD_ ohne compareToFileSolution starten.");
            }
        }
        return erg;
    }

    public static boolean compareToExact(String file, Parameter par, double phi) {
        HitterComparator hitterComparator = new HitterComparator();
        MultiDatabase d = new MultiDatabase(file, par);
        d.openRead();
        HashMap<Element, MultiHitterInfo> solutionHitters = d.readSolution();
        double filePhi = d.getPhi();
        double fileEpsilon = d.getEpsilon();
        d.closeRead();
        if (Math.abs(phi - filePhi) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Phi-Werte in Datei und Methodenaufruf: " + phi + ", " + filePhi);
        }
        if (Math.abs(fileEpsilon) > 1.0E-10) {
            throw new RuntimeException("Epsilon > 0");
        }
        HashMap<Element, MultiHitterInfo> exactHitters = ProductionIPGenerator.calcExact(file, par, phi);
        ArrayList<Map.Entry<Element, MultiHitterInfo>> exHitterList = new ArrayList<Map.Entry<Element, MultiHitterInfo>>(exactHitters.entrySet());
        ArrayList<Map.Entry<Element, MultiHitterInfo>> solHitterList = new ArrayList<Map.Entry<Element, MultiHitterInfo>>(solutionHitters.entrySet());
        Collections.sort(exHitterList, hitterComparator);
        Collections.sort(solHitterList, hitterComparator);
        return solutionHitters.equals(exactHitters);
    }

    public static void evaluationStability(String file, Parameter par, double phi, double epsilon, long seed) {
        Random gen = new Random(seed);
        AbstractComplexHHH fastPA = ProductionIPGenerator.fillApprox(file, par, epsilon);
        HashSet<Element> original = new HashSet<Element>();
        HashSet<Element> noise = new HashSet<Element>();
        Set<Element> tmp = fastPA.outputSet(phi).keySet();
        for (Element el : tmp) {
            original.add(el);
        }
        MultiDatabase d = new MultiDatabase(file, par);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        for (int round = 0; round < 30; ++round) {
            AbstractComplexHHH noisePA;
            switch (algo) {
                case FULL_ANC: {
                    noisePA = new FullAncHHH(epsilon, par);
                    break;
                }
                case PART_ANC: {
                    noisePA = new PartAncHHH(epsilon, par);
                    break;
                }
                default: {
                    throw new RuntimeException("Kein Algorithmus gewaehlt");
                }
            }
            int man = gen.nextInt(400);
            for (int k = 0; k < man; ++k) {
                data.remove(gen.nextInt(data.size()));
            }
            for (Element element : data) {
                noisePA.insert(element, 1, true);
            }
            tmp = noisePA.outputSet(phi).keySet();
            for (Element el : tmp) {
                noise.add(el);
            }
            System.out.println(Evaluation.compactHierarch(original, noise));
        }
    }

    public static Exact fillExact(String file, Parameter par) {
        Exact myExact = new Exact(par);
        MultiDatabase d = new MultiDatabase(file, par);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        for (Element element : data) {
            myExact.insert(element, 1, true);
        }
        return myExact;
    }

    public static HashMap<Element, MultiHitterInfo> calcExact(String file, Parameter par, double phi) {
        Exact myExact = ProductionIPGenerator.fillExact(file, par);
        return myExact.outputSet(phi);
    }

    public static AbstractComplexHHH fillApprox(String file, Parameter par, double epsilon) {
        return ProductionIPGenerator.fillApprox(file, par, epsilon, algo);
    }

    public static AbstractComplexHHH fillApprox(String file, Parameter par, double epsilon, AlgoType algo) {
        AbstractComplexHHH fastPA;
        MultiDatabase d = new MultiDatabase(file, par);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        switch (algo) {
            case FULL_ANC: {
                fastPA = new FullAncHHH(epsilon, par);
                break;
            }
            case PART_ANC: {
                fastPA = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Kein Algorithmus gewaehlt");
            }
        }
        for (Element element : data) {
            fastPA.insert(element, 1, true);
        }
        return fastPA;
    }

    public static OLD_AbstractComplexHHH fillOld(String file, Parameter par, double epsilon, AlgoType algo) {
        OLD_AbstractComplexHHH hitterAlgo;
        MultiDatabase d = new MultiDatabase(file, par);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        switch (algo) {
            case OLD_FULL_ANC: {
                hitterAlgo = new OLD_FullAncHHH(epsilon, par);
                break;
            }
            case OLD_PART_ANC: {
                hitterAlgo = new OLD_PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Kein Algorithmus gewaehlt");
            }
        }
        for (Element element : data) {
            hitterAlgo.insert(element, 1, true);
        }
        return hitterAlgo;
    }

    public static HashMap<Element, MultiHitterInfo> calcApprox(String file, Parameter par, double phi, double epsilon) {
        AbstractComplexHHH fastPA = ProductionIPGenerator.fillApprox(file, par, epsilon);
        return fastPA.outputSet(phi);
    }

    public static boolean streamTest(String file, Parameter par, double phi, double epsilon) {
        AbstractComplexHHH fastPA;
        int buffersize = 100;
        int count = 0;
        MultiDatabase d = new MultiDatabase(file, par);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        long lines = data.size();
        HashMultiset<Element> container = HashMultiset.create();
        StreamReader reader = new StreamReader(par);
        switch (algo) {
            case FULL_ANC: {
                fastPA = new FullAncHHH(epsilon, par);
                break;
            }
            case PART_ANC: {
                fastPA = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Kein Algorithmus gewaehlt");
            }
        }
        if (LogService.shouldLog(1)) {
            LogService.log(1, "Start: " + new Date());
        }
        while ((long)count < lines) {
            int remaining = Math.min(buffersize, (int)lines - count);
            reader.readLoop(container, remaining);
            count += container.size();
            for (Element e : container.elementSet()) {
                fastPA.insert(e, container.count(e), true);
            }
        }
        reader.close();
        System.out.println("Stop: " + new Date());
        if (LogService.shouldLog(1)) {
            LogService.log(1, "Stop: " + new Date());
            LogService.log(1, "tupel: = " + fastPA.getTupelCount() + "  " + new Date() + "reach= " + fastPA.reach + "  unreach " + fastPA.unreach + "Stop Insert");
        }
        boolean erg = HitterPolice.check(file, fastPA, par, phi, false);
        return erg;
    }

    static double readPhi(Parameter par) {
        MultiDatabase d = new MultiDatabase(file, par);
        double phi = d.getPhi();
        return phi;
    }

    static double readEpsilon(Parameter par) {
        MultiDatabase d = new MultiDatabase(file, par);
        double epsilon = d.getEpsilon();
        return epsilon;
    }

    private static void printSetup(Parameter par, int numberOfTestcases, int offset, boolean writeSolution, boolean compareToFileSolution) {
        System.out.println("\nAlgo = " + (Object)((Object)algo) + "\nBenutze Datei " + file + " NumberOfTestcases: " + numberOfTestcases + " mit Offset " + offset + "\nParameter:\n" + par + "\nmode=" + ProductionIPGenerator.modeString(mode) + "\ndistr=" + ProductionIPGenerator.distrString(distr) + "\nWriteSolution=" + writeSolution + "\nCompareToFileSolution=" + compareToFileSolution + "\n");
        if (par.mBug()) {
            System.out.println("\n\n ************* MBUG ist eingeschaltet! *****************\n\n");
        }
        if (par.bProb()) {
            System.out.println("\n\n ************* BPROB ist eingeschaltet! *****************\n\n");
        }
    }

    private static String modeString(int mode) {
        String s = "";
        switch (mode) {
            case 1: {
                s = "MULTIPLE";
                break;
            }
            case 2: {
                s = "OLD";
                break;
            }
            case 3: {
                s = "BATCHOLD";
                break;
            }
            case 4: {
                s = "MULTICOMPARE";
                break;
            }
            case 8: {
                s = "MULTICOMPARE_2";
                break;
            }
            case 5: {
                s = "STREAM";
                break;
            }
            case 6: {
                s = "EXACT";
                break;
            }
            case 7: {
                s = "QUALITY";
                break;
            }
            case 9: {
                s = "EVALUATION";
                break;
            }
            case 10: {
                s = "FORKCHECK";
            }
        }
        return s;
    }

    private static String distrString(int distr) {
        String s = "";
        switch (distr) {
            case 1: {
                s = "TINY";
                break;
            }
            case 2: {
                s = "UNIBIG";
                break;
            }
            case 3: {
                s = "MEDIUM";
                break;
            }
            case 16: {
                s = "SKEWED";
                break;
            }
            case 32: {
                s = "EPSI_0";
            }
        }
        return s;
    }
}

