/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.Exact;
import hitters.multi.MultiDatabase;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EvaluationTest {
    Parameter par;
    AbstractComplexHHH pa;
    List<Element> list = new ArrayList<Element>();
    List<Element> ogmList = new ArrayList<Element>();
    List<Element> bigList = new ArrayList<Element>();

    @Before
    public void setUp() throws Exception {
        String[][] u;
        String[][] s;
        byte[][] plength = new byte[][]{};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        for (String[] eInt : s = new String[][]{{"/1/1", "/1"}, {"/1/1", "/2"}, {"/1/1", "/3"}, {"/1/2", "/1"}, {"/1/2", "/2"}, {"/1/2", "/3"}, {"/1/3", "/1"}, {"/1/3", "/2"}, {"/1/3", "/3"}, {"/1/4", "/1"}, {"/1/4", "/2"}, {"/1/4", "/3"}}) {
            this.list.add(Element.createElement(eInt, null, this.par));
        }
        this.ogmList.add(Element.createElement(s[0], null, this.par));
        this.ogmList.add(Element.createElement(s[1], null, this.par));
        this.ogmList.add(Element.createElement(s[2], null, this.par));
        String[][] t = new String[][]{{"*", "/1"}, {"/1", "/3"}, {"/1", "*"}, {"*", "*"}};
        this.ogmList.add(Element.createElement(t[0], null, this.par));
        this.ogmList.add(Element.createElement(t[1], null, this.par));
        this.ogmList.add(Element.createElement(t[2], null, this.par));
        this.ogmList.add(Element.createElement(t[3], null, this.par));
        for (int i = 0; i < 8; ++i) {
            this.bigList.add(Element.createElement(s[i], null, this.par));
        }
        for (String[] eInt : u = new String[][]{{"/1", "/3"}, {"/1/2", "*"}, {"/1/1", "*"}, {"/1", "/2"}, {"/1", "/1"}, {"/1/3", "*"}, {"*", "/3"}, {"/1", "*"}, {"*", "/2"}, {"*", "/1"}, {"*", "*"}}) {
            this.bigList.add(Element.createElement(eInt, null, this.par));
        }
    }

    @Test
    public void testJaccardAndDice() {
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        this.fill(approx, 0, 8);
        this.fill(exact, 8, 11);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 0.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 0.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 0.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 0.0) < 1.0E-12);
        this.fill(approx, 0, 12);
        this.fill(exact, 0, 12);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 1.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 1.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 1.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 1.0) < 1.0E-12);
        this.fill(approx, 0, 0);
        this.fill(exact, 7, 11);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 0.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 0.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 0.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 0.0) < 1.0E-12);
        this.fill(approx, 0, 8);
        this.fill(exact, 7, 12);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 0.08333333333333333) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 0.15384615384615385) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 0.125) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 0.2) < 1.0E-12);
        this.fill(approx, 5, 12);
        this.fill(exact, 1, 9);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 0.36363636363636365) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 0.5333333333333333) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 0.5714285714285714) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 0.5) < 1.0E-12);
        this.fill(approx, 0, 11);
        this.fill(exact, 2, 12);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 0.75) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 0.8571428571428571) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 0.8181818181818182) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 0.9) < 1.0E-12);
        this.fill(approx, 0, 12);
        this.fill(exact, 1, 11);
        Assert.assertTrue(Math.abs(Evaluation.jaccard(approx, exact) - 0.8333333333333334) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dice(approx, exact) - 0.9090909090909091) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.precision(approx, exact) - 0.8333333333333334) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.recall(approx, exact) - 1.0) < 1.0E-12);
    }

    @Test
    public void testOgmGanesan() {
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        this.clear(approx, exact);
        approx.add(this.ogmList.get(0).clone());
        exact.add(this.ogmList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.6666666666666666) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.ogmList.get(0).clone());
        exact.add(this.ogmList.get(0).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.ogmList.get(0).clone());
        exact.add(this.ogmList.get(2).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.6666666666666666) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.ogmList.get(0).clone());
        exact.add(this.ogmList.get(3).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.6666666666666666) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.ogmList.get(0).clone());
        exact.add(this.ogmList.get(4).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.4166666666666667) < 1.0E-12);
        this.clear(approx, exact);
        exact.add(this.ogmList.get(6).clone());
        approx.add(this.ogmList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.5) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.ogmList.get(0).clone());
        approx.add(this.ogmList.get(4).clone());
        exact.add(this.ogmList.get(3).clone());
        exact.add(this.ogmList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.7083333333333334) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(1).clone());
        approx.add(this.bigList.get(8).clone());
        approx.add(this.bigList.get(17).clone());
        exact.add(this.bigList.get(2).clone());
        exact.add(this.bigList.get(6).clone());
        exact.add(this.bigList.get(9).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact) - 0.6944444444444444) < 1.0E-12);
    }

    @Test
    public void testOgmCormode() {
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(0).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - 1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(2).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(3).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(4).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -3.0) < 1.0E-12);
        this.clear(approx, exact);
        exact.add(this.bigList.get(6).clone());
        approx.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -3.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        approx.add(this.bigList.get(4).clone());
        exact.add(this.bigList.get(3).clone());
        exact.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -3.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(1).clone());
        approx.add(this.bigList.get(8).clone());
        approx.add(this.bigList.get(17).clone());
        exact.add(this.bigList.get(2).clone());
        exact.add(this.bigList.get(6).clone());
        exact.add(this.bigList.get(9).clone());
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - -4.0) < 1.0E-12);
    }

    @Test
    public void testBgm() {
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - -3.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(0).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - 1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(2).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - -3.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(4).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - -7.0) < 1.0E-12);
        this.clear(approx, exact);
        exact.add(this.bigList.get(6).clone());
        approx.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - -7.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        approx.add(this.bigList.get(9).clone());
        exact.add(this.bigList.get(3).clone());
        exact.add(this.bigList.get(16).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - -6.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(1).clone());
        approx.add(this.bigList.get(8).clone());
        approx.add(this.bigList.get(17).clone());
        exact.add(this.bigList.get(2).clone());
        exact.add(this.bigList.get(6).clone());
        exact.add(this.bigList.get(9).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm(approx, exact) - -9.0) < 1.0E-12);
    }

    @Test
    public void testBgm2() {
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.6666666666666666) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(0).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(2).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.6666666666666666) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        exact.add(this.bigList.get(4).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.3333333333333333) < 1.0E-12);
        this.clear(approx, exact);
        exact.add(this.bigList.get(6).clone());
        approx.add(this.bigList.get(1).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.3333333333333333) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(0).clone());
        approx.add(this.bigList.get(9).clone());
        exact.add(this.bigList.get(3).clone());
        exact.add(this.bigList.get(16).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.5833333333333334) < 1.0E-12);
        this.clear(approx, exact);
        approx.add(this.bigList.get(1).clone());
        approx.add(this.bigList.get(8).clone());
        approx.add(this.bigList.get(17).clone());
        exact.add(this.bigList.get(2).clone());
        exact.add(this.bigList.get(6).clone());
        exact.add(this.bigList.get(9).clone());
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.6944444444444444) < 1.0E-12);
    }

    @Test
    public void testbgm2HHH() {
        String dir = "resources/testcase/Evaluation/";
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        Parameter myParams = new Parameter(2);
        String[][] s = new String[][]{{"*", "/2"}, {"*", "*"}, {"/2", "/2"}, {"/2", "*"}};
        Set<Element> tmp1 = this.hittersPA(dir + "Eva7");
        Set<Element> tmp2 = this.hittersExact(dir + "Eva7");
        for (Element el : tmp1) {
            approx.add(el);
        }
        for (Element el : tmp2) {
            exact.add(el);
        }
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 1.0) < 1.0E-12);
        Element e = Element.createElement(s[0], null, myParams);
        approx.add(e);
        e = Element.createElement(s[1], null, myParams);
        exact.add(e);
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.75) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.bgm2(exact, approx) - 0.75) < 1.0E-12);
        e = Element.createElement(s[2], null, myParams);
        approx.add(e);
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.7) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.bgm2(exact, approx) - 0.7) < 1.0E-12);
        e = Element.createElement(s[3], null, myParams);
        exact.add(e);
        Assert.assertTrue(Math.abs(Evaluation.bgm2(approx, exact) - 0.75) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.bgm2(exact, approx) - 0.75) < 1.0E-12);
    }

    @Test
    public void testOgmHHH() {
        Set<Element> exact;
        String dir = "resources/testcase/Evaluation/";
        Set<Element> approx = this.hittersPA(dir + "Eva1");
        Assert.assertTrue(Math.abs(Evaluation.ogmGanesan(approx, exact = this.hittersExact(dir + "Eva1")) - 1.0) < 1.0E-12);
        this.clear(approx, exact);
        approx = this.hittersPA(dir + "Eva1");
        exact = this.hittersExact(dir + "Eva1");
        Assert.assertTrue(Math.abs(Evaluation.ogmCormode(approx, exact) - 1.0) < 1.0E-12);
        System.out.println(Evaluation.evaluate(approx, exact));
    }

    @Test
    public void testDsmHHH() {
        String dir = "resources/testcase/Evaluation/";
        Parameter myParams = new Parameter(2);
        String[][] s = new String[][]{{"/2", "/2"}, {"*", "/2"}, {"/2/2", "*"}, {"*", "/1"}};
        Map<Element, Integer> approxDs = this.hittersPADataStruct(dir + "Eva7");
        Map<Element, Integer> exactDs = this.hittersExactDataStruct(dir + "Eva7");
        Assert.assertTrue(Math.abs(Evaluation.dsm(approxDs, approxDs) - 1.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dsm(exactDs, exactDs) - 1.0) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dsm(approxDs, exactDs) - 0.3333333333333333) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dsm(exactDs, approxDs) - 0.3333333333333333) < 1.0E-12);
        Element e = Element.createElement(s[0], null, myParams);
        approxDs.put(e, 3);
        e = Element.createElement(s[1], null, myParams);
        approxDs.put(e, 2);
        Assert.assertTrue(Math.abs(Evaluation.dsm(approxDs, exactDs) - 0.46296296296296297) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dsm(exactDs, approxDs) - 0.46296296296296297) < 1.0E-12);
        e = Element.createElement(s[2], null, myParams);
        approxDs.put(e, 3);
        Assert.assertTrue(Math.abs(Evaluation.dsm(approxDs, exactDs) - 0.44074074074074077) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dsm(exactDs, approxDs) - 0.44074074074074077) < 1.0E-12);
        e = Element.createElement(s[3], null, myParams);
        approxDs.put(e, 5);
        exactDs.put(e, 2);
        Assert.assertTrue(Math.abs(Evaluation.dsm(approxDs, exactDs) - 0.5042328042328043) < 1.0E-12);
        Assert.assertTrue(Math.abs(Evaluation.dsm(exactDs, approxDs) - 0.5042328042328043) < 1.0E-12);
    }

    @Test
    public void testDA() {
        HashSet<Element> approx = new HashSet<Element>();
        HashSet<Element> exact = new HashSet<Element>();
        HashSet<Element> third = new HashSet<Element>();
        String[][] u = new String[][]{{"/FILESYS/read"}, {"/FILESYS/open/WR_ONLY"}, {"/INFO/gettimeofday"}, {"/FILESYS/open"}, {"/PROCMEM/clone"}, {"/FILESYS"}, {"/FILESYS/open"}, {"/PROCMEM/clone"}};
        byte[][] plength = new byte[][]{};
        this.par = new Parameter(1 - plength.length, plength);
        approx.add(Element.createElement(u[0], null, this.par));
        approx.add(Element.createElement(u[1], null, this.par));
        approx.add(Element.createElement(u[2], null, this.par));
        exact.add(Element.createElement(u[3], null, this.par));
        exact.add(Element.createElement(u[4], null, this.par));
        third.add(Element.createElement(u[5], null, this.par));
        third.add(Element.createElement(u[6], null, this.par));
        third.add(Element.createElement(u[7], null, this.par));
        System.out.println("C1 = " + approx + "  \n\n C2 = " + exact + "\n\n C3 = " + third);
        System.out.println(Evaluation.evaluate(approx, exact) + "\n\n");
        System.out.println(Evaluation.evaluate(third, exact) + "\n\n");
    }

    private void clear(Set<Element> approx, Set<Element> exact) {
        approx.clear();
        exact.clear();
    }

    private void fill(Set<Element> set, int lo, int hi) {
        if (lo < 0 || hi > this.list.size()) {
            throw new RuntimeException("Unpassende Schranken.");
        }
        set.clear();
        for (int i = lo; i < hi; ++i) {
            set.add(this.list.get(i).clone());
        }
    }

    private Set<Element> hittersPA(String testcase) {
        Parameter myParams = new Parameter(2);
        MultiDatabase d = new MultiDatabase(testcase, myParams);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        double phi = d.getPhi();
        PartAncHHH hitterAlgo = new PartAncHHH(d.getEpsilon(), myParams);
        for (Element e : data) {
            hitterAlgo.insert(e, 1);
        }
        return hitterAlgo.outputSet(phi).keySet();
    }

    private Set<Element> hittersExact(String testcase) {
        Parameter myParams = new Parameter(2);
        MultiDatabase d = new MultiDatabase(testcase, myParams);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        double phi = d.getPhi();
        Exact hitterAlgo = new Exact(myParams);
        for (Element e : data) {
            hitterAlgo.insert(e, 1);
        }
        return hitterAlgo.outputSet(phi).keySet();
    }

    private Map<Element, Integer> hittersPADataStruct(String testcase) {
        Parameter myParams = new Parameter(2);
        MultiDatabase d = new MultiDatabase(testcase, myParams);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        PartAncHHH hitterAlgo = new PartAncHHH(d.getEpsilon(), myParams);
        for (Element e : data) {
            hitterAlgo.insert(e, 1);
        }
        return hitterAlgo.dumpf();
    }

    private Map<Element, Integer> hittersExactDataStruct(String testcase) {
        Parameter myParams = new Parameter(2);
        MultiDatabase d = new MultiDatabase(testcase, myParams);
        d.openRead();
        Vector<Element> data = d.readElements();
        d.closeRead();
        Exact hitterAlgo = new Exact(myParams);
        for (Element e : data) {
            hitterAlgo.insert(e, 1);
        }
        return hitterAlgo.dumpf();
    }
}

