/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.Element;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElementTest {
    Element[] aUnsort = new Element[9];
    Element[] aSorted = new Element[9];
    AbstractComplexHHH pa;
    Parameter par;

    @Before
    public void setUp() throws Exception {
        String[] md;
        String[] eInt;
        int i;
        byte[][] plength = new byte[][]{{0, 8, 16, 24, 32}, {0, 8, 16, 24, 32}};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        String[] st = new String[]{"/1/3/4/1", "/1/3/5/3", "/1/3/4/1", "/1/5/2/1", "/1/5/9/1", "/1/3/4/1", "/1/5/9/1", "/1/3/4/1", "/1/5/9/1", "/1/5/9/6", "/2/4/4/7", "/2/5/1/9", "/3/5/2/7", "/3/5/2/8", "/3/5/2/9", "/3/5/6/1", "/3/5/7/8", "/1/3/4/1"};
        int off = 6;
        for (i = 0; i < this.aUnsort.length; ++i) {
            eInt = new String[]{st[(2 * i + off) % 18], st[(2 * i + off + 1) % 18]};
            md = new String[]{};
            this.aUnsort[i] = Element.createElement(md, eInt, this.par);
        }
        for (i = 0; i < this.aSorted.length; ++i) {
            eInt = new String[]{st[2 * i], st[2 * i + 1]};
            md = new String[]{};
            this.aSorted[i] = Element.createElement(md, eInt, this.par);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield1() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/256", "/102/110/101/104"};
        Element a = Element.createElement(md, s1, this.par);
        a.setTo(a);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield2() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/122", "/102/257/101/104"};
        Element a = Element.createElement(md, s1, this.par);
        a.setTo(a);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield3() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/256", "/102/110/101/104"};
        String[] s2 = new String[]{"/127/112/111/109", "/102/110/101"};
        Element a = Element.createElement(md, s2, this.par);
        a.setTo(null, s1);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield4() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/122", "/102/257/101/104"};
        String[] s2 = new String[]{"/127/112/111/109", "/102/110/101"};
        Element a = Element.createElement(md, s2, this.par);
        a.setTo(null, s1);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield5() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/0/122", "/102/257/101/104"};
        Element a = Element.createElement(md, s1, this.par);
        a.setTo(a);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield6() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/122", "/102/257/101/0"};
        Element a = Element.createElement(md, s1, this.par);
        a.setTo(a);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield7() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/-7/111/122", "/102/257/101/104"};
        Element a = Element.createElement(md, s1, this.par);
        a.setTo(a);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield8() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/122", "/102/257/-1/104"};
        Element a = Element.createElement(md, s1, this.par);
        a.setTo(a);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield9() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/122", "/102/257/0/104"};
        String[] s2 = new String[]{"/127/112/111/109", "/102/110/101"};
        Element a = Element.createElement(md, s2, this.par);
        a.setTo(null, s1);
    }

    @Test(expected=NumberFormatException.class)
    public final void testBitfield10() {
        String[] md = new String[]{};
        String[] s1 = new String[]{"/127/112/111/0", "/102/257/10/104"};
        String[] s2 = new String[]{"/127/112/111/109", "/102/110/101"};
        Element a = Element.createElement(md, s2, this.par);
        a.setTo(null, s1);
    }

    @Test
    public final void testBitfieldLarge() {
        String[] s1 = new String[]{"/127/112/111/109", "/102/110/101/104"};
        String[] s2 = new String[]{"/127/112/111/109", "/102/110/101"};
        String[] s3 = new String[]{"/128/112/111/154", "/102/110/101/104"};
        String[] s4 = new String[]{"/128/112/111/154", "/102/110/101"};
        String[] md = new String[]{};
        Element a = Element.createElement(md, s1, this.par);
        md = new String[]{};
        Element b = Element.createElement(md, s2, this.par);
        a.setTo(b);
        md = new String[]{};
        a = Element.createElement(md, s3, this.par);
        md = new String[]{};
        a = Element.createElement(md, s4, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
        a.setTo(null, s1);
        a.setTo(null, s2);
        a.setTo(null, s3);
        a.setTo(null, s4);
    }

    @Test
    public final void testSetTo() {
        String[] s1 = new String[]{"/9/9/9/9", "/3/4/5/6"};
        String[] s2 = new String[]{"/1/3/4/1", "/1/3/5/3"};
        String[] s3 = new String[]{"/1", "/1/3/5"};
        String[] s4 = new String[]{"*", "*"};
        String[] s5 = new String[]{"*", "/3/4"};
        String[] s6 = new String[]{"/9/9/9", "*"};
        String[] s11 = new String[]{"/9", "/3/4/5"};
        String[] s12 = new String[]{"/1/3/4/1", "/1/3/5"};
        String[] s13 = new String[]{"/127/112/111/109", "/102/110/101/104"};
        String[] s14 = new String[]{"/127/112/111/109", "/102/110/101"};
        String[] s15 = new String[]{"/128/112/111/154", "/102/110/101/104"};
        String[] s16 = new String[]{"/128/112/111/154", "/102/110/101"};
        int[] label = new int[]{1, 3};
        int[] label2 = new int[]{0, 0};
        int[] label5 = new int[]{0, 2};
        int[] label6 = new int[]{3, 0};
        int[] label7 = new int[]{3, 5};
        Element clone = this.aSorted[0].clone();
        String[] sLeer = new String[]{};
        this.aSorted[0].setTo(sLeer, s1);
        Assert.assertFalse(this.aSorted[0].equals(clone));
        Assert.assertTrue(this.aSorted[0].equals(this.aSorted[0]));
        Element a = clone.clone();
        a.setTo(this.aSorted[0]);
        Assert.assertTrue(this.aSorted[0].equals(a));
        clone.setTo(a);
        Assert.assertTrue(this.aSorted[0].equals(clone));
        clone.setTo(sLeer, s2);
        Assert.assertTrue(this.aSorted[0].equals(a));
        Assert.assertFalse(this.aSorted[0].compareTo(clone) == 0);
        Assert.assertTrue(this.aSorted[0].compareTo(a) == 0);
        Assert.assertFalse(this.aSorted[0].hashCode() == clone.hashCode());
        Assert.assertTrue(this.aSorted[0].hashCode() == a.hashCode());
        this.aSorted[0].setTo(sLeer, s2);
        Assert.assertTrue(this.aSorted[0].equals(clone));
        Assert.assertTrue(this.aSorted[0].compareTo(clone) == 0);
        Assert.assertTrue(this.aSorted[0].hashCode() == clone.hashCode());
        a = clone.clone();
        Element b = clone.clone();
        Assert.assertTrue(a.hasParent(0));
        Assert.assertTrue(a.hasParent(1));
        Assert.assertTrue(a.turnIntoParent(0));
        Assert.assertTrue(b.turnIntoParent(1));
        Assert.assertFalse(a.equals(clone));
        Assert.assertFalse(a.hashCode() == clone.hashCode());
        Assert.assertFalse(b.hashCode() == clone.hashCode());
        Assert.assertTrue(a.isGenOf(clone));
        Assert.assertTrue(b.isGenOf(clone));
        Assert.assertFalse(clone.isGenOf(a));
        Assert.assertFalse(clone.isGenOf(b));
        Assert.assertFalse(b.isGenOf(a));
        a.setTo(sLeer, s1);
        b.setTo(a);
        Assert.assertTrue(a.equals(b));
        a.turnIntoParent(1);
        Assert.assertFalse(a.equals(b));
        a.setTo(sLeer, s2);
        Assert.assertTrue(a.hashCode() == clone.hashCode());
        Assert.assertTrue(a.equals(clone));
        Assert.assertTrue(a.generalizeTo(label));
        b.setTo(sLeer, s3);
        Assert.assertTrue(a.hashCode() == b.hashCode());
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label6));
        a.setTo(sLeer, s2);
        Assert.assertTrue(a.generalizeTo(label2));
        b.setTo(sLeer, s4);
        Assert.assertTrue(a.hashCode() == b.hashCode());
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label));
        a.setTo(sLeer, s1);
        b.setTo(sLeer, s5);
        Assert.assertFalse(a.equals(b));
        Assert.assertTrue(a.generalizeTo(label5));
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label));
        a.setTo(sLeer, s1);
        b.setTo(sLeer, s6);
        Assert.assertFalse(a.equals(b));
        Assert.assertTrue(a.generalizeTo(label6));
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label));
        a.setTo(sLeer, s1);
        b.setTo(sLeer, s11);
        Assert.assertFalse(a.generalizeTo(label7));
        Assert.assertFalse(a.equals(b));
        Assert.assertTrue(a.generalizeTo(label));
        Assert.assertTrue(a.equals(b));
        a.setTo(null, s2);
        b.setTo(null, s2);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        Assert.assertTrue(a.hasParent(1));
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        Assert.assertTrue(a.equals(b));
        Assert.assertTrue(a.turnIntoParent(1));
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
        Assert.assertFalse(a.equals(b));
        b.setTo(null, s12);
        Assert.assertTrue(a.equals(b));
        String[] md = new String[]{};
        a = Element.createElement(md, s2, this.par);
        b = a.clone();
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        Assert.assertTrue(a.turnIntoParent(0));
        Assert.assertTrue(a.turnIntoParent(0));
        Assert.assertTrue(a.getLevel(0) == 2);
        Assert.assertTrue(a.getLevel(1) == 4);
        int cont = 0;
        while (a.hasParent(1)) {
            Assert.assertTrue(a.turnIntoParent(1));
            Assert.assertTrue(a.getLevel(0) == 2);
            Assert.assertTrue(a.getLevel(1) == 4 - ++cont);
        }
        Assert.assertTrue(b.getLevel(0) == 4);
        Assert.assertTrue(b.getLevel(1) == 4);
        md = new String[]{};
        a = Element.createElement(md, s13, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        md = new String[]{};
        a = Element.createElement(md, s14, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
        md = new String[]{};
        a = Element.createElement(md, s15, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        md = new String[]{};
        a = Element.createElement(md, s16, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
    }

    @Test
    public final void testSetToGlbOf() {
        int i;
        byte[][] plength = new byte[][]{{0, 4, 8, 12, 16, 20, 24, 28, 32}, {0, 4, 8, 12, 16, 20, 24, 28, 32}};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        String[][] s = new String[][]{{"/1/3/4/9", "/1/3/5/3/7/8/9/6"}, {"/1/3/4/1", "/1/3/5/3"}, {"/1", "/1/3/5/3/7/8"}, {"*", "*"}, {"*", "/1/3"}, {"/1/3/4/9/6", "*"}, {"/1/3/4/9/6", "/1/3/5/3/7/8"}, {"/1/3/4/9", "/1/3/5/3/7/8"}, {"/1/3/4/9/6", "/1/3/5/3/7/8/9/6"}, {"/4", "/1"}, {"/5", "/2"}};
        Element[] a = new Element[s.length];
        int[][] exp = new int[][]{{0, 1, -1}, {0, 2, 0}, {7, 0, 0}, {7, 2, 7}, {0, 3, 0}, {0, 4, 0}, {0, 5, 8}, {0, 6, 8}, {0, 7, 0}, {1, 7, -1}, {1, 3, 1}, {1, 4, 1}, {1, 5, -1}, {5, 6, 6}, {2, 3, 2}, {9, 10, -1}};
        Element glb = new Element(this.par);
        Element expected = new Element(this.par);
        String[] sEmpty = new String[]{};
        for (i = 0; i < s.length; ++i) {
            sEmpty = new String[]{};
            a[i] = Element.createElement(sEmpty, s[i], this.par);
        }
        for (i = 0; i < exp.length; ++i) {
            boolean possible = glb.setToGlbOf(a[exp[i][0]], a[exp[i][1]]);
            if (exp[i][2] >= 0) {
                expected.setTo(a[exp[i][2]]);
                Assert.assertTrue(glb.equals(expected));
                Assert.assertTrue(possible);
                continue;
            }
            Assert.assertFalse(a[exp[i][0]].equals(a[exp[i][1]]));
            Assert.assertFalse(possible);
        }
    }

    @Test
    public final void testLca() {
        Element lca;
        int i;
        byte[][] plength = new byte[][]{{0, 4, 8, 12, 16, 20, 24, 28, 32}, {0, 4, 8, 12, 16, 20, 24, 28, 32}};
        byte[][] plengthString = new byte[][]{};
        byte[][] plengthMix = new byte[][]{{0, 4, 8, 12, 16, 20, 24, 28, 32}};
        this.par = new Parameter(2 - plength.length, plength);
        Parameter parString = new Parameter(2, plengthString);
        Parameter parMix = new Parameter(1, plengthMix);
        String[][] s = new String[][]{{"/1/3/4/9", "/1/3/5/3/7/8/9/6"}, {"/1/3/4/1", "/1/3/5/3"}, {"/1/3/4", "/1/3/5/3"}, {"/1", "/1/3/5/3/4/8"}, {"/1", "/1/3/5/3"}, {"*", "*"}, {"*", "/1/3"}, {"/1/3/4/9/6", "*"}, {"/1/3/4", "*"}, {"*", "/1"}, {"/4", "/1"}, {"/5", "/2"}, {"/1", "*"}};
        Element[] a = new Element[s.length];
        Element[] b = new Element[s.length];
        Element[] c = new Element[s.length];
        int[][] exp = new int[][]{{0, 1, 2}, {0, 3, 4}, {1, 5, 5}, {3, 5, 5}, {2, 6, 6}, {4, 6, 6}, {1, 7, 8}, {3, 7, 12}, {10, 1, 9}, {10, 0, 9}, {3, 11, 5}, {1, 11, 5}, {7, 11, 5}, {10, 11, 5}};
        String[] tmp1 = new String[1];
        String[] tmp2 = new String[1];
        for (i = 0; i < s.length; ++i) {
            tmp1 = new String[1];
            tmp2 = new String[1];
            tmp1[0] = s[i][0];
            tmp2[0] = s[i][1];
            a[i] = Element.createElement(null, s[i], this.par);
            b[i] = Element.createElement(s[i], null, parString);
            c[i] = Element.createElement(tmp1, tmp2, parMix);
        }
        for (i = 0; i < exp.length; ++i) {
            lca = a[exp[i][0]].getLca(a[exp[i][1]]);
            Assert.assertTrue(lca.equals(a[exp[i][2]]));
            lca = a[exp[i][1]].getLca(a[exp[i][0]]);
            Assert.assertTrue(lca.equals(a[exp[i][2]]));
        }
        for (i = 0; i < exp.length; ++i) {
            lca = b[exp[i][0]].getLca(b[exp[i][1]]);
            Assert.assertTrue(lca.equals(b[exp[i][2]]));
            lca = b[exp[i][1]].getLca(b[exp[i][0]]);
            Assert.assertTrue(lca.equals(b[exp[i][2]]));
        }
        for (i = 0; i < exp.length; ++i) {
            lca = c[exp[i][0]].getLca(c[exp[i][1]]);
            Assert.assertTrue(lca.equals(c[exp[i][2]]));
            lca = c[exp[i][1]].getLca(c[exp[i][0]]);
            Assert.assertTrue(lca.equals(c[exp[i][2]]));
        }
    }

    @Test
    public final void testHashCode() {
        byte[][] plength = new byte[][]{};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        String[] e1 = new String[]{"/a/b/c/d", "/1/2/3/4"};
        String[] e2 = new String[]{"/a/b/c", "/1/2"};
        String[] e3 = new String[]{"/a/b/c/d", "/1/2/3/4"};
        String[] e4 = new String[]{"*", "*"};
        String[] n1 = new String[]{};
        String[] n2 = new String[]{};
        String[] n3 = new String[]{};
        String[] n4 = new String[]{};
        Element m1 = Element.createElement(e1, n1, this.par);
        Element m2 = Element.createElement(e2, n2, this.par);
        Element m3 = Element.createElement(e3, n3, this.par);
        Element m4 = Element.createElement(e4, n4, this.par);
        String s1 = e1[0] + e1[1];
        String s2 = e2[0] + e2[1];
        String s3 = e3[0] + e3[1];
        String s4 = e4[0] + e4[1];
        Assert.assertTrue(s1.hashCode() == m1.hashCode());
        Assert.assertTrue(s2.hashCode() == m2.hashCode());
        Assert.assertTrue(s3.hashCode() == m3.hashCode());
        Assert.assertTrue(s4.hashCode() == m4.hashCode());
        Assert.assertFalse(s3.hashCode() == m2.hashCode());
        Assert.assertFalse(s4.hashCode() == m2.hashCode());
        Assert.assertTrue(m1.hashCode() == m3.hashCode());
        Assert.assertFalse(m4.hashCode() == m2.hashCode());
        Assert.assertFalse(m3.hashCode() == m2.hashCode());
    }

    @Test
    public final void testEqualsObject() {
        List<Element> lUnsort = Arrays.asList(this.aUnsort);
        Collections.sort(lUnsort);
        lUnsort.toArray(this.aUnsort);
        for (int i = 0; i < this.aSorted.length; ++i) {
            for (int j = 0; j < this.aSorted.length; ++j) {
                if (i == j | i == 2 & j == 3 | i == 3 & j == 2) {
                    Assert.assertTrue(this.aSorted[i].equals(this.aSorted[j]));
                    Assert.assertTrue(this.aUnsort[i].equals(this.aUnsort[j]));
                    Assert.assertTrue(this.aSorted[i].equals(this.aUnsort[j]));
                    Assert.assertTrue(this.aUnsort[i].equals(this.aSorted[j]));
                    continue;
                }
                Assert.assertFalse(this.aSorted[i].equals(this.aSorted[j]));
                Assert.assertFalse(this.aUnsort[i].equals(this.aUnsort[j]));
                Assert.assertFalse(this.aSorted[i].equals(this.aUnsort[j]));
                Assert.assertFalse(this.aUnsort[i].equals(this.aSorted[j]));
            }
        }
    }

    @Test
    public final void testCompareTo() {
        Assert.assertTrue(this.aSorted[0].compareTo(this.aSorted[1]) < 0);
        Assert.assertTrue(this.aSorted[1].compareTo(this.aSorted[0]) > 0);
        Assert.assertTrue(this.aSorted[2].compareTo(this.aSorted[2]) == 0);
        Assert.assertTrue(this.aSorted[2].compareTo(this.aSorted[3]) == 0);
        Assert.assertTrue(this.aSorted[3].compareTo(this.aSorted[2]) == 0);
        Assert.assertTrue(this.aSorted[5].compareTo(this.aSorted[8]) < 0);
        Assert.assertTrue(this.aSorted[8].compareTo(this.aSorted[5]) > 0);
        Assert.assertTrue(this.aSorted[4].compareTo(this.aSorted[7]) < 0);
        Assert.assertTrue(this.aSorted[7].compareTo(this.aSorted[4]) > 0);
        List<Element> lUnsort = Arrays.asList(this.aUnsort);
        List<Element> lSorted = Arrays.asList(this.aSorted);
        Assert.assertFalse(((Object)lUnsort).equals(lSorted));
        Collections.sort(lUnsort);
        Assert.assertTrue(((Object)lUnsort).equals(lSorted));
        Collections.shuffle(lUnsort);
        Collections.sort(lUnsort);
        Assert.assertTrue(((Object)lUnsort).equals(lSorted));
    }

    @Test(expected=NullPointerException.class)
    public final void testNull() {
        for (int i = 0; i < this.aSorted.length; ++i) {
            Assert.assertFalse(this.aSorted[i].equals(null));
        }
        this.aSorted[4].compareTo(null);
    }

    @Test
    public final void testTurnIntoParent() {
        byte[][] plength = new byte[][]{{0, 6, 12, 18, 24, 32}, {0, 6, 12, 18, 24, 32}};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        String[] emptyStr = new String[]{};
        String[][] s = new String[][]{{"/1/3/4/1", "/1/3/5/3"}, {"/1/3/4/1/6", "/1/3"}, {"/1", "*"}, {"*", "/1/3/5/3"}, {"/1", "/1/3/5/3"}, {"*", "*"}};
        String[][] p0 = new String[][]{{"/1/3/4", "/1/3/5/3"}, {"/1/3/4/1", "/1/3"}, {"*", "*"}, {"*", "/1/3/5/3"}, {"*", "/1/3/5/3"}, {"*", "*"}};
        String[][] p1 = new String[][]{{"/1/3/4/1", "/1/3/5"}, {"/1/3/4/1/6", "/1"}, {"/1", "*"}, {"*", "/1/3/5"}, {"/1", "/1/3/5"}, {"*", "*"}};
        boolean[][] hasPar = new boolean[][]{{true, true}, {true, true}, {true, false}, {false, true}, {true, true}, {false, false}};
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < s.length; ++i) {
                this.aUnsort[i] = Element.createElement((String[])emptyStr.clone(), s[i], this.par);
                Element a = Element.createElement((String[])emptyStr.clone(), s[i], this.par);
                Element parent0 = Element.createElement((String[])emptyStr.clone(), p0[i], this.par);
                Element parent1 = Element.createElement((String[])emptyStr.clone(), p1[i], this.par);
                Element b = this.aUnsort[i].clone();
                Assert.assertTrue(this.aUnsort[i].turnIntoParent(j) == hasPar[i][j]);
                if (j == 0) {
                    Assert.assertTrue(this.aUnsort[i].equals(parent0));
                } else {
                    Assert.assertTrue(this.aUnsort[i].equals(parent1));
                }
                Assert.assertTrue(a.equals(b));
                Assert.assertTrue(b.equals(a));
                Assert.assertTrue(b.equals(this.aUnsort[i]) != hasPar[i][j]);
            }
        }
    }

    @Test
    public final void testGetLevel() {
        int j;
        byte[][] plength = new byte[][]{{0, 6, 12, 18, 24, 32}, {0, 6, 12, 18, 24, 32}};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        String[] emptyStr = new String[]{};
        String[][] s = new String[][]{{"/1/3/4/1", "/1/3/5/3"}, {"/1/3/4/1/6", "/1/3"}, {"/1", "*"}, {"*", "/1/3/5/3"}, {"/1", "/1/3/5/3"}, {"*", "*"}};
        int[][] expLevel = new int[][]{{4, 4}, {5, 2}, {1, 0}, {0, 4}, {1, 4}, {0, 0}};
        int[] expL = new int[]{8, 7, 1, 4, 5, 0};
        boolean[][] hasPar = new boolean[][]{{true, true}, {true, true}, {true, false}, {false, true}, {true, true}, {false, false}};
        for (int i = 0; i < s.length; ++i) {
            this.aUnsort[i] = Element.createElement((String[])emptyStr.clone(), s[i], this.par);
            Assert.assertTrue(this.aUnsort[i].getL() == expL[i]);
            for (j = 0; j < 2; ++j) {
                Assert.assertTrue(this.aUnsort[i].getLevel(j) == expLevel[i][j]);
                Assert.assertTrue(this.aUnsort[i].hasParent(j) == hasPar[i][j]);
            }
        }
        Element a = new Element(this.par);
        Assert.assertTrue(a.getL() == 0);
        for (j = 0; j < 2; ++j) {
            Assert.assertTrue(a.getLevel(j) == 0);
        }
    }

    @Test
    public final void testHack() {
        String[] mdb;
        String[] mda;
        int i;
        byte[][] plength = new byte[][]{{0, 8, 16, 24, 32}};
        this.par = new Parameter(2 - plength.length, plength);
        this.pa = new PartAncHHH(0.0, this.par);
        String[] st = new String[]{"/1/3/4/1", "/1/3/5/3", "/1/3/4/1", "/1/5/2/1", "/1/5/9/1", "/1/3/4/1", "/1/5/9/1", "/1/3/4/1", "/1/5/9/1", "/1/5/9/6", "/2/4/4/7", "/2/5/1/9", "/3/5/2/7", "/3/5/2/8", "/3/5/2/9", "/3/5/6/1", "/3/5/7/8", "/1/3/4/1"};
        int off = 6;
        for (i = 0; i < this.aUnsort.length; ++i) {
            mda = new String[1];
            mdb = new String[1];
            mda[0] = st[(2 * i + off) % 18];
            mdb[0] = st[(2 * i + off + 1) % 18];
            this.aUnsort[i] = Element.createElement(mda, mdb, this.par);
            mda = new String[1];
            mdb = new String[1];
        }
        for (i = 0; i < this.aSorted.length; ++i) {
            mda = new String[1];
            mdb = new String[1];
            mda[0] = st[2 * i];
            mdb[0] = st[2 * i + 1];
            this.aSorted[i] = Element.createElement(mda, mdb, this.par);
            mda = new String[1];
            mdb = new String[1];
        }
        String[] s1 = new String[]{"/9/9/9/9", "/3/4/5/6"};
        String[] s2 = new String[]{"/1/3/4/1", "/1/3/5/3"};
        String[] s3 = new String[]{"/1", "/1/3/5"};
        String[] s4 = new String[]{"*", "*"};
        String[] s5 = new String[]{"*", "/3/4"};
        String[] s6 = new String[]{"/9/9/9", "*"};
        String[] s11 = new String[]{"/9", "/3/4/5"};
        String[] s12 = new String[]{"/1/3/4/1", "/1/3/5"};
        String[] s13 = new String[]{"/127/112/111/109", "/102/110/101/104"};
        String[] s14 = new String[]{"/127/112/111/109", "/102/110/101"};
        String[] s15 = new String[]{"/128/112/111/154", "/102/110/101/104"};
        String[] s16 = new String[]{"/128/112/111/154", "/102/110/101"};
        int[] label = new int[]{1, 3};
        int[] label2 = new int[]{0, 0};
        int[] label5 = new int[]{0, 2};
        int[] label6 = new int[]{3, 0};
        int[] label7 = new int[]{3, 5};
        Element clone = this.aSorted[0].clone();
        Element a = clone.clone();
        Element b = clone.clone();
        Assert.assertTrue(a.hashCode() == clone.hashCode());
        Assert.assertTrue(a.hasParent(0));
        Assert.assertTrue(a.hasParent(1));
        Assert.assertTrue(a.turnIntoParent(0));
        Assert.assertTrue(b.hashCode() == clone.hashCode());
        Assert.assertTrue(b.turnIntoParent(1));
        Assert.assertFalse(a.equals(clone));
        Assert.assertFalse(a.hashCode() == clone.hashCode());
        Assert.assertFalse(b.hashCode() == clone.hashCode());
        Assert.assertTrue(a.isGenOf(clone));
        Assert.assertTrue(b.isGenOf(clone));
        Assert.assertFalse(clone.isGenOf(a));
        Assert.assertFalse(clone.isGenOf(b));
        Assert.assertFalse(b.isGenOf(a));
        mda = new String[1];
        mdb = new String[1];
        mda[0] = s1[0];
        mdb[0] = s1[1];
        a = Element.createElement(mda, mdb, this.par);
        b.setTo(a);
        Assert.assertTrue(a.equals(b));
        a.turnIntoParent(1);
        Assert.assertFalse(a.equals(b));
        mda = new String[1];
        mdb = new String[1];
        mda[0] = s2[0];
        mdb[0] = s2[1];
        a = Element.createElement(mda, mdb, this.par);
        a = this.makeMixed(s2, this.par);
        Assert.assertTrue(a.hashCode() == clone.hashCode());
        Assert.assertTrue(a.equals(clone));
        Assert.assertTrue(a.generalizeTo(label));
        mda = new String[1];
        mdb = new String[1];
        mda[0] = s3[0];
        mdb[0] = s3[1];
        b = Element.createElement(mda, mdb, this.par);
        Assert.assertTrue(a.hashCode() == b.hashCode());
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label6));
        a = this.makeMixed(s2, this.par);
        Assert.assertTrue(a.generalizeTo(label2));
        b = this.makeMixed(s4, this.par);
        Assert.assertTrue(a.hashCode() == b.hashCode());
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label));
        a = this.makeMixed(s1, this.par);
        b = this.makeMixed(s5, this.par);
        Assert.assertFalse(a.equals(b));
        Assert.assertTrue(a.generalizeTo(label5));
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label));
        a = this.makeMixed(s1, this.par);
        b = this.makeMixed(s6, this.par);
        Assert.assertFalse(a.equals(b));
        Assert.assertTrue(a.generalizeTo(label6));
        Assert.assertTrue(a.equals(b));
        Assert.assertFalse(a.generalizeTo(label));
        a = this.makeMixed(s1, this.par);
        b = this.makeMixed(s11, this.par);
        Assert.assertFalse(a.generalizeTo(label7));
        Assert.assertFalse(a.equals(b));
        Assert.assertTrue(a.generalizeTo(label));
        Assert.assertTrue(a.equals(b));
        a = this.makeMixed(s2, this.par);
        b = this.makeMixed(s2, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        Assert.assertTrue(a.hasParent(1));
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        Assert.assertTrue(a.equals(b));
        Assert.assertTrue(a.turnIntoParent(1));
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
        Assert.assertFalse(a.equals(b));
        b = this.makeMixed(s12, this.par);
        Assert.assertTrue(a.equals(b));
        a = this.makeMixed(s2, this.par);
        b = a.clone();
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        Assert.assertTrue(a.turnIntoParent(0));
        Assert.assertTrue(a.turnIntoParent(0));
        Assert.assertTrue(a.getLevel(0) == 2);
        Assert.assertTrue(a.getLevel(1) == 4);
        int cont = 0;
        while (a.hasParent(1)) {
            Assert.assertTrue(a.turnIntoParent(1));
            Assert.assertTrue(a.getLevel(0) == 2);
            Assert.assertTrue(a.getLevel(1) == 4 - ++cont);
        }
        Assert.assertTrue(b.getLevel(0) == 4);
        Assert.assertTrue(b.getLevel(1) == 4);
        a = this.makeMixed(s13, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        a = this.makeMixed(s14, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
        a = this.makeMixed(s15, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 4);
        a = this.makeMixed(s16, this.par);
        Assert.assertTrue(a.getLevel(0) == 4);
        Assert.assertTrue(a.getLevel(1) == 3);
    }

    private Element makeMixed(String[] s, Parameter par) {
        String[] mda = new String[1];
        String[] mdb = new String[1];
        mda[0] = s[0];
        mdb[0] = s[1];
        return Element.createElement(mda, mdb, par);
    }
}

