/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.SysParameter;
import hitters.tools.Utils;
import hitters.tools.XMLPlotter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Test;

public class ComplexHHHTest {
    static final int PART_ANC = 4096;
    static final int FULL_ANC = 8192;
    String dir = "resources/testcase/";
    MultiDatabase d;
    AbstractComplexHHH hitterAlgo;
    byte[][] plength = new byte[0][];
    Parameter myParams = new Parameter(2 - this.plength.length, this.plength);
    double phi;
    String[][] k = new String[][]{{"*", "*"}, {"/2", "*"}, {"*", "/1"}, {"*", "/2"}, {"/1", "*"}, {"*", "/3"}, {"/2", "/1"}, {"/2", "/2"}, {"/1", "/1"}, {"/1", "/2"}, {"/1", "/3"}};
    Comparator<int[]> defaultComparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] a, int[] b) {
            int erg = ComplexHHHTest.this.k[a[0]][0].compareTo(ComplexHHHTest.this.k[b[0]][0]);
            if (erg != 0) {
                return erg;
            }
            return ComplexHHHTest.this.k[a[0]][1].compareTo(ComplexHHHTest.this.k[b[0]][1]);
        }
    };
    Comparator<Map.Entry<Element, MultiStringElement>> entryComparator = new Comparator<Map.Entry<Element, MultiStringElement>>(){

        @Override
        public int compare(Map.Entry<Element, MultiStringElement> a, Map.Entry<Element, MultiStringElement> b) {
            return a.getKey().compareTo(b.getKey());
        }
    };

    @Test
    public void testEmpty() {
        String res = "{( * (s) | * (s) )= ( fmin = 0, fmax = 0, F = 0 ) }";
        this.hitterAlgo = new PartAncHHH(0.0, this.myParams);
        Assert.assertTrue(this.hitterAlgo.outputSet(0.3).toString().equals(res));
        Assert.assertTrue(this.hitterAlgo.outputSet(1.0).toString().equals(res));
        Assert.assertTrue(this.hitterAlgo.outputSet(0.0).toString().equals(res));
        this.hitterAlgo = new FullAncHHH(0.0, this.myParams);
        Assert.assertTrue(this.hitterAlgo.outputSet(0.3).toString().equals(res));
        Assert.assertTrue(this.hitterAlgo.outputSet(1.0).toString().equals(res));
        Assert.assertTrue(this.hitterAlgo.outputSet(0.0).toString().equals(res));
    }

    @Test
    public void testWTF() {
        double epsilon = 0.007;
        double phi = 3.0 * epsilon;
        DimType[] dims = new DimType[]{DimType.SEQUENCE};
        SysParameter par = new SysParameter(dims);
        HashSet<String> calls = new HashSet<String>();
        calls.add("brk");
        par.setUsedCalls(calls);
        this.hitterAlgo = new FullAncHHH(epsilon, par);
        this.d = new MultiDatabase("D:/ws/HHH/resources/data/ge4", par);
        this.d = new MultiDatabase("D:/ws/HHH/resources/data/ff1", par);
        this.d.openRead();
        Vector<Element> data = this.d.readSystemCalls();
        for (Element e : data) {
            this.hitterAlgo.insert(e, 1, true);
        }
        HashMap<Element, MultiHitterInfo> res = this.hitterAlgo.outputSet(phi);
        ArrayList<String> list = new ArrayList<String>();
        for (Element e : res.keySet()) {
            list.add(e.toShortString() + " " + res.get(e).toShortString());
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            System.out.println((String)list.get(i));
        }
    }

    @Test
    public void testInsert() {
        this.d = new MultiDatabase(this.dir + "PATest/PA6", this.myParams);
        this.d.openRead();
        Vector<Element> data = this.d.readElements();
        this.hitterAlgo = new PartAncHHH(0.0, this.myParams);
        for (Element e : data) {
            this.hitterAlgo.insert(e, 1, true);
        }
        Assert.assertTrue(this.hitterAlgo.getN() == 15);
        Assert.assertTrue(this.hitterAlgo.getTupelCount() == 7);
        Assert.assertTrue(this.hitterAlgo.getMaxTupelCount() == 7);
        for (Element e : data) {
            this.hitterAlgo.insert(e.clone(), 9, true);
        }
        Assert.assertTrue(this.hitterAlgo.getN() == 150);
        Assert.assertTrue(this.hitterAlgo.getTupelCount() == 7);
        Assert.assertTrue(this.hitterAlgo.getMaxTupelCount() == 7);
        this.hitterAlgo = new FullAncHHH(0.0, this.myParams);
        for (Element e : data) {
            this.hitterAlgo.insert(e, 1, true);
        }
        Assert.assertTrue(this.hitterAlgo.getN() == 15);
        for (Element e : data) {
            this.hitterAlgo.insert(e.clone(), 9, true);
        }
        Assert.assertTrue(this.hitterAlgo.getN() == 150);
    }

    @Test
    public void testOutputSetBatch() {
        List<Map.Entry<Element, MultiStringElement>> dump;
        HashMap<Element, MultiHitterInfo> res;
        int i;
        String file = "PATest/PA";
        for (i = 1; i < 8; ++i) {
            this.load(file + i, 4096);
            res = this.hitterAlgo.outputSet(this.phi, false);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
            this.load(file + i, 4096);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
        }
        file = "FATest/FA";
        for (i = 2; i < 9; ++i) {
            this.load(file + i, 8192);
            res = this.hitterAlgo.outputSet(this.phi, false);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
            this.load(file + i, 8192);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
        }
    }

    @Test
    public void testPar() {
        Parameter p = new Parameter(1);
        Assert.assertTrue(p.getH() == 13);
        DimType[] dims = new DimType[]{DimType.CALL, DimType.SEQUENCE};
        p = new SysParameter(dims);
        Assert.assertTrue(p.getH() == 35);
    }

    @Test
    public void testBits() {
        DimType[] dims = new DimType[]{DimType.SEQUENCE, DimType.SEQUENCE};
        SysParameter p = new SysParameter(dims);
        PartAncHHH hitter = new PartAncHHH(0.1, p);
        hitter.getEpsilon();
    }

    @Test
    public void testCalcLabels() {
        Parameter p = new Parameter(1);
        PartAncHHH hitter = new PartAncHHH(0.1, p);
        List<int[]> labels = hitter.calcLabels(3);
        int[] a = new int[]{3};
        ArrayList<int[]> res = new ArrayList<int[]>();
        res.add(a);
        Assert.assertTrue(this.arrayListEquals(labels, res));
        res.clear();
        p = new Parameter(2);
        hitter = new PartAncHHH(0.1, p);
        labels = hitter.calcLabels(3);
        int[][] b = new int[][]{{0, 3}, {1, 2}, {2, 1}, {3, 0}};
        for (int i = 0; i < b.length; ++i) {
            res.add(b[i]);
        }
        Assert.assertTrue(this.arrayListEquals(labels, res));
        res.clear();
        p = new Parameter(3);
        hitter = new PartAncHHH(0.1, p);
        labels = hitter.calcLabels(2);
        int[][] c = new int[][]{{0, 0, 2}, {0, 1, 1}, {0, 2, 0}, {1, 0, 1}, {1, 1, 0}, {2, 0, 0}};
        for (int i = 0; i < c.length; ++i) {
            res.add(c[i]);
        }
        Assert.assertTrue(this.arrayListEquals(labels, res));
        System.out.println(labels.size());
    }

    @Test
    public void test1D() {
        Parameter p = new Parameter(1);
        String file = "PATest/1D/PA1D";
        for (int i = 1; i < 4; ++i) {
            this.load(file + i, 4096, p);
            HashMap<Element, MultiHitterInfo> res = this.hitterAlgo.outputSet(this.phi, false);
            this.validateHitter(res, file, i);
            List<Map.Entry<Element, MultiStringElement>> dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
            this.load(file + i, 4096, p);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
        }
    }

    @Test
    public void testPlotter() {
        Parameter p = new Parameter(3);
        String[] eStr = new String[]{"/a/b", "/1/2", "/3/4"};
        Element e = Element.createElement(eStr, p);
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(e);
        XMLPlotter pl = new XMLPlotter("tmp/gt.graphml");
        pl.addItems3D(list);
        pl.plot();
    }

    @Test
    public void test3D() {
        List<Map.Entry<Element, MultiStringElement>> dump;
        HashMap<Element, MultiHitterInfo> res;
        int i;
        Parameter p = new Parameter(3);
        String file = "PATest/3D/PA3D";
        for (i = 1; i < 3; ++i) {
            this.load(file + i, 4096, p);
            res = this.hitterAlgo.outputSet(this.phi, false);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
            this.load(file + i, 4096, p);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            res = this.hitterAlgo.outputSet(this.phi, true);
            this.validateHitter(res, file, i);
            dump = this.hitterAlgo.dumpTrie();
            this.validateDump(dump, file, i);
        }
        i = 2;
        this.load(file + i, 4096, p);
        res = this.hitterAlgo.outputSet(this.phi, false);
        dump = this.hitterAlgo.dumpTrie();
        for (Map.Entry<Element, MultiStringElement> me : dump) {
            System.out.println(me.getKey().toShortString() + " " + me.getValue().toShortString());
        }
        System.out.println();
        for (Element e : res.keySet()) {
            System.out.println(e.toShortString() + " " + res.get(e).toShortString());
        }
    }

    @Test
    public final void testAncestorInsert() {
        MultiStringElement m;
        Element a;
        String[][] t = new String[][]{{"/1/2/3/4/5", "*"}, {"/1/2/3/4", "*"}, {"/1/2/3", "*"}, {"/1/2", "*"}, {"/1", "*"}, {"*", "*"}, {"/1/2/3/4/5", "/1"}, {"/1/2/3", "/1"}, {"/1/2", "/1"}, {"/1", "/1"}, {"*", "/1"}, {"/1/2/3/4", "/1/2"}, {"*", "/1/2"}, {"/1/2/3/4", "/1/2/3"}, {"/1/2", "/1/2/3"}, {"/1", "/1/2/3"}, {"*", "/1/2/3/4"}, {"/1/2/3/4/5", "/1/2/3/4"}};
        int[][] d0 = new int[][]{{4, 1, 1}, {4, 1, 1}, {4, 1, 1}, {4, 1, 1}, {4, 1, 1}, {4, 1, 1}, {6, 3, 4}, {6, 3, 4}, {6, 3, 4}, {6, 3, 4}, {4, 1, 1}, {6, 3, 4}, {6, 3, 4}, {6, 3, 4}, {6, 3, 4}, {6, 3, 4}, {6, 3, 4}, {0, 0, 0}};
        this.hitterAlgo = new PartAncHHH(0.1, this.myParams);
        this.hitterAlgo.setN(170);
        for (int i = 0; i < 18; ++i) {
            a = Element.createElement(t[i], null, this.myParams);
            m = new MultiStringElement(d0[i][0], d0[i][1], d0[i][2]);
            if (d0[i][0] == 0) continue;
            this.hitterAlgo.setTest(a, m);
        }
        a = Element.createElement(t[17], null, this.myParams);
        Assert.assertTrue(3 == this.hitterAlgo.instantiateDelta(a));
        this.hitterAlgo.insertWithoutCompress(a, 1, true);
        m = this.hitterAlgo.dumpElement(a);
        Assert.assertTrue(m.delta == 3);
        int x = 2;
        for (int k = 7; k < 17; ++k) {
            if (k > 7) {
                d0[k - 1][1] = 3;
            }
            d0[k][1] = x;
            this.hitterAlgo = new PartAncHHH(0.1, this.myParams);
            this.hitterAlgo.setN(170);
            for (int i = 0; i < 18; ++i) {
                a = Element.createElement(t[i], null, this.myParams);
                m = new MultiStringElement(d0[i][0], d0[i][1], d0[i][2]);
                if (d0[i][0] == 0) continue;
                this.hitterAlgo.setTest(a, m);
            }
            a = Element.createElement(t[17], null, this.myParams);
            if (k != 10) {
                Assert.assertTrue(x == this.hitterAlgo.instantiateDelta(a));
            }
            this.hitterAlgo.insertWithoutCompress(a, 1, true);
            m = this.hitterAlgo.dumpElement(a);
            if (k != 10) {
                Assert.assertTrue(m.delta == x);
                continue;
            }
            Assert.assertTrue(m.delta == 3);
        }
    }

    @Test
    public final void testInsertNoCompress() {
        int[][] ins = new int[][]{{6, 1}, {7, 1}, {8, 1}, {7, 9}, {9, 4}, {6, 5}, {7, 2}, {10, 1}, {9, 8}};
        int[][] exp = new int[][]{{8, 1, 0}, {9, 12, 1}, {10, 1, 2}, {6, 6, 0}, {7, 12, 0}};
        this.compareInsert(ins, exp, 0.1, false, null);
        String[][] str = new String[][]{{"*", "*"}, {"*", "/1"}, {"/1", "*"}, {"*", "/2"}, {"/2", "*"}, {"*", "/3"}};
        int[][] ins1 = new int[][]{{0, 4}, {4, 5}, {1, 3}, {2, 9}, {3, 4}, {5, 5}};
        int[][] exp1 = new int[][]{{0, 4, 0}, {4, 5, 0}, {1, 3, 0}, {2, 9, 0}, {3, 4, 0}, {5, 5, 0}};
        this.compareInsert(ins1, exp1, 0.1, false, str);
    }

    private void compareInsert(int[][] insr, int[][] expc, double eps, boolean compress, String[][] s) {
        this.compareInsert(insr, expc, eps, compress, s, this.plength);
    }

    private void compareInsert(int[][] insr, int[][] expc, double eps, boolean compress, final String[][] s, byte[][] myPlength) {
        Element a;
        Comparator<int[]> arrayComparator;
        String[][] str;
        int counter = 0;
        int offset = 0;
        if (compress) {
            offset = 1;
        }
        this.hitterAlgo = new PartAncHHH(0.1, this.myParams);
        if (s == null) {
            str = this.k;
            arrayComparator = this.defaultComparator;
        } else {
            str = s;
            arrayComparator = new Comparator<int[]>(){

                @Override
                public int compare(int[] a, int[] b) {
                    int erg = s[a[0]][0].compareTo(s[b[0]][0]);
                    if (erg != 0) {
                        return erg;
                    }
                    return s[a[0]][1].compareTo(s[b[0]][1]);
                }
            };
        }
        Arrays.sort(expc, arrayComparator);
        for (int i = 0; i < insr.length; ++i) {
            counter += insr[i][1];
            a = Element.createElement(str[insr[i][0]], null, this.myParams);
            if (compress) {
                this.hitterAlgo.insert(a, insr[i][1], true);
                continue;
            }
            this.hitterAlgo.insertWithoutCompress(a, insr[i][1], true);
        }
        List<Map.Entry<Element, MultiStringElement>> trie = this.hitterAlgo.dumpTrie();
        Collections.sort(trie, this.entryComparator);
        Assert.assertTrue(trie.size() == expc.length);
        for (int i = 0; i < expc.length; ++i) {
            a = trie.get(i).getKey();
            MultiStringElement m = trie.get(i).getValue();
            Assert.assertTrue(a.equals(Element.createElement(str[expc[i][0]], null, this.myParams)));
            Assert.assertTrue(m.g == expc[i][1]);
            Assert.assertTrue(m.m == expc[i][2]);
            Assert.assertTrue(m.delta == expc[i][2 + offset]);
        }
        Assert.assertTrue(this.hitterAlgo.getN() == counter);
    }

    @Test
    public final void testCompress() {
        String[][] str = new String[][]{{"*", "*"}, {"*", "/1"}, {"/1", "*"}, {"*", "/2"}, {"/2", "*"}, {"*", "/3"}, {"/1", "/1"}, {"/2", "/1"}, {"/1", "/2"}, {"/1", "/3"}, {"/2", "/2"}, {"/2", "/3"}};
        int[][] d0 = new int[][]{{5, 1, 1}, {2, 2, 2}, {0, 0, 0}, {1, 2, 2}, {3, 4, 3}, {5, 5, 5}, {1, 3, 3}, {2, 2, 2}, {0, 0, 0}, {1, 0, 0}, {3, 0, 0}, {1, 3, 3}};
        int[][] expc = new int[][]{{1, 2, 2, 2}, {3, 4, 3, 2}, {4, 6, 4, 3}, {5, 6, 5, 5}, {6, 1, 3, 3}, {7, 2, 2, 2}, {11, 1, 3, 3}};
        this.compareCompress(d0, expc, 0.1, 22, str);
    }

    private void compareCompress(int[][] data, int[][] expc, double eps, int N, final String[][] s) {
        MultiStringElement m;
        Element a;
        Comparator<int[]> arrayComparator;
        String[][] str;
        if (s == null) {
            str = this.k;
            arrayComparator = this.defaultComparator;
        } else {
            str = s;
            arrayComparator = new Comparator<int[]>(){

                @Override
                public int compare(int[] a, int[] b) {
                    int erg = s[a[0]][0].compareTo(s[b[0]][0]);
                    if (erg != 0) {
                        return erg;
                    }
                    return s[a[0]][1].compareTo(s[b[0]][1]);
                }
            };
        }
        Arrays.sort(expc, arrayComparator);
        this.hitterAlgo = new PartAncHHH(0.1, this.myParams);
        for (int i = 0; i < data.length; ++i) {
            a = Element.createElement(str[i], null, this.myParams);
            m = new MultiStringElement(data[i][0], data[i][1], data[i][2]);
            if (data[i][0] == 0) continue;
            this.hitterAlgo.setTest(a, m);
        }
        this.hitterAlgo.setN(N);
        this.hitterAlgo.compress();
        List<Map.Entry<Element, MultiStringElement>> trie = this.hitterAlgo.dumpTrie();
        Collections.sort(trie, this.entryComparator);
        Assert.assertTrue(trie.size() == expc.length);
        for (int i = 0; i < expc.length; ++i) {
            a = trie.get(i).getKey();
            m = trie.get(i).getValue();
            Assert.assertTrue(a.equals(Element.createElement(str[expc[i][0]], null, this.myParams)));
            Assert.assertTrue(m.g == expc[i][1]);
            Assert.assertTrue(m.m == expc[i][2]);
            Assert.assertTrue(m.delta == expc[i][3]);
        }
    }

    @Test
    public final void testOutputSet() {
        String[][] t = new String[][]{{"*", "*"}, {"/2", "*"}, {"*", "/1"}, {"*", "/2"}, {"/1", "*"}, {"*", "/3"}, {"/2", "/1"}, {"/2", "/2"}, {"/1", "/1"}, {"/1", "/2"}, {"/1", "/3"}, {"/3", "/1"}, {"/3", "*"}};
        int[][] d0 = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {3, 0, 0}, {0, 0, 0}, {0, 0, 0}, {1, 0, 0}, {3, 0, 0}, {1, 0, 0}, {0, 0, 0}};
        int[][] expc = new int[][]{{2, 4, 4, 4}, {4, 4, 4, 4}};
        this.compareOutput(d0, expc, 0.0, 8, 0.5, t);
        int[][] d = new int[][]{{9, 0, 6}, {6, 0, 1}, {1, 0, 1}, {4, 0, 7}, {3, 0, 3}, {5, 0, 0}, {5, 0, 1}, {1, 0, 7}, {4, 0, 3}, {1, 0, 1}, {1, 0, 0}};
        int[][] ex = new int[][]{{0, 34, 46, 38}, {2, 9, 11, 9}, {3, -1, 13, 12}, {4, 6, 12, 8}, {8, 1, 7, 4}, {1, 11, 13, 18}, {7, -6, 8, 1}};
        this.compareOutput(d, ex, 0.0, 40, 0.175, null);
        int[][] d2 = new int[][]{{6, 0, 99}, {4, 0, 6}, {3, 0, 2}, {4, 0, 1}, {6, 0, 1}, {5, 0, 2}, {5, 0, 1}, {6, 0, 2}, {1, 0, 7}, {4, 0, 0}, {5, 0, 1}};
        int[][] ex2 = new int[][]{{0, -50, 148, 29}, {1, 9, 21, 11}, {2, 7, 11, 15}, {3, 13, 15, 10}, {4, 15, 17, 22}, {5, 8, 12, 10}, {7, 4, 8, 6}, {8, -6, 8, 1}};
        this.compareOutput(d2, ex2, 0.0, 49, 0.14285714285714285, null);
        int[][] d3 = new int[][]{{6, 0, 1}, {3, 0, 1}, {2, 0, 0}, {3, 0, 2}, {3, 0, 3}, {2, 0, 1}, {4, 0, 1}, {3, 0, 2}, {3, 0, 1}, {4, 0, 0}, {3, 0, 0}};
        int[][] ex3 = new int[][]{{0, 35, 37, 17}, {1, 9, 11, 6}, {2, 9, 9, 4}, {3, 8, 12, 5}, {4, 10, 16, 7}, {5, 4, 6, 5}, {6, 3, 5, 4}, {7, 1, 5, 3}, {8, 2, 4, 3}, {9, 4, 4, 4}};
        this.compareOutput(d3, ex3, 0.0, 36, 0.1111111111111111, null);
        String[][] t4 = new String[][]{{"*", "*"}, {"/2", "*"}, {"*", "/1"}, {"*", "/2"}, {"/1", "*"}, {"*", "/3"}, {"/2", "/1"}, {"/2", "/2"}, {"/1", "/1"}, {"/1", "/2"}, {"/1", "/3"}, {"/2", "/3"}};
        int[][] d4 = new int[][]{{6, 0, 1}, {3, 0, 1}, {2, 0, 0}, {3, 0, 2}, {3, 0, 3}, {2, 0, 1}, {4, 0, 1}, {3, 0, 2}, {3, 0, 1}, {4, 0, 0}, {3, 0, 0}, {1, 0, 1}};
        int[][] ex4 = new int[][]{{0, 36, 38, 18}, {1, 10, 12, 7}, {2, 9, 9, 4}, {3, 8, 12, 5}, {4, 10, 16, 7}, {5, 5, 7, 6}, {6, 3, 5, 4}, {7, 1, 5, 3}, {8, 2, 4, 3}, {9, 4, 4, 4}};
        this.compareOutput(d4, ex4, 0.0, 36, 0.1111111111111111, t4);
    }

    public void compareOutput(int[][] d, int[][] exp, double eps, int N, double phi, final String[][] s) {
        Element a;
        Comparator<int[]> arrayComparator;
        String[][] str;
        if (s == null) {
            str = this.k;
            arrayComparator = this.defaultComparator;
        } else {
            str = s;
            arrayComparator = new Comparator<int[]>(){

                @Override
                public int compare(int[] a, int[] b) {
                    int erg = s[a[0]][0].compareTo(s[b[0]][0]);
                    if (erg != 0) {
                        return erg;
                    }
                    return s[a[0]][1].compareTo(s[b[0]][1]);
                }
            };
        }
        Arrays.sort(exp, arrayComparator);
        this.hitterAlgo = new PartAncHHH(0.1, this.myParams);
        for (int i = 0; i < d.length; ++i) {
            a = Element.createElement(str[i], null, this.myParams);
            MultiStringElement m = new MultiStringElement(d[i][0], d[i][1], d[i][2]);
            if (d[i][0] == 0) continue;
            this.hitterAlgo.setTest(a, m);
        }
        this.hitterAlgo.setN(N);
        HashMap<Element, MultiHitterInfo> res = this.hitterAlgo.outputSet(phi);
        ArrayList<Element> ls = new ArrayList<Element>(res.keySet());
        Collections.sort(ls);
        Assert.assertTrue(ls.size() == exp.length);
        for (int i = 0; i < ls.size(); ++i) {
            a = ls.get(i);
            MultiHitterInfo h = res.get(a);
            Assert.assertTrue(a.equals(Element.createElement(str[exp[i][0]], null, this.myParams)));
            Assert.assertTrue(h.fmin == exp[i][1]);
            Assert.assertTrue(h.fmax == exp[i][2]);
            Assert.assertTrue(h.F == exp[i][3]);
        }
    }

    @Test
    public final void testExp() {
        Assert.assertTrue(Utils.exp(2, 3) == 8L);
        Assert.assertTrue(Utils.exp(2, 5) == 32L);
        Assert.assertFalse(Utils.exp(2, 2) == 8L);
        Assert.assertTrue(Utils.exp(1, 3) == 1L);
        Assert.assertTrue(Utils.exp(0, 3) == 0L);
        Assert.assertTrue(Utils.exp(2, 0) == 1L);
        Assert.assertTrue(Utils.exp(0, 0) == 1L);
    }

    private void load(String testcase, int algo, Parameter theParams) {
        this.d = new MultiDatabase(this.dir + testcase, theParams);
        this.d.openRead();
        Vector<Element> data = this.d.readElements();
        this.phi = this.d.getPhi();
        switch (algo) {
            case 8192: {
                this.hitterAlgo = new FullAncHHH(this.d.getEpsilon(), theParams);
                break;
            }
            case 4096: {
                this.hitterAlgo = new PartAncHHH(this.d.getEpsilon(), theParams);
                break;
            }
            default: {
                throw new RuntimeException("Algorithmus angeben!");
            }
        }
        for (Element e : data) {
            this.hitterAlgo.insert(e, 1, true);
        }
    }

    private void load(String testcase, int algo) {
        this.load(testcase, algo, this.myParams);
    }

    private void validateHitter(HashMap<Element, MultiHitterInfo> res, String testcase, int nr) {
        String s = null;
        ArrayList<String> list = new ArrayList<String>();
        testcase = testcase + nr;
        for (Element e : res.keySet()) {
            list.add(e.toShortString() + " " + res.get(e).toShortString());
        }
        Collections.sort(list);
        List<String> solution = this.loadSolution(this.dir + testcase + ".res");
        Assert.assertTrue("Problem: Testcase " + nr + " Hitter Groessen unterschiedl.", list.size() == solution.size());
        for (int i = 0; i < list.size(); ++i) {
            s = (String)list.get(i);
            String pre = "Problem: Hitter Testcase " + nr + " Zeile " + i + ": ";
            String message = pre + " Berechnet: " + (String)list.get(i);
            message = message + "\nGelesen: " + solution.get(i);
            Assert.assertTrue(message, s.trim().equals(solution.get(i).trim()));
        }
    }

    private void validateDump(List<Map.Entry<Element, MultiStringElement>> dump, String testcase, int nr) {
        String s = null;
        ArrayList<String> list = new ArrayList<String>();
        testcase = testcase + nr;
        for (Map.Entry<Element, MultiStringElement> entry : dump) {
            list.add(entry.getKey().toShortString() + " " + entry.getValue().toShortString());
        }
        Collections.sort(list);
        List<String> solution = this.loadSolution(this.dir + testcase + ".data");
        Assert.assertTrue("Problem: Testcase " + nr + " Dump Groessen unterschiedl.", list.size() == solution.size());
        for (int i = 0; i < list.size(); ++i) {
            s = (String)list.get(i);
            String pre = "Problem: Dump Testcase " + nr + " Zeile " + i + ": ";
            String message = pre + " Berechnet: " + (String)list.get(i);
            message = message + "\nGelesen: " + solution.get(i);
            Assert.assertTrue(message, s.trim().equals(solution.get(i).trim()));
        }
    }

    private List<String> loadSolution(String file) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(list);
        return list;
    }

    private boolean arrayListEquals(List<int[]> a, List<int[]> b) {
        boolean equal = true;
        if (a.size() != b.size()) {
            return false;
        }
        for (int j = 0; j < a.size(); ++j) {
            int[] aArr = a.get(j);
            int[] bArr = b.get(j);
            for (int i = 0; i < aArr.length; ++i) {
                if (aArr[i] == bArr[i]) continue;
                equal = false;
            }
        }
        return equal;
    }
}

