/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.Element;
import hitters.multi.SysParameter;

public class SysElement
extends Element {
    public SysElement(String[] eStr, int[] eInt, SysParameter myParams) {
        super(eStr, eInt, myParams);
    }

    @Override
    public String toString() {
        int i;
        String myS = "";
        String seq = "";
        for (i = 0; i < this.eStr.length; ++i) {
            myS = myS + this.eStr[i];
            myS = i < this.myParams.getDim() - 1 ? myS + " (s) | " : myS + " (s)";
        }
        for (i = 0; i < this.eInt.length; ++i) {
            int[] code = new int[this.myParams.getMaskLength(i)];
            for (int j = 1; j < this.myParams.getMaskLength(i); ++j) {
                int res = this.eInt[i] & this.myParams.getMask(i, j) & ~this.myParams.getMask(i, j - 1);
                code[j] = res >>>= 32 - this.myParams.getPlength(i, j);
            }
            switch (this.getPar().dimContents(i + this.myParams.getDimS())) {
                case CALL: {
                    myS = myS + this.getPar().getTaxonomy().getPathlabel(code);
                    break;
                }
                case SEQUENCE: {
                    for (int c : code) {
                        String part = this.getPar().getTaxonomy().flat2call(c);
                        if (part == null) continue;
                        seq = seq + "/" + part;
                    }
                    if (seq.length() > 0) {
                        myS = myS + seq;
                        break;
                    }
                    myS = myS + "*";
                    break;
                }
                case RETURN: {
                    switch (code[1]) {
                        case 0: {
                            myS = myS + "*";
                            break;
                        }
                        case 1: {
                            myS = myS + "/NO_ERROR";
                            break;
                        }
                        case 2: {
                            myS = myS + "/ERROR";
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("default SysElement");
                }
            }
            myS = i < this.eInt.length - 1 ? myS + " (i) | " : myS + " (i)";
        }
        return "( " + myS + " )";
    }

    @Override
    public String toShortString() {
        int i;
        String myS = "";
        String seq = "";
        for (i = 0; i < this.eStr.length; ++i) {
            myS = myS + this.eStr[i];
            if (i >= this.myParams.getDim() - 1) continue;
            myS = myS + " | ";
        }
        for (i = 0; i < this.eInt.length; ++i) {
            int[] code = new int[this.myParams.getMaskLength(i)];
            for (int j = 1; j < this.myParams.getMaskLength(i); ++j) {
                int res = this.eInt[i] & this.myParams.getMask(i, j) & ~this.myParams.getMask(i, j - 1);
                code[j] = res >>>= 32 - this.myParams.getPlength(i, j);
            }
            switch (this.getPar().dimContents(i + this.myParams.getDimS())) {
                case CALL: {
                    myS = myS + this.getPar().getTaxonomy().getPathlabel(code);
                    break;
                }
                case SEQUENCE: {
                    for (int c : code) {
                        String part = this.getPar().getTaxonomy().flat2call(c);
                        if (part == null) continue;
                        seq = seq + "/" + part;
                    }
                    if (seq.length() > 0) {
                        myS = myS + seq;
                        break;
                    }
                    myS = myS + "*";
                    break;
                }
                case RETURN: {
                    switch (code[1]) {
                        case 0: {
                            myS = myS + "*";
                            break;
                        }
                        case 1: {
                            myS = myS + "/NO_ERROR";
                            break;
                        }
                        case 2: {
                            myS = myS + "/ERROR";
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("default SysElement");
                }
            }
            if (i >= this.eInt.length - 1) continue;
            myS = myS + " | ";
        }
        return myS;
    }

    @Override
    public SysElement clone() {
        return new SysElement(this.eStr, this.eInt, this.getPar());
    }

    private SysParameter getPar() {
        return (SysParameter)this.myParams;
    }
}

