/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.SysParameter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ProcTable {
    SysParameter myParams;
    HashMap<Integer, String> fdTable = new HashMap();
    HashMap<Integer, Boolean> fdFlag = new HashMap();
    String unfinished = "";
    int[] roundBuffer;
    int pos = 0;
    int bLength = 0;

    public ProcTable(SysParameter myParams) {
        this.myParams = myParams;
        this.bLength = myParams.getSeqLength() + 1;
        this.roundBuffer = new int[this.bLength];
        for (int i = 0; i < this.bLength; ++i) {
            this.roundBuffer[i] = -1;
        }
        this.fdTable.put(0, "/stdin");
        this.fdTable.put(1, "/stdout");
        this.fdTable.put(2, "/stderr");
        this.fdFlag.put(0, false);
        this.fdFlag.put(1, false);
        this.fdFlag.put(2, false);
    }

    public String getFile(String fd) {
        String file = null;
        int fdInt = Integer.parseInt(fd);
        file = this.fdTable.get(fdInt);
        if (file == null) {
            file = "\"/DateiUnbekannt\"";
        }
        return file;
    }

    public void putFile(int fd, String file, boolean cloExec) {
        if (file == null) {
            file = "\"/DateiUnbekannt\"";
        }
        this.fdTable.put(fd, file);
        this.fdFlag.put(fd, cloExec);
    }

    public String removeFile(String fd) {
        String file = null;
        int fdInt = Integer.parseInt(fd);
        file = this.fdTable.get(fdInt);
        this.fdTable.remove(fdInt);
        this.fdFlag.remove(fdInt);
        if (file == null) {
            file = "\"/DateiUnbekannt\"";
        }
        return file;
    }

    public void setCloseOnExec(String fd, boolean cloExec) {
        int fdInt = Integer.parseInt(fd);
        this.fdFlag.put(fdInt, cloExec);
    }

    public void doCloseOnExec() {
        Set<Integer> keys = this.fdTable.keySet();
        Iterator<Integer> it = keys.iterator();
        while (it.hasNext()) {
            int fd = it.next();
            if (!this.fdFlag.get(fd).booleanValue()) continue;
            it.remove();
            this.fdFlag.remove(fd);
        }
    }

    public boolean isUnfinished() {
        return this.unfinished.length() > 0;
    }

    public String mergeParts(String resumed) {
        String[] comps = resumed.split("<\\.\\.\\.\\s[a-z_][a-z_0-9]+\\sresumed>");
        String delim = comps[1].trim().startsWith(")") ? "" : " ";
        String result = this.unfinished + delim + comps[1].trim();
        this.unfinished = "";
        return result;
    }

    public void setUnfishedPart(String part) {
        String[] comps = part.split("<unfinished\\s\\.\\.\\.>");
        String result = comps[0];
        this.unfinished = result.trim();
    }

    public void putCall(int call) {
        this.roundBuffer[this.pos++ % this.bLength] = call;
    }

    public int[] getCalls() {
        int[] sequence = new int[this.bLength];
        int j = 0;
        for (int i = this.pos + this.bLength - 1; i >= this.pos; --i) {
            sequence[j++] = this.roundBuffer[i % this.bLength];
        }
        return sequence;
    }

    public String getSequence() {
        String seq = "";
        int[] intSequence = this.getCalls();
        if (intSequence.length == 0) {
            seq = "*";
        }
        for (int i : intSequence) {
            String part = this.myParams.getTaxonomy().flat2call(i);
            if (part == null) continue;
            seq = seq + "/" + part;
        }
        return seq;
    }

    public ProcTable clone() {
        ProcTable clone = new ProcTable(this.myParams);
        clone.fdFlag = new HashMap<Integer, Boolean>(this.fdFlag);
        clone.fdTable = new HashMap<Integer, String>(this.fdTable);
        return clone;
    }

    public ProcTable shareFd() {
        ProcTable clone = new ProcTable(this.myParams);
        clone.fdFlag = this.fdFlag;
        clone.fdTable = this.fdTable;
        return clone;
    }
}

