/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import com.rapidminer.tools.Tools;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.Parameter;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.multi.TestCaseInfo;
import hitters.tools.LogService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class MultiDatabase {
    final int HITTER = 1;
    final int NODES = 2;
    private String filename;
    private FileWriter outData;
    private BufferedWriter out;
    private FileReader inData;
    private BufferedReader in;
    private int N = -1;
    private double phi = -1.0;
    private double epsilon = -1.0;
    private Parameter myParams;

    public MultiDatabase(String filename, Parameter myParams) {
        if (LogService.shouldLog(1)) {
            LogService.log(1, "MultiDataBase: dimI lt. Par " + myParams.getDimI() + " dimS lt Par " + myParams.getDimS());
        }
        this.filename = filename;
        this.myParams = myParams;
    }

    public Vector<TestCaseInfo> readTestCaseInfo() {
        int dim = -1;
        int dimS = -1;
        int dimI = -1;
        Vector<TestCaseInfo> data = new Vector<TestCaseInfo>();
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                int i;
                if (line.length() <= 0) continue;
                if (line.startsWith("#$")) {
                    line = line.substring(2);
                    dimS = Integer.parseInt(line.split("[|]")[0].trim());
                    dimI = Integer.parseInt(line.split("[|]")[1].trim());
                    if (dimS != this.myParams.getDimS() || dimI != this.myParams.getDimI()) {
                        if (LogService.shouldLog(1)) {
                            LogService.log(1, "Dimensionen in Datei entsprechen nicht Dimensionen im Parameterobjekt.");
                        }
                        dimS = this.myParams.getDimS();
                        dimI = this.myParams.getDimI();
                    }
                    dim = dimI + dimS;
                }
                if (!line.startsWith("#@")) continue;
                if (dim < 1) {
                    throw new RuntimeException(" Dimensionen nicht in Testdatei angegeben oder null.");
                }
                String[] item = (line = line.substring(2)).split("[|]");
                if (dim != item.length - 1) {
                    throw new RuntimeException("Verschiedene Dim. beim Lesen der Daten.");
                }
                String[] clean = new String[item.length - 1];
                for (i = 0; i < item.length - 1; ++i) {
                    clean[i] = item[i].trim();
                }
                int number = Integer.parseInt(item[item.length - 1].trim());
                String[] eStr = new String[dimS];
                String[] eInt = new String[dimI];
                for (i = 0; i < dimS; ++i) {
                    eStr[i] = clean[i];
                }
                for (i = 0; i < dimI; ++i) {
                    eInt[i] = clean[i + dimS];
                }
                Element e = Element.createElement(eStr, eInt, this.myParams);
                data.add(new TestCaseInfo(e, number));
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        return data;
    }

    public Vector<Element> readElements() {
        int dim = -1;
        int dimS = -1;
        int dimI = -1;
        Vector<Element> data = new Vector<Element>();
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                int i;
                if (line.length() <= 0) continue;
                if (line.startsWith("#$")) {
                    line = line.substring(2);
                    dimS = Integer.parseInt(line.split("[|]")[0].trim());
                    dimI = Integer.parseInt(line.split("[|]")[1].trim());
                    if (dimS != this.myParams.getDimS() || dimI != this.myParams.getDimI()) {
                        if (LogService.shouldLog(1)) {
                            LogService.log(1, "Dimensionen in Datei entsprechen nicht Dimensionen im Parameterobjekt.");
                        }
                        dimS = this.myParams.getDimS();
                        dimI = this.myParams.getDimI();
                    }
                    dim = dimI + dimS;
                }
                if (!line.startsWith("/")) continue;
                if (dim < 1) {
                    throw new RuntimeException("Dimensionen nicht in Datei angegeben oder null.");
                }
                String[] item = line.split("[|]");
                if (dim != item.length) {
                    throw new RuntimeException("Verschiedene Dim. beim Lesen der Daten.");
                }
                String[] clean = new String[item.length];
                for (i = 0; i < item.length; ++i) {
                    clean[i] = item[i].trim();
                }
                String[] eStr = new String[dimS];
                String[] eInt = new String[dimI];
                for (i = 0; i < dimS; ++i) {
                    eStr[i] = clean[i];
                }
                for (i = 0; i < dimI; ++i) {
                    eInt[i] = clean[i + dimS];
                }
                Element e = Element.createElement(eStr, eInt, this.myParams);
                data.add(e.clone());
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return data;
    }

    public Vector<Element> readSystemCalls() {
        SysElement e = null;
        Vector<Element> data = new Vector<Element>();
        if (!(this.myParams instanceof SysParameter)) {
            throw new RuntimeException("System Calls lesen nur mit Parameterobjekt vom Typ SysParameter.");
        }
        SysParameter sysPar = (SysParameter)this.myParams;
        SysParser parser = new SysParser(sysPar);
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                if (line.length() <= 0) continue;
                if (LogService.shouldLog(1)) {
                    LogService.log(1, "DATABASE lese : System Call " + line);
                }
                e = null;
                e = parser.createElement(line);
                if (e == null) continue;
                if (sysPar.capDepth()) {
                    e.capHierarchy(sysPar.getCap());
                }
                data.add(e);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return data;
    }

    public boolean openRead() {
        boolean success = true;
        try {
            this.inData = new FileReader(this.filename);
            this.in = new BufferedReader(this.inData);
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
            success = false;
        }
        return success;
    }

    public void closeRead() {
        try {
            this.in.close();
            this.inData.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean openWrite() {
        boolean success = true;
        try {
            this.outData = new FileWriter(this.filename);
            this.out = new BufferedWriter(this.outData);
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
            success = false;
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public void closeWrite() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
    }

    public void println(String s) {
        try {
            this.out.write(s + System.getProperty("line.separator"));
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() {
        this.closeRead();
        this.openRead();
    }

    public double getPhi() {
        if (this.in != null) {
            this.reset();
        } else {
            this.openRead();
        }
        if (this.phi < 0.0) {
            this.readSolution();
        }
        if (this.phi < -1.0E-10) {
            throw new RuntimeException("Kann phi nicht lesen");
        }
        this.closeRead();
        return this.phi;
    }

    public double getEpsilon() {
        if (this.in != null) {
            this.reset();
        } else {
            this.openRead();
        }
        if (this.epsilon < 0.0) {
            this.readSolution();
        }
        if (this.epsilon < -1.0E-10) {
            throw new RuntimeException("Kann epsilon nicht lesen");
        }
        this.closeRead();
        return this.epsilon;
    }

    public int getSize() {
        if (this.in != null) {
            this.reset();
        } else {
            this.openRead();
        }
        if (this.N < 0) {
            this.readSolution();
        }
        if (this.N < 0) {
            throw new RuntimeException("Kann N nicht lesen");
        }
        this.closeRead();
        return this.N;
    }

    public HashMap<Element, MultiStringElement> readNodes() {
        HashMap map = this.genericReadSolution(2);
        return map;
    }

    public HashMap<Element, MultiHitterInfo> readSolution() {
        HashMap map = this.genericReadSolution(1);
        return map;
    }

    public static void saveHHH(Set<Element> res, String saveFile, String original, Parameter par, double epsilon, double phi, AlgoType algo) {
        MultiDatabase.saveHHH(res, saveFile, original, (SysParameter)par, epsilon, phi, algo);
    }

    public static void saveHHH(Set<Element> res, String saveFile, String original, SysParameter par, double epsilon, double phi, AlgoType algo) {
        BufferedWriter out = null;
        saveFile = saveFile + ".hhh";
        String cr = System.getProperty("line.sparator");
        cr = Tools.getLineSeparator();
        try {
            out = new BufferedWriter(new FileWriter(saveFile));
            out.write(par.dimString() + cr);
            for (Element el : res) {
                out.write(el.toShortString() + cr);
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            out.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
    }

    public static Set<Element> readHHH(String file) {
        HashSet<Element> res = new HashSet<Element>();
        BufferedReader in = null;
        SysParameter par = null;
        SysParser parser = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file + ".hhh"));
            while ((line = in.readLine()) != null && par == null) {
                if (line.length() <= 0 || !line.startsWith("# Dimensionen = [")) continue;
                String[] comps = line.split("\\[|\\]");
                comps = comps[1].split(",");
                DimType[] dims = new DimType[comps.length];
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i].trim().equals("PATH")) {
                        dims[i] = DimType.PATH;
                    }
                    if (comps[i].trim().equals("CALL")) {
                        dims[i] = DimType.CALL;
                    }
                    if (comps[i].trim().equals("SEQUENCE")) {
                        dims[i] = DimType.SEQUENCE;
                    }
                    if (!comps[i].trim().equals("RETURN")) continue;
                    dims[i] = DimType.RETURN;
                }
                par = new SysParameter(dims);
                parser = new SysParser(par);
            }
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                SysElement el = parser.parseLine(line);
                if (el == null) {
                    throw new RuntimeException("readHHH: Can't  parse line: " + line);
                }
                res.add(el);
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            in.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        return res;
    }

    public static Set<Element> readSpincHHH(String file) {
        HashSet<Element> res = new HashSet<Element>();
        BufferedReader in = null;
        SysParameter par = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file + ".hhh"));
            while ((line = in.readLine()) != null && par == null) {
                if (line.length() <= 0 || !line.startsWith("# Dimensionen = [")) continue;
                String[] comps = line.split("\\[|\\]");
                comps = comps[1].split(",");
                DimType[] dims = new DimType[comps.length];
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i].trim().equals("PATH")) {
                        dims[i] = DimType.PATH;
                    }
                    if (comps[i].trim().equals("CALL")) {
                        dims[i] = DimType.CALL;
                    }
                    if (comps[i].trim().equals("SEQUENCE")) {
                        dims[i] = DimType.SEQUENCE;
                    }
                    if (!comps[i].trim().equals("RETURN")) continue;
                    dims[i] = DimType.RETURN;
                }
                if (dims.length > 1 && dims[0] != DimType.PATH) {
                    throw new RuntimeException("Use PATH only for Spincyk-logs.");
                }
                par = new SysParameter(dims);
            }
            while ((line = in.readLine()) != null) {
                Element el;
                if (line.length() <= 0 || line.startsWith("#")) continue;
                String fl = line.trim();
                if (fl.equals("")) {
                    throw new RuntimeException("readHHH: Can't  parse line: " + line);
                }
                if (fl.length() > 1) {
                    fl = "/" + fl;
                }
                if ((el = Element.createElement(new String[]{fl}, par)) == null) {
                    throw new RuntimeException("readHHH: Can't  parse line: " + line);
                }
                res.add(el);
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            in.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        return res;
    }

    private HashMap genericReadSolution(int type) {
        HashMap<Element, Comparable<MultiHitterInfo>> solution = null;
        String marker = null;
        switch (type) {
            case 1: {
                marker = "#=";
                solution = new HashMap<Element, Comparable<MultiHitterInfo>>();
                break;
            }
            case 2: {
                marker = "#*";
                solution = new HashMap();
            }
        }
        int dim = -1;
        int dimS = -1;
        int dimI = -1;
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                int i;
                if (line.length() <= 0) continue;
                if (line.startsWith("#$")) {
                    line = line.substring(2);
                    dimS = Integer.parseInt(line.split("[|]")[0].trim());
                    dimI = Integer.parseInt(line.split("[|]")[1].trim());
                    if (dimS != this.myParams.getDimS() || dimI != this.myParams.getDimI()) {
                        if (LogService.shouldLog(1)) {
                            LogService.log(1, "Dimensionen in Datei entsprechen nicht Dimensionen im Parameterobjekt.");
                        }
                        dimS = this.myParams.getDimS();
                        dimI = this.myParams.getDimI();
                    }
                    dim = dimI + dimS;
                }
                if (line.startsWith("#%")) {
                    line = line.substring(2);
                    this.N = Integer.parseInt(line.split("[|]")[0].trim());
                    this.phi = Double.parseDouble(line.split("[|]")[1].trim());
                    this.epsilon = Double.parseDouble(line.split("[|]")[2].trim());
                }
                if (!line.startsWith(marker)) continue;
                if (dim < 1) {
                    throw new RuntimeException("Dimensionen nicht in Musterl\u00ef\u00bf\u00bdsung angegeben oder null.");
                }
                if (this.phi < -1.0E10) {
                    throw new RuntimeException("Phi nicht in Musterl\u00ef\u00bf\u00bdsung angegeben.");
                }
                if (this.epsilon < -1.0E10) {
                    throw new RuntimeException(" Epsilon nicht in Musterl\u00ef\u00bf\u00bdsung angegeben.");
                }
                String[] item = (line = line.substring(2)).split("[|]");
                if (dim != item.length - 3) {
                    throw new RuntimeException("Verschiedene Dim. beim Lesen der Daten.");
                }
                String[] clean = new String[item.length - 3];
                for (i = 0; i < item.length - 3; ++i) {
                    clean[i] = item[i].trim();
                }
                int i1 = Integer.parseInt(item[item.length - 3].trim());
                int i2 = Integer.parseInt(item[item.length - 2].trim());
                int i3 = Integer.parseInt(item[item.length - 1].trim());
                String[] eStr = new String[dimS];
                String[] eInt = new String[dimI];
                for (i = 0; i < dimS; ++i) {
                    eStr[i] = clean[i];
                }
                for (i = 0; i < dimI; ++i) {
                    eInt[i] = clean[i + dimS];
                }
                Element e = Element.createElement(eStr, eInt, this.myParams);
                switch (type) {
                    case 1: {
                        solution.put(e, new MultiHitterInfo(i1, i2, i3));
                        break;
                    }
                    case 2: {
                        solution.put(e, new MultiStringElement(i1, i2, i3));
                    }
                }
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        return solution;
    }
}

