/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import com.google.common.collect.HashMultiset;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.Element;
import hitters.multi.HitterComparator;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.NodeComparator;
import hitters.multi.OLD_AbstractComplexHHH;
import hitters.multi.Parameter;
import hitters.tools.LogService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class HitterPolice {
    static Comparator<Map.Entry<Element, MultiStringElement>> nodeComparator = new NodeComparator();
    static Comparator<Map.Entry<Element, MultiHitterInfo>> hitterComparator = new HitterComparator();

    public static boolean compareToSolution(String testCase, AbstractComplexHHH partAnc, Parameter myParams, double phiUsed, boolean sysCall) {
        boolean bl;
        boolean datenGleich;
        MultiDatabase d = new MultiDatabase(testCase, myParams);
        double epsUsed = partAnc.getEpsilon();
        if (sysCall) {
            throw new RuntimeException("compareToSolution fuer SysCalls nicht impl.");
        }
        d.openRead();
        HashMap<Element, MultiHitterInfo> solutionHitters = d.readSolution();
        double phi = d.getPhi();
        double epsilon = d.getEpsilon();
        d.reset();
        HashMap<Element, MultiStringElement> nodes = d.readNodes();
        d.closeRead();
        if (phi < epsilon + 1.0E-10) {
            throw new RuntimeException(" Phi < Epsilon, keine gute Idee: phi= " + phi + " eps= " + epsilon);
        }
        if (Math.abs(phi - phiUsed) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Phi-Werte in Datei und Methodenaufruf: " + phi + ", " + phiUsed);
        }
        if (Math.abs(epsilon - epsUsed) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Epsilon-Werte in Datei und partAnc");
        }
        HashMap<Element, MultiHitterInfo> partAncHitters = partAnc.outputSet(phi);
        ArrayList<Map.Entry<Element, MultiHitterInfo>> paHitterList = new ArrayList<Map.Entry<Element, MultiHitterInfo>>(partAncHitters.entrySet());
        ArrayList<Map.Entry<Element, MultiHitterInfo>> solHitterList = new ArrayList<Map.Entry<Element, MultiHitterInfo>>(solutionHitters.entrySet());
        Collections.sort(paHitterList, hitterComparator);
        Collections.sort(solHitterList, hitterComparator);
        List<Map.Entry<Element, MultiStringElement>> paNodes = partAnc.dumpTrie();
        ArrayList<Map.Entry<Element, MultiStringElement>> fileNodes = new ArrayList<Map.Entry<Element, MultiStringElement>>(nodes.entrySet());
        Collections.sort(paNodes, nodeComparator);
        Collections.sort(fileNodes, nodeComparator);
        if (LogService.shouldLog(128)) {
            LogService.log(128, "\nDatenstruktur berechnet: ");
            for (Map.Entry<Element, MultiStringElement> entry : paNodes) {
                LogService.log(128, entry);
            }
            LogService.log(128, "\nApproximative Hitter: ");
            for (Map.Entry<Element, Comparable<MultiStringElement>> entry : paHitterList) {
                LogService.log(128, entry);
            }
            LogService.log(128, "Approximative Hitter: Anzahl= " + partAncHitters.size());
            LogService.log(128, " \n ************************************** \n ");
            LogService.log(128, "\nDatenstruktur gelesen: ");
            for (Map.Entry<Element, Comparable<MultiStringElement>> entry : fileNodes) {
                LogService.log(128, entry);
            }
            LogService.log(128, "\nSolutionHitters: ");
            for (Map.Entry<Element, Comparable<MultiStringElement>> entry : solHitterList) {
                LogService.log(128, entry);
            }
            LogService.log(128, "solutionHitters: Anzahl= " + solutionHitters.size());
            LogService.log(128, "Loesungen gleich: " + solutionHitters.equals(partAncHitters));
            LogService.log(128, "Datenstrukturen gleich: ");
            LogService.log(128, fileNodes.containsAll(paNodes) && paNodes.containsAll(fileNodes));
        }
        boolean bl2 = datenGleich = fileNodes.containsAll(paNodes) && paNodes.containsAll(fileNodes);
        if (!datenGleich && LogService.shouldLog(128)) {
            LogService.log(128, " Berechnete Datenstruktur entspricht nicht der Datenstruktur laut Datei.");
        }
        if (!(bl = solutionHitters.equals(partAncHitters)) && LogService.shouldLog(128)) {
            LogService.log(128, " Berechnete HHH entsprechen nicht den HHH laut Datei.");
        }
        return datenGleich && bl;
    }

    public static boolean check(String testCase, AbstractComplexHHH partAnc, Parameter myParams, double phiUsed, boolean sysCall) {
        double epsilon;
        double phi;
        int N;
        Vector<Element> data;
        boolean correct = true;
        MultiDatabase d = new MultiDatabase(testCase, myParams);
        int trueCount = 0;
        double epsUsed = partAnc.getEpsilon();
        if (sysCall) {
            d.openRead();
            data = d.readSystemCalls();
            N = data.size();
            phi = phiUsed;
            epsilon = epsUsed;
        } else {
            d.openRead();
            data = d.readElements();
            d.reset();
            N = d.getSize();
            phi = d.getPhi();
            epsilon = d.getEpsilon();
        }
        if (N != data.size()) {
            throw new RuntimeException("Falscher N-Wert in Datei: " + N + ". Tats.: " + data.size());
        }
        if (phi < epsilon + 1.0E-10) {
            throw new RuntimeException(" Phi < Epsilon, keine gute Idee: phi= " + phi + " eps= " + epsilon);
        }
        if (Math.abs(phi - phiUsed) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Phi-Werte in Datei und Methodenaufruf: " + phi + ", " + phiUsed);
        }
        if (Math.abs(epsilon - epsUsed) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Epsilon-Werte in Datei und partAnc");
        }
        if (LogService.shouldLog(1)) {
            LogService.log(1, "Trie: " + partAnc.dumpTrie());
        }
        HashMultiset prefixSet = HashMultiset.create();
        HashMultiset elementSet = HashMultiset.create();
        Element a = new Element(myParams);
        Element b = new Element(myParams);
        for (Element e : data) {
            a.setTo(e);
            elementSet.add(a.clone());
            int lim0 = a.getLevel(0);
            int lim1 = a.getLevel(1);
            for (int i = 0; i <= lim0; ++i) {
                if (i > 0) {
                    a.turnIntoParent(0);
                }
                b.setTo(a);
                for (int j = 0; j <= lim1; ++j) {
                    if (j > 0) {
                        b.turnIntoParent(1);
                    }
                    prefixSet.add(b.clone());
                }
            }
        }
        HashMap<Element, Integer> estF = partAnc.dumpF(phi);
        int limit = 1;
        for (int round = 0; round < limit; ++round) {
            double phiNow = epsilon + (double)(round + 1 + limit) * (phi - epsilon) / (double)(2 * limit);
            HashMap<Element, MultiHitterInfo> partAncHitters = partAnc.outputSet(phiNow);
            double marg = partAnc.getEpsilon() * (double)partAnc.getN();
            if (LogService.shouldLog(256)) {
                LogService.log(256, "Approximative Hitter: ");
            }
            for (Map.Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet()) {
                if (!LogService.shouldLog(256)) continue;
                LogService.log(256, entr);
            }
            if (LogService.shouldLog(256)) {
                LogService.log(256, "phiNow= " + phiNow + " Approximative Hitter: Anzahl= " + partAncHitters.size());
            }
            for (Element elem : partAncHitters.keySet()) {
                trueCount = prefixSet.count(elem);
                MultiHitterInfo mhi = partAncHitters.get(elem);
                if (trueCount < mhi.fmin) {
                    correct = false;
                    System.out.println("Zu gro\u00df: Element: " + elem + " hat" + " TrueCount " + trueCount + " aber fmin=" + mhi.fmin + " und fmax =" + mhi.fmax);
                }
                if (trueCount > mhi.fmax) {
                    correct = false;
                    System.out.println("Zu klein: Element: " + elem + " hat" + " TrueCount " + trueCount + " aber fmin=" + mhi.fmin + " und fmax =" + mhi.fmax);
                }
                if (!((double)(mhi.fmax - mhi.fmin) > 2.0 * marg)) continue;
                correct = false;
                System.out.println("Spanne: Element: " + elem + " hat" + " 2 * marg " + 2.0 * marg + " aber fmin=" + mhi.fmin + " und fmax =" + mhi.fmax);
            }
            if (LogService.shouldLog(1)) {
                LogService.log(1, "Nach ab) - alles korrekt: " + correct);
            }
            HashMap<Element, Integer> F = new HashMap<Element, Integer>();
            int[] label = new int[myParams.getDim()];
            if (myParams.getDim() != 2) {
                throw new RuntimeException("Hitterpolice: Dimension muss 2 sein.");
            }
            Element p = new Element(myParams);
            for (Element e : elementSet.elementSet()) {
                F.put(e, 0);
            }
            for (int l = myParams.getL(); l >= 0; --l) {
                for (int i = 0; i <= l; ++i) {
                    label[0] = i;
                    label[1] = l - i;
                    if (label[0] > myParams.gethi(0) || label[1] > myParams.gethi(1)) continue;
                    if (LogService.shouldLog(16)) {
                        LogService.log(16, " ***Police Label: [" + label[0] + "," + label[1] + "] ***");
                    }
                    for (Element e : elementSet.elementSet()) {
                        if (LogService.shouldLog(16)) {
                            LogService.log(16, "Berabeite nun " + e);
                        }
                        p.setTo(e);
                        if (!p.generalizeTo(label)) continue;
                        boolean block = false;
                        for (Element h : partAncHitters.keySet()) {
                            if (h.getL() > l && h.isGenOf(e) && p.isGenOf(h)) {
                                block = true;
                            }
                            if (!h.equals(p)) continue;
                            block = true;
                        }
                        if (block) continue;
                        if (!F.containsKey(p)) {
                            F.put(p.clone(), elementSet.count(e));
                        } else {
                            F.put(p.clone(), (Integer)F.get(p) + elementSet.count(e));
                        }
                        if (!LogService.shouldLog(16)) continue;
                        LogService.log(16, "Police: Addiere " + elementSet.count(e) + " zu F " + "f\u00fcr p=" + p + " wegen " + e);
                    }
                }
                if (LogService.shouldLog(16)) {
                    LogService.log(16, "\nEbene beendet: " + l);
                }
                for (Element e : F.keySet()) {
                    MultiHitterInfo h;
                    if (e.getL() != l) continue;
                    if ((double)((Integer)F.get(e)).intValue() >= phiNow * (double)N) {
                        correct = false;
                        h = new MultiHitterInfo(prefixSet.count(e), prefixSet.count(e), (Integer)F.get(e));
                        System.out.println("h\u00e4tte ausgegeben werden m\u00fcssen: " + e + " mit h=" + h + " wegen phiNow * N =" + phiNow * (double)N + " F=" + F.get(e));
                        continue;
                    }
                    int estFint = estF.get(e) == null ? 0 : estF.get(e);
                    if ((Integer)F.get(e) <= estFint + partAnc.instantiateDelta(e)) continue;
                    correct = false;
                    System.out.println("N=" + N + " Schaetzung F zu niedrig");
                    h = new MultiHitterInfo(prefixSet.count(e), prefixSet.count(e), (Integer)F.get(e));
                    System.out.println("zu niedrig: " + e + "  " + h + " mit delta=" + partAnc.instantiateDelta(e) + " gesch F= " + estF.get(e));
                }
            }
            if (LogService.shouldLog(16)) {
                LogService.log(16, "Nach e)  correct = " + correct);
            }
            if (correct) continue;
            System.out.println("\n\ngefunden Approximative Hitter: ");
            for (Map.Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet()) {
                System.out.println(" gefunden " + entr);
            }
            System.out.println("gefunden phiNow= " + phiNow + " Approximative Hitter: Anzahl= " + partAncHitters.size());
        }
        return correct;
    }

    public static boolean check(String testCase, OLD_AbstractComplexHHH partAnc, Parameter myParams, double phiUsed, boolean sysCall) {
        double epsilon;
        double phi;
        int N;
        Vector<Element> data;
        boolean correct = true;
        MultiDatabase d = new MultiDatabase(testCase, myParams);
        int trueCount = 0;
        double epsUsed = partAnc.getEpsilon();
        if (sysCall) {
            d.openRead();
            data = d.readSystemCalls();
            N = data.size();
            phi = phiUsed;
            epsilon = epsUsed;
        } else {
            d.openRead();
            data = d.readElements();
            d.reset();
            N = d.getSize();
            phi = d.getPhi();
            epsilon = d.getEpsilon();
        }
        if (N != data.size()) {
            throw new RuntimeException("Falscher N-Wert in Datei: " + N + ". Tats.: " + data.size());
        }
        if (phi < epsilon + 1.0E-10) {
            throw new RuntimeException(" Phi < Epsilon, keine gute Idee: phi= " + phi + " eps= " + epsilon);
        }
        if (Math.abs(phi - phiUsed) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Phi-Werte in Datei und Methodenaufruf: " + phi + ", " + phiUsed);
        }
        if (Math.abs(epsilon - epsUsed) > 1.0E-10) {
            throw new RuntimeException("Verschiedene Epsilon-Werte in Datei und partAnc");
        }
        if (LogService.shouldLog(1)) {
            LogService.log(1, "Trie: " + partAnc.dumpTrie());
        }
        HashMultiset prefixSet = HashMultiset.create();
        HashMultiset elementSet = HashMultiset.create();
        Element a = new Element(myParams);
        Element b = new Element(myParams);
        for (Element e : data) {
            a.setTo(e);
            elementSet.add(a.clone());
            int lim0 = a.getLevel(0);
            int lim1 = a.getLevel(1);
            for (int i = 0; i <= lim0; ++i) {
                if (i > 0) {
                    a.turnIntoParent(0);
                }
                b.setTo(a);
                for (int j = 0; j <= lim1; ++j) {
                    if (j > 0) {
                        b.turnIntoParent(1);
                    }
                    prefixSet.add(b.clone());
                }
            }
        }
        HashMap<Element, Integer> estF = partAnc.dumpF(phi);
        int limit = 1;
        for (int round = 0; round < limit; ++round) {
            double phiNow = epsilon + (double)(round + 1 + limit) * (phi - epsilon) / (double)(2 * limit);
            HashMap<Element, MultiHitterInfo> partAncHitters = partAnc.outputSet(phiNow);
            double marg = partAnc.getEpsilon() * (double)partAnc.getN();
            if (LogService.shouldLog(256)) {
                LogService.log(256, "Approximative Hitter: ");
            }
            for (Map.Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet()) {
                if (!LogService.shouldLog(256)) continue;
                LogService.log(256, entr);
            }
            if (LogService.shouldLog(256)) {
                LogService.log(256, "phiNow= " + phiNow + " Approximative Hitter: Anzahl= " + partAncHitters.size());
            }
            for (Element elem : partAncHitters.keySet()) {
                trueCount = prefixSet.count(elem);
                MultiHitterInfo mhi = partAncHitters.get(elem);
                if (trueCount < mhi.fmin) {
                    correct = false;
                    System.out.println("Zu gro\u00df: Element: " + elem + " hat" + " TrueCount " + trueCount + " aber fmin=" + mhi.fmin + " und fmax =" + mhi.fmax);
                }
                if (trueCount > mhi.fmax) {
                    correct = false;
                    System.out.println("Zu klein: Element: " + elem + " hat" + " TrueCount " + trueCount + " aber fmin=" + mhi.fmin + " und fmax =" + mhi.fmax);
                }
                if (!((double)(mhi.fmax - mhi.fmin) > 2.0 * marg)) continue;
                correct = false;
                System.out.println("Spanne: Element: " + elem + " hat" + " 2 * marg " + 2.0 * marg + " aber fmin=" + mhi.fmin + " und fmax =" + mhi.fmax);
            }
            if (LogService.shouldLog(1)) {
                LogService.log(1, "Nach ab) - alles korrekt: " + correct);
            }
            HashMap<Element, Integer> F = new HashMap<Element, Integer>();
            int[] label = new int[myParams.getDim()];
            if (myParams.getDim() != 2) {
                throw new RuntimeException("Hitterpolice: Dimension muss 2 sein.");
            }
            Element p = new Element(myParams);
            for (Element e : elementSet.elementSet()) {
                F.put(e, 0);
            }
            for (int l = myParams.getL(); l >= 0; --l) {
                for (int i = 0; i <= l; ++i) {
                    label[0] = i;
                    label[1] = l - i;
                    if (label[0] > myParams.gethi(0) || label[1] > myParams.gethi(1)) continue;
                    if (LogService.shouldLog(16)) {
                        LogService.log(16, " ***Police Label: [" + label[0] + "," + label[1] + "] ***");
                    }
                    for (Element e : elementSet.elementSet()) {
                        if (LogService.shouldLog(16)) {
                            LogService.log(16, "Berabeite nun " + e);
                        }
                        p.setTo(e);
                        if (!p.generalizeTo(label)) continue;
                        boolean block = false;
                        for (Element h : partAncHitters.keySet()) {
                            if (h.getL() > l && h.isGenOf(e) && p.isGenOf(h)) {
                                block = true;
                            }
                            if (!h.equals(p)) continue;
                            block = true;
                        }
                        if (block) continue;
                        if (!F.containsKey(p)) {
                            F.put(p.clone(), elementSet.count(e));
                        } else {
                            F.put(p.clone(), (Integer)F.get(p) + elementSet.count(e));
                        }
                        if (!LogService.shouldLog(16)) continue;
                        LogService.log(16, "Police: Addiere " + elementSet.count(e) + " zu F " + "f\u00fcr p=" + p + " wegen " + e);
                    }
                }
                if (LogService.shouldLog(16)) {
                    LogService.log(16, "\nEbene beendet: " + l);
                }
                for (Element e : F.keySet()) {
                    MultiHitterInfo h;
                    if (e.getL() != l) continue;
                    if ((double)((Integer)F.get(e)).intValue() >= phiNow * (double)N) {
                        correct = false;
                        h = new MultiHitterInfo(prefixSet.count(e), prefixSet.count(e), (Integer)F.get(e));
                        System.out.println("h\u00e4tte ausgegeben werden m\u00fcssen: " + e + " mit h=" + h + " wegen phiNow * N =" + phiNow * (double)N + " F=" + F.get(e));
                        continue;
                    }
                    int estFint = estF.get(e) == null ? 0 : estF.get(e);
                    if ((Integer)F.get(e) <= estFint + partAnc.instantiateDelta(e)) continue;
                    correct = false;
                    System.out.println("N=" + N + " Schaetzung F zu niedrig");
                    h = new MultiHitterInfo(prefixSet.count(e), prefixSet.count(e), (Integer)F.get(e));
                    System.out.println("zu niedrig: " + e + "  " + h + " mit delta=" + partAnc.instantiateDelta(e) + " gesch F= " + estF.get(e));
                }
            }
            if (LogService.shouldLog(16)) {
                LogService.log(16, "Nach e)  correct = " + correct);
            }
            if (correct) continue;
            System.out.println("\n\ngefunden Approximative Hitter: ");
            for (Map.Entry<Element, MultiHitterInfo> entr : partAncHitters.entrySet()) {
                System.out.println(" gefunden " + entr);
            }
            System.out.println("gefunden phiNow= " + phiNow + " Approximative Hitter: Anzahl= " + partAncHitters.size());
        }
        return correct;
    }
}

