/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.Element;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Evaluation {
    public static final int OGM_GANESAN = 0;
    public static final int OGM_CORMODE = 1;
    public static final int BGM = 2;
    public static final int BGM2 = 3;

    public static double jaccard(Set<Element> approx, Set<Element> exact) {
        int cut = 0;
        for (Element elem : approx) {
            if (!exact.contains(elem)) continue;
            ++cut;
        }
        int join = approx.size() + exact.size() - cut;
        return (double)cut / (double)join;
    }

    public static double dice(Set<Element> approx, Set<Element> exact) {
        int cut = 0;
        for (Element elem : approx) {
            if (!exact.contains(elem)) continue;
            ++cut;
        }
        int sum = approx.size() + exact.size();
        return (double)(2 * cut) / (double)sum;
    }

    public static double precision(Set<Element> approx, Set<Element> exact) {
        int count = 0;
        for (Element elem : approx) {
            if (!exact.contains(elem)) continue;
            ++count;
        }
        if (approx.size() == 0) {
            return 0.0;
        }
        return (double)count / (double)approx.size();
    }

    public static double recall(Set<Element> approx, Set<Element> exact) {
        int count = 0;
        for (Element elem : exact) {
            if (!approx.contains(elem)) continue;
            ++count;
        }
        return (double)count / (double)exact.size();
    }

    public static double ogmGanesan(Set<Element> approx, Set<Element> exact) {
        double sim = 0.0;
        for (Element elem : exact) {
            sim += Evaluation.elemSimGanesan(elem, approx);
        }
        for (Element elem : approx) {
            sim += Evaluation.elemSimGanesan(elem, exact);
        }
        double res = sim / (double)(exact.size() + approx.size());
        return res;
    }

    public static double ogmCormode(Set<Element> approx, Set<Element> exact) {
        double term1 = 0.0;
        double term2 = 0.0;
        for (Element elem : approx) {
            term1 += Math.abs(Evaluation.depthLca(elem, exact) - (double)elem.getL());
        }
        for (Element elem : exact) {
            term2 += Math.abs(Evaluation.depthLca(elem, approx) - (double)elem.getL());
        }
        double res = 1.0 - term1 - term2;
        return res;
    }

    public static double bgm(Set<Element> approx, Set<Element> exact) {
        double erg;
        Element lca;
        Element match;
        double term1 = 0.0;
        double term2 = 0.0;
        for (Element elem : approx) {
            match = Evaluation.bestMatch(elem, exact);
            lca = elem.getLca(match);
            erg = elem.getL() + match.getL() - 2 * lca.getL();
            term1 += erg;
        }
        for (Element elem : exact) {
            match = Evaluation.bestMatch(elem, approx);
            lca = elem.getLca(match);
            erg = elem.getL() + match.getL() - 2 * lca.getL();
            term2 += erg;
        }
        double res = 1.0 - term1 - term2;
        return res;
    }

    public static double bgm2(Set<Element> approx, Set<Element> exact) {
        Element lca;
        Element match;
        double sim = 0.0;
        for (Element elem : approx) {
            match = Evaluation.bestMatch(elem, exact);
            if (elem.getL() == 0 && match.getL() == 0) {
                sim += 1.0;
                continue;
            }
            if (elem.getL() == 0 || match.getL() == 0) {
                sim += 0.5;
                continue;
            }
            lca = elem.getLca(match);
            sim += 0.5 * (double)lca.getL() * (1.0 / (double)elem.getL() + 1.0 / (double)match.getL());
        }
        for (Element elem : exact) {
            match = Evaluation.bestMatch(elem, approx);
            if (elem.getL() == 0 && match.getL() == 0) {
                sim += 1.0;
                continue;
            }
            if (elem.getL() == 0 || match.getL() == 0) {
                sim += 0.5;
                continue;
            }
            lca = elem.getLca(match);
            sim += 0.5 * (double)lca.getL() * (1.0 / (double)elem.getL() + 1.0 / (double)match.getL());
        }
        double res = sim / (double)(exact.size() + approx.size());
        return res;
    }

    public static double dsm(Map<Element, Integer> approxDs, Map<Element, Integer> exactDs) {
        int max;
        int min;
        int otherVal;
        Integer other;
        int thisVal;
        double sum = 0.0;
        HashSet<Element> union = new HashSet<Element>();
        for (Element e : approxDs.keySet()) {
            union.add(e);
        }
        for (Element e : exactDs.keySet()) {
            union.add(e);
        }
        for (Element e : approxDs.keySet()) {
            thisVal = approxDs.get(e);
            other = exactDs.get(e);
            otherVal = other == null ? 0 : other;
            min = Math.min(thisVal, otherVal);
            max = Math.max(thisVal, otherVal);
            sum += (double)min / (double)(min + max);
            if (other != null) continue;
            sum += (double)(min / (min + max));
        }
        for (Element e : exactDs.keySet()) {
            thisVal = exactDs.get(e);
            other = approxDs.get(e);
            otherVal = other == null ? 0 : other;
            min = Math.min(thisVal, otherVal);
            max = Math.max(thisVal, otherVal);
            sum += (double)min / (double)(min + max);
            if (other != null) continue;
            sum += (double)(min / (min + max));
        }
        return sum / (double)union.size();
    }

    public static String evaluate(Set<Element> approx, Set<Element> exact) {
        String result = "OGMGanesan = " + Evaluation.ogmGanesan(approx, exact);
        result = result + "\nOGMCormode = " + Evaluation.ogmCormode(approx, exact);
        result = result + "\nBgm = " + Evaluation.bgm(approx, exact);
        result = result + "\nBgm2 = " + Evaluation.bgm2(approx, exact);
        return result;
    }

    public static String compactHierarch(Set<Element> approx, Set<Element> exact) {
        String result = Evaluation.ogmGanesan(approx, exact) + ";";
        result = result + Evaluation.ogmCormode(approx, exact) + ";";
        result = result + Evaluation.bgm(approx, exact) + ";";
        result = result + Evaluation.bgm2(approx, exact);
        return result;
    }

    public static String compactFlat(Set<Element> approx, Set<Element> exact) {
        String result = Evaluation.precision(approx, exact) + ";";
        result = result + Evaluation.recall(approx, exact) + ";";
        result = result + Evaluation.jaccard(approx, exact) + ";";
        result = result + Evaluation.dice(approx, exact);
        return result;
    }

    public static String compactAll(Set<Element> approx, Set<Element> exact) {
        return Evaluation.compactFlat(approx, exact) + ";" + Evaluation.compactHierarch(approx, exact);
    }

    private static double elemSimGanesan(Element e, Set<Element> other) {
        if (e.getL() == 0) {
            return 1.0;
        }
        return (double)Evaluation.bestLca(e, other).getL() / (double)e.getL();
    }

    private static double depthLca(Element e, Set<Element> other) {
        Element lca = Evaluation.bestLca(e, other);
        return lca.getL();
    }

    private static Element bestLca(Element e, Set<Element> other) {
        return e.getLca(Evaluation.bestMatch(e, other));
    }

    private static Element bestMatch(Element e, Set<Element> other) {
        Element bestMatch = null;
        int bestDepth = -1;
        int bestMatchDepth = Integer.MAX_VALUE;
        if (other.size() == 0) {
            throw new RuntimeException();
        }
        for (Element cand : other) {
            Element lca = e.getLca(cand);
            if (lca.getL() > bestDepth) {
                bestDepth = lca.getL();
                bestMatchDepth = cand.getL();
                bestMatch = cand;
            }
            if (lca.getL() != bestDepth || cand.getL() >= bestMatchDepth) continue;
            bestDepth = lca.getL();
            bestMatchDepth = cand.getL();
            bestMatch = cand;
        }
        return bestMatch;
    }

    public static Double distance(int distanceMeasure, Set<Element> sample, Set<Element> hitter) {
        switch (distanceMeasure) {
            case 0: {
                return 1.0 - Evaluation.ogmGanesan(sample, hitter);
            }
            case 1: {
                return 1.0 - Evaluation.ogmCormode(sample, hitter);
            }
            case 2: {
                return 1.0 - Evaluation.bgm(sample, hitter);
            }
            case 3: {
                return 1.0 - Evaluation.bgm2(sample, hitter);
            }
        }
        throw new RuntimeException(" Kein gueltiges Distanzma\u00ef\u00bf\u00bd gew\u00ef\u00bf\u00bdhlt.");
    }
}

