/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.Parameter;
import hitters.tools.Utils;
import java.util.Arrays;

public class Element
implements Comparable<Element> {
    protected Parameter myParams;
    protected final String[] eStr;
    protected final int[] eInt;
    private int hashCode = 0;
    private final int[] level;
    private int L = 0;

    public Element(String[] eStr, int[] eInt, Parameter myParams) {
        int i;
        this.myParams = myParams;
        this.eStr = new String[myParams.getDimS()];
        this.eInt = new int[myParams.getDimI()];
        this.level = new int[myParams.getDim()];
        for (i = 0; i < eStr.length; ++i) {
            if (eStr[i] == null) continue;
            this.eStr[i] = eStr[i].length() > 0 ? eStr[i] : "*";
        }
        if (eInt != null) {
            for (i = 0; i < eInt.length; ++i) {
                this.eInt[i] = eInt[i];
            }
        }
        this.updateLevel();
    }

    public Element(Parameter par) {
        this(new String[par.getDimS()], new int[par.getDimI()], par);
    }

    public int getLevel(int dim) {
        return this.level[dim];
    }

    public int getL() {
        return this.L;
    }

    public int getDim() {
        return this.myParams.getDim();
    }

    public boolean hasParent(int dim) {
        return this.level[dim] > 0;
    }

    public boolean turnIntoParent(int dim) {
        this.hashCode = 0;
        boolean has = this.hasParent(dim);
        if (has) {
            if (dim < this.myParams.getDimS()) {
                int l = this.eStr[dim].lastIndexOf(47);
                this.eStr[dim] = l > 0 ? this.eStr[dim].substring(0, l) : (l == 0 ? "*" : null);
            } else {
                int n = dim - this.myParams.getDimS();
                this.eInt[n] = this.eInt[n] & this.myParams.getMask(dim - this.myParams.getDimS(), this.level[dim] - 1);
            }
            int n = dim;
            this.level[n] = this.level[n] - 1;
            --this.L;
        }
        return has;
    }

    public boolean generalizeTo(int[] label) {
        int i;
        for (int i2 = 0; i2 < this.eStr.length + this.eInt.length; ++i2) {
            if (this.level[i2] >= label[i2]) continue;
            return false;
        }
        this.hashCode = 0;
        this.L = 0;
        for (i = 0; i < this.eStr.length; ++i) {
            if (this.level[i] == 0 || label[i] == 0) {
                this.eStr[i] = "*";
            } else {
                String[] split = this.eStr[i].split("/");
                if (split.length <= 1) {
                    this.eStr[i] = "*";
                } else {
                    this.eStr[i] = "";
                    for (int j = 1; j < label[i] + 1; ++j) {
                        this.eStr[i] = this.eStr[i] + "/" + split[j];
                    }
                }
            }
            this.level[i] = label[i];
            if (this.eStr[i].equals("*") && this.level[i] > 0) {
                throw new RuntimeException("level[i] > 0: " + this.level[i]);
            }
            this.L += this.level[i];
        }
        for (i = 0; i < this.eInt.length; ++i) {
            int n = i;
            this.eInt[n] = this.eInt[n] & this.myParams.getMask(i, label[i + this.myParams.getDimS()]);
            this.level[i + this.myParams.getDimS()] = label[i + this.myParams.getDimS()];
            this.L += this.level[i + this.myParams.getDimS()];
        }
        return true;
    }

    public void capHierarchy(int[] label) {
        int i;
        this.hashCode = 0;
        this.L = 0;
        for (i = 0; i < this.eInt.length + this.eStr.length; ++i) {
            this.level[i] = Math.min(this.level[i], label[i]);
        }
        for (i = 0; i < this.eStr.length; ++i) {
            if (this.level[i] == 0) {
                this.eStr[i] = "*";
            } else {
                String[] split = this.eStr[i].split("/");
                if (split.length <= 1) {
                    this.eStr[i] = "*";
                } else {
                    this.eStr[i] = "";
                    for (int j = 1; j < this.level[i] + 1; ++j) {
                        this.eStr[i] = this.eStr[i] + "/" + split[j];
                    }
                }
            }
            this.L += this.level[i];
        }
        for (i = 0; i < this.eInt.length; ++i) {
            int n = i;
            this.eInt[n] = this.eInt[n] & this.myParams.getMask(i, this.level[i + this.myParams.getDimS()]);
            this.L += this.level[i + this.myParams.getDimS()];
        }
    }

    public boolean isGenOf(Element special) {
        for (int i = 0; i < this.eStr.length + this.eInt.length; ++i) {
            if (special.getLevel(i) >= this.level[i]) continue;
            return false;
        }
        Element dummy = special.clone();
        dummy.generalizeTo(this.level);
        return dummy.equals(this);
    }

    public boolean setToGlbOf(Element a, Element b) {
        int i;
        this.hashCode = 0;
        boolean success = true;
        for (i = 0; i < this.myParams.getDimS(); ++i) {
            if (a.getLevel(i) <= b.getLevel(i)) {
                this.eStr[i] = b.eStr[i];
                if (a.eStr[i].startsWith("*") || b.eStr[i].startsWith(a.eStr[i], 0)) continue;
                success = false;
                break;
            }
            this.eStr[i] = a.eStr[i];
            if (b.eStr[i].startsWith("*") || a.eStr[i].startsWith(b.eStr[i], 0)) continue;
            success = false;
            break;
        }
        for (i = 0; i < this.myParams.getDimI(); ++i) {
            int ma = a.getLevel(this.myParams.getDimS() + i);
            int mb = b.getLevel(this.myParams.getDimS() + i);
            int ms = this.myParams.getMask(i, Math.min(ma, mb));
            this.eInt[i] = ma <= mb ? b.eInt[i] : a.eInt[i];
            if ((b.eInt[i] & ms) == (a.eInt[i] & ms)) continue;
            success = false;
            break;
        }
        this.updateLevel();
        return success;
    }

    public Element getLca(Element other) {
        int j;
        int mx;
        int mb;
        int ma;
        int i;
        int[] label = new int[this.myParams.getDim()];
        Element e = other.clone();
        int counter = 0;
        for (i = 0; i < this.myParams.getDimS(); ++i) {
            String[] split1 = this.eStr[i].split("/");
            String[] split2 = other.eStr[i].split("/");
            ma = this.getLevel(i);
            mb = other.getLevel(i);
            mx = Math.min(ma, mb);
            counter = 0;
            for (j = 1; j < mx + 1 && split1[j].equals(split2[j]); ++j) {
                ++counter;
            }
            label[i] = counter;
        }
        for (i = 0; i < this.myParams.getDimI(); ++i) {
            int ms;
            ma = this.getLevel(this.myParams.getDimS() + i);
            mb = other.getLevel(this.myParams.getDimS() + i);
            mx = Math.min(ma, mb);
            counter = 0;
            for (j = 0; j < mx && (this.eInt[i] & (ms = this.myParams.getMask(i, j + 1))) == (other.eInt[i] & ms); ++j) {
                ++counter;
            }
            label[this.myParams.getDimS() + i] = counter;
        }
        e.generalizeTo(label);
        return e;
    }

    public boolean isBelowLabel(int[] label) {
        boolean ident = true;
        for (int i = 0; i < this.eStr.length + this.eInt.length; ++i) {
            if (this.level[i] < label[i]) {
                return false;
            }
            if (this.level[i] == label[i]) continue;
            ident = false;
        }
        return !ident;
    }

    public void setTo(Element value) {
        int i;
        this.hashCode = 0;
        for (i = 0; i < this.eStr.length; ++i) {
            this.eStr[i] = value.eStr[i];
            this.level[i] = value.level[i];
        }
        for (i = 0; i < this.eInt.length; ++i) {
            this.eInt[i] = value.eInt[i];
            this.level[i + this.myParams.getDimS()] = value.level[i + this.myParams.getDimS()];
        }
        this.L = value.L;
    }

    public void setTo(String[] s, int[] newInt) {
        int i;
        this.hashCode = 0;
        for (i = 0; i < this.myParams.getDimS(); ++i) {
            this.eStr[i] = s[i];
        }
        for (i = 0; i < this.eInt.length; ++i) {
            this.eInt[i] = newInt[i];
        }
        this.updateLevel();
    }

    public void setTo(String[] s, String[] eIntStr) {
        this.setTo(s, this.stringToInt(eIntStr));
    }

    public String get(int dim) {
        if (dim < this.myParams.getDimS()) {
            return this.eStr[dim];
        }
        return this.toString(this.eInt[dim - this.myParams.getDimS()], dim);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int i;
            int hash = 0;
            for (i = 0; i < this.eStr.length; ++i) {
                for (int j = 0; j < this.eStr[i].length(); ++j) {
                    hash *= 31;
                }
                hash += this.eStr[i].hashCode();
            }
            for (i = 0; i < this.eInt.length; ++i) {
                hash = 31 * hash + this.eInt[i];
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        int i;
        boolean equal = true;
        if (!(o instanceof Element)) {
            return false;
        }
        Element m = (Element)o;
        if (this.eStr.length != m.eStr.length) {
            return false;
        }
        for (i = 0; i < this.eStr.length; ++i) {
            if (this.eStr[i].equals(m.eStr[i])) continue;
            equal = false;
        }
        for (i = 0; i < this.eInt.length; ++i) {
            if (this.eInt[i] == m.eInt[i]) continue;
            equal = false;
        }
        return equal;
    }

    @Override
    public int compareTo(Element m) {
        int i;
        int comp = 0;
        if (m.eStr.length != this.eStr.length) {
            throw new RuntimeException("Element:Unterschiedl. Dim: " + m.eStr.length + " " + this.eStr.length);
        }
        for (i = 0; i < this.eStr.length; ++i) {
            comp = this.eStr[i].compareTo(m.eStr[i]);
            if (comp == 0) continue;
            return comp;
        }
        for (i = 0; i < this.eInt.length; ++i) {
            comp = this.eInt[i] - m.eInt[i];
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public Element clone() {
        return new Element(this.eStr, this.eInt, this.myParams);
    }

    public String toString() {
        int i;
        String s = "( ";
        for (i = 0; i < this.eStr.length; ++i) {
            s = s + this.eStr[i];
            s = i < this.myParams.getDim() - 1 ? s + " (s) | " : s + " (s)";
        }
        for (i = 0; i < this.eInt.length; ++i) {
            for (int j = 1; j < this.myParams.getMaskLength(i); ++j) {
                int res = this.eInt[i] & this.myParams.getMask(i, j) & ~this.myParams.getMask(i, j - 1);
                s = s + "/" + (res >>>= 32 - this.myParams.getPlength(i, j));
            }
            s = i < this.eInt.length - 1 ? s + " (i) | " : s + " (i)";
        }
        s = s + " )";
        return s;
    }

    public String toShortString() {
        int i;
        String s = "";
        for (i = 0; i < this.eStr.length; ++i) {
            s = this.eStr[i].equals("*") ? s + "*" : s + this.eStr[i].substring(1);
            if (i >= this.myParams.getDim() - 1) continue;
            s = s + " | ";
        }
        for (i = 0; i < this.eInt.length; ++i) {
            for (int j = 1; j < this.myParams.getMaskLength(i); ++j) {
                int res = this.eInt[i] & this.myParams.getMask(i, j) & ~this.myParams.getMask(i, j - 1);
                s = s + "/" + (res >>>= 32 - this.myParams.getPlength(i, j));
            }
            if (i >= this.eInt.length - 1) continue;
            s = s + " | ";
        }
        return s;
    }

    public int[] stringToInt(String[] s) {
        return Element.stringToInt(s, this.myParams);
    }

    public int[] stringToInt(String s0, String s1) {
        String[] st = new String[]{s0, s1};
        return Element.stringToInt(st, this.myParams);
    }

    public static int[] stringToInt(String[] st, Parameter par) {
        int[] eInt = new int[par.getDimI()];
        for (int k = 0; k < eInt.length; ++k) {
            String[] md = st[k].split("/");
            for (int j = 1; j < md.length; ++j) {
                long n = Long.parseLong(md[j]);
                int width = par.getWidth(k, j);
                if (n < 0L || n > Utils.exp(2, width) - 1L) {
                    throw new NumberFormatException("Angebener Wert " + n + " nicht im zul\u00e4ssigen Bereich (Item: " + Arrays.toString(st) + ").");
                }
                int n2 = k;
                eInt[n2] = (int)((long)eInt[n2] + (n <<= 32 - par.getPlength(k, j)));
            }
        }
        return eInt;
    }

    public void print(int num, int i) {
        System.out.println(this.toString(num, i));
    }

    public String toString(int num, int dim) {
        String s = "";
        for (int j = 1; j < this.myParams.getMaskLength(dim - this.myParams.getDimS()); ++j) {
            int res = num & this.myParams.getMask(dim - this.myParams.getDimS(), j) & ~this.myParams.getMask(dim - this.myParams.getDimS(), j - 1);
            s = s + "/" + (res >>>= 32 - this.myParams.getPlength(dim - this.myParams.getDimS(), j));
        }
        return s;
    }

    public static String toString(int num, int dim, Parameter par) {
        String s = "";
        for (int j = 1; j < par.getMaskLength(dim - par.getDimS()); ++j) {
            int res = num & par.getMask(dim - par.getDimS(), j) & ~par.getMask(dim - par.getDimS(), j - 1);
            s = s + "/" + (res >>>= 32 - par.getPlength(dim - par.getDimS(), j));
        }
        return s;
    }

    public static Element createElement(String[] eStr, Parameter myParams) {
        return Element.createElement(eStr, null, myParams);
    }

    public static Element createElement(String[] eStr, String[] eInt, Parameter myParams) {
        if (eInt == null && myParams.getDimI() != 0) {
            throw new RuntimeException("eInt == null && myParams.getDimI() != 0");
        }
        if (eStr == null && myParams.getDimS() != 0) {
            throw new RuntimeException("eStr == null && myParams.getDimS() != 0 ");
        }
        int[] res = eInt != null ? Element.stringToInt(eInt, myParams) : new int[]{};
        if (eStr == null) {
            eStr = new String[]{};
        }
        return new Element(eStr, res, myParams);
    }

    private void updateLevel() {
        int i;
        this.L = 0;
        int k = 0;
        for (i = 0; i < this.eStr.length; ++i) {
            this.level[i] = 0;
            k = 0;
            if (this.eStr[i] != null) {
                k = this.eStr[i].indexOf(47, k);
                while (k >= 0) {
                    k = this.eStr[i].indexOf(47, k + 1);
                    int n = i;
                    this.level[n] = this.level[n] + 1;
                }
            }
            this.L += this.level[i];
        }
        for (i = 0; i < this.eInt.length; ++i) {
            this.level[i + this.myParams.getDimS()] = 0;
            for (int j = 0; j < this.myParams.getMaskLength(i); ++j) {
                if ((this.eInt[i] & ~this.myParams.getMask(i, j)) == 0) continue;
                int n = i + this.myParams.getDimS();
                this.level[n] = this.level[n] + 1;
            }
            this.L += this.level[i + this.myParams.getDimS()];
        }
    }
}

