/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import com.google.common.collect.HashMultiset;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.Exact;
import hitters.multi.FullAncHHH;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.tools.LogService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ControlRoom {
    static String DELIMITER = "\n\n************************************\n\n";
    static final int SPEED_MAXSPACE = 1;
    static final int SPACE_DYN = 2;
    static final int SPEED_BUF = 3;
    static final int SPEED_CAP = 4;
    static final int ALL_CAP = 5;
    static final int ALL = 6;
    static final int EVALUATION = 7;
    static final int TMP = 8;
    static final int ALL_CAP_NEU = 9;
    static int mode;
    static AlgoType algo;

    public static void main(String[] args) throws IOException {
        System.out.println("# " + Arrays.toString(args));
        String file = args[0];
        String outFile = args[1];
        if (args.length > 0) {
            char[] flags;
            block89: for (char c : flags = args[2].toCharArray()) {
                switch (c) {
                    case 'F': {
                        algo = AlgoType.FULL_ANC;
                        continue block89;
                    }
                    case 'P': {
                        algo = AlgoType.PART_ANC;
                        continue block89;
                    }
                    case 's': {
                        mode = 1;
                        continue block89;
                    }
                    case 'd': {
                        mode = 2;
                        continue block89;
                    }
                    case 'b': {
                        mode = 3;
                        continue block89;
                    }
                    case 'c': {
                        mode = 4;
                        continue block89;
                    }
                    case 'a': {
                        mode = 5;
                        continue block89;
                    }
                    case 'm': {
                        mode = 6;
                        continue block89;
                    }
                    case 'e': {
                        mode = 7;
                        continue block89;
                    }
                    case 't': {
                        mode = 8;
                        continue block89;
                    }
                    case 'n': {
                        mode = 9;
                    }
                }
            }
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        DimType[] dims = null;
        AbstractComplexHHH hitterAlgo = null;
        switch (mode) {
            case 1: {
                int n = 3;
                double epsmin = Double.parseDouble(args[3]);
                double epsmax = Double.parseDouble(args[4]);
                int step = Integer.parseInt(args[5]);
                double stepsize = (epsmax - epsmin) / (double)step;
                double[] points = new double[step + 1];
                double pos = epsmin;
                for (int i = 0; i < step + 1; ++i) {
                    points[i] = pos;
                    pos += stepsize;
                }
                out.write("# " + Arrays.toString(points));
                out.newLine();
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 3; ++round) {
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN};
                            }
                        }
                        SysParameter par = new SysParameter(dims);
                        List<Element> list = ControlRoom.parseElements(file, par);
                        for (double point : points) {
                            long time = -System.currentTimeMillis();
                            int sumTupelCount = 0;
                            out.write((Object)((Object)algo) + ";" + round + ";" + point + ";");
                            for (int i = 0; i < n; ++i) {
                                hitterAlgo = ControlRoom.getAlgo(point, par);
                                for (Element e : list) {
                                    hitterAlgo.insert(e, 1);
                                }
                                sumTupelCount = hitterAlgo.getMaxTupelCount();
                            }
                            out.write("" + (time += System.currentTimeMillis()) / (long)n + ";" + sumTupelCount);
                            out.newLine();
                        }
                    }
                }
                break;
            }
            case 7: {
                int n = 1;
                double epsmin = Double.parseDouble(args[3]);
                double epsmax = Double.parseDouble(args[4]);
                int step = Integer.parseInt(args[5]);
                double phi = 0.001;
                double stepsize = (epsmax - epsmin) / (double)step;
                double[] points = new double[step + 1];
                double pos = epsmin;
                for (int i = 0; i < step + 1; ++i) {
                    points[i] = pos;
                    pos += stepsize;
                }
                out.write("# " + Arrays.toString(points));
                out.newLine();
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 3; ++round) {
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN};
                            }
                        }
                        SysParameter par = new SysParameter(dims);
                        List<Element> list = ControlRoom.parseElements(file, par);
                        for (double point : points) {
                            double ogm = 0.0;
                            double cor = 0.0;
                            double bgm = 0.0;
                            double bgm2 = 0.0;
                            out.write((Object)((Object)algo) + ";" + round + ";" + point + ";");
                            System.out.println((Object)((Object)algo) + ";" + round + ";" + point + ";");
                            for (int i = 0; i < n; ++i) {
                                hitterAlgo = ControlRoom.getAlgo(point, par);
                                for (Element e : list) {
                                    hitterAlgo.insert(e, 1);
                                }
                            }
                            Exact exactAlgo = new Exact(par);
                            for (Element e : list) {
                                exactAlgo.insert(e, 1);
                            }
                            Set<Element> exact = exactAlgo.outputSet(phi).keySet();
                            Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
                            ogm = Evaluation.ogmGanesan(approx, exact);
                            cor = Evaluation.ogmCormode(approx, exact);
                            bgm = Evaluation.bgm(approx, exact);
                            bgm2 = Evaluation.bgm2(approx, exact);
                            out.write(ogm + ";" + cor + ";" + bgm + ";" + bgm2);
                            out.newLine();
                            System.out.println(ogm + ";" + cor + ";" + bgm + ";" + bgm2);
                        }
                    }
                }
                break;
            }
            case 2: {
                int n = 1;
                double eps = Double.parseDouble(args[3]);
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 3; ++round) {
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN};
                            }
                        }
                        SysParameter par = new SysParameter(dims);
                        List<Element> list = ControlRoom.parseElements(file, par);
                        for (int i = 0; i < n; ++i) {
                            out.flush();
                            hitterAlgo = ControlRoom.getAlgo(eps, par);
                            int count = 0;
                            for (Element e : list) {
                                hitterAlgo.insert(e, 1);
                                if (++count % 20 != 0) continue;
                                out.write((Object)((Object)algo) + ";" + round + ";" + eps + ";" + count + ";" + hitterAlgo.getTupelCount());
                                out.newLine();
                            }
                        }
                    }
                }
                break;
            }
            case 3: {
                int n = 5;
                HashMultiset buffer = HashMultiset.create(1000000);
                for (double eps = 1.0E-6; eps < 0.02; eps *= 100.0) {
                    for (double buf = 3.0; buf < 28.0; buf *= 3.0) {
                        for (int a = 0; a < 2; ++a) {
                            algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                            for (int round = 0; round < 3; ++round) {
                                switch (round) {
                                    case 0: {
                                        dims = new DimType[]{DimType.CALL};
                                        break;
                                    }
                                    case 1: {
                                        dims = new DimType[]{DimType.PATH, DimType.CALL};
                                        break;
                                    }
                                    case 2: {
                                        dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                        break;
                                    }
                                    case 3: {
                                        dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN};
                                    }
                                }
                                SysParameter par = new SysParameter(dims);
                                List<Element> list = ControlRoom.parseElements(file, par);
                                out.write((Object)((Object)algo) + ";" + buf + ";" + round + ";" + eps + ";");
                                long time = -System.currentTimeMillis();
                                for (int i = 0; i < n; ++i) {
                                    hitterAlgo = ControlRoom.getAlgo(eps, par);
                                    for (Element e : list) {
                                        hitterAlgo.insert(e, 1);
                                    }
                                }
                                time += System.currentTimeMillis();
                                int window = (int)Math.floor(1.0 / eps);
                                int max = (int)Math.floor((double)window * buf);
                                buffer = HashMultiset.create(2 * max);
                                long timeBuf = -System.currentTimeMillis();
                                long timeAlgoBuf = 0L;
                                for (int i = 0; i < n; ++i) {
                                    AbstractComplexHHH buffAlgo = ControlRoom.getAlgo(eps, par);
                                    int counter = 0;
                                    buffer.clear();
                                    for (Element e : list) {
                                        buffer.add(e);
                                        if (counter++ < max) continue;
                                        long tmp = -System.currentTimeMillis();
                                        for (Element bufEl : buffer.elementSet()) {
                                            buffAlgo.insert(bufEl, buffer.count(bufEl));
                                        }
                                        timeAlgoBuf += (tmp += System.currentTimeMillis());
                                        counter = 0;
                                        buffer.clear();
                                    }
                                    long tmp = -System.currentTimeMillis();
                                    for (Element bufEl : buffer.elementSet()) {
                                        buffAlgo.insert(bufEl, buffer.count(bufEl));
                                    }
                                    timeAlgoBuf += (tmp += System.currentTimeMillis());
                                    if (buffAlgo.getN() == hitterAlgo.getN()) continue;
                                    throw new RuntimeException("buffAlgo.getN() != hitterAlgo.getN()");
                                }
                                out.write("" + time / (long)n + ";" + (timeBuf += System.currentTimeMillis()) / (long)n + ";" + timeAlgoBuf / (long)n);
                                out.newLine();
                                out.flush();
                            }
                        }
                    }
                }
                break;
            }
            case 4: {
                int n = 1;
                double eps = Double.parseDouble(args[3]);
                ArrayList<int[]> caps = new ArrayList<int[]>();
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 2; ++round) {
                        caps.clear();
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                int i = 1;
                                while (i < 7) {
                                    caps.add(new int[]{i++});
                                }
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                int i = 1;
                                while (i < 7) {
                                    caps.add(new int[]{12, i++});
                                }
                                i = 1;
                                while (i < 13) {
                                    caps.add(new int[]{i++, 6});
                                }
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                int i = 1;
                                while (i < 7) {
                                    caps.add(new int[]{12, i++, 4});
                                }
                                i = 1;
                                while (i < 13) {
                                    caps.add(new int[]{i++, 6, 4});
                                }
                                i = 1;
                                while (i < 5) {
                                    caps.add(new int[]{12, 6, i++});
                                }
                                break;
                            }
                        }
                        for (int[] cap : caps) {
                            SysParameter par = new SysParameter(dims, cap);
                            List<Element> list = ControlRoom.parseElements(file, par);
                            long time = -System.currentTimeMillis();
                            int sumTupelCount = 0;
                            out.write((Object)((Object)algo) + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";");
                            for (int i = 0; i < n; ++i) {
                                hitterAlgo = ControlRoom.getAlgo(eps, par);
                                for (Element e : list) {
                                    hitterAlgo.insert(e, 1);
                                }
                                sumTupelCount = hitterAlgo.getMaxTupelCount();
                            }
                            out.write("" + (time += System.currentTimeMillis()) / (long)n + ";" + sumTupelCount);
                            out.newLine();
                        }
                    }
                }
                break;
            }
            case 6: {
                out.write("algo;round;eps;time;sumTupCount;ogm;cor;bgm;bgm2;length;sizeExact;sizeApprox;timeV;approxV;dssizeV;hhhsizeV");
                out.newLine();
                int n = 1;
                double eps = Double.parseDouble(args[3]);
                double phi = 4.0 * eps;
                String prefix = "J:/log/";
                String[] files = "ff;tp;rb;gy;ne;vg;xe;ka;xt;tb;ep".split(";");
                ArrayList<String> allfiles = new ArrayList<String>();
                for (String s : files) {
                    allfiles.add(prefix + s + "1");
                }
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 7; ++round) {
                        double[] t_vect = new double[files.length];
                        double[] a_vect = new double[files.length];
                        int[] s_vect = new int[files.length];
                        int[] h_vect = new int[files.length];
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH};
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.SEQUENCE};
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                break;
                            }
                            case 4: {
                                dims = new DimType[]{DimType.PATH, DimType.SEQUENCE};
                                break;
                            }
                            case 5: {
                                dims = new DimType[]{DimType.CALL, DimType.SEQUENCE};
                                break;
                            }
                            case 6: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                            }
                        }
                        SysParameter par = new SysParameter(dims);
                        out.write((Object)((Object)algo) + ";" + round + ";" + eps + ";");
                        System.out.println((Object)((Object)algo) + ";" + round + ";" + eps + ";");
                        long time = 0L;
                        int sumTupelCount = 0;
                        double ogm = 0.0;
                        double cor = 0.0;
                        double bgm = 0.0;
                        double bgm2 = 0.0;
                        int length = 0;
                        int sizeExact = 0;
                        int sizeApprox = 0;
                        int fileNr = 0;
                        for (String aFile : allfiles) {
                            List<Element> list = null;
                            list = ControlRoom.parseElements(aFile, par);
                            length += list.size();
                            long tmp = -System.currentTimeMillis();
                            for (int i = 0; i < n; ++i) {
                                hitterAlgo = ControlRoom.getAlgo(eps, par);
                                for (Element e : list) {
                                    hitterAlgo.insert(e, 1);
                                }
                                sumTupelCount += hitterAlgo.getMaxTupelCount();
                            }
                            time += (tmp += System.currentTimeMillis());
                            Exact exactAlgo = new Exact(par);
                            for (Element e : list) {
                                exactAlgo.insert(e, 1);
                            }
                            Set<Element> exact = exactAlgo.outputSet(phi).keySet();
                            Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
                            ogm += Evaluation.ogmGanesan(approx, exact);
                            cor += Evaluation.ogmCormode(approx, exact);
                            bgm += Evaluation.bgm(approx, exact);
                            double tmpA = Evaluation.bgm2(approx, exact);
                            bgm2 += tmpA;
                            sizeExact += exact.size();
                            sizeApprox += approx.size();
                            t_vect[fileNr] = tmp;
                            a_vect[fileNr] = tmpA;
                            s_vect[fileNr] = hitterAlgo.getMaxTupelCount();
                            h_vect[fileNr] = approx.size();
                            ++fileNr;
                        }
                        out.write("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()));
                        out.write(";" + ogm / (double)(n * allfiles.size()));
                        out.write(";" + cor / (double)(n * allfiles.size()));
                        out.write(";" + bgm / (double)(n * allfiles.size()));
                        out.write(";" + bgm2 / (double)(n * allfiles.size()));
                        out.write(";" + length / allfiles.size());
                        out.write(";" + sizeExact / allfiles.size());
                        out.write(";" + sizeApprox / allfiles.size());
                        out.write(";" + Arrays.toString(t_vect));
                        out.write(";" + Arrays.toString(a_vect));
                        out.write(";" + Arrays.toString(s_vect));
                        out.write(";" + Arrays.toString(h_vect));
                        System.out.println("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()) + ";" + bgm2 / (double)(n * allfiles.size()));
                        System.out.println(";" + length / allfiles.size() + ";" + sizeExact / allfiles.size() + ";" + sizeApprox / allfiles.size());
                        out.newLine();
                        out.flush();
                    }
                }
                break;
            }
            case 9: {
                ArrayList<int[]> caps = new ArrayList<int[]>();
                out.write("algo;round;eps;cap;time;sumTupCount;ogm;cor;bgm;bgm2;length;sizeExact;sizeApprox;timeV;approxV;dssizeV;hhhsizeV;hhhexactV");
                out.newLine();
                int n = 1;
                double eps = Double.parseDouble(args[3]);
                double phi = 4.0 * eps;
                String prefix = "J:/log/";
                String[] files = "ff;tp;rb;gy;ne;vg;xe;ka;xt;tb;ep".split(";");
                ArrayList<String> allfiles = new ArrayList<String>();
                for (String s : files) {
                    allfiles.add(prefix + s + "1");
                }
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 7; ++round) {
                        double[] t_vect = new double[files.length];
                        double[] a_vect = new double[files.length];
                        int[] s_vect = new int[files.length];
                        int[] h_vect = new int[files.length];
                        int[] e_vect = new int[files.length];
                        caps.clear();
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                caps.add(new int[]{6});
                                caps.add(new int[]{3});
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH};
                                caps.add(new int[]{12});
                                caps.add(new int[]{6});
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.SEQUENCE};
                                caps.add(new int[]{4});
                                caps.add(new int[]{2});
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                caps.add(new int[]{12, 6});
                                caps.add(new int[]{6, 3});
                                break;
                            }
                            case 4: {
                                dims = new DimType[]{DimType.PATH, DimType.SEQUENCE};
                                caps.add(new int[]{12, 4});
                                caps.add(new int[]{6, 2});
                                break;
                            }
                            case 5: {
                                dims = new DimType[]{DimType.CALL, DimType.SEQUENCE};
                                caps.add(new int[]{6, 4});
                                caps.add(new int[]{3, 2});
                                break;
                            }
                            case 6: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                caps.add(new int[]{12, 6, 4});
                                caps.add(new int[]{6, 3, 2});
                            }
                        }
                        for (int[] cap : caps) {
                            SysParameter par = new SysParameter(dims, cap);
                            out.write((Object)((Object)algo) + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";");
                            System.out.println((Object)((Object)algo) + ";" + round + ";" + eps + ";");
                            long time = 0L;
                            int sumTupelCount = 0;
                            double ogm = 0.0;
                            double cor = 0.0;
                            double bgm = 0.0;
                            double bgm2 = 0.0;
                            int length = 0;
                            int sizeExact = 0;
                            int sizeApprox = 0;
                            int fileNr = 0;
                            for (String aFile : allfiles) {
                                List<Element> list = null;
                                list = ControlRoom.parseElements(aFile, par);
                                length += list.size();
                                long tmp = -System.currentTimeMillis();
                                for (int i = 0; i < n; ++i) {
                                    hitterAlgo = ControlRoom.getAlgo(eps, par);
                                    for (Element e : list) {
                                    }
                                    sumTupelCount += hitterAlgo.getMaxTupelCount();
                                }
                                time += (tmp += System.currentTimeMillis());
                                Exact exactAlgo = new Exact(par);
                                for (Element e : list) {
                                    exactAlgo.insert(e, 1);
                                }
                                Set<Element> exact = exactAlgo.outputSet(phi).keySet();
                                Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
                                ogm += Evaluation.ogmGanesan(approx, exact);
                                cor += Evaluation.ogmCormode(approx, exact);
                                bgm += Evaluation.bgm(approx, exact);
                                double tmpA = Evaluation.bgm2(approx, exact);
                                bgm2 += tmpA;
                                sizeExact += exact.size();
                                sizeApprox += approx.size();
                                t_vect[fileNr] = tmp;
                                a_vect[fileNr] = tmpA;
                                s_vect[fileNr] = hitterAlgo.getMaxTupelCount();
                                h_vect[fileNr] = approx.size();
                                e_vect[fileNr] = exact.size();
                                ++fileNr;
                            }
                            out.write("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()));
                            out.write(";" + ogm / (double)(n * allfiles.size()));
                            out.write(";" + cor / (double)(n * allfiles.size()));
                            out.write(";" + bgm / (double)(n * allfiles.size()));
                            out.write(";" + bgm2 / (double)(n * allfiles.size()));
                            out.write(";" + length / allfiles.size());
                            out.write(";" + sizeExact / allfiles.size());
                            out.write(";" + sizeApprox / allfiles.size());
                            out.write(";" + Arrays.toString(t_vect));
                            out.write(";" + Arrays.toString(a_vect));
                            out.write(";" + Arrays.toString(s_vect));
                            out.write(";" + Arrays.toString(h_vect));
                            out.write(";" + Arrays.toString(e_vect));
                            System.out.println("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()) + ";" + bgm2 / (double)(n * allfiles.size()));
                            System.out.println(";" + length / allfiles.size() + ";" + sizeExact / allfiles.size() + ";" + sizeApprox / allfiles.size());
                            out.newLine();
                            out.flush();
                        }
                    }
                }
                break;
            }
            case 5: {
                int n = 1;
                double eps = Double.parseDouble(args[3]);
                ArrayList<int[]> caps = new ArrayList<int[]>();
                String prefix = "J:/log/";
                String[] files = "ff;tp;rb;gy;ne;vg;xe;ka;xt;tb;ep".split(";");
                ArrayList<String> allfiles = new ArrayList<String>();
                for (String s : files) {
                    allfiles.add(prefix + s + "1");
                }
                for (int a = 0; a < 2; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 0; round < 7; ++round) {
                        caps.clear();
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                caps.add(new int[]{6});
                                caps.add(new int[]{3});
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH};
                                caps.add(new int[]{12});
                                caps.add(new int[]{6});
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.SEQUENCE};
                                caps.add(new int[]{4});
                                caps.add(new int[]{2});
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                caps.add(new int[]{12, 6});
                                caps.add(new int[]{6, 3});
                                break;
                            }
                            case 4: {
                                dims = new DimType[]{DimType.PATH, DimType.SEQUENCE};
                                caps.add(new int[]{12, 4});
                                caps.add(new int[]{6, 2});
                                break;
                            }
                            case 5: {
                                dims = new DimType[]{DimType.CALL, DimType.SEQUENCE};
                                caps.add(new int[]{6, 4});
                                caps.add(new int[]{3, 2});
                                break;
                            }
                            case 6: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                                caps.add(new int[]{12, 6, 4});
                                caps.add(new int[]{6, 3, 2});
                            }
                        }
                        for (int[] cap : caps) {
                            SysParameter par = new SysParameter(dims, cap);
                            out.write((Object)((Object)algo) + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";");
                            System.out.println((Object)((Object)algo) + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";");
                            long time = 0L;
                            int sumTupelCount = 0;
                            for (String aFile : allfiles) {
                                List<Element> list = ControlRoom.parseElements(aFile, par);
                                long tmp = -System.currentTimeMillis();
                                for (int i = 0; i < n; ++i) {
                                    hitterAlgo = ControlRoom.getAlgo(eps, par);
                                    for (Element e : list) {
                                        hitterAlgo.insert(e, 1);
                                    }
                                    sumTupelCount += hitterAlgo.getMaxTupelCount();
                                }
                                time += (tmp += System.currentTimeMillis());
                            }
                            out.write("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()));
                            System.out.println("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()));
                            out.newLine();
                        }
                    }
                }
                break;
            }
            case 8: {
                int n = 1;
                double eps = Double.parseDouble(args[3]);
                double phi = Double.parseDouble(args[4]);
                ArrayList<String> allfiles = new ArrayList<String>();
                allfiles.add(file);
                for (int a = 0; a < 1; ++a) {
                    algo = a == 0 ? AlgoType.FULL_ANC : AlgoType.PART_ANC;
                    for (int round = 3; round < 4; ++round) {
                        switch (round) {
                            case 0: {
                                dims = new DimType[]{DimType.CALL};
                                break;
                            }
                            case 1: {
                                dims = new DimType[]{DimType.PATH};
                                break;
                            }
                            case 2: {
                                dims = new DimType[]{DimType.SEQUENCE};
                                break;
                            }
                            case 3: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL};
                                break;
                            }
                            case 4: {
                                dims = new DimType[]{DimType.PATH, DimType.SEQUENCE};
                                break;
                            }
                            case 5: {
                                dims = new DimType[]{DimType.CALL, DimType.SEQUENCE};
                                break;
                            }
                            case 6: {
                                dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
                            }
                        }
                        SysParameter par = new SysParameter(dims);
                        out.write((Object)((Object)algo) + ";" + round + ";" + eps + ";");
                        System.out.println((Object)((Object)algo) + ";" + round + ";" + eps + ";");
                        long time = 0L;
                        int sumTupelCount = 0;
                        double ogm = 0.0;
                        double cor = 0.0;
                        double bgm = 0.0;
                        double bgm2 = 0.0;
                        int length = 0;
                        int sizeExact = 0;
                        int sizeApprox = 0;
                        for (String aFile : allfiles) {
                            System.out.println((Object)((Object)algo) + ";" + round + "start parse " + new Date());
                            List<Element> list = ControlRoom.parseElements(aFile, par);
                            length += list.size();
                            System.out.println((Object)((Object)algo) + ";" + round + "start stream " + new Date());
                            long tmp = -System.currentTimeMillis();
                            for (int i = 0; i < n; ++i) {
                                hitterAlgo = ControlRoom.getAlgo(eps, par);
                                for (Element e : list) {
                                    hitterAlgo.insert(e, 1);
                                }
                                sumTupelCount += hitterAlgo.getMaxTupelCount();
                            }
                            time += (tmp += System.currentTimeMillis());
                            System.out.println((Object)((Object)algo) + ";" + round + "start output " + new Date());
                            Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
                            System.out.println((Object)((Object)algo) + ";" + round + "start exact " + new Date());
                            Exact exactAlgo = new Exact(par);
                            for (Element e : list) {
                                exactAlgo.insert(e, 1);
                            }
                            System.out.println((Object)((Object)algo) + ";" + round + "start output exact" + new Date());
                            Set<Element> exact = exactAlgo.outputSet(phi).keySet();
                            System.out.println((Object)((Object)algo) + ";" + round + "start Evaluation " + new Date());
                            ogm += Evaluation.ogmGanesan(approx, exact);
                            cor += Evaluation.ogmCormode(approx, exact);
                            bgm += Evaluation.bgm(approx, exact);
                            bgm2 += Evaluation.bgm2(approx, exact);
                            System.out.println((Object)((Object)algo) + ";" + round + "stop Evaluation " + new Date());
                            sizeExact += exact.size();
                            sizeApprox += approx.size();
                        }
                        out.write("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()));
                        out.write(";" + ogm / (double)(n * allfiles.size()));
                        out.write(";" + cor / (double)(n * allfiles.size()));
                        out.write(";" + bgm / (double)(n * allfiles.size()));
                        out.write(";" + bgm2 / (double)(n * allfiles.size()));
                        out.write(";" + length / allfiles.size());
                        out.write(";" + sizeExact / allfiles.size());
                        out.write(";" + sizeApprox / allfiles.size());
                        System.out.println("" + time / (long)(n * allfiles.size()) + ";" + sumTupelCount / (n * allfiles.size()) + ";" + bgm2 / (double)(n * allfiles.size()));
                        System.out.println(";" + length / allfiles.size() + ";" + sizeExact / allfiles.size() + ";" + sizeApprox / allfiles.size());
                        out.newLine();
                        out.flush();
                    }
                }
                break;
            }
        }
        LogService.logDBClose();
        out.close();
    }

    static AbstractComplexHHH getAlgo(double epsilon, Parameter par) {
        AbstractComplexHHH hitterAlgo;
        switch (algo) {
            case FULL_ANC: {
                hitterAlgo = new FullAncHHH(epsilon, par);
                break;
            }
            case PART_ANC: {
                hitterAlgo = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Kein Algorithmus gewaehlt");
            }
        }
        return hitterAlgo;
    }

    public static List<Element> parseElements(String file, SysParameter par) {
        ArrayList<Element> list = new ArrayList<Element>();
        BufferedReader in = null;
        int counter = 0;
        SysParser parser = new SysParser(par);
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                SysElement el;
                if (line.length() <= 0 || line.startsWith("#") || (el = parser.createElement(line)) == null) continue;
                list.add(el);
                ++counter;
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        LogService.logDBClose();
        try {
            in.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        return list;
    }

    private static AbstractComplexHHH fillApprox(String file, SysParameter par, double epsilon, AlgoType algo) {
        AbstractComplexHHH fastPA;
        BufferedReader in = null;
        BufferedWriter out = null;
        int counter = 0;
        SysParser parser = new SysParser(par);
        System.out.println("\n# Datei = " + file);
        System.out.println("\n# Epsilon = " + epsilon);
        System.out.println("\n# Algo = " + (Object)((Object)algo));
        System.out.println(par);
        switch (algo) {
            case FULL_ANC: {
                fastPA = new FullAncHHH(epsilon, par);
                break;
            }
            case PART_ANC: {
                fastPA = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Kein Algorithmus gewaehlt");
            }
        }
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            out = new BufferedWriter(new FileWriter("tmp/out"));
            while ((line = in.readLine()) != null) {
                SysElement el;
                if (line.length() <= 0 || (el = parser.createElement(line)) == null) continue;
                fastPA.insert(el, 1);
                ++counter;
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        System.out.println("counter = " + counter);
        System.out.println("ParserCounter = " + parser.getCounter());
        System.out.println((double)counter / (double)parser.getCounter());
        LogService.logDBClose();
        try {
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        return fastPA;
    }
}

