/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.AbstractHHH;
import hitters.multi.Element;
import hitters.multi.MultiHitterInfo;
import hitters.multi.MultiStringElement;
import hitters.multi.NodeComparator;
import hitters.multi.Parameter;
import hitters.multi.QueueElement;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.tools.LogService;
import hitters.tools.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractComplexHHH
extends AbstractHHH {
    final double epsilon;
    final int w;
    int bcurrent = 1;
    private final boolean OPTIMIZE = false;
    private final int QUICK = 1;
    private final int STANDARD = 3;
    private final int PARENT = 4;
    private final int SILLY = 2;
    private final int deltaMode = 3;
    private final ArrayList<HashMap<Element, MultiStringElement>> levelSets;
    private final ArrayList<HashMap<Element, QueueElement>> levelQueues;
    Element tst;
    protected Element aTemp;
    private MultiStringElement mTemp = new MultiStringElement(0, 0, 0);
    private int[] label;
    private int[] depth;
    private int[] pos;
    private int[] hi;
    BitSet bits = new BitSet(this.par.getH());
    public int reach = 0;
    public int unreach = 0;
    public int[] counter = new int[this.par.getL() + 1];
    public int[] success = new int[this.par.getL() + 1];
    public int[] sum = new int[this.par.getL() + 1];
    HashMap<Element, Integer> fLog = new HashMap();
    HashMap<Element, Integer> estFLog = new HashMap();
    boolean logsUptodate = false;

    public AbstractComplexHHH(double epsilon, Parameter p) {
        super(p);
        this.epsilon = epsilon;
        this.w = epsilon > 1.0E-7 ? (int)Math.ceil(1.0 / epsilon) : Integer.MAX_VALUE;
        this.label = new int[this.par.getDim()];
        this.depth = new int[4];
        this.pos = new int[4];
        this.hi = new int[4];
        for (int dim = 0; dim < 4; ++dim) {
            this.hi[dim] = dim < this.par.getDim() ? this.par.gethi(dim) : 0;
        }
        this.levelSets = new ArrayList(this.par.getL() + 1);
        this.levelQueues = new ArrayList(this.par.getL() + 1);
        for (int i = 0; i <= this.par.getL(); ++i) {
            this.levelSets.add(i, new HashMap());
            this.levelQueues.add(i, new HashMap());
        }
    }

    @Override
    public void insert(Element e, int count, boolean increase) {
        this.insertWork(e, count, true, increase);
    }

    public void compress() {
        int l;
        HashMap<Element, QueueElement> parentQueue = null;
        HashMap<Element, QueueElement> grandPQueue = null;
        int parcount = 0;
        Element p = this.aTemp.clone();
        HashSet<Element> parentSet = new HashSet<Element>();
        this.logsUptodate = false;
        LogService.logF("Complex. N, Tupelcount: " + this.N + " " + this.getTupelCount());
        if (LogService.shouldLog(4)) {
            LogService.log(4, "\nDatenstruktur vor compress (bcurrent = " + this.bcurrent + "):");
            List<Map.Entry<Element, MultiStringElement>> dump = this.dumpTrie();
            for (Map.Entry<Element, MultiStringElement> entry : dump) {
                LogService.log(4, entry);
            }
            LogService.log(4, "\n");
        }
        for (l = this.par.getL(); l >= 0; --l) {
            if (this.levelQueues.get(l).size() <= 0) continue;
            throw new RuntimeException("PQ nicht leer");
        }
        for (l = this.par.getL(); l >= 0; --l) {
            QueueElement tmp;
            HashMap<Element, MultiStringElement> lSet = this.levelSets.get(l);
            Iterator<Element> it = lSet.keySet().iterator();
            if (l >= 1) {
                parentQueue = this.levelQueues.get(l - 1);
            }
            if (l >= 2) {
                grandPQueue = this.levelQueues.get(l - 2);
            }
            while (it.hasNext()) {
                Element e = it.next();
                MultiStringElement mse = lSet.get(e);
                boolean childrenOK = this.checkChildren(e, parentSet);
                if (!childrenOK || Math.abs(mse.g) + mse.delta > this.bcurrent) continue;
                if (LogService.shouldLog(4)) {
                    LogService.log(4, "Compress -> Bereite remove vor fuer " + e + " wegen g = " + mse.g + ", delta = " + mse.delta + ", bcurrent " + this.bcurrent);
                }
                int limit = (int)Utils.exp(2, this.par.getDim());
                block4: for (int j = 1; j < limit; ++j) {
                    parcount = 0;
                    boolean inDomain = true;
                    p.setTo(e);
                    for (int i = 0; i < this.par.getDim(); ++i) {
                        if ((j & 1 << this.par.getDim() - i - 1) == 0) continue;
                        ++parcount;
                        if (p.turnIntoParent(i)) continue;
                        inDomain = false;
                        continue block4;
                    }
                    if (!inDomain) continue;
                    int fac = 2 * (parcount % 2) - 1;
                    if (LogService.shouldLog(4)) {
                        LogService.log(4, "Compress -> Insert fuer " + p + " mit " + mse.g * fac);
                    }
                    if (parcount == 1) {
                        int maxM = !this.par.mBug() ? Math.max(Math.abs(mse.g) + mse.delta, mse.m) : Math.abs(mse.g) + mse.delta;
                        if (!parentQueue.containsKey(p)) {
                            tmp = new QueueElement(mse.g * fac, true, maxM);
                            parentQueue.put(p.clone(), tmp);
                            continue;
                        }
                        tmp = parentQueue.get(p);
                        tmp.increase = true;
                        tmp.g += mse.g * fac;
                        tmp.maxM = Math.max(tmp.maxM, maxM);
                        continue;
                    }
                    if (!grandPQueue.containsKey(p)) {
                        tmp = new QueueElement(mse.g * fac, false, 0);
                        grandPQueue.put(p.clone(), tmp);
                        continue;
                    }
                    tmp = grandPQueue.get(p);
                    tmp.g += mse.g * fac;
                }
                if (LogService.shouldLog(8)) {
                    LogService.log(8, "Compress -> Entferne " + e);
                }
                it.remove();
                --this.tupelCount;
            }
            if (l > 0) {
                for (Element q : parentQueue.keySet()) {
                    tmp = parentQueue.get(q);
                    if (LogService.shouldLog(8)) {
                        LogService.log(8, "level " + l + " Compress -> Insert (Queue) " + q + " mit " + tmp.g + " und increase = " + tmp.increase + " und MaxM " + tmp.maxM + " Level(q)=" + q.getL());
                    }
                    this.insertWork(q, tmp.g, false, false);
                    if (!tmp.increase) continue;
                    MultiStringElement parent = this.levelSets.get(l - 1).get(q);
                    parent.m = Math.max(parent.m, tmp.maxM);
                }
            }
            parentQueue.clear();
            parentSet.clear();
            for (Element el : lSet.keySet()) {
                this.updateNextParentSet(el, parentSet);
            }
        }
        if (LogService.shouldLog(4)) {
            LogService.log(4, "\nDatenstruktur nach compress (bcurrent = " + this.bcurrent + " und wird nun erhoeht):");
            List<Map.Entry<Element, MultiStringElement>> dump = this.dumpTrie();
            for (Map.Entry<Element, MultiStringElement> entry : dump) {
                LogService.log(4, entry);
            }
            LogService.log(4, "\n");
        }
    }

    public void output(double phi) {
        HashMap<Element, MultiHitterInfo> hInfoSet = this.outputSet(phi);
        for (Element h : hInfoSet.keySet()) {
            System.out.println(h + " " + hInfoSet.get(h));
        }
    }

    @Override
    public HashMap<Element, MultiHitterInfo> outputSet(double phi) {
        return this.outputSet(phi, false);
    }

    @Override
    public HashMap<Element, MultiHitterInfo> outputSet(double phi, boolean log) {
        if (this.N < 1) {
            return this.simpleSet();
        }
        HashMap<Element, Integer> F = new HashMap<Element, Integer>();
        HashMap<Element, Integer> f = new HashMap<Element, Integer>();
        HashMap<Element, MultiHitterInfo> hInfoSet = new HashMap<Element, MultiHitterInfo>();
        HashMap<Element, MultiHitterInfo> tempHitterSet = new HashMap<Element, MultiHitterInfo>();
        Set<Object> usedHitters = new HashSet();
        Element p = this.aTemp.clone();
        Element meet = this.aTemp.clone();
        if (log) {
            this.fLog.clear();
            this.estFLog.clear();
        }
        if (LogService.shouldLog(64)) {
            LogService.log(64, "Zustand der Datenstruktur vor Output: ");
            for (Map.Entry<Element, MultiStringElement> entr : this.dumpTrie()) {
                LogService.log(64, entr.getKey().toShortString() + " " + entr.getValue().toShortString());
            }
        }
        if (LogService.shouldLog(2)) {
            LogService.log(2, "Output: " + new Date());
            LogService.log(2, "bcurrent= " + this.bcurrent + " N=" + this.N);
        }
        for (int lv = this.maxLevel(); lv >= 0; --lv) {
            List<int[]> labelList = this.calcLabels(lv);
            for (int[] label : labelList) {
                int delta;
                boolean block;
                MultiStringElement m;
                if (LogService.shouldLog(2)) {
                    LogService.log(2, "\n *** Label: " + Arrays.toString(label) + "  ***");
                }
                usedHitters = this.trimHitters(hInfoSet.keySet(), label);
                for (int j = this.maxLevel(); j >= lv; --j) {
                    HashMap<Element, MultiStringElement> lSet = this.levelSets.get(j);
                    for (Element e : lSet.keySet()) {
                        p.setTo(e);
                        if (!p.generalizeTo(label)) continue;
                        m = lSet.get(e);
                        if (!f.containsKey(p)) {
                            f.put(p.clone(), m.g);
                        } else {
                            f.put(p, (Integer)f.get(p) + m.g);
                        }
                        if (log) {
                            if (!this.fLog.containsKey(p)) {
                                this.fLog.put(p.clone(), m.g);
                            } else {
                                this.fLog.put(p, this.fLog.get(p) + m.g);
                            }
                        }
                        block = false;
                        for (Element element : usedHitters) {
                            if (this.par.bProb()) {
                                if (!element.isGenOf(e)) continue;
                                block = true;
                                continue;
                            }
                            if (!p.isGenOf(element) || !element.isGenOf(e)) continue;
                            block = true;
                        }
                        if (block) continue;
                        if (!F.containsKey(p)) {
                            F.put(p.clone(), m.g);
                        } else {
                            F.put(p, (Integer)F.get(p) + m.g);
                        }
                        if (log) {
                            if (!this.estFLog.containsKey(p)) {
                                this.estFLog.put(p.clone(), m.g);
                            } else {
                                this.estFLog.put(p, this.estFLog.get(p) + m.g);
                            }
                        }
                        if (!LogService.shouldLog(2)) continue;
                        LogService.log(2, "Addiere g = " + m.g + " zu F (F nun " + F.get(p) + ") f\u00fcr" + " p = " + p + "\nwegen e = " + e);
                    }
                }
                for (Element element : usedHitters) {
                    p.setTo(element);
                    if (!p.generalizeTo(label)) continue;
                    block = false;
                    for (Element element2 : usedHitters) {
                        if (element.equals(element2) || !p.isGenOf(element2) || !element2.isGenOf(element)) continue;
                        block = true;
                    }
                    if (block) continue;
                    m = null;
                    m = this.trieGet(element);
                    delta = m != null ? m.delta : this.instantiateDelta(element);
                    if (!F.containsKey(p)) {
                        F.put(p.clone(), delta);
                    } else {
                        F.put(p, (Integer)F.get(p) + delta);
                    }
                    if (!LogService.shouldLog(2)) continue;
                    LogService.log(2, "Addiere Delta-h = " + delta + " zu F (F nun " + F.get(p) + ") f\u00fcr p = " + p + "\nwegen h = " + element);
                }
                for (Element element : usedHitters) {
                    for (Element element3 : usedHitters) {
                        if (element.compareTo(element3) >= 0 || !meet.setToGlbOf(element, element3)) continue;
                        p.setTo(meet);
                        if (!p.generalizeTo(label)) continue;
                        MultiStringElement multiStringElement = this.trieGet(meet);
                        delta = multiStringElement != null ? multiStringElement.delta : this.instantiateDelta(meet);
                        if (!F.containsKey(p)) {
                            F.put(p.clone(), delta);
                        } else {
                            F.put(p, (Integer)F.get(p) + delta);
                        }
                        if (!LogService.shouldLog(2)) continue;
                        LogService.log(2, "Addiere glb-Delta = " + delta + " zu F (F nun " + F.get(p) + ") f\u00fcr p = " + p + "\nwegen h = " + element + " und k = " + element3 + "\nund meet = " + meet);
                    }
                }
                for (Element element : f.keySet()) {
                    int intF = F.get(element) == null ? 0 : (Integer)F.get(element);
                    if (log) {
                        this.estFLog.put(element.clone(), intF);
                    }
                    if ((Integer)f.get(element) <= 0 || element.getL() != lv) continue;
                    m = this.trieGet(element);
                    delta = m != null ? m.delta : this.instantiateDelta(element);
                    intF = F.get(element) == null ? 0 : (Integer)F.get(element);
                    if (!((double)(intF + delta) >= phi * (double)this.N - 1.0E-9)) continue;
                    MultiHitterInfo h = new MultiHitterInfo((Integer)f.get(element) - delta, (Integer)f.get(element) + delta, intF);
                    tempHitterSet.put(element, h);
                    if (!LogService.shouldLog(2)) continue;
                    LogService.log(2, "F\u00fcge zu HHH hinzu: " + element + " mit" + h + " wegen phi * N = " + phi * (double)this.N + " delta=" + delta);
                }
                f.clear();
                F.clear();
            }
            if (LogService.shouldLog(2)) {
                LogService.log(2, "\nEbene beendet: " + lv);
            }
            hInfoSet.putAll(tempHitterSet);
            tempHitterSet.clear();
        }
        boolean bl = this.logsUptodate = this.logsUptodate || log;
        if (LogService.shouldLog(2)) {
            LogService.log(2, "Output beendet: " + new Date());
        }
        if (LogService.shouldLog(256)) {
            LogService.log(256, "Output beendet: ");
            for (Element h : hInfoSet.keySet()) {
                LogService.log(256, h.toShortString() + " " + hInfoSet.get(h).toShortString());
            }
        }
        return hInfoSet;
    }

    @Override
    public int instantiateDelta(Element e) {
        int delta = this.bcurrent - 1;
        int level = e.getL();
        HashMap<Element, MultiStringElement> set = this.levelSets.get(level);
        if (this.aTemp == null) {
            this.aTemp = e.clone();
        }
        this.mTemp = set.get(e);
        if (this.mTemp != null) {
            return this.mTemp.delta;
        }
        switch (3) {
            case 2: {
                break;
            }
            case 4: {
                for (int i = 0; i < this.par.getDim(); ++i) {
                    this.aTemp.setTo(e);
                    if (!this.aTemp.turnIntoParent(i)) continue;
                    this.mTemp = this.levelSets.get(level - 1).get(this.aTemp);
                    if (this.mTemp == null) continue;
                    delta = Math.min(delta, this.mTemp.m);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.par.getDim(); ++i) {
                    this.aTemp.setTo(e);
                    if (!this.aTemp.turnIntoParent(i)) continue;
                    this.mTemp = this.levelSets.get(level - 1).get(this.aTemp);
                    if (this.mTemp != null) {
                        delta = Math.min(delta, this.mTemp.m);
                    }
                    for (int j = 0; j < this.par.getDim(); ++j) {
                        if (!this.aTemp.turnIntoParent(j)) continue;
                        this.mTemp = this.levelSets.get(level - 2).get(this.aTemp);
                        if (this.mTemp == null) continue;
                        delta = Math.min(delta, this.mTemp.m);
                    }
                }
                break;
            }
            case 3: {
                int dim;
                this.bits.clear();
                for (dim = 0; dim < 4; ++dim) {
                    this.depth[dim] = dim < this.par.getDim() ? e.getLevel(dim) : 0;
                }
                for (dim = 0; dim < 4; ++dim) {
                    if (this.depth[dim] <= 0) continue;
                    this.copy(this.depth, this.pos);
                    int n = dim;
                    this.pos[n] = this.pos[n] - 1;
                    this.setReachable(this.pos);
                }
                this.pos[3] = this.depth[3];
                while (this.pos[3] >= 0) {
                    this.pos[2] = this.depth[2];
                    while (this.pos[2] >= 0) {
                        this.pos[1] = this.depth[1];
                        while (this.pos[1] >= 0) {
                            this.pos[0] = this.depth[0];
                            while (this.pos[0] >= 0) {
                                if (this.isReachable(this.pos)) {
                                    for (dim = 0; dim < this.par.getDim(); ++dim) {
                                        this.label[dim] = this.pos[dim];
                                    }
                                    this.aTemp.setTo(e);
                                    this.aTemp.generalizeTo(this.label);
                                    this.mTemp = this.trieGet(this.aTemp);
                                    if (this.mTemp != null) {
                                        delta = Math.min(delta, this.mTemp.m);
                                    } else {
                                        for (dim = 0; dim < 4; ++dim) {
                                            if (this.pos[dim] <= 0) continue;
                                            int n = dim;
                                            this.pos[n] = this.pos[n] - 1;
                                            this.setReachable(this.pos);
                                            int n2 = dim;
                                            this.pos[n2] = this.pos[n2] + 1;
                                        }
                                    }
                                }
                                this.pos[0] = this.pos[0] - 1;
                            }
                            this.pos[1] = this.pos[1] - 1;
                        }
                        this.pos[2] = this.pos[2] - 1;
                    }
                    this.pos[3] = this.pos[3] - 1;
                }
                break;
            }
            default: {
                throw new RuntimeException("deltaMode f\u00fcr InstantiateDelta nicht angegeben.");
            }
        }
        return delta;
    }

    public void setN(int N) {
        this.N = N;
        this.bcurrent = (int)Math.ceil((double)N / (double)this.w);
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int getW() {
        return this.w;
    }

    @Override
    public HashMap<Element, Integer> dumpF(double phi) {
        this.outputSet(phi, true);
        return this.estFLog;
    }

    @Override
    public HashMap<Element, Integer> dumpf() {
        if (!this.logsUptodate) {
            this.outputSet(1.0, true);
        }
        return this.fLog;
    }

    public MultiStringElement trieGet(Element e) {
        MultiStringElement m = this.levelSets.get(e.getL()).get(e);
        return m;
    }

    public void triePut(Element e, MultiStringElement m) {
        this.levelSets.get(e.getL()).put(e, m);
    }

    public void setTest(Element e, MultiStringElement m) {
        if (this.aTemp == null) {
            this.aTemp = e.clone();
        }
        this.levelSets.get(e.getL()).put(e, m);
    }

    public void insertWithoutCompress(Element e, int count, boolean increase) {
        this.insertWork(e, count, false, increase);
    }

    public List<Map.Entry<Element, MultiStringElement>> dumpTrie() {
        ArrayList<Map.Entry<Element, MultiStringElement>> res = new ArrayList<Map.Entry<Element, MultiStringElement>>();
        for (HashMap<Element, MultiStringElement> map : this.levelSets) {
            res.addAll(map.entrySet());
        }
        Collections.sort(res, new NodeComparator());
        return res;
    }

    public ArrayList<HashMap<Element, MultiStringElement>> dumpLevelSets() {
        return this.levelSets;
    }

    public MultiStringElement dumpElement(Element a) {
        MultiStringElement elem = this.levelSets.get(a.getL()).get(a);
        return elem;
    }

    protected void insertWork(Element e, int count, boolean compress, boolean increase) {
        this.insertWork(e, count, compress, increase, -1);
    }

    private void insertWork(Element e, int count, boolean compress, boolean increase, int delta) {
        if (LogService.shouldLog(1)) {
            LogService.log(1, "insert " + e + " count=" + count);
        }
        if (this.aTemp == null) {
            this.aTemp = e.clone();
        }
        this.mTemp = this.trieGet(e);
        this.logsUptodate = false;
        if (this.mTemp != null) {
            this.mTemp.g += count;
        } else {
            this.specializedInsert(e, count, delta);
            ++this.tupelCount;
        }
        if (increase) {
            this.N += count;
            if (LogService.shouldLog(1)) {
                LogService.log(1, "bcurrent alt= " + this.bcurrent + " N=" + this.N + " count = " + count);
            }
            if (Math.floor((double)this.N / (double)this.w) + 1.0 > (double)this.bcurrent) {
                if (this.tupelCount > this.maxTupel) {
                    this.maxTupel = this.tupelCount;
                }
                if (compress) {
                    this.compress();
                }
                this.bcurrent = (int)Math.floor((double)this.N / (double)this.w) + 1;
                if (LogService.shouldLog(1)) {
                    LogService.log(1, "bcurrent neu= " + this.bcurrent + " N=" + this.N + " count = " + count);
                }
            }
        }
    }

    protected abstract void specializedInsert(Element var1, int var2, int var3);

    protected abstract boolean checkChildren(Element var1, HashSet<Element> var2);

    protected abstract void updateNextParentSet(Element var1, HashSet<Element> var2);

    private HashMap<Element, MultiHitterInfo> simpleSet() {
        Element e;
        HashMap<Element, MultiHitterInfo> hitterSet = new HashMap<Element, MultiHitterInfo>();
        String[] iStr = new String[this.par.getDimI()];
        for (int i = 0; i < iStr.length; ++i) {
            iStr[i] = "*";
        }
        String[] sStr = new String[this.par.getDimS()];
        for (int i = 0; i < sStr.length; ++i) {
            sStr[i] = "*";
        }
        if (this.par instanceof SysParameter) {
            int[] intA = Element.stringToInt(iStr, this.par);
            e = new SysElement(sStr, intA, (SysParameter)this.par);
        } else {
            e = Element.createElement(sStr, iStr, this.par);
        }
        MultiHitterInfo m = new MultiHitterInfo(0, 0, 0);
        hitterSet.put(e, m);
        return hitterSet;
    }

    private int maxLevel() {
        int maxLevel = 0;
        for (int j = 0; j <= this.par.getL(); ++j) {
            HashMap<Element, MultiStringElement> lSet = this.levelSets.get(j);
            if (lSet.size() <= 0) continue;
            maxLevel = j;
        }
        return maxLevel;
    }

    private void copy(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
    }

    public void setReachable(int[] pos) {
        int index = 0;
        int fac = 1;
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < i; ++j) {
                fac *= this.hi[j] + 1;
            }
            index += pos[i] * fac;
        }
        this.bits.set(index);
    }

    public boolean isReachable(int[] pos) {
        int index = 0;
        int fac = 1;
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < i; ++j) {
                fac *= this.hi[j] + 1;
            }
            index += pos[i] * fac;
        }
        return this.bits.get(index);
    }
}

