/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SpecificInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class UnseenClassValidation
extends OperatorChain {
    public static final String PARAMETER_NUMBER_OF_VALIDATIONS = "number_of_validations";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_AUTO_VALIDATION = "auto_validation";
    public static final String PARAMETER_ALL_ATTRIBUTES = "all_attributes";
    private static final Class[] OUTPUT_CLASSES = new Class[]{PerformanceVector.class, AttributeWeights.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private PerformanceCriterion lastPerformance;
    private PerformanceCriterion lastAutoPerformance;
    private PerformanceCriterion lastAllAttributesPerformance;
    private IOContainer methodResult;
    private int number;
    private int iteration;
    private int sizeUnseen = 0;
    private int sizeAuto = 0;
    private int sizeAll = 0;
    private int sizeFeatures = 0;
    private boolean inAuto = false;
    private boolean inAllAttributes = false;
    private String subset = "";
    private String features = "";

    public UnseenClassValidation(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueDouble("performance", "The last performance (main criterion) when evaluating on the unseen classes."){

            public double getDoubleValue() {
                if (UnseenClassValidation.this.lastPerformance != null) {
                    return UnseenClassValidation.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue((Value)new ValueDouble("autoPerformance", "The last performance (main criterion) when evaluating on the classes used to learn the attribute weights."){

            public double getDoubleValue() {
                if (UnseenClassValidation.this.lastAutoPerformance != null) {
                    return UnseenClassValidation.this.lastAutoPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue((Value)new ValueDouble("allAttributesPerformance", "The last performance (main criterion) when evaluating with all attributes switched on."){

            public double getDoubleValue() {
                if (UnseenClassValidation.this.lastAllAttributesPerformance != null) {
                    return UnseenClassValidation.this.lastAllAttributesPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue((Value)new ValueDouble("variance", "The variance of the last performance (main criterion)."){

            public double getDoubleValue() {
                if (UnseenClassValidation.this.lastPerformance != null) {
                    return UnseenClassValidation.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
        this.addValue((Value)new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return UnseenClassValidation.this.iteration;
            }
        });
        this.addValue((Value)new ValueDouble("sizeFeatures", "The number of selected features."){

            public double getDoubleValue() {
                return new Double(UnseenClassValidation.this.sizeFeatures);
            }
        });
        this.addValue((Value)new ValueDouble("sizeAuto", "The size of the set used for evaluation on the classes used to learn the attribute weights."){

            public double getDoubleValue() {
                return new Double(UnseenClassValidation.this.sizeAuto);
            }
        });
        this.addValue((Value)new ValueDouble("sizeAllAttributes", "The size of the set used for evaluation with all atributes switched on."){

            public double getDoubleValue() {
                return new Double(UnseenClassValidation.this.sizeAll);
            }
        });
        this.addValue((Value)new ValueDouble("sizeUnseen", "The size of the set used for evaluation on the unseen classes."){

            public double getDoubleValue() {
                return new Double(UnseenClassValidation.this.sizeUnseen);
            }
        });
        this.addValue((Value)new ValueString("inAuto", "True if currently performing evaluation on the classes used to learn the attribute weights."){

            public String getStringValue() {
                if (UnseenClassValidation.this.inAuto) {
                    return "true";
                }
                return "false";
            }
        });
        this.addValue((Value)new ValueString("inAllAttributes", "True if currently performing evaluation with all attributes switched on."){

            public String getStringValue() {
                if (UnseenClassValidation.this.inAllAttributes) {
                    return "true";
                }
                return "false";
            }
        });
        this.addValue((Value)new ValueString("subset", "Subset of classes used to learn the attribute weights."){

            public String getStringValue() {
                return UnseenClassValidation.this.subset;
            }
        });
        this.addValue((Value)new ValueString("features", "Names of the selected attributes."){

            public String getStringValue() {
                return UnseenClassValidation.this.features;
            }
        });
    }

    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    public int getMinNumberOfInnerOperators() {
        return 2;
    }

    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition((InnerOperatorCondition)new SpecificInnerOperatorCondition("FeatureSelection", 0, new Class[]{ExampleSet.class}, new Class[]{AttributeWeights.class}));
        condition.addCondition((InnerOperatorCondition)new SpecificInnerOperatorCondition("Evaluation", 1, new Class[]{ExampleSet.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    public IOObject[] apply() throws OperatorException {
        PerformanceVector allAttributesPerformanceVector;
        ExampleSet eSet = (ExampleSet)this.getInput(ExampleSet.class);
        int eSetSize = eSet.size();
        this.number = this.getParameterAsInt(PARAMETER_NUMBER_OF_VALIDATIONS);
        int randomSeed = this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED);
        RandomGenerator random = null;
        random = randomSeed != -1 ? RandomGenerator.getRandomGenerator((boolean)true, (int)randomSeed) : RandomGenerator.getGlobalRandomGenerator();
        Attribute label = eSet.getAttributes().getLabel();
        SplittedExampleSet inputSet = SplittedExampleSet.splitByAttribute((ExampleSet)eSet, (Attribute)label);
        int nrOfClasses = inputSet.getNumberOfSubsets();
        int size = 0;
        LinkedList averageVectors = new LinkedList();
        LinkedList autoVectors = new LinkedList();
        LinkedList allAttributesVectors = new LinkedList();
        AttributeWeights globalWeights = new AttributeWeights();
        for (Attribute attribute : eSet.getAttributes()) {
            globalWeights.setWeight(attribute.getName(), 0.0);
        }
        this.iteration = 0;
        while (this.iteration < this.number) {
            SplittedExampleSet newInputSet;
            inputSet.clearSelection();
            int[] randomSubset = UnseenClassValidation.getRandomSubset(nrOfClasses, random);
            for (int i = 0; i < randomSubset.length; ++i) {
                inputSet.selectAdditionalSubset(randomSubset[i]);
            }
            this.subset = "\"" + Arrays.toString(randomSubset) + "\"";
            int subsetSize = inputSet.size();
            int unseenSize = eSetSize - subsetSize;
            SplittedExampleSet firstExampleSet = null;
            if (this.getParameterAsBoolean(PARAMETER_AUTO_VALIDATION)) {
                size = (int)Math.floor(Math.min((double)unseenSize, (double)subsetSize / 2.0));
                double ratio = 1.0 - (double)size / (double)subsetSize;
                firstExampleSet = new SplittedExampleSet((ExampleSet)inputSet, ratio, 1, true, randomSeed);
                firstExampleSet.selectSingleSubset(0);
            } else {
                firstExampleSet = (SplittedExampleSet)inputSet.clone();
            }
            AttributeWeights weights = (AttributeWeights)this.useMethod((ExampleSet)firstExampleSet).remove(AttributeWeights.class);
            this.methodResult.remove(ExampleSet.class);
            this.sizeFeatures = this.countSelectedAttributes(weights);
            this.features = "\"" + this.getSelectedAttributes(weights) + "\"";
            if (this.getParameterAsBoolean(PARAMETER_AUTO_VALIDATION)) {
                this.inAuto = true;
                firstExampleSet.selectSingleSubset(1);
                this.sizeAuto = firstExampleSet.size();
                this.sizeUnseen = 0;
                this.sizeAll = 0;
                AttributeWeightedExampleSet autoWeightedSet = new AttributeWeightedExampleSet((ExampleSet)firstExampleSet, weights, 0.0).createCleanClone();
                IOContainer autoEvalOutput = this.getEvaluator().apply(this.methodResult.append(new IOObject[]{autoWeightedSet}));
                PerformanceVector autoIterationPerformance = (PerformanceVector)autoEvalOutput.get(PerformanceVector.class);
                Tools.handleAverages((IOContainer)autoEvalOutput, autoVectors, (boolean)true);
                this.setAutoResult(autoIterationPerformance.getMainCriterion());
                this.inAuto = false;
            }
            inputSet.invertSelection();
            if (this.getParameterAsBoolean(PARAMETER_AUTO_VALIDATION)) {
                double ratio = (double)size / (double)inputSet.size();
                newInputSet = new SplittedExampleSet((ExampleSet)inputSet, ratio, 1, true, randomSeed);
                newInputSet.selectSingleSubset(0);
            } else {
                newInputSet = (SplittedExampleSet)inputSet.clone();
            }
            if (this.getParameterAsBoolean(PARAMETER_ALL_ATTRIBUTES)) {
                this.inAllAttributes = true;
                this.sizeAll = newInputSet.size();
                this.sizeUnseen = 0;
                IOContainer attribOutput = this.getEvaluator().apply(this.methodResult.append(new IOObject[]{(ExampleSet)newInputSet.clone()}));
                PerformanceVector allAttributesIterationPerformance = (PerformanceVector)attribOutput.get(PerformanceVector.class);
                Tools.handleAverages((IOContainer)attribOutput, allAttributesVectors, (boolean)true);
                this.setAllAttributesResult(allAttributesIterationPerformance.getMainCriterion());
                this.inAllAttributes = false;
            }
            this.sizeUnseen = newInputSet.size();
            AttributeWeightedExampleSet weightedSet = new AttributeWeightedExampleSet((ExampleSet)newInputSet, weights, 0.0).createCleanClone();
            IOContainer evalOutput = this.evaluate((ExampleSet)weightedSet);
            PerformanceVector iterationPerformance = (PerformanceVector)evalOutput.get(PerformanceVector.class);
            Tools.handleAverages((IOContainer)evalOutput, averageVectors, (boolean)true);
            this.handleWeights(globalWeights, weights);
            this.setResult(iterationPerformance.getMainCriterion());
            this.inApplyLoop();
            ++this.iteration;
        }
        for (String currentName : globalWeights.getAttributeNames()) {
            globalWeights.setWeight(currentName, globalWeights.getWeight(currentName) / (double)this.number);
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        this.setResult(averagePerformance.getMainCriterion());
        PerformanceVector autoPerformanceVector = Tools.getPerformanceVector(autoVectors);
        if (autoPerformanceVector != null) {
            this.setAutoResult(autoPerformanceVector.getMainCriterion());
            System.out.println(autoPerformanceVector);
        }
        if ((allAttributesPerformanceVector = Tools.getPerformanceVector(allAttributesVectors)) != null) {
            this.setAllAttributesResult(allAttributesPerformanceVector.getMainCriterion());
            System.out.println(allAttributesPerformanceVector);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(averagePerformance);
        if (this.getParameterAsBoolean(PARAMETER_AUTO_VALIDATION)) {
            result.add(autoPerformanceVector);
        }
        if (this.getParameterAsBoolean(PARAMETER_ALL_ATTRIBUTES)) {
            result.add(allAttributesPerformanceVector);
        }
        result.add(globalWeights);
        return result.toArray(new IOObject[0]);
    }

    private int countSelectedAttributes(AttributeWeights weights) {
        return this.getSelectedAttributes(weights).split("#").length;
    }

    private String getSelectedAttributes(AttributeWeights weights) {
        Set attributes = weights.getAttributeNames();
        String selected = "";
        for (String s : attributes) {
            if (!(weights.getWeight(s) > 0.99)) continue;
            selected = selected + s + "#";
        }
        return selected;
    }

    private Operator getMethod() {
        return this.getOperator(0);
    }

    private Operator getEvaluator() {
        return this.getOperator(1);
    }

    void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    void setAutoResult(PerformanceCriterion pc) {
        this.lastAutoPerformance = pc;
    }

    void setAllAttributesResult(PerformanceCriterion pc) {
        this.lastAllAttributesPerformance = pc;
    }

    IOContainer useMethod(ExampleSet methodTrainingSet) throws OperatorException {
        this.methodResult = this.getMethod().apply(new IOContainer(new IOObject[]{methodTrainingSet}));
        return this.methodResult;
    }

    IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.methodResult == null) {
            throw new RuntimeException("Wrong use of MethodEvaluator.evaluate(ExampleSet): No preceding invocation of useMethod(ExampleSet)!");
        }
        IOContainer result = this.getEvaluator().apply(this.methodResult.append(new IOObject[]{testSet}));
        this.methodResult = null;
        return result;
    }

    private void handleWeights(AttributeWeights globalWeights, AttributeWeights currentWeights) {
        for (String currentName : currentWeights.getAttributeNames()) {
            double globalWeight = globalWeights.getWeight(currentName);
            double currentWeight = currentWeights.getWeight(currentName);
            if (Double.isNaN(globalWeight)) {
                globalWeights.setWeight(currentName, currentWeight);
                continue;
            }
            globalWeights.setWeight(currentName, globalWeight + currentWeight);
        }
    }

    public static int[] getRandomSubset(int n, RandomGenerator random) {
        int i;
        int[] vec = new int[n];
        int[] res = new int[n / 2];
        for (i = 0; i < vec.length; ++i) {
            vec[i] = i;
        }
        for (i = 0; i < vec.length; ++i) {
            int pos = random.nextInt(vec.length - i);
            if (i < n / 2) {
                res[i] = vec[pos];
            }
            int tmp = vec[vec.length - i - 1];
            vec[vec.length - i - 1] = vec[pos];
            vec[pos] = tmp;
        }
        return res;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALIDATIONS, "Number of iterations for the validation", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean(PARAMETER_AUTO_VALIDATION, "Also evaluate performance for the classes used for attribute selection.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_ALL_ATTRIBUTES, "Also evaluate performance with all attributes switched on.", false));
        return types;
    }
}

