/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.google.common.collect.HashMultiset;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.preprocessing.hhhitter.ParameterWrapper;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import hitters.multi.DimType;
import hitters.multi.SysParameter;
import hitters.tools.Utils;
import java.util.HashSet;
import java.util.List;

public class HistoExtraction
extends Operator {
    String callString = "";

    public HistoExtraction(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueString("UsedCalls", "The systemcalls that are used, all other calls are ignored."){

            public String getStringValue() {
                return HistoExtraction.this.callString;
            }
        });
    }

    public IOObject[] apply() throws OperatorException {
        LogService logService = LogService.getGlobal();
        logService.setVerbosityLevel(2);
        logService.log("Start apply   ", 2);
        ExampleSet exampleSet = (ExampleSet)this.getInput(ExampleSet.class);
        ExampleSet clone = (ExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        ParameterWrapper pw = new ParameterWrapper();
        DimType[] dims = new DimType[]{DimType.PATH};
        pw.par = new SysParameter(dims);
        HashSet<String> calls = new HashSet<String>();
        for (Attribute attr : clone.getAttributes()) {
            calls.add(attr.getName());
        }
        this.callString = this.makeString(calls);
        logService.log("" + calls, 2);
        pw.par.setUsedCalls(calls);
        HashMultiset globalSet = HashMultiset.create();
        for (Example example : clone) {
            this.checkForStop();
            HashMultiset<String> set = this.calcHisto(example, pw);
            globalSet.addAll(set);
            double count = 0.0;
            for (Attribute a : example.getAttributes()) {
                count += (double)set.count(a.getName());
            }
            System.out.println("count = " + count);
            for (Attribute a : example.getAttributes()) {
                double d = set.count(a.getName());
                example.setValue(a, d / count);
            }
        }
        double count = 0.0;
        Example example = clone.getExample(0);
        for (Attribute a : example.getAttributes()) {
            double d = globalSet.count(a.getName());
            System.out.println(a.getName() + ";" + d + ";" + d / count);
        }
        return new IOObject[]{clone};
    }

    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public HashMultiset<String> calcHisto(Example example, ParameterWrapper pw) throws OperatorException {
        HashMultiset<String> set = null;
        LogService logService = LogService.getGlobal();
        Attribute idAttribute = example.getAttributes().getSpecial("id");
        String id = example.getValueAsString(idAttribute, 3, false);
        logService.log("Extracting Histo for " + id + "...", 2);
        set = Utils.getHist(id);
        logService.log("...done.");
        return set;
    }

    private String makeString(HashSet<String> calls) {
        String s = "";
        for (String c : calls) {
            s = s + ", " + c;
        }
        return s.substring(2);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        return types;
    }
}

