/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeight;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;
import hitters.multi.Element;
import java.util.Set;

public abstract class HierarchicalSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = -9162977561294965657L;
    ObjectAttribute<?> hitterAttribute;
    AttributeWeight weight;
    int index = -1;

    public double calculateDistance(double[] value1, double[] value2) {
        return 1.0 - this.calculateSimilarity(value1, value2);
    }

    public double calculateSimilarity(double[] value1, double[] value2) {
        if (this.hitterAttribute == null) {
            throw new RuntimeException("No hitterAttribute was stored during init");
        }
        int index1 = new Double(value1[this.index]).intValue();
        int index2 = new Double(value2[this.index]).intValue();
        Set hhh1 = (Set)this.hitterAttribute.getMapping().mapObjectIndex(index1);
        Set hhh2 = (Set)this.hitterAttribute.getMapping().mapObjectIndex(index2);
        if (hhh1.size() == 0 || hhh2.size() == 0) {
            return 0.0;
        }
        return this.calculateSimilarity(hhh1, hhh2);
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        int i = 0;
        Attributes attributes = exampleSet.getAttributes();
        for (Attribute a : attributes) {
            if (a.getName().equals("structID")) {
                this.hitterAttribute = (ObjectAttribute)a;
                this.index = i;
            }
            ++i;
        }
        if (this.hitterAttribute == null) {
            throw new UserError(null, 128, new Object[]{"ID (containing the Hierarchical Heavy Hitters). The distance measure you have chosen is not applicable for other datasets"});
        }
    }

    protected abstract double calculateSimilarity(Set<Element> var1, Set<Element> var2);
}

