/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.preprocessing.hhhitter.HHHExtraction;
import com.rapidminer.operator.preprocessing.hhhitter.HHHResult;
import com.rapidminer.operator.preprocessing.hhhitter.ParameterWrapper;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.PartAncHHH;
import hitters.multi.SysParameter;
import hitters.tools.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class HHHExtractionPlain
extends HHHExtraction {
    public static final String USE_PATH = "use_path";
    public static final String USE_CALL = "use_calls";
    public static final String USE_SEQ = "use_sequence";
    public static final String USE_RETURN = "use_returnvalue";
    public static final String PATH_CAP = "path_cap";
    public static final String CALL_CAP = "call_cap";
    public static final String SEQ_CAP = "sequence_cap";
    String callString = "";
    double hitterTime;

    public HHHExtractionPlain(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueString("UsedCalls", "The systemcalls that are used, all other calls are ignored."){

            public String getStringValue() {
                return HHHExtractionPlain.this.callString;
            }
        });
        this.addValue((Value)new ValueDouble("HitterTime", "The time spent to calculate the Hierarchical Heavy Hitters."){

            public double getDoubleValue() {
                return new Double(HHHExtractionPlain.this.hitterTime);
            }
        });
    }

    public void doWork() throws OperatorException {
        super.doWork();
        LogService logService = LogService.getGlobal();
        logService.log("Start apply   ", 4);
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet clone = (ExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        this.sizeExSet = exampleSet.size();
        this.cacheHits = 0;
        this.setSize = "\"";
        this.avgSetSize = 0.0;
        this.dsSize = 0.0;
        Attribute idAttribute = this.getIdAttribute(clone);
        ParameterWrapper pw = this.getParameterWrapper();
        boolean writeDs = this.getParameterAsBoolean("write_data_struct");
        String cachePrefix = this.getParameterAsString("cache_path");
        HashSet<String> calls = new HashSet<String>();
        for (Attribute attr : clone.getAttributes()) {
            calls.add(attr.getName());
        }
        this.callString = this.makeString(calls);
        logService.log("" + calls, 4);
        pw.par.setUsedCalls(calls);
        Attribute structID = this.createHitterAttribute(clone);
        Attribute dsID = this.createDSAttribute(clone, writeDs);
        ArrayList<Set<Element>> allHHH = new ArrayList<Set<Element>>();
        ArrayList<String> names = new ArrayList<String>();
        this.hitterTime = -System.currentTimeMillis();
        for (Example example : clone) {
            double val;
            Set<Element> hhh;
            double startTime = System.currentTimeMillis();
            this.checkForStop();
            int tmpDsSize = 0;
            if (writeDs) {
                AbstractComplexHHH hitterAlgo = this.getAlgo(example, pw);
                hhh = hitterAlgo.outputSet(pw.phi).keySet();
                HashMap<Element, Integer> ds = hitterAlgo.dumpf();
                this.dsSize += (double)ds.size();
                tmpDsSize = ds.size();
                val = ((ObjectAttribute)dsID).getMapping().mapString(ds);
                example.setValue(dsID, val);
            } else {
                hhh = this.calcHitters(example, pw, cachePrefix, this.getParameterAsBoolean("use_cache"));
            }
            this.setSize = this.setSize + hhh.size() + "; ";
            this.avgSetSize += (double)hhh.size();
            allHHH.add(hhh);
            names.add(example.getValueAsString(idAttribute, 3, false));
            val = ((ObjectAttribute)structID).getMapping().mapString(hhh);
            example.setValue(structID, val);
            double endTime = System.currentTimeMillis();
            logService.log("  ds: " + tmpDsSize + ", hhh: " + hhh.size() + ", time: " + (endTime - startTime), 4);
        }
        this.hitterTime += (double)System.currentTimeMillis();
        this.avgSetSize /= (double)clone.size();
        this.dsSize /= (double)clone.size();
        this.setSize = this.setSize + "\"";
        HHHResult result = new HHHResult(pw, allHHH, names);
        if (this.getParameterAsBoolean("result")) {
            this.exampleSetOutput.deliver((IOObject)clone);
            this.resultOutput.deliver((IOObject)result);
        } else {
            this.exampleSetOutput.deliver((IOObject)clone);
        }
    }

    private Set<Element> calcHitters(Example example, ParameterWrapper pw, String cachePrefix, boolean shouldUseCache) throws OperatorException {
        String id = null;
        String cacheName = null;
        Set<Element> hhh = null;
        LogService logService = LogService.getGlobal();
        Attribute idAttribute = example.getAttributes().getSpecial("id");
        id = example.getValueAsString(idAttribute, 3, false);
        id = id.substring(id.lastIndexOf("/"));
        if (shouldUseCache) {
            String cacheDir = cachePrefix + "/" + (Object)((Object)pw.algo) + "/eps" + Utils.format(pw.epsilon) + "#phi" + Utils.format(pw.phi);
            SysParameter sysPar = pw.par;
            for (int i = 0; i < pw.par.getDim(); ++i) {
                cacheDir = cacheDir + "#" + (Object)((Object)sysPar.dimContents(i)) + "#" + sysPar.getCap()[i];
            }
            HashSet<String> calls = pw.par.usedCalls();
            String callCode = Utils.createCallCode(calls);
            File tmpDir = new File(cacheDir = cacheDir + "/" + callCode);
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            cacheName = cacheDir + id;
            try {
                hhh = MultiDatabase.readHHH(cacheName);
                ++this.cacheHits;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (hhh == null) {
            AbstractComplexHHH hitterAlgo = this.getAlgo(example, pw);
            hhh = hitterAlgo.outputSet(pw.phi).keySet();
            if (shouldUseCache) {
                try {
                    MultiDatabase.saveHHH(hhh, cacheName, id, pw.par, pw.epsilon, pw.phi, pw.algo);
                }
                catch (Exception e) {
                    logService.log("Can't write cache: " + cacheName + " " + e, 5);
                }
            }
        }
        return hhh;
    }

    private AbstractComplexHHH getAlgo(Example example, ParameterWrapper pw) {
        LogService logService = LogService.getGlobal();
        AbstractComplexHHH hitterAlgo = pw.algo == AlgoType.PART_ANC ? new PartAncHHH(pw.epsilon, pw.par) : new FullAncHHH(pw.epsilon, pw.par);
        Attribute idAttribute = example.getAttributes().getSpecial("id");
        String id = example.getValueAsString(idAttribute, 3, false);
        MultiDatabase d = new MultiDatabase(id, pw.par);
        id = id.substring(id.lastIndexOf("/"));
        logService.log(id.substring(1) + "...", 4);
        d.openRead();
        Vector<Element> elements = d.readSystemCalls();
        d.closeRead();
        for (Element e : elements) {
            hitterAlgo.insert(e, 1);
        }
        return hitterAlgo;
    }

    private Attribute getIdAttribute(ExampleSet exampleSet) throws UserError {
        boolean found = false;
        Attribute idAttribute = exampleSet.getAttributes().getSpecial("id");
        if (idAttribute == null) {
            throw new UserError((Operator)this, 117, new Object[]{"ID (containing the name of a logfile)"});
        }
        if (exampleSet.size() == 0) {
            throw new UserError((Operator)this, 117);
        }
        String id = exampleSet.getExample(0).getValueAsString(idAttribute, 3, false);
        File f = new File(id);
        found = f.exists();
        if (!found) {
            throw new UserError((Operator)this, 127, new Object[]{"An ID attribute (containing the name of a logfile) is required. This logfile does not exist!"});
        }
        return idAttribute;
    }

    @Override
    protected DimType[] retrieveDims() throws UserError {
        DimType[] dims;
        ArrayList<DimType> dimList = new ArrayList<DimType>();
        if (this.getParameterAsBoolean(USE_PATH)) {
            dimList.add(DimType.PATH);
        }
        if (this.getParameterAsBoolean(USE_CALL)) {
            dimList.add(DimType.CALL);
        }
        if (this.getParameterAsBoolean(USE_SEQ)) {
            dimList.add(DimType.SEQUENCE);
        }
        if (this.getParameterAsBoolean(USE_RETURN)) {
            dimList.add(DimType.RETURN);
        }
        if ((dims = dimList.toArray(new DimType[0])).length < 1) {
            throw new UserError((Operator)this, 202, new Object[]{"use_path, use_calls", USE_SEQ, USE_RETURN});
        }
        return dims;
    }

    @Override
    protected int[] retrieveCaps() throws UndefinedParameterError {
        ArrayList<Integer> capList = new ArrayList<Integer>();
        if (this.getParameterAsBoolean(USE_PATH)) {
            capList.add(this.getParameterAsInt(PATH_CAP));
        }
        if (this.getParameterAsBoolean(USE_CALL)) {
            capList.add(this.getParameterAsInt(CALL_CAP));
        }
        if (this.getParameterAsBoolean(USE_SEQ)) {
            capList.add(this.getParameterAsInt(SEQ_CAP));
        }
        if (this.getParameterAsBoolean(USE_RETURN)) {
            capList.add(2);
        }
        int[] cap = new int[capList.size()];
        for (int i = 0; i < cap.length; ++i) {
            cap[i] = (Integer)capList.get(i);
        }
        return cap;
    }

    private String makeString(HashSet<String> calls) {
        String s = "";
        for (String c : calls) {
            s = s + ", " + c;
        }
        return s.substring(2);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(USE_PATH, "Use the paths as a hierarchical variable.", true);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(PATH_CAP, "The limit on the path depth.", 1, Integer.MAX_VALUE, 12);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(USE_CALL, "Use the system calls as a hierarchical variable.", true);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(CALL_CAP, "The limit on the system call depth.", 1, 6, 6);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(USE_SEQ, "Use the sequence of (flat) calls as a hierarchical variable.", false);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(SEQ_CAP, "The limit on the sequence length.", 1, 4, 4);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(USE_RETURN, "Use the return value of the system calls as a hierarchical variable.", false);
        types.add((ParameterType)type);
        return types;
    }
}

