/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.CoarsePopulationEvaluator;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.KeepBest;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationEvaluator;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.RedundanceRemoval;
import com.rapidminer.operator.features.selection.ForwardSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

public class CoarseFeatureSelectionOperator
extends FeatureOperator {
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final String PARAMETER_THRESHOLD = "evaluation_threshold";
    public static final int FORWARD_SELECTION = 0;
    private int generationsWOImp;
    private int maxGenerations;
    private double threshold;

    public CoarseFeatureSelectionOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        this.maxGenerations = this.getParameterAsInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS);
        this.generationsWOImp = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        this.threshold = this.getParameterAsDouble(PARAMETER_THRESHOLD);
        return super.apply();
    }

    int getDefaultDirection() {
        return 0;
    }

    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        Population initP = new Population();
        for (int a = 0; a < es.getAttributes().size(); ++a) {
            double[] weights = new double[es.getAttributes().size()];
            weights[a] = 1.0;
            initP.add(new Individual(weights));
        }
        return initP;
    }

    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        int keepBest = 1;
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        preOp.add((PopulationOperator)new KeepBest(keepBest));
        preOp.add((PopulationOperator)new ForwardSelection());
        this.maxGenerations = this.maxGenerations <= 0 ? input.getAttributes().size() - 1 : --this.maxGenerations;
        preOp.add((PopulationOperator)new RedundanceRemoval());
        return preOp;
    }

    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    protected PopulationEvaluator getPopulationEvaluator(ExampleSet exampleSet) throws UndefinedParameterError {
        return new CoarsePopulationEvaluator(this, this.getInput(), exampleSet, this.threshold);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after n generations without improval of the performance (-1: stops if the maximum_number_of_generations is reached).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Delivers the maximum amount of generations (-1: might use or deselect all features).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeDouble(PARAMETER_THRESHOLD, "Minimum dissimilarity to previous best for an individual in order to be evaluated.", 0.0, 1.0, 0.001));
        return types;
    }
}

